/**********
Copyright 1994 h+t
**********/

/*
 * Frame buffer for the ACRTC using graphics library interface.
 */

#include "spice.h"
#include "mfb.h"
#include "ftegraph.h"
#include "ftedev.h"
#include "util.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <_agraph.h>


#include "suffix.h"

/*
    {"ACRTC", 0, 0, 1000, 1000, 0, 0, ACRTC_Init, ACRTC_NewViewport,
    ACRTC_Close, ACRTC_Clear,
    ACRTC_DrawLine, ACRTC_Arc, ACRTC_Text, ACRTC_DefineColor, ACRTC_DefineLinestyle,
    ACRTC_SetLinestyle, ACRTC_SetColor, ACRTC_Update,
    nodev, ACRTC_MakeMenu, ACRTC_MakeDialog, gen_Input,
    gen_DatatoScreen,ACRTC_BildReady},
*/




static unsigned short line_styles[ ] = {
	0xffff, 0xaaaa, 0x7777, 0xcccc,
	0xf0f0, 0xfc10, 0x7575, 0x3f11,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
	};

static aktLstyle =0, aktcolor= LIGHTWHITE;


#define NSTYLES	((NUMELEMS(line_styles))-16)

ACRTC_NewViewport(graph)
GRAPH *graph;
{

    if (! ACRTC_Init() == 0) {
      externalerror("Can't initialize ACRTC.");
      return(1);
    }

		/* hardcopying from the screen */
/*
    if (graph->absolute.width) {
		mfbscreenflag = 1;
    }
*/

/* note: for now, do nothing
    later, divide screen into n+1, and redraw existing n plots */

    graph->fontwidth = 8 ;  /* !!!!!!!!!!! */ 
    graph->fontheight =  11 ;  /* derzeit NUR h+t Font */

    graph->viewport.height = dispdev->height;
    graph->viewport.width = dispdev->width;

    graph->absolute.xpos = 0;
    graph->absolute.ypos = 0;
    graph->absolute.width = dispdev->width;
    graph->absolute.height = dispdev->height;
    return(0);

}

/*
DISPDEVICE *FindDev(name)

*/
static init =0;


int
ACRTC_Close()
{
	gr_fcolor(LIGHTWHITE);
	gr_org(0,0);
	gr_reset();
	gr_end();
	
	printf( " \x1b.1");   /* Cursor ein */
	fflush(stdout);

	init = 0;
    return (0);
}

int
ACRTC_Init( )
{
extern 	DISPDEVICE device[];

	if(  !init && gr_start("/acrtc")) return 1 ;  /* open ging nicht */
	init = 1;
	gr_fcolor(LIGHTWHITE);
	gr_org(0,-MAX_Y);
	gr_reset();			/* cls */

	gr_org(0,-MAX_Y);
	gr_opmode(1);       /* Zeichenmode OR anwaehlen */
	
	
	
	dispdev -> width =  MAX_X+1;
	dispdev -> height=  MAX_Y+1;
	dispdev -> numlinestyles = NSTYLES ;
	dispdev -> numcolors = LIGHTWHITE+1;
	
	
	printf( " \x1b.1");   /* Cursor ein */
	fflush(stdout);

    return (0);
}

ACRTC_Clear( )
{
	gr_clear( 0 )	; /*  cls */

/*	
    _settextposition(1, 1);
*/
}



ACRTC_SetColor(color)
	int	color;
{
	color = color % (LIGHTWHITE+1);

    if (color > 0) {
		color = (color *2)-1;
		if( color > LIGHTWHITE) color = (color-LIGHTWHITE)+1;
		gr_fcolor( aktcolor= color );
    } else
		gr_fcolor(aktcolor=LIGHTWHITE);

    return (0);
}

int
ACRTC_SetLinestyle(int style)
{
/*
	aktLstyle = style% NSTYLES;
*/
	
/*
    _setlinestyle(line_styles[aktLstyle]);
*/


    return (0);
}

int
ACRTC_Text(text, x, y, degrees)
    char *text;
    int x, y, degrees;
{
	
	gr_org(0,-MAX_Y);

	gr_amove(x,y-6);  /* um Zeichenhoehe korrigieren */
	gr_textdir(0, degrees?0:2);
	gr_text(text);
	gr_textdir(0, 0);

    return (0);
}

int
ACRTC_DrawLine(int x1, int y1, int x2, int y2)
{
    gr_setpatt(&line_styles[aktLstyle]);
	gr_org(0,-MAX_Y);
    gr_amove(x1,y1);
	gr_aline(x2,y2);
    return (0);
}

int
ACRTC_Update()
{
	
    /* Do nothing */
    return (0);
}

int
ACRTC_BildReady()
{
	
	gr_fcolor(aktcolor=LIGHTWHITE);

	printf( " \x1b.1");   /* Cursor ein */
	/* printf(" press any key to continue ");*/
	fflush(stdout);
	
    return (0);
}

int
ACRTC_DefineColor(int red, int green, int blue, int num)
{
	/* Clut wert laden */
	
	if(num <=  LIGHTWHITE	)
	{
		gr_writeclut(num,red>>2,green>>2,blue>>2);
	}
	
	
    /* No-op. */
    return (0);
}

int
ACRTC_DefineLinestyle(int num, int mask)
{
    if ((num < 0) || (num >= NSTYLES))
        return (MFBBADLST);
    line_styles[num] = mask;

    return (0);
}

void
ACRTC_Arc(x,y,r,astart,astop,s)
    int x;      /* x coordinate of center */
    int y;      /* y coordinate of center */
    int r;      /* radius of arc */
    int astart;       /* initial angle ( +x axis = 0 degrees ) */
    int astop;  /* final angle ( +x axis = 0 degrees ) */
    int s;      /* number of segments in a 360 degree arc */
    /*
     * Notes:
     *    Draws an arc of radius r and center at (x,y) beginning at
     *    angle astart (in degrees) and ending at astop
     */
{
    int	x0, y0, x1, y1;


    x0 = x + r * cos((double) astart * M_PI / 180.0);
    y0 = x + r * cos((double) astart * M_PI / 180.0);
    x1 = x + r * cos((double) astop * M_PI / 180.0);
    y1 = x + r * cos((double) astop * M_PI / 180.0);
    
	gr_org(0,-MAX_Y);
    gr_amove(x0,y0);		/* Startpunkt setzen */
    
    gr_setpatt(&line_styles[aktLstyle]);

    gr_aarc(x,y,x1,y1);

}

ACRTC_MakeDialog()
{
}
ACRTC_MakeMenu()
{
}
