/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

    /* CKTacDump(ckt,freq,file)
     * this is a simple program to dump the complex rhs vector 
     * into the rawfile.
     */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


int
CKTacDump(ckt,freq,plot)
    register CKTcircuit *ckt;
    double freq;
    GENERIC *plot;
{
    register double *rhsold;
    register double *irhsold;
    register int i;
    register IFcomplex *data;
    IFvalue freqData;
    IFvalue valueData;

    rhsold = ckt->CKTrhsOld;
    irhsold = ckt->CKTirhsOld;
    freqData.rValue = freq;
    valueData.v.numValue = ckt->CKTmaxEqNum-1;
    data = (IFcomplex *) MALLOC((ckt->CKTmaxEqNum-1)*sizeof(IFcomplex));
    valueData.v.vec.cVec = data;
    for (i=0;i<ckt->CKTmaxEqNum-1;i++) {
        data[i].real = rhsold[i+1];
        data[i].imag = irhsold[i+1];
    }
    (*(SPfrontEnd->OUTpData))(plot,&freqData,&valueData);
    FREE(data);
    return(OK);
}
