/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

    /* CKTmapNode(ckt,node)
     *  map the given node to the compact node numbering set of the
     * specified circuit
     */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


/* ARGSUSED */
int
CKTmapNode(ckt,node,name)
    GENERIC *ckt;
    GENERIC **node;
    IFuid name;
{
    register CKTnode *here;
    int error;
    IFuid uid;
    CKTnode *mynode;

    for (here = ((CKTcircuit *)ckt)->CKTnodes; here; here = here->next)  {
        if(here->name == name) {
            if(node) *node = (char *)here;
            return(E_EXISTS);
        }
    }
    /* not found, so must be a new one */
    error = CKTmkNode((CKTcircuit*)ckt,&mynode); /*allocate the node*/
    if(error) return(error);
    error = (*(SPfrontEnd->IFnewUid))((GENERIC *)ckt,&uid,(IFuid*)NULL,name,
            UID_SIGNAL,(GENERIC**)mynode);  /* get a uid for it */
    if(error) return(error);
    mynode->name = uid;     /* set the info we have */
    mynode->type = SP_VOLTAGE;
    error = CKTlinkEq((CKTcircuit*)ckt,mynode); /* and link it in */
    if(node) *node = (GENERIC *)mynode; /* and finally, return it */
    return(OK);
}
