/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

int 
NaskQuest(ckt,anal,which,value)
    CKTcircuit *ckt;
    GENERIC *anal;
    int which;
    IFvalue *value;
{
    switch(which) {

    case N_OUTPUT:
        value->nValue = ((NOISEAN*)anal)->output;
        break;

    case N_OUTREF:
        value->nValue = ((NOISEAN*)anal)->outputRef;
        break;

    case N_INPUT:
        value->uValue = ((NOISEAN*)anal)->input;
        break;

    case N_DEC:
        if(((NOISEAN*)anal)->NstpType == DECADE) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case N_OCT:
        if(((NOISEAN*)anal)->NstpType == OCTAVE) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case N_LIN:
        if(((NOISEAN*)anal)->NstpType == LINEAR) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case N_STEPS:
        value->iValue = ((NOISEAN*)anal)->NnumSteps;
        break;

    case N_START:
        value->rValue = ((NOISEAN*)anal)->NstartFreq;
        break;

    case N_STOP:
        value->rValue = ((NOISEAN*)anal)->NstopFreq;
        break;

    case N_PTSPERSUM:
        value->iValue = ((NOISEAN*)anal)->NStpsSm;
	break;

    default:
        return(E_BADPARM);
    }
    return(OK);
}

