/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/

/*
 * Nintegrate.c (noizDens, lnNdens, lnNlstDens, data)
 *
 *    This subroutine evaluates the integral of the function
 *
 *                                             EXPONENT
 *                      NOISE = a * (FREQUENCY)
 *
 *   given two points from the curve.  If EXPONENT is relatively close
 *   to 0, the noise is simply multiplied by the change in frequency.
 *   If it isn't, a more complicated expression must be used.  Note that
 *   EXPONENT = -1 gives a different equation than EXPONENT <> -1.
 *   Hence, the reason for the constant 'N_INTUSELOG'.
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

double
Nintegrate (noizDens, lnNdens, lnNlstDens, data)

double noizDens;
double lnNdens;
double lnNlstDens;
register Ndata *data;


{
    double exponent;
    double a;

    exponent = (lnNdens - lnNlstDens) / data->delLnFreq;
    if ( FABS(exponent) < N_INTFTHRESH ) {
	return (noizDens * data->delFreq);
    } else {
	a = exp(lnNdens - exponent*data->lnFreq);
	exponent += 1.0;
	if (FABS(exponent) < N_INTUSELOG) {
	    return (a * (data->lnFreq - data->lnLastFreq));
        } else {
	    return (a * ((exp(exponent * data->lnFreq) - exp(exponent * data->lnLastFreq)) /
		    exponent));
        }
    }
}
