/**********
Copyright 1991 Regents of the University of California.  All rights reserved.
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

/* ARGSUSED */
int 
SENSask(ckt,anal,which,value)
    CKTcircuit *ckt;
    GENERIC *anal;
    int which;
    IFvalue *value;
{
    SENS_AN	*sinfo = (SENS_AN *) anal;

    switch (which) {

    case SENS_START:
	value->rValue = sinfo->start_freq;
        break;

    case SENS_STOP:
	value->rValue = sinfo->stop_freq;
        break;

    case SENS_STEPS:
	value->iValue = sinfo->n_freq_steps;
        break;

    case SENS_DEC:
    case SENS_OCT:
    case SENS_LIN:
    case SENS_DC:
	value->iValue = sinfo->step_type == which;
        break;

    case SENS_DEFTOL:
	sinfo->deftol = value->rValue;
	break;

    case SENS_DEFPERTURB:
	value->rValue = sinfo->defperturb;
	break;

#ifdef notdef
    case SENS_TYPE:
	value->sValue = sinfo->type;
	break;
#endif

    default:
        return(E_BADPARM);
    }
    return(OK);
}

