/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

/* ARGSUSED */
int 
TFsetParm(ckt,anal,which,value)
    CKTcircuit *ckt;
    GENERIC *anal;
    int which;
    IFvalue *value;
{
    switch(which) {

    case TF_OUTPOS:
        ((TFan *)anal)->TFoutPos = (CKTnode *)value->nValue;
        ((TFan *)anal)->TFoutIsV = TRUE;
        ((TFan *)anal)->TFoutIsI = FALSE;
        break;
    case TF_OUTNEG:
        ((TFan *)anal)->TFoutNeg = (CKTnode *)value->nValue;
        ((TFan *)anal)->TFoutIsV = TRUE;
        ((TFan *)anal)->TFoutIsI = FALSE;
        break;
    case TF_OUTNAME:
        ((TFan *)anal)->TFoutName = value->sValue;
        break;
    case TF_OUTSRC:
        ((TFan *)anal)->TFoutSrc = value->uValue;
        ((TFan *)anal)->TFoutIsV = FALSE;
        ((TFan *)anal)->TFoutIsI = TRUE;
        break;
    case TF_INSRC:
        ((TFan *)anal)->TFinSrc = value->uValue;
        break;

    default:
        return(E_BADPARM);
    }
    return(OK);
}


static IFparm TFparms[] = {
    { "outpos",      TF_OUTPOS,     IF_SET|IF_NODE, "Positive output node" },
    { "outneg",      TF_OUTNEG,     IF_SET|IF_NODE, "Negative output node" },
    { "outname",     TF_OUTNAME,    IF_SET|IF_STRING,"Name of output variable"},
    { "outsrc",      TF_OUTSRC,     IF_SET|IF_INSTANCE, "Output source" },
    { "insrc",       TF_INSRC,      IF_SET|IF_INSTANCE, "Input source" }
};

SPICEanalysis TFinfo  = {
    { 
        "TF",
        "transfer function analysis",

        sizeof(TFparms)/sizeof(IFparm),
        TFparms
    },
    sizeof(TFan),
    NODOMAIN,
    0,
    TFsetParm,
    TFaskQuest,
    NULL,
    TFanal
};
