/**********
Copyright 1991 Regents of the University of California.  All rights reserved.
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

/*
 * this used to be in setup, but we need it here now
 * (must be done after mode is set as below)
 */

TRANinit(ckt,job)
    CKTcircuit	*ckt;
    JOB		*job;
{
    ckt->CKTfinalTime = ((TRANan*)job)->TRANfinalTime;
    ckt->CKTstep = ((TRANan*)job)->TRANstep;
    ckt->CKTinitTime = ((TRANan*)job)->TRANinitTime;
    ckt->CKTmaxStep = ((TRANan*)job)->TRANmaxStep;
	 if(ckt->CKTmaxStep == 0) {
		ckt->CKTmaxStep = (ckt->CKTfinalTime-ckt->CKTinitTime)/50;
	/* bugfix: 14.11.95 WM */
		if (ckt->CKTmaxStep > ckt->CKTstep)
       	ckt->CKTmaxStep = ckt->CKTstep;
	/* bugfix end */
	 }
	 ckt->CKTdelmin = 1e-9*ckt->CKTmaxStep;	/* XXX */
    ckt->CKTmode = ((TRANan*)job)->TRANmode;

    return OK;
}
