/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

/*
 * This routine deletes all BJTs from the circuit and frees
 * all storage they were using.
 */

#include "spice.h"
#include "const.h"
#include "util.h"
#include <stdio.h>
#include "ifsim.h"
#include "cktdefs.h"
#include "devdefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "bjtdefs.h"
#include "complex.h"
#include "trandefs.h"
#include "smpdefs.h"
#include "distodef.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop


void
BJTdestroy(inModel)
    GENmodel **inModel;

{

    BJTmodel **model = (BJTmodel**)inModel;
    BJTinstance *here;
    BJTinstance *prev = NULL;
    BJTmodel *mod = *model;
    BJTmodel *oldmod = NULL;

    for( ; mod ; mod = mod->BJTnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (BJTinstance *)NULL;
        for(here = mod->BJTinstances ; here ; here = here->BJTnextInstance) {
            if(prev){
                if(prev->BJTsens) FREE(prev->BJTsens);
                FREE(prev);
            }
            prev = here;
        }
        if(prev){
            if(prev->BJTsens) FREE(prev->BJTsens);
            FREE(prev);
        }
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
