/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

/*
 * This routine gets the device initial conditions for the BJTs
 * from the RHS vector
 */

#include "spice.h"
#include "const.h"
#include "util.h"
#include <stdio.h>
#include "ifsim.h"
#include "cktdefs.h"
#include "devdefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "bjtdefs.h"
#include "complex.h"
#include "trandefs.h"
#include "smpdefs.h"
#include "distodef.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop


int
BJTgetic(inModel,ckt)
    GENmodel *inModel;
    register CKTcircuit *ckt;

{

    BJTmodel *model = (BJTmodel*)inModel;
    register BJTinstance *here;
    /*
     * grab initial conditions out of rhs array.   User specified, so use
     * external nodes to get values
     */

    for( ; model ; model = model->BJTnextModel) {
        for(here = model->BJTinstances; here ; here = here->BJTnextInstance) {
            if(!here->BJTicVBEGiven) {
                here->BJTicVBE = 
                        *(ckt->CKTrhs + here->BJTbaseNode) - 
                        *(ckt->CKTrhs + here->BJTemitNode);
            }
            if(!here->BJTicVCEGiven) {
                here->BJTicVCE = 
                        *(ckt->CKTrhs + here->BJTcolNode) - 
                        *(ckt->CKTrhs + here->BJTemitNode);
            }
        }
    }
    return(OK);
}
