/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Hong J. Park, Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "devdefs.h"
#include "bsim2def.h"
#include "sperror.h"
#include "ifsim.h"
#include "util.h"
#include "trandefs.h"
#include "const.h"
#include "complex.h"
#include "gendefs.h"
#include "smpdefs.h"
#include "suffix.h"
#pragma hdrstop


int
B2delete(inModel,name,inInst)
    GENmodel *inModel;
    IFuid name;
    GENinstance **inInst;

{

    B2instance **fast = (B2instance**)inInst;
    B2model *model = (B2model*)inModel;
    B2instance **prev = NULL;
    B2instance *here;

    for( ; model ; model = model->B2nextModel) {
        prev = &(model->B2instances);
        for(here = *prev; here ; here = *prev) {
            if(here->B2name == name || (fast && here==*fast) ) {
                *prev= here->B2nextInstance;
                FREE(here);
                return(OK);
            }
            prev = &(here->B2nextInstance);
        }
    }
    return(E_NODEV);
}
