/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Hong J. Park, Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "devdefs.h"
#include "bsim2def.h"
#include "sperror.h"
#include "ifsim.h"
#include "util.h"
#include "trandefs.h"
#include "const.h"
#include "complex.h"
#include "gendefs.h"
#include "smpdefs.h"
#include "suffix.h"
#pragma hdrstop


void
B2destroy(inModel)
    GENmodel **inModel;

{

    B2model **model = (B2model**)inModel;
    B2instance *here;
    B2instance *prev = NULL;
    B2model *mod = *model;
    B2model *oldmod = NULL;

    for( ; mod ; mod = mod->B2nextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (B2instance *)NULL;
        for(here = mod->B2instances ; here ; here = here->B2nextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}

