/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "ifsim.h"
#include "cktdefs.h"
#include "devdefs.h"
#include "cccsdefs.h"
#include "suffix.h"
#include "complex.h"
#include "smpdefs.h"
#include "sperror.h"
#include "util.h"
#pragma hdrstop


/*ARGSUSED*/
int
CCCSload(inModel,ckt)

    GENmodel *inModel;
    CKTcircuit *ckt;

        /* actually load the current voltage value into the 
         * sparse matrix previously provided 
         */
{
    register CCCSmodel *model = (CCCSmodel*)inModel;
    register CCCSinstance *here;

    /*  loop through all the voltage source models */
    for( ; model != NULL; model = model->CCCSnextModel ) {

        /* loop through all the instances of the model */
        for (here = model->CCCSinstances; here != NULL ;
                here=here->CCCSnextInstance) {
            
            *(here->CCCSposContBrptr) += here->CCCScoeff ;
            *(here->CCCSnegContBrptr) -= here->CCCScoeff ;
        }
    }
    return(OK);
}
