/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "const.h"
#include "smpdefs.h"
#include "ifsim.h"
#include "cktdefs.h"
#include "util.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "sperror.h"
#include "complex.h"
#include "trandefs.h"
#include "devdefs.h"
#include "diodefs.h"
#include "suffix.h"
#pragma hdrstop


void
DIOdestroy(inModel)
    GENmodel **inModel;
{
    DIOmodel **model = (DIOmodel**)inModel;
    DIOinstance *here;
    DIOinstance *prev = NULL;
    DIOmodel *mod = *model;
    DIOmodel *oldmod = NULL;

    for( ; mod ; mod = mod->DIOnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (DIOinstance *)NULL;
        for(here = mod->DIOinstances ; here ; here = here->DIOnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
