/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include <stdio.h>
#include "smpdefs.h"
#include "inddefs.h"
#include "complex.h"
#include "util.h"
#include "sperror.h"
#include "trandefs.h"
#include "suffix.h"
#pragma hdrstop


void
INDdestroy(inModel)
    GENmodel **inModel;
{
    INDmodel **model = (INDmodel**)inModel;
    INDinstance *here;
    INDinstance *prev = NULL;
    INDmodel *mod = *model;
    INDmodel *oldmod = NULL;

    for( ; mod ; mod = mod->INDnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (INDinstance *)NULL;
        for(here = mod->INDinstances ; here ; here = here->INDnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
