/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "util.h"
#include "const.h"
#include "complex.h"
#include "cktdefs.h"
#include "fteconst.h"
#include "smpdefs.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "ifsim.h"
#include "trandefs.h"
#include "devdefs.h"
#include "distodef.h"
#include "sperror.h"
#include "jfetdefs.h"
#include "suffix.h"
#pragma hdrstop


int
JFETgetic(inModel,ckt)
    GENmodel *inModel;
    CKTcircuit *ckt;
{
    JFETmodel *model = (JFETmodel*)inModel;
    JFETinstance *here;
    /*
     * grab initial conditions out of rhs array.   User specified, so use
     * external nodes to get values
     */

    for( ; model ; model = model->JFETnextModel) {
        for(here = model->JFETinstances; here ; here = here->JFETnextInstance) {
            if(!here->JFETicVDSGiven) {
                here->JFETicVDS = 
                        *(ckt->CKTrhs + here->JFETdrainNode) - 
                        *(ckt->CKTrhs + here->JFETsourceNode);
            }
            if(!here->JFETicVGSGiven) {
                here->JFETicVGS = 
                        *(ckt->CKTrhs + here->JFETgateNode) - 
                        *(ckt->CKTrhs + here->JFETsourceNode);
            }
        }
    }
    return(OK);
}
