/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "devdefs.h"
#include "smpdefs.h"
#include "ifsim.h"
#include "distodef.h"
#include "complex.h"
#include "const.h"
#include "trandefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "sperror.h"
#include "util.h"
#include "mos1defs.h"
#include "suffix.h"
#pragma hdrstop


void
MOS1destroy(inModel)
    GENmodel **inModel;
{
    MOS1model **model = (MOS1model**)inModel;
    MOS1instance *here;
    MOS1instance *prev = NULL;
    MOS1model *mod = *model;
    MOS1model *oldmod = NULL;

    for( ; mod ; mod = mod->MOS1nextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (MOS1instance *)NULL;
        for(here = mod->MOS1instances ; here ; here = here->MOS1nextInstance) {
            if(prev){
                if(prev->MOS1sens) FREE(prev->MOS1sens); 
                FREE(prev);
            }
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
