/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "const.h"
#include "devdefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "complex.h"
#include "cktdefs.h"
#include "smpdefs.h"
#include "ifsim.h"
#include "util.h"
#include "trandefs.h"
#include "sperror.h"
#include "mos3defs.h"
#include "distodef.h"
#include "suffix.h"
#pragma hdrstop


int
MOS3delete(inModel,name,inst)
    GENmodel *inModel;
    IFuid name;
    GENinstance **inst;
{
    MOS3model *model = (MOS3model *)inModel;
    MOS3instance **fast = (MOS3instance **)inst;
    MOS3instance **prev = NULL;
    MOS3instance *here;

    for( ; model ; model = model->MOS3nextModel) {
        prev = &(model->MOS3instances);
        for(here = *prev; here ; here = *prev) {
            if(here->MOS3name == name || (fast && here==*fast) ) {
                *prev= here->MOS3nextInstance;
                FREE(here);
                return(OK);
            }
            prev = &(here->MOS3nextInstance);
        }
    }
    return(E_NODEV);
}
