/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Gordon Jacobs
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include "util.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "smpdefs.h"
#include "complex.h"
#include "noisedef.h"
#include "sperror.h"
#include "trandefs.h"
#include "swdefs.h"
#include "suffix.h"
#pragma hdrstop


int
SWmDelete(inModel,modname,kill)
    GENmodel **inModel;
    IFuid modname;
    GENmodel *kill;
{
    SWmodel **model = (SWmodel **)inModel;
    SWmodel *modfast = (SWmodel *)kill;
    SWinstance *here;
    SWinstance *prev = NULL;
    SWmodel **oldmod;
    oldmod = model;
    for( ; *model ; model = &((*model)->SWnextModel)) {
        if( (*model)->SWmodName == modname || 
                (modfast && *model == modfast) ) goto delgot;
        oldmod = model;
    }
    return(E_NOMOD);

delgot:
    *oldmod = (*model)->SWnextModel; /* cut deleted device out of list */
    for(here = (*model)->SWinstances ; here ; here = here->SWnextInstance) {
        if(prev) FREE(prev);
        prev = here;
    }
    if(prev) FREE(prev);
    FREE(*model);
    return(OK);

}
