/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "devdefs.h"
#include "util.h"
#include "cktdefs.h"
#include "smpdefs.h"
#include "ifsim.h"
#include "trandefs.h"
#include "tradefs.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop


int
TRAmDelete(inModel,modname,kill)
    GENmodel **inModel;
    IFuid modname;
    GENmodel *kill;
{
    TRAmodel **model = (TRAmodel **)inModel;
    TRAmodel *modfast = (TRAmodel *)kill;
    TRAinstance *here;
    TRAinstance *prev = NULL;
    TRAmodel **oldmod;
    oldmod = model;
    for( ; *model ; model = &((*model)->TRAnextModel)) {
        if( (*model)->TRAmodName == modname || 
                (modfast && *model == modfast) ) goto delgot;
        oldmod = model;
    }
    return(E_NOMOD);

delgot:
    *oldmod = (*model)->TRAnextModel; /* cut deleted device out of list */
    for(here = (*model)->TRAinstances ; here ; here = here->TRAnextInstance) {
        if(prev) FREE(prev);
        prev = here;
    }
    if(prev) FREE(prev);
    FREE(*model);
    return(OK);

}
