/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Thomas L. Quarles
**********/
/*
 */


#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "util.h"
#include "urcdefs.h"
#include "gendefs.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop


void
URCdestroy(inModel)
    GENmodel **inModel;
{
    URCmodel **model = (URCmodel **)inModel;
    URCinstance *here;
    URCinstance *prev = NULL;
    URCmodel *mod = *model;
    URCmodel *oldmod = NULL;

    for( ; mod ; mod = mod->URCnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (URCinstance *)NULL;
        for(here = mod->URCinstances ; here ; here = here->URCnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
