/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 * Circuit debugging commands.
 */

#include "spice.h"
#include "cpdefs.h"
#include "fteinput.h"
#include "ftegraph.h"
#include "ftedev.h"
#include "fteext.h"
#include "ftedefs.h"
#include "ftedebug.h"
#include "ftedbgra.h"
#include "ftedata.h"
#include "ftecmath.h"
#include "fteinp.h"
#include "fteconst.h"
#include "fteparse.h"
#include "ftehelp.h"
#include "hlpdefs.h"
#include "gendefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include "inpdefs.h"
#include "dgen.h"
#include "util.h"
#include "cpstd.h"
#include "cpextern.h"
#include "jobdefs.h"
#include "iferrmsg.h"
#include "misc.h"
#include "devdefs.h"
#include "sperror.h"
#include "const.h"
#include "suffix.h"
#define BOOL_ALREADY_TYPEDEFED
#pragma hdrstop

/* ARGSUSED */
void
com_state(wl)
    wordlist *wl;
{
    if (!ft_curckt) {
        fprintf(cp_err, "Error: no circuit loaded.\n");
        return;
    }
    fprintf(cp_out, "Current circuit: %s\n", ft_curckt->ci_name);
    if (!ft_curckt->ci_inprogress) {
        fprintf(cp_out, "No run in progress.\n");
        return;
    }
    fprintf(cp_out, "Type of run: %s\n", plot_cur->pl_name);
    fprintf(cp_out, "Number of points so far: %d\n",
            plot_cur->pl_scale->v_length);
    fprintf(cp_out, "(That's all this command does so far)\n");
    return;
}

/* ARGSUSED */
void
com_dump(wl)
    wordlist *wl;
{
    if (!ft_curckt || !ft_curckt->ci_ckt) {
        fprintf(cp_err, "Error: no circuit loaded.\n");
        return;
    }
    if_dump(ft_curckt->ci_ckt, cp_out);
    return;
}

