#include <RCSwitch.h> // Remote-Control-Library

const int fotoWiderstand = 1; // Fotowiderstand wird an A1 ausgelesen
const int ausEinPin = 10; // Aus-Ein-Schalter wird an D11 ausgelesen
long zeitSekunden = 1; // zählt nachher die Sekunden, wie lange die Messung läuft
long zeitBisSchalter =0; //misst nachher die Zeit zwischen Programmstart und Schalter setzen
int fotoWiderstandWert = 100; // Misst nachher analog den Wert an dem Fotowiderstand 
int fotoWiderstandVorher = 0; // zählt nachher hoch, wie lange das Display schon aus ist
int ausEinStatus = 0; // Status (Low/High) des Schalters
boolean steckdoseAn = false; // Wert, der auf true bleibt, wenn einmal der Schalter gesetzt ist

RCSwitch mySwitch = RCSwitch();

void setup() {
  Serial.begin(9600);
  mySwitch.enableTransmit(11);   // Fernbedienung wird an D10 angeschlossen
  pinMode(fotoWiderstand, INPUT);    // A1 für Fotowiderstand als Input definieren
  pinMode (ausEinPin, INPUT); // D11 für Aus-Ein-Schalter als Input definieren

}

void loop() 
{
  ausEinStatus = digitalRead(ausEinPin); // Status des Schalters überprüfen
  
  if ((ausEinStatus == LOW) && (steckdoseAn == true)) // Reset des Programms, wenn man den Schalter wieder auf aus stellt
  { 
    mySwitch.switchOff("11111", 4);        // Steckdose A ausschalten   
    zeitBisSchalter = 0; 
    steckdoseAn = false;
  } 
  
  if ((ausEinStatus == HIGH) && (steckdoseAn == false)) // nur wenn Schalter an ist und Steckdose aus ist, aktiv werden    
  { 
    if (zeitBisSchalter == 0) 
    {      
      zeitBisSchalter = millis();
    } // Sobald der Schalter an ist, Zeit merken seit Programmausführung

    zeitSekunden = (millis()-zeitBisSchalter)/60000;

    // Logbucheintrag
    Serial.print("FW: ");
    Serial.print(analogRead(fotoWiderstand));
    Serial.print(" (");
    Serial.print(zeitSekunden);
    Serial.print(" min), Steckdose: ");
    Serial.println(steckdoseAn);

    fotoWiderstandWert = analogRead(fotoWiderstand);
    if (fotoWiderstandWert < 20) // wenn der Fotowiderstand einen sehr niedrigen Wert hat, dann in die Schleife gehen
    {  
      if (fotoWiderstandVorher > 4) // erst wenn mindestens vier mal dunkel war, wird auch wirklich abgeschaltet
      { 
        mySwitch.switchOn("11111", 4);        // Steckdose  anschalten
        steckdoseAn = true; // Ab jetzt legt sich das Programm schlafen
        Serial.println("Messung beendet");
        fotoWiderstandVorher = 0;
      } 
      else
      {
        fotoWiderstandVorher = fotoWiderstandVorher + 1;
      }
    }
    else
    {
       fotoWiderstandVorher = 0; // wenn die Helligkeit wieder höher ist, dann den Zaehler zurücksetzen
    }
  }
  delay(5000); // Takt = ca. 10 Sekunden
}
