package de.jockels.forms;

import java.security.InvalidParameterException;

public abstract class Content {
	/**
	 * auf den Inhalt kann direkt ohne get/set zugegriffen werden: 
	 * Strings: s[idx]
	 * int: i[idx]
	 * boolean: i[idx]>0
	 * 
	 * Es wre auch mglich, unter einem Index einen String und einen int/boolean
	 * abzuspeichern, aber das drfte fr Verwirrung sorgen. Weitere Typen (float etc.)
	 * kann man einfach hinzufgen oder ggf. im int/String reprsentieren
	 */
	protected String[] s;
	protected long[] l;
	
	
	/**
	 * Erzeugt ein Content-Objekt und legt die Inhalts-Arrays an
	 * @param size so gro werden das String- und das int-Array
	 */
	public Content(int size) {
		s = new String[size];
		l = new long[size];
	}


	// Get/Set
	public String getString(int idx) { test(idx); return s[idx]; }
	public void setString(int idx, String st) { test(idx); s[idx] = st; }
	public long getLong(int idx) { test(idx); return l[idx]; }
	public void setLong(int idx, long in) { test(idx); l[idx] = in; }
	public int getInt(int idx) { 
		test(idx); 
		return l[idx]>Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l[idx]; }
	public void setInt(int idx, int in) { test(idx); l[idx] = in; }
	public boolean getBoolean(int idx) { test(idx); return l[idx]>0; }
	public void setBoolean(int idx, boolean b) { test(idx); l[idx] = b ? 1 : 0; }
	
	private void test(int i) { 
		if (i<0 || i>=s.length) throw new InvalidParameterException();
	}

	
	/**
	 * berprft das ganze Objekt auf Gltigkeit und ruft error fr die
	 * Elemente auf, bis ein ungltiges gefunden wird. Die folgenden
	 * Elemente werden dann nicht mehr berprft.
	 * @return 0, wenn alle Elemente gltig sind, sonst den ersten Fehler
	 */
	public int error() {
		for (int i=0; i<s.length; i++) {
			int e = error(i);
			if (e>0) return e;
		}
		return 0;
	}
	

	/**
	 * berprft ein einziges Objekt auf Gltigkeit, in Nachkommen zu berladen. Die
	 * einfachste Mglichkeit ist "return 0;"
	 * @param i Index in die Wertefelder (wird nicht berprft)
	 * @return 0, wenn kein Fehler, sonst sollte ein Index in die String-Resourcen
	 * 	geliefert werden, der den Fehler beschreibt
	 */
	public abstract int error(int i);
}
