package de.jockels.forms;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;

public class ContentHelper<T extends Content> {
	public final static String TAG ="ContentHelper";
	public enum Type {STRING, INT, LONG, BOOLEAN};

	Type[] mTypes;
	String[] mKeys;
	int mSize, mHelper;
	Class<T> mMaker;

	public ContentHelper(int aSize, Class<T> maker) {
		mSize = aSize;
		mHelper = 0;
		mTypes = new Type[mSize];
		mKeys = new String[mSize];
		mMaker = maker;
	}

	public int getSize() { return mSize; }
	public Type getType(int i) { return mTypes[i]; }
	
	// Content-Beschreibung --------------------------------------------------------------------
	public void setDescription(int idx, Type type, String key) {
		mTypes[idx] = type;
		mKeys[idx] = key;
	}

	public ContentHelper<T> addString(String key) {
		setDescription(mHelper, Type.STRING, key);
		mHelper++;
		return this;
	}
	
	public ContentHelper<T> addInt(String key) {
		setDescription(mHelper, Type.INT, key);
		mHelper++;
		return this;
	}
	
	public ContentHelper<T> addLong(String key) {
		setDescription(mHelper, Type.LONG, key);
		mHelper++;
		return this;
	}
	
	public ContentHelper<T> addBoolean(String key) {
		setDescription(mHelper, Type.BOOLEAN, key);
		mHelper++;
		return this;
	}
	
	
	// Vergleiche  ---------------------------------------------------------------------------------
	public boolean isEqual(T a1, T a2, int i) {
		switch (mTypes[i]) {
		case STRING:
			return TextUtils.equals(a1.s[i], a2.s[i]);
		case INT: case LONG: case BOOLEAN: 
			return a1.l[i] == a2.l[i];
		}
		return false;
	}
	
	public boolean isEqual(T a1, T a2) {
		for (int i=0; i<mSize; i++) 
			if (!isEqual(a1, a2, i)) return false;
		return true;
	}

	
	// Cursor-Interaktion ---------------------------------------------------------------------------
	public T createFromCursor(Cursor cu) {
		T c;
		try {
			c = mMaker.newInstance();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		for (int i=0; i<mSize; i++) {
			switch (mTypes[i]) {
			case STRING:
				c.s[i] = cu.getString(cu.getColumnIndex(mKeys[i]));
				break;
			case INT: 
				c.l[i] = cu.getInt(cu.getColumnIndex(mKeys[i]));
			case LONG: case BOOLEAN:
				c.l[i] = cu.getLong(cu.getColumnIndex(mKeys[i]));
				break;
			}
		}
		return c;
	}
	
	public ContentValues writeToContentValues(T c) {
		ContentValues cv = new ContentValues();
		for (int i=0; i<mSize; i++) {
			switch (mTypes[i]) {
			case STRING:
				cv.put(mKeys[i], c.s[i]);
				break;
			case INT: case BOOLEAN: case LONG:
				cv.put(mKeys[i], c.l[i]);
				break;
			}
		}
		return cv;
	}

}
