package de.jockels.lib;

import java.util.Locale;

import android.text.TextUtils;

public class StringTools {
	@SuppressWarnings("unused")
	private static final String TAG = "TextUtils";
	
	/**
	 * Wandelt den ersten Buchstaben des Strings in einen Grobuchstaben,
	 * die anderen in Kleinbuchstaben. 
	 * @param s der Eingabestring (im Idealfall ein Wort) oder null
	 * @return String der gleichen Lnge, bzw. "" falls null kommt
	 */
	public static String toCamelCaseWord(String s) {
		if (TextUtils.isEmpty(s)) {
			return "";
		} else {
			Locale l = Locale.getDefault();
			return s.substring(0, 1).toUpperCase(l) + s.substring(1).toLowerCase(l);
		}
	}
	
	
	/**
	 * Wandelt jedes Wort eines Strings mit toCamelCaseWord um, falls das Wort nur
	 * aus Zeichen besteht. Falls Ziffern oder sonstige Zeichen drin vorkommen, wird
	 * das Wort ganz in Grobuchstaben gewandelt.
	 * @param s der Satz(sollte nicht null sein)
	 * @return ein Satz mit umgewandelten Worten
	 */
	public static String toCamelCase(String s) {
		String[] p = s.split(" ");
		String r = null;
		for (String i : p) {
			if (r==null) r = ""; else r += " ";
			if (i.matches("[\\w.]+")) r += toCamelCaseWord(i); else r += i.toUpperCase(Locale.getDefault());
		}
		return r;
	}
	
	
	/**
	 * String/Integer-Wandlung ohne Exceptions; bei Konvert-Fehlern wird 0
	 * zurckgeliefert
	 * @param aString der String, der in einen Integer konvertiert werden soll
	 * @return der String als Zahl oder 0
	 */
	public static int tryParseInt(String aString) { return tryParseInt(aString, 0); }
	
	
	/**
	 * String/Integer-Wandlung ohne Exceptions; bei Konvert-Fehlern wird der Default-
	 * Wert zurckgeliefert
	 * @param aString der String, der in einen Integer konvertiert werden soll
	 * @param aDefault der Default-Wert, falls der String keine gltige Zahl ist
	 * @return der String als Zahl oder aDefault
	 */
	public static int tryParseInt(String aString, int aDefault) {
		try {
			return Integer.parseInt(aString);
		} catch (NumberFormatException e) {
			return aDefault;
		}
	}

	
	/**
	 * String/Long-Wandlung ohne Exceptions; bei Konvert-Fehlern wird der Default-
	 * Wert zurckgeliefert
	 * @param aString der String, der in einen Integer konvertiert werden soll
	 * @param aDefault der Default-Wert, falls der String keine gltige Zahl ist
	 * @return der String als Zahl oder aDefault
	 */
	public static long tryParseLong(String aString, long aDefault) {
		try {
			return Long.parseLong(aString);
		} catch (NumberFormatException e) {
			return aDefault;
		}
	}

}
