#include <Mechanic.h>
#include <SoftwareSerial.h>

ObdInterface obd;
ObdMessage msg;

SoftwareSerial blue(9, 8);

void setup() {
  Serial.begin(115200);
  while (!Serial);

  blue.begin(9600);

  obd.setSlow(false);
  obd.setExtended(false);
  obd.setDebug(false);
  obd.begin();
}

void loop() {
  float speed = 0, rpm = 0, load = 0, temp = 0, fuel = 0;
  
  obd.getPidAsFloat(0x0d, 0.0f, 255.0f, speed);
  obd.getPidAsFloat(0x0c, 0.0f, 16383.75f, rpm);
  obd.getPidAsFloat(0x04, 0.0f, 100.0f, load);
  obd.getPidAsFloat(0x05, -40.0f, 215.0f, temp);
  obd.getPidAsFloat(0x2F, 0.0f, 100.0f, fuel);

  blue.print(speed);
  blue.print(",");
  blue.print(rpm);
  blue.print(",");
  blue.print(load);
  blue.print(",");
  blue.print(temp);
  blue.print(",");
  blue.print(fuel);
  blue.write(13);
  blue.write(10);
  
  delay(100);
}

