local ledState = 0;
local turnOff = 0;
 
function blink() {
  if (turnOff == 1) {
    hardware.pin7.write(0);
  } else {
    ledState = ledState ? 0 : 1;
    hardware.pin7.write(ledState);
    imp.wakeup(0.1, blink);
  }
}
 
class LedControl extends InputPort {
  name = "LED control"
  type = "number"
 
  function set(value) {
    if (value == 0) {
      turnOff = 1;
    } else {
      turnOff = 0;
      blink();
    }
  }
}
 
hardware.pin7.configure(DIGITAL_OUT);
imp.configure("Remote Controlled LED", [ LedControl() ], []);
blink();
