require 'serialport'

if ARGV.size != 1
  puts "You have to pass the name of a serial port."
  exit 1
end

arduino = SerialPort.new( 
  ARGV[0],         # port name,
  9600,            # baud rate
  8,               # data bits
  1,               # stop bits
  SerialPort::NONE # parity
)

sleep 2
while true
  line = arduino.gets.chomp
  if line.start_with? '$GPRMC'
    attr = line.split(',')
    if attr.length > 6 && attr[2] == 'A'
      puts line
    end
  end
end
