#include "System.h"
#include "RCC.h"
#include "LED.h"

void Delay(uint32_t time);

int main() {
  InitializeSystem();
  InitializeLEDs();
  SysTick_Config(HCLKFrequency() / 100);

  for (;;) {
    SetLEDs(ALL);
    Delay(100);
    SetLEDs(OFF);
    Delay(100);
  }
}

volatile uint32_t SysTickCounter = 0;

void Delay(uint32_t time) {
  uint32_t end = SysTickCounter + time;
  while (SysTickCounter != end);
}

void SysTick_Handler() {  
  SysTickCounter++;
}
