#include "System.h"
#include "RCC.h"
#include "LED.h"
#include "Accelerometer.h"

void Delay(uint32_t time);

int main() {
  InitializeSystem();
  InitializeLEDs();
  SysTick_Config(HCLKFrequency() / 100);

  InitializeAccelerometer();

  int8_t values[3];
  uint8_t leds = 0;
  for (;;) {
    ReadRawAccelerometerData(values);
    leds = 0;
    if (values[0] < 0)
      leds |= ORANGE;
    else
      leds |= BLUE;
    if (values[1] < 0)
      leds |= GREEN;
    else
      leds |= RED;
    SetLEDs(leds);
  }
}

volatile uint32_t SysTickCounter = 0;

void Delay(uint32_t time) {
  uint32_t end = SysTickCounter + time;
  while (SysTickCounter != end);
}

void SysTick_Handler() {  
  SysTickCounter++;
}

