/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : GPIO2.c
**     Project     : ProcessorExpert
**     Processor   : MK10DX128VFM5
**     Component   : GPIO_LDD
**     Version     : Component 01.126, Driver 01.06, CPU db: 3.00.000
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-02-10, 15:52, # CodeGen: 68
**     Abstract    :
**         The HAL GPIO component will provide a low level API for unified
**         access to general purpose digital input/output pins across
**         various device designs.
**
**         RTOS drivers using HAL GPIO API will be simpler and more
**         portable to various microprocessors.
**     Settings    :
**          Component name                                 : GPIO2
**          Port                                           : PTD
**          Port width                                     : 32 bits
**          Mask of allocated pins                         : 30
**          Interrupt service/event                        : Disabled
**          Bit fields                                     : 2
**            Bit field                                    : 
**              Field name                                 : LED_GREEN
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : PTD4/LLWU_P14/SPI0_PCS1/UART0_RTS_b/FTM0_CH4/EWM_IN
**                  Pin signal                             : LED_GREEN
**                  Initial pin direction                  : Output
**                    Initial output state                 : 0
**                  Initial pin event                      : Disabled
**                  Lock initialization function           : no
**            Bit field                                    : 
**              Field name                                 : LED_YELLOW
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : ADC0_SE6b/PTD5/SPI0_PCS2/UART0_CTS_b/UART0_COL_b/FTM0_CH5/EWM_OUT_b
**                  Pin signal                             : LED_YELLOW
**                  Initial pin direction                  : Output
**                    Initial output state                 : 0
**                  Initial pin event                      : Disabled
**                  Lock initialization function           : no
**          Initialization                                 : 
**            Auto initialization                          : yes
**            Event mask                                   : 
**              OnPortEvent                                : Disabled
**     Contents    :
**         Init                    - LDD_TDeviceData* GPIO2_Init(LDD_TUserData *UserDataPtr);
**         Deinit                  - void GPIO2_Deinit(LDD_TDeviceData *DeviceDataPtr);
**         GetPortValue            - GPIO2_TPortValue GPIO2_GetPortValue(LDD_TDeviceData *DeviceDataPtr);
**         ClearPortBits           - void GPIO2_ClearPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue Mask);
**         SetPortBits             - void GPIO2_SetPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue Mask);
**         TogglePortBits          - void GPIO2_TogglePortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue...
**         SetFieldValue           - void GPIO2_SetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         GetFieldValue           - GPIO2_TFieldValue GPIO2_GetFieldValue(LDD_TDeviceData *DeviceDataPtr,...
**         ClearFieldBits          - void GPIO2_ClearFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         SetFieldBits            - void GPIO2_SetFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         ToggleFieldBits         - void GPIO2_ToggleFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         SetFieldInputDirection  - void GPIO2_SetFieldInputDirection(LDD_TDeviceData *DeviceDataPtr,...
**         SetFieldOutputDirection - void GPIO2_SetFieldOutputDirection(LDD_TDeviceData *DeviceDataPtr,...
**         ConnectPin              - LDD_TError GPIO2_ConnectPin(LDD_TDeviceData *DeviceDataPtr, LDD_TPinMask...
**
**     Copyright : 1997 - 2012 Freescale, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE GPIO2. */

#include "GPIO2.h"
#include "FreeRTOS.h" /* FreeRTOS interface */
#include "IO_Map.h"

typedef struct {
  LDD_TUserData *UserData;             /* RTOS device data structure */
} GPIO2_TDeviceData, *GPIO2_TDeviceDataPtr; /* Device data structure type */
/*
** ===================================================================
**     Method      :  GPIO2_Init (component GPIO_LDD)
**
**     Description :
**         This method initializes the associated peripheral(s) and the
**         component internal variables. The method is called
**         automatically as a part of the application initialization
**         code.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the RTOS device
**                           structure. This pointer will be passed to
**                           all events as parameter.
**     Returns     :
**         ---             - Pointer to the dynamically allocated
**                           private structure or NULL if there was an
**                           error.
** ===================================================================
*/
LDD_TDeviceData* GPIO2_Init(LDD_TUserData *UserDataPtr)
{
  /* Allocate LDD device structure */
  GPIO2_TDeviceData *DeviceDataPrv;

  /* {FreeRTOS RTOS Adapter} Driver memory allocation: RTOS function call is defined by FreeRTOS RTOS Adapter property */
  DeviceDataPrv = (GPIO2_TDeviceData *)pvPortMalloc(sizeof(GPIO2_TDeviceData));
  #if FreeRTOS_CHECK_MEMORY_ALLOCATION_ERRORS
  if (DeviceDataPrv == NULL) {
    return (NULL);
  }
  #endif
  /* Save RTOS Device structure */
  DeviceDataPrv->UserData = UserDataPtr; /* Store the RTOS device structure */
  /* GPIOD_PDOR: PDO&=~0x30 */
  GPIOD_PDOR &= (uint32_t)~(uint32_t)(GPIO_PDOR_PDO(0x30));                                                   
  /* GPIOD_PDDR: PDD|=0x30 */
  GPIOD_PDDR |= GPIO_PDDR_PDD(0x30);                                                   
  /* Initialization of Port Control registers */
  /* PORTD_PCR4: ISF=0,LK=0,MUX=1 */
  PORTD_PCR4 = (uint32_t)((PORTD_PCR4 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTD_PCR5: ISF=0,LK=0,MUX=1 */
  PORTD_PCR5 = (uint32_t)((PORTD_PCR5 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* Registration of the device structure */
  PE_LDD_RegisterDeviceStructure(PE_LDD_COMPONENT_GPIO2_ID,DeviceDataPrv);
  return ((LDD_TDeviceData *)DeviceDataPrv);
}

/*
** ===================================================================
**     Method      :  GPIO2_Deinit (component GPIO_LDD)
**
**     Description :
**         This method disables the device and frees the device data
**         structure memory.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Pointer to device data
**                           structure pointer.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_Deinit(LDD_TDeviceData *DeviceDataPtr)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  /* PORTD_PCR4: IRQC=0 */
  PORTD_PCR4 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* PORTD_PCR5: IRQC=0 */
  PORTD_PCR5 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* GPIOD_PDDR: PDD&=~0x30 */
  GPIOD_PDDR &= (uint32_t)~(uint32_t)(GPIO_PDDR_PDD(0x30));                                                   
  /* Unregistration of the device structure */
  PE_LDD_UnregisterDeviceStructure(PE_LDD_COMPONENT_GPIO2_ID);
  /* Deallocation of the device structure */
  /* {FreeRTOS RTOS Adapter} Driver memory deallocation: RTOS function call is defined by FreeRTOS RTOS Adapter property */
  #if FRTOS_MEMORY_SCHEME != 1 /* scheme 1 has no deallocate */
  vPortFree((GPIO2_TDeviceDataPtr)DeviceDataPtr);
  #endif
}

/*
** ===================================================================
**     Method      :  GPIO2_GetPortValue (component GPIO_LDD)
**
**     Description :
**         This method returns the current port input data value. Only
**         configured pins (through all of bit fields in this component)
**         are returned.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**     Returns     :
**         ---             - Unaligned current port input data value
**                           masked for allocated pins of the port. The
**                           bit 0 corresponds with the pin which has
**                           index 0 within the port, the bit 1
**                           corresponds with the pin which has index 1
**                           within the port, etc. Only configured pins
**                           (through all of bit fields in this
**                           component) are returned. The others are
**                           zeros.
** ===================================================================
*/
GPIO2_TPortValue GPIO2_GetPortValue(LDD_TDeviceData *DeviceDataPtr)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  return (GPIO2_TPortValue)(GPIO_PDD_GetPortDataInput(GPIO2_MODULE_BASE_ADDRESS)
    & ((GPIO2_TPortValue)GPIO2_ALLOCATED_PINS_MASK));
}

/*
** ===================================================================
**     Method      :  GPIO2_ClearPortBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the port to the
**         inactive level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to setting the
**                           inactive level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_ClearPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_ClearPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
    ((GPIO2_TPortValue)(((GPIO2_TPortValue)GPIO2_ALLOCATED_PINS_MASK) & ((GPIO2_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO2_SetPortBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the port to the
**         active level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to setting the
**                           active level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_SetPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_SetPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
    ((GPIO2_TPortValue)(((GPIO2_TPortValue)GPIO2_ALLOCATED_PINS_MASK) & ((GPIO2_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO2_TogglePortBits (component GPIO_LDD)
**
**     Description :
**         This method inverts the specified bits of the port to
**         another level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to inverting the
**                           current level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_TogglePortBits(LDD_TDeviceData *DeviceDataPtr, GPIO2_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_TogglePortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
    ((GPIO2_TPortValue)(((GPIO2_TPortValue)GPIO2_ALLOCATED_PINS_MASK) & ((GPIO2_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO2_SetFieldValue (component GPIO_LDD)
**
**     Description :
**         This method sets the output data value of the specified bit
**         field.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Value           - Aligned data value to writting to the
**                           specified bit field. The bit 0 corresponds
**                           with the pin which has index 0 within the
**                           given bit field, the bit 1 corresponds with
**                           the pin which has index 1 within the given
**                           bit field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_SetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO2_TFieldValue Value)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_SetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS)
          & ((GPIO2_TPortValue)(~((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)))
        )
        | (
          ((GPIO2_TPortValue)(Value << GPIO2_LED_GREEN_START_BIT))
          & ((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
        )
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_SetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS)
          & ((GPIO2_TPortValue)(~((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)))
        )
        | (
          ((GPIO2_TPortValue)(Value << GPIO2_LED_YELLOW_START_BIT))
          & ((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
        )
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_GetFieldValue (component GPIO_LDD)
**
**     Description :
**         This method returns the current input data of the specified
**         field.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to reading. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**     Returns     :
**         ---             - Aligned current port input value masked
**                           for allocated pins of the field. The bit 0
**                           corresponds with the pin which has index 0
**                           within the given bit field, the bit 1
**                           corresponds with the pin which has index 1
**                           within the given bit field, etc.
** ===================================================================
*/
GPIO2_TFieldValue GPIO2_GetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      return
        (GPIO2_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO2_MODULE_BASE_ADDRESS)
            & (GPIO2_TPortValue)GPIO2_LED_GREEN_MASK
          )
          >> GPIO2_LED_GREEN_START_BIT
        );
    }
    case LED_YELLOW: {                 /* bit field #1 */
      return
        (GPIO2_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO2_MODULE_BASE_ADDRESS)
            & (GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK
          )
          >> GPIO2_LED_YELLOW_START_BIT
        );
    }
    default:
      break;                           /* Invalid BitField is not treated, result is undefined */
  } /* switch (Field) */
  return (GPIO2_TFieldValue)0U;
}

/*
** ===================================================================
**     Method      :  GPIO2_ClearFieldBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the specified bit
**         field to the inactive level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to setting the
**                           inactive level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_ClearFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO2_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_GREEN_START_BIT))
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_YELLOW_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_SetFieldBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the specified bit
**         field to the active level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to setting the
**                           active level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_SetFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO2_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_SetPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_GREEN_START_BIT))
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_SetPortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_YELLOW_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_ToggleFieldBits (component GPIO_LDD)
**
**     Description :
**         This method inverts the specified bits of the specified bit
**         field to other level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to inverting the
**                           current level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_ToggleFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO2_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_GREEN_START_BIT))
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
        & ((GPIO2_TPortValue)(Mask << GPIO2_LED_YELLOW_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_SetFieldInputDirection (component GPIO_LDD)
**
**     Description :
**         This method sets all pins of the field to the input
**         direction.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_SetFieldInputDirection(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO2_MODULE_BASE_ADDRESS,
        GPIO2_LED_GREEN_MASK
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO2_MODULE_BASE_ADDRESS,
        GPIO2_LED_YELLOW_MASK
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_SetFieldOutputDirection (component GPIO_LDD)
**
**     Description :
**         This method sets all pins of the field to the output
**         direction.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to set to the output
**                           direction. Bit fields are defined during
**                           design time and for each bit field there is
**                           a generated constant.
**         Value           - Aligned data value to appear on the
**                           bit field pins after they have been
**                           switched to the output direction.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO2_SetFieldOutputDirection(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO2_TFieldValue Value)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_GREEN: {                  /* bit field #0 */
      GPIO_PDD_SetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS)
          & ((GPIO2_TPortValue)(
            ~((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
          ))
        ))
        | (
          ((GPIO2_TPortValue)(Value << GPIO2_LED_GREEN_START_BIT))
          & ((GPIO2_TPortValue)GPIO2_LED_GREEN_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO2_MODULE_BASE_ADDRESS,
        GPIO2_LED_GREEN_MASK
      );
      break;
    }
    case LED_YELLOW: {                 /* bit field #1 */
      GPIO_PDD_SetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS,
        ((GPIO2_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO2_MODULE_BASE_ADDRESS)
          & ((GPIO2_TPortValue)(
            ~((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
          ))
        ))
        | (
          ((GPIO2_TPortValue)(Value << GPIO2_LED_YELLOW_START_BIT))
          & ((GPIO2_TPortValue)GPIO2_LED_YELLOW_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO2_MODULE_BASE_ADDRESS,
        GPIO2_LED_YELLOW_MASK
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO2_ConnectPin (component GPIO_LDD)
**
**     Description :
**         This method reconnects the requested pin associated with the
**         selected peripheral in this component. This method is only
**         available for CPU derivatives and peripherals that support
**         the runtime pin sharing with other internal on-chip
**         peripherals.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         PinMask         - Mask for the requested pins. The
**                           peripheral pins are reconnected according
**                           to this mask.
**     Returns     :
**         ---             - Error code, possible values:
**                           ERR_OK - OK
**                           ERR_PARAM_MASK - Invalid pin mask
** ===================================================================
*/
LDD_TError GPIO2_ConnectPin(LDD_TDeviceData *DeviceDataPtr, LDD_TPinMask PinMask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  /* Pin mask test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if ((PinMask & ((LDD_TPinMask)~((LDD_TPinMask)GPIO2_ALLOCATED_PINS_MASK))) != 0U) {
    return ERR_PARAM_MASK;
  }
  if ((PinMask & LDD_GPIO_PIN_4) != 0U) {
    clrSetReg32Bits(PORTD_PCR4, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  if ((PinMask & LDD_GPIO_PIN_5) != 0U) {
    clrSetReg32Bits(PORTD_PCR5, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  return ERR_OK;
}

/* END GPIO2. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
