//-----------------------------------------------------------------------------
//  MMA8451Q.h
/// @file
///
/// @brief Header of the module MMA8451Q.c
///
/// This is the header of the module MMA8451Q.c.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-04-22 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MMA8451Q_H
 #define __MMA8451Q_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------

// Defines for setting the output data rate
/// Ouput data rate 800 hz
#define MMA845X_ODR_800HZ     0x01
/// Ouput data rate 400 hz
#define MMA845X_ODR_400HZ     0x02
/// Ouput data rate 200 hz
#define MMA845X_ODR_200HZ     0x03
/// Ouput data rate 100 hz
#define MMA845X_ODR_100HZ     0x04
/// Ouput data rate 50 hz
#define MMA845X_ODR_50HZ      0x05
/// Ouput data rate 12,5 hz
#define MMA845X_ODR_12_5HZ    0x06
/// Ouput data rate 6,25 hz
#define MMA845X_ODR_6_25HZ    0x07
/// Ouput data rate 1,563 hz
#define MMA845X_ODR_1_563HZ   0x08

// Defines for setting the oversampling mode
/// Oversampling mode normal
#define MMA845X_OSM_NORMAL    0x01
/// Oversampling mode low noise low power
#define MMA845X_OSM_LOW_NOISE 0x02
/// Oversampling mode high resolution
#define MMA845X_OSM_HIGH_RES  0x03
/// Oversampling mode low power
#define MMA845X_OSM_LOW_POWER 0x04

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------
// Inits the driver for the MMA8451Q device
void MMA845X_Init (LDD_TDeviceData * pI2C_Handle);
// Gets the device id
UBYTE MMA845X_GetDeviceID (void);
// Reads the actual acceleration values
void MMA845X_ReadAccelerationValues (PREAL pX_Value, PREAL pY_Value, PREAL pZ_Value, UWORD CountsPerG);
// Sets the full scale value for the MMA8451Q device
void MMA845X_SetFullScaleValue (UBYTE FullScaleValue);
// Sets the device in standby mode
void MMA845X_Standby (void);
// Sets the device in active mode
void MMA845X_Active (void);
// Sets the output data rate
void MMA845X_SetOutputDataRate (UBYTE OutputDataRate);
// Sets the oversampling mode
void MMA845X_SetOversamplingMode (UBYTE OversamplingMode);
// Clears the fread bit of the device
void MMA845X_ClearFRead (void);
// Wait until the measurement is complete
void MMA845X_WaitUntilMeasurementComplete (void);
// Reads the device status register
UBYTE MMA845X_ReadStatus (void);
// Is the measurement complete
bool MMA845X_IsMeasurementComplete (void);

#endif //__MMA8451Q_H
