//-----------------------------------------------------------------------------
//  MPL3115A2.h
/// @file
///
/// @brief Treiber fr den Hhensensor MPL3115A2
///
/// Treiber fr den Hhensensor MPL3115A2
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-01-15 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MPL3115A2_H
 #define __MPL3115A2_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------
#include "Basetyp.h"
#include "PE_Types.h"

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------
// Init the driver
void MPL3115A2_Init (LDD_TDeviceData * pI2C_Handle);
// Switches the MPL3115A2 in active mode
void MPL3115A2_Active (void);
// Switches the MPL3115A2 in standby mode
void MPL3115A2_Standby (void);
// Switches the MPL3115A2 in preassure measure mode
void MPL3115A2_SetBarometerMode (void);
// Switches the MPL3115A2 in altitude measure mode
void MPL3115A2_SetAltimeterMode(void);
// Sets the oversampling ratio
void MPL3115A2_SetOversampleRatio (UBYTE OversampleRatio);
// Request the pressure measurement value
void MPL3115A2_ReqPressure (void);
// Request the altitude measurement value
void MPL3115A2_ReqAltitude (void);
// Reads the altitude and the temperature value
bool MPL3115A2_ReadAltitudeEx (float * pAltitude, float * pTemperature);
//  Reads the altitude value
bool MPL3115A2_ReadAltitude (float * pAltitude);
// Reads the pressure and the temperature value
bool MPL3115A2_ReadPressureExt (float * pPreasure, float * pTemperature);
// Reads the pressure value
bool MPL3115A2_ReadPressure (float * pPreasure);
// Starts a new measuring an waits until the measuring is finished
void MPL3115A2_InitiateMeasurementAndWaitToFinish (UBYTE fWithReset);
// Waits until a measuring is complete
void MPL3115A2_WaitUntilMeasurementComplete (void);
// Check if a measurement is complete
bool MPL3115A2_IsMeasurementComplete (void);
// Starts a new measuring on the MPL3115A2
void MPL3115A2_InitiateMeasurement (void);
// Reads the status register of the MPL3115A2
UBYTE MPL3115A2_ReadStatus (void);

#endif /* __MPL3115A2_H */
