/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : GPIO1.c
**     Project     : ProcessorExpert
**     Processor   : MK10DX128VFM5
**     Component   : GPIO_LDD
**     Version     : Component 01.126, Driver 01.06, CPU db: 3.00.000
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-05-20, 22:57, # CodeGen: 132
**     Abstract    :
**         The HAL GPIO component will provide a low level API for unified
**         access to general purpose digital input/output pins across
**         various device designs.
**
**         RTOS drivers using HAL GPIO API will be simpler and more
**         portable to various microprocessors.
**     Settings    :
**          Component name                                 : GPIO1
**          Port                                           : PTC
**          Port width                                     : 32 bits
**          Mask of allocated pins                         : DA
**          Interrupt service/event                        : Enabled
**            Interrupt                                    : INT_PORTC
**            Interrupt priority                           : medium priority
**          Bit fields                                     : 5
**            Bit field                                    : 
**              Field name                                 : LED_RED
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : CMP0_IN1/PTC7/SPI0_SIN/USB_SOF_OUT/I2S0_RX_FS
**                  Pin signal                             : LED_RED
**                  Initial pin direction                  : Output
**                    Initial output state                 : 0
**                  Initial pin event                      : Disabled
**                  Lock initialization function           : no
**            Bit field                                    : 
**              Field name                                 : MMA_SA0
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : ADC0_SE15/TSI0_CH14/PTC1/LLWU_P6/SPI0_PCS3/UART1_RTS_b/FTM0_CH0/I2S0_TXD0
**                  Pin signal                             : MMA_SA0
**                  Initial pin direction                  : Output
**                    Initial output state                 : 0
**                  Initial pin event                      : Disabled
**                  Lock initialization function           : no
**            Bit field                                    : 
**              Field name                                 : MPL_INT1
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : PTC4/LLWU_P8/SPI0_PCS0/UART1_TX/FTM0_CH3/CMP1_OUT
**                  Pin signal                             : MPL_INT1
**                  Initial pin direction                  : Input
**                  Initial pin event                      : Rising edge
**                  Lock initialization function           : no
**            Bit field                                    : 
**              Field name                                 : TASTER
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : CMP0_IN0/PTC6/LLWU_P10/SPI0_SOUT/PDB0_EXTRG/I2S0_RX_BCLK/I2S0_MCLK
**                  Pin signal                             : TASTER
**                  Initial pin direction                  : Input
**                  Initial pin event                      : Both edges
**                  Lock initialization function           : no
**            Bit field                                    : 
**              Field name                                 : B_POWER_CTRL
**              Pins                                       : 1
**                Pin                                      : 
**                  Pin                                    : CMP1_IN1/PTC3/LLWU_P7/SPI0_PCS1/UART1_RX/FTM0_CH2/CLKOUTa/I2S0_TX_BCLK
**                  Pin signal                             : B_POWER_CTRL
**                  Initial pin direction                  : Output
**                    Initial output state                 : 0
**                  Initial pin event                      : Disabled
**                  Lock initialization function           : no
**          Initialization                                 : 
**            Auto initialization                          : yes
**            Event mask                                   : 
**              OnPortEvent                                : Enabled
**     Contents    :
**         Init                    - LDD_TDeviceData* GPIO1_Init(LDD_TUserData *UserDataPtr);
**         Deinit                  - void GPIO1_Deinit(LDD_TDeviceData *DeviceDataPtr);
**         GetPortValue            - GPIO1_TPortValue GPIO1_GetPortValue(LDD_TDeviceData *DeviceDataPtr);
**         ClearPortBits           - void GPIO1_ClearPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue Mask);
**         SetPortBits             - void GPIO1_SetPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue Mask);
**         TogglePortBits          - void GPIO1_TogglePortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue...
**         SetFieldValue           - void GPIO1_SetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         GetFieldValue           - GPIO1_TFieldValue GPIO1_GetFieldValue(LDD_TDeviceData *DeviceDataPtr,...
**         ClearFieldBits          - void GPIO1_ClearFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         SetFieldBits            - void GPIO1_SetFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         ToggleFieldBits         - void GPIO1_ToggleFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField...
**         SetFieldInputDirection  - void GPIO1_SetFieldInputDirection(LDD_TDeviceData *DeviceDataPtr,...
**         SetFieldOutputDirection - void GPIO1_SetFieldOutputDirection(LDD_TDeviceData *DeviceDataPtr,...
**         ConnectPin              - LDD_TError GPIO1_ConnectPin(LDD_TDeviceData *DeviceDataPtr, LDD_TPinMask...
**
**     Copyright : 1997 - 2012 Freescale, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE GPIO1. */

#include "Events.h"
#include "GPIO1.h"
#include "FreeRTOS.h" /* FreeRTOS interface */
#include "IO_Map.h"

typedef struct {
  GPIO1_TPortValue EventFlags;         /* Holds event flags */
  LDD_TUserData *UserData;             /* RTOS device data structure */
} GPIO1_TDeviceData, *GPIO1_TDeviceDataPtr; /* Device data structure type */
/* {FreeRTOS RTOS Adapter} Global variable used for passing a parameter into ISR */
static GPIO1_TDeviceData * INT_PORTC__BAREBOARD_RTOS_ISRPARAM;
/*
** ===================================================================
**     Method      :  GPIO1_Init (component GPIO_LDD)
**
**     Description :
**         This method initializes the associated peripheral(s) and the
**         component internal variables. The method is called
**         automatically as a part of the application initialization
**         code.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the RTOS device
**                           structure. This pointer will be passed to
**                           all events as parameter.
**     Returns     :
**         ---             - Pointer to the dynamically allocated
**                           private structure or NULL if there was an
**                           error.
** ===================================================================
*/
LDD_TDeviceData* GPIO1_Init(LDD_TUserData *UserDataPtr)
{
  /* Allocate LDD device structure */
  GPIO1_TDeviceData *DeviceDataPrv;

  /* {FreeRTOS RTOS Adapter} Driver memory allocation: RTOS function call is defined by FreeRTOS RTOS Adapter property */
  DeviceDataPrv = (GPIO1_TDeviceData *)pvPortMalloc(sizeof(GPIO1_TDeviceData));
  #if FreeRTOS_CHECK_MEMORY_ALLOCATION_ERRORS
  if (DeviceDataPrv == NULL) {
    return (NULL);
  }
  #endif
  /* Save RTOS Device structure */
  DeviceDataPrv->EventFlags = 0x00U;   /* Clears stored events */
  DeviceDataPrv->UserData = UserDataPtr; /* Store the RTOS device structure */
  /* Interrupt vector(s) allocation */
  /* {FreeRTOS RTOS Adapter} Set interrupt vector: IVT is static, ISR parameter is passed by the global variable */
  INT_PORTC__BAREBOARD_RTOS_ISRPARAM = DeviceDataPrv;
  /* GPIOC_PDOR: PDO&=~0x8A */
  GPIOC_PDOR &= (uint32_t)~(uint32_t)(GPIO_PDOR_PDO(0x8A));                                                   
  /* GPIOC_PDDR: PDD&=~0x50,PDD|=0x8A */
  GPIOC_PDDR = (uint32_t)((GPIOC_PDDR & (uint32_t)~(uint32_t)(
                GPIO_PDDR_PDD(0x50)
               )) | (uint32_t)(
                GPIO_PDDR_PDD(0x8A)
               ));                                                  
  /* Initialization of Port Control registers */
  /* PORTC_PCR7: ISF=0,LK=0,MUX=1 */
  PORTC_PCR7 = (uint32_t)((PORTC_PCR7 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTC_PCR1: ISF=0,LK=0,MUX=1 */
  PORTC_PCR1 = (uint32_t)((PORTC_PCR1 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTC_PCR4: ISF=0,LK=0,MUX=1 */
  PORTC_PCR4 = (uint32_t)((PORTC_PCR4 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTC_PCR6: ISF=0,LK=0,MUX=1 */
  PORTC_PCR6 = (uint32_t)((PORTC_PCR6 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTC_PCR3: ISF=0,LK=0,MUX=1 */
  PORTC_PCR3 = (uint32_t)((PORTC_PCR3 & (uint32_t)~(uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_LK_MASK |
                PORT_PCR_MUX(0x06)
               )) | (uint32_t)(
                PORT_PCR_MUX(0x01)
               ));                                                  
  /* PORTC_PCR4: ISF=1,IRQC=9 */
  PORTC_PCR4 = (uint32_t)((PORTC_PCR4 & (uint32_t)~(uint32_t)(
                PORT_PCR_IRQC(0x06)
               )) | (uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_IRQC(0x09)
               ));                                                  
  /* PORTC_PCR6: ISF=1,IRQC=0x0B */
  PORTC_PCR6 = (uint32_t)((PORTC_PCR6 & (uint32_t)~(uint32_t)(
                PORT_PCR_IRQC(0x04)
               )) | (uint32_t)(
                PORT_PCR_ISF_MASK |
                PORT_PCR_IRQC(0x0B)
               ));                                                  
  /* NVICIP42: PRI42=0x80 */
  NVICIP42 = NVIC_IP_PRI42(0x80);                                                   
  /* NVICISER1: SETENA|=0x0400 */
  NVICISER1 |= NVIC_ISER_SETENA(0x0400);                                                   
  /* Registration of the device structure */
  PE_LDD_RegisterDeviceStructure(PE_LDD_COMPONENT_GPIO1_ID,DeviceDataPrv);
  return ((LDD_TDeviceData *)DeviceDataPrv);
}

/*
** ===================================================================
**     Method      :  GPIO1_Deinit (component GPIO_LDD)
**
**     Description :
**         This method disables the device and frees the device data
**         structure memory.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Pointer to device data
**                           structure pointer.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_Deinit(LDD_TDeviceData *DeviceDataPtr)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  /* PORTC_PCR7: IRQC=0 */
  PORTC_PCR7 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* PORTC_PCR1: IRQC=0 */
  PORTC_PCR1 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* PORTC_PCR4: IRQC=0 */
  PORTC_PCR4 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* PORTC_PCR6: IRQC=0 */
  PORTC_PCR6 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* PORTC_PCR3: IRQC=0 */
  PORTC_PCR3 &= (uint32_t)~(uint32_t)(PORT_PCR_IRQC(0x0F));                                                   
  /* GPIOC_PDDR: PDD&=~0xDA */
  GPIOC_PDDR &= (uint32_t)~(uint32_t)(GPIO_PDDR_PDD(0xDA));                                                   
  /* Interrupt vector(s) deallocation */
  /* {FreeRTOS RTOS Adapter} Restore interrupt vector: IVT is static, no code is generated */
  /* Unregistration of the device structure */
  PE_LDD_UnregisterDeviceStructure(PE_LDD_COMPONENT_GPIO1_ID);
  /* Deallocation of the device structure */
  /* {FreeRTOS RTOS Adapter} Driver memory deallocation: RTOS function call is defined by FreeRTOS RTOS Adapter property */
  #if FRTOS_MEMORY_SCHEME != 1 /* scheme 1 has no deallocate */
  vPortFree((GPIO1_TDeviceDataPtr)DeviceDataPtr);
  #endif
}

/*
** ===================================================================
**     Method      :  GPIO1_GetPortValue (component GPIO_LDD)
**
**     Description :
**         This method returns the current port input data value. Only
**         configured pins (through all of bit fields in this component)
**         are returned.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**     Returns     :
**         ---             - Unaligned current port input data value
**                           masked for allocated pins of the port. The
**                           bit 0 corresponds with the pin which has
**                           index 0 within the port, the bit 1
**                           corresponds with the pin which has index 1
**                           within the port, etc. Only configured pins
**                           (through all of bit fields in this
**                           component) are returned. The others are
**                           zeros.
** ===================================================================
*/
GPIO1_TPortValue GPIO1_GetPortValue(LDD_TDeviceData *DeviceDataPtr)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  return (GPIO1_TPortValue)(GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
    & ((GPIO1_TPortValue)GPIO1_ALLOCATED_PINS_MASK));
}

/*
** ===================================================================
**     Method      :  GPIO1_ClearPortBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the port to the
**         inactive level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to setting the
**                           inactive level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_ClearPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
    ((GPIO1_TPortValue)(((GPIO1_TPortValue)GPIO1_ALLOCATED_PINS_MASK) & ((GPIO1_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO1_SetPortBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the port to the
**         active level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to setting the
**                           active level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_SetPortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
    ((GPIO1_TPortValue)(((GPIO1_TPortValue)GPIO1_ALLOCATED_PINS_MASK) & ((GPIO1_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO1_TogglePortBits (component GPIO_LDD)
**
**     Description :
**         This method inverts the specified bits of the port to
**         another level. Only configured pins (through all of bit
**         fields in this component) are affected.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Mask            - Unaligned mask of bits to inverting the
**                           current level. Each port pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the port,
**                           the bit 1 corresponds with the pin which
**                           has index 1 within the port, etc. Only
**                           configured pins (through all of bit fields
**                           in this component) are affected.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_TogglePortBits(LDD_TDeviceData *DeviceDataPtr, GPIO1_TPortValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
    ((GPIO1_TPortValue)(((GPIO1_TPortValue)GPIO1_ALLOCATED_PINS_MASK) & ((GPIO1_TPortValue)(Mask)))));
}

/*
** ===================================================================
**     Method      :  GPIO1_SetFieldValue (component GPIO_LDD)
**
**     Description :
**         This method sets the output data value of the specified bit
**         field.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Value           - Aligned data value to writting to the
**                           specified bit field. The bit 0 corresponds
**                           with the pin which has index 0 within the
**                           given bit field, the bit 1 corresponds with
**                           the pin which has index 1 within the given
**                           bit field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_SetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO1_TFieldValue Value)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(~((GPIO1_TPortValue)GPIO1_LED_RED_MASK)))
        )
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_LED_RED_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
        )
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(~((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)))
        )
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_MMA_SA0_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
        )
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(~((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)))
        )
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_MPL_INT1_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
        )
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(~((GPIO1_TPortValue)GPIO1_TASTER_MASK)))
        )
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_TASTER_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_TASTER_MASK)
        )
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        (
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(~((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)))
        )
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_B_POWER_CTRL_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
        )
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_GetFieldValue (component GPIO_LDD)
**
**     Description :
**         This method returns the current input data of the specified
**         field.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to reading. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**     Returns     :
**         ---             - Aligned current port input value masked
**                           for allocated pins of the field. The bit 0
**                           corresponds with the pin which has index 0
**                           within the given bit field, the bit 1
**                           corresponds with the pin which has index 1
**                           within the given bit field, etc.
** ===================================================================
*/
GPIO1_TFieldValue GPIO1_GetFieldValue(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      return
        (GPIO1_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
            & (GPIO1_TPortValue)GPIO1_LED_RED_MASK
          )
          >> GPIO1_LED_RED_START_BIT
        );
    }
    case MMA_SA0: {                    /* bit field #1 */
      return
        (GPIO1_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
            & (GPIO1_TPortValue)GPIO1_MMA_SA0_MASK
          )
          >> GPIO1_MMA_SA0_START_BIT
        );
    }
    case MPL_INT1: {                   /* bit field #2 */
      return
        (GPIO1_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
            & (GPIO1_TPortValue)GPIO1_MPL_INT1_MASK
          )
          >> GPIO1_MPL_INT1_START_BIT
        );
    }
    case TASTER: {                     /* bit field #3 */
      return
        (GPIO1_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
            & (GPIO1_TPortValue)GPIO1_TASTER_MASK
          )
          >> GPIO1_TASTER_START_BIT
        );
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      return
        (GPIO1_TFieldValue)(
          (
            GPIO_PDD_GetPortDataInput(GPIO1_MODULE_BASE_ADDRESS)
            & (GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK
          )
          >> GPIO1_B_POWER_CTRL_START_BIT
        );
    }
    default:
      break;                           /* Invalid BitField is not treated, result is undefined */
  } /* switch (Field) */
  return (GPIO1_TFieldValue)0U;
}

/*
** ===================================================================
**     Method      :  GPIO1_ClearFieldBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the specified bit
**         field to the inactive level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to setting the
**                           inactive level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_ClearFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO1_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_LED_RED_START_BIT))
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MMA_SA0_START_BIT))
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MPL_INT1_START_BIT))
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_TASTER_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_TASTER_START_BIT))
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_ClearPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_B_POWER_CTRL_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_SetFieldBits (component GPIO_LDD)
**
**     Description :
**         This method drives the specified bits of the specified bit
**         field to the active level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to setting the
**                           active level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_SetFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO1_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_LED_RED_START_BIT))
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MMA_SA0_START_BIT))
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MPL_INT1_START_BIT))
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_TASTER_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_TASTER_START_BIT))
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_SetPortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_B_POWER_CTRL_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_ToggleFieldBits (component GPIO_LDD)
**
**     Description :
**         This method inverts the specified bits of the specified bit
**         field to other level.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**         Mask            - Aligned mask of bits to inverting the
**                           current level. Each field pin has
**                           corresponding bit in the mask. Bit value 0
**                           means not selected bit, bit value 1 means
**                           selected bit. The bit 0 corresponds with
**                           the pin which has index 0 within the given
**                           bit field, the bit 1 corresponds with the
**                           pin which has index 1 within the given bit
**                           field, etc.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_ToggleFieldBits(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO1_TFieldValue Mask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_LED_RED_START_BIT))
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MMA_SA0_START_BIT))
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_MPL_INT1_START_BIT))
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_TASTER_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_TASTER_START_BIT))
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_TogglePortDataOutputMask(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
        & ((GPIO1_TPortValue)(Mask << GPIO1_B_POWER_CTRL_START_BIT))
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_SetFieldInputDirection (component GPIO_LDD)
**
**     Description :
**         This method sets all pins of the field to the input
**         direction.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to write. Bit fields are
**                           defined during design time and for each bit
**                           field there is a generated constant.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_SetFieldInputDirection(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_LED_RED_MASK
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_MMA_SA0_MASK
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_MPL_INT1_MASK
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_TASTER_MASK
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_SetPortInputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_B_POWER_CTRL_MASK
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_SetFieldOutputDirection (component GPIO_LDD)
**
**     Description :
**         This method sets all pins of the field to the output
**         direction.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         Field           - Bit field to set to the output
**                           direction. Bit fields are defined during
**                           design time and for each bit field there is
**                           a generated constant.
**         Value           - Aligned data value to appear on the
**                           bit field pins after they have been
**                           switched to the output direction.
**     Returns     : Nothing
** ===================================================================
*/
void GPIO1_SetFieldOutputDirection(LDD_TDeviceData *DeviceDataPtr, LDD_GPIO_TBitField Field, GPIO1_TFieldValue Value)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  switch (Field) {                     /* no break */
    case LED_RED: {                    /* bit field #0 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(
            ~((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
          ))
        ))
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_LED_RED_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_LED_RED_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_LED_RED_MASK
      );
      break;
    }
    case MMA_SA0: {                    /* bit field #1 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(
            ~((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
          ))
        ))
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_MMA_SA0_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_MMA_SA0_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_MMA_SA0_MASK
      );
      break;
    }
    case MPL_INT1: {                   /* bit field #2 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(
            ~((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
          ))
        ))
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_MPL_INT1_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_MPL_INT1_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_MPL_INT1_MASK
      );
      break;
    }
    case TASTER: {                     /* bit field #3 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(
            ~((GPIO1_TPortValue)GPIO1_TASTER_MASK)
          ))
        ))
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_TASTER_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_TASTER_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_TASTER_MASK
      );
      break;
    }
    case B_POWER_CTRL: {               /* bit field #4 */
      GPIO_PDD_SetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS,
        ((GPIO1_TPortValue)(
          GPIO_PDD_GetPortDataOutput(GPIO1_MODULE_BASE_ADDRESS)
          & ((GPIO1_TPortValue)(
            ~((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
          ))
        ))
        | (
          ((GPIO1_TPortValue)(Value << GPIO1_B_POWER_CTRL_START_BIT))
          & ((GPIO1_TPortValue)GPIO1_B_POWER_CTRL_MASK)
        )
      );
      GPIO_PDD_SetPortOutputDirectionMask(GPIO1_MODULE_BASE_ADDRESS,
        GPIO1_B_POWER_CTRL_MASK
      );
      break;
    }
    default:
      break;                           /* Invalid Field is not treated, result is undefined */
  } /* switch (Field) */
}

/*
** ===================================================================
**     Method      :  GPIO1_ConnectPin (component GPIO_LDD)
**
**     Description :
**         This method reconnects the requested pin associated with the
**         selected peripheral in this component. This method is only
**         available for CPU derivatives and peripherals that support
**         the runtime pin sharing with other internal on-chip
**         peripherals.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer returned by <Init> method.
**         PinMask         - Mask for the requested pins. The
**                           peripheral pins are reconnected according
**                           to this mask.
**     Returns     :
**         ---             - Error code, possible values:
**                           ERR_OK - OK
**                           ERR_PARAM_MASK - Invalid pin mask
** ===================================================================
*/
LDD_TError GPIO1_ConnectPin(LDD_TDeviceData *DeviceDataPtr, LDD_TPinMask PinMask)
{
  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  /* Pin mask test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if ((PinMask & ((LDD_TPinMask)~((LDD_TPinMask)GPIO1_ALLOCATED_PINS_MASK))) != 0U) {
    return ERR_PARAM_MASK;
  }
  if ((PinMask & LDD_GPIO_PIN_7) != 0U) {
    clrSetReg32Bits(PORTC_PCR7, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  if ((PinMask & LDD_GPIO_PIN_1) != 0U) {
    clrSetReg32Bits(PORTC_PCR1, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  if ((PinMask & LDD_GPIO_PIN_4) != 0U) {
    clrSetReg32Bits(PORTC_PCR4, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  if ((PinMask & LDD_GPIO_PIN_6) != 0U) {
    clrSetReg32Bits(PORTC_PCR6, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  if ((PinMask & LDD_GPIO_PIN_3) != 0U) {
    clrSetReg32Bits(PORTC_PCR3, 0x01000600U, 0x0100U); /* MUX=0x01U */
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  GPIO1_Interrupt (component GPIO_LDD)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes event(s) of the component.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
PE_ISR(GPIO1_Interrupt)
{
  /* {FreeRTOS RTOS Adapter} ISR parameter is passed through the global variable */
  GPIO1_TDeviceDataPtr DeviceDataPrv = INT_PORTC__BAREBOARD_RTOS_ISRPARAM;
  GPIO1_TPortValue State;

  State = (GPIO1_TPortValue)(PORT_PDD_GetInterruptFlags(GPIO1_PORTCONTROL_BASE_ADDRESS)
          & ((GPIO1_TPortValue)GPIO1_ALLOCATED_PINS_MASK)); /* Retrieve flags */
  DeviceDataPrv->EventFlags |= State;
  PORT_PDD_ClearInterruptFlags(GPIO1_PORTCONTROL_BASE_ADDRESS, State); /* Clears flags */
  GPIO1_OnPortEvent(DeviceDataPrv->UserData); /* Call OnPortEvent event */
}

/* END GPIO1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
