/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : LEDRed.c
**     Project     : ProcessorExpert
**     Processor   : MK10DX128VFM5
**     Component   : LED
**     Version     : Component 01.046, Driver 01.00, CPU db: 3.00.000
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-01-15, 16:48, # CodeGen: 56
**     Abstract    :
**
**     Settings    :
**
**     Contents    :
**         On     - void LEDRed_On(void);
**         Off    - void LEDRed_Off(void);
**         Neg    - void LEDRed_Neg(void);
**         Get    - byte LEDRed_Get(void);
**         Put    - void LEDRed_Put(byte val);
**         Init   - void LEDRed_Init(void);
**         Deinit - void LEDRed_Deinit(void);
**
**     License   :  Open Source (LGPL)
**     Copyright : (c) Copyright Erich Styger, 2012, all rights reserved.
**     This an open source software implementing an LED driver using Processor Expert.
**     This is a free software and is opened for education,  research and commercial developments under license policy of following terms:
**     * This is a free software and there is NO WARRANTY.
**     * No restriction on use. You can use, modify and redistribute it for personal, non-profit or commercial product UNDER YOUR RESPONSIBILITY.
**     * Redistributions of source code must retain the above copyright notice.
** ###################################################################*/

/* MODULE LEDRed. */

#include "LEDRed.h"

/*
** ===================================================================
**     Method      :  LEDRed_On (component LED)
**
**     Description :
**         This turns the LED on.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_On(void)
{
  GPIO1_SetPortBits(NULL, GPIO1_LED_RED_MASK);
}

/*
** ===================================================================
**     Method      :  LEDRed_Off (component LED)
**
**     Description :
**         This turns the LED off.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_Off(void)
{
  GPIO1_ClearPortBits(NULL, GPIO1_LED_RED_MASK);
}

/*
** ===================================================================
**     Method      :  LEDRed_Neg (component LED)
**
**     Description :
**         This negates/toggles the LED
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_Neg(void)
{
  GPIO1_TogglePortBits(NULL, GPIO1_LED_RED_MASK);
}

/*
** ===================================================================
**     Method      :  LEDRed_Get (component LED)
**
**     Description :
**         This returns logical 1 in case the LED is on, 0 otherwise.
**     Parameters  : None
**     Returns     :
**         ---             - Status of the LED (on or off)
** ===================================================================
*/
byte LEDRed_Get(void)
{
  return (byte)((GPIO1_GetPortValue(NULL)&GPIO1_LED_RED_MASK)!=0);
}

/*
** ===================================================================
**     Method      :  LEDRed_Init (component LED)
**
**     Description :
**         Performs the LED driver initialization.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_Init(void)
{
  LEDRed_Off();
}

/*
** ===================================================================
**     Method      :  LEDRed_Put (component LED)
**
**     Description :
**         Turns the LED on or off.
**     Parameters  :
**         NAME            - DESCRIPTION
**         val             - value to define if the LED has to be on or
**                           off.
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_Put(byte val)
{
  if(val) {
    LEDRed_On();
  } else {
    LEDRed_Off();
  }
}

/*
** ===================================================================
**     Method      :  LEDRed_Deinit (component LED)
**
**     Description :
**         Deinitializes the driver
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void LEDRed_Deinit(void)
{
  GPIO1_Deinit(NULL);
}

/* END LEDRed. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
