//-----------------------------------------------------------------------------
//  DebugDrv.c
/// @file
///
/// @brief <Bitte Kurzbeschreibung eintragen.>
///
/// <Bitte Langbeschreibung eintragen.>
///
/// @see <Verweis auf weitere Klassen>
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Entwurf
/// @date    $Date:$
/// @version $Revision:$
/// @author  Eike Mueller(TABO)
///
/// @todo <[optional] Gibt es noch offene Punkte?>
/// @todo <[optional] Die Beschreibung eines offenen Punktes kann im Code auch
///        mehr als eine Zeile lang sein. Bzgl. der Todo-Suche mit grep findet
///        man so jedoch nur die erste Zeile des Todos.>
///
/// @history
/// Datum/Ver  Author/Vernderung
///
/// 2013-01-15 Eike Mueller(TABO)
///            Entwurf => V.1.0
/// @endhistory
/// @todo <Dieser Kommentarblock wurde durch ein Makro eingefuegt. Bitte fuellen
///        Sie die Felder in den spitzen Klammern mit sinnvollen Werten aus.>
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------
#include "Events.h"

/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "DebugDrv.h"

//-----------------------------------------------------------------------------
// Private-Definitionen, -Makros und -Konstanten
//-----------------------------------------------------------------------------
#define DIGITS 6
#define uchar unsigned char
//-----------------------------------------------------------------------------
// Private-Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Externe Referenzen
//-----------------------------------------------------------------------------
extern bool UARTDataTransmittedFlg;
LDD_TDeviceData * m_pDeviceDataPtr;
//-----------------------------------------------------------------------------
// Modulglobale Variable
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der private-Funktionen
//-----------------------------------------------------------------------------

void putcharx( int8_t val );

//-----------------------------------------------------------------------------
// Implementierung
//-----------------------------------------------------------------------------

void outstring( char * pChar, int16_t StringLenght )
{
   AS1_SendBlock( m_pDeviceDataPtr, pChar, StringLenght);
   while (!UARTDataTransmittedFlg);  
   UARTDataTransmittedFlg = FALSE;
}

void outfloat( float val )
{
   char ep, dp, i, num;

   if( val < 0 )
   {
      val = -val;
      putcharx( '-' );
   }

   ep = 0;

   if( val != 0 )
   {
      if( val < 1 )
      {
         val *= 1000;
         ep = -3;
      }

      if( val >= 1000 )
      {
         val *= 0.001;
         ep = 3;
      }
   }

   for( dp = 1; val >= 10; val *= 0.1 )    // normalize (x.xxx)
      dp ++;

   for( i = DIGITS;; )
   {        // n digits
      putcharx( (num = val) + '0' );    // get digit
      if( --i == 0 )
         break;
      if( --dp == 0 )        // set decimal point
         putcharx( ',' );
      val = (val - num) * 10;      // next digit
   }
   if( ep )
   {
      putcharx( 'e' );
      outint( ep );
   }
}

void outint( int val )
{
   int16_t TEST[] = { 10, 100, 1000, 10000 };
   uchar d, i;
   int8_t zero;
   int16_t uval = val;

   if( val < 0 )
   {
      uval = -val;
      putcharx( '-' );
   }

   zero = 1;
   i = 4;

   do
   {
      i--;
      for( d = '0'; uval >= TEST[i]; uval -= TEST[i] )
      {
         d++;
         zero = 0;
      }

      if( zero == 0 )
         putcharx( d );
   } while( i );

   putcharx( (uchar)uval + '0' );
}

void putcharx( int8_t val )
{
   AS1_SendBlock( m_pDeviceDataPtr,  &val, 1);
   while (!UARTDataTransmittedFlg);  
   UARTDataTransmittedFlg = FALSE;
}
