//-----------------------------------------------------------------------------
//  MMA8451Q_Defs.h
/// @file
///
/// @brief Definitions for the sensor MMA845X
///
/// Definitions for the sensor MMA845X
///
/// @copyright 2013-2013 Sirona Dental Systems GmbH - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-05 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MMA8451Q_DEFS_H
 #define __MMA8451Q_DEFS_H

//-----------------------------------------------------------------------------
// Standard include files
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Project specific include files
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitions ,makros and constants
//-----------------------------------------------------------------------------

/*----------------------------------------------------------------------------*/
/* Status register                                                            */
/*----------------------------------------------------------------------------*/
/// Data overwrite x-, y- and z-axis
#define MMA845X_STATUS_REG_ZYXOW       0x80
/// Data overwrite z-axis
#define MMA845X_STATUS_REG_ZOW         0x40
/// Data overwrite y-axis
#define MMA845X_STATUS_REG_YOW         0x20
/// Data overwrite x-axis
#define MMA845X_STATUS_REG_XOW         0x10
/// Data ready for x-, y- and z-axis
#define MMA845X_STATUS_REG_ZYXDR       0x08
/// Data ready for z-axis
#define MMA845X_STATUS_REG_ZDR         0x04
/// Data ready for y-axis
#define MMA845X_STATUS_REG_YDR         0x02
/// Data ready for x-axis
#define MMA845X_STATUS_REG_XDR         0x01


/// Full scale value 2G
#define DATA_CFG_FULL_SCALE_VAL_2G        0
/// Full scale value 2G
#define DATA_CFG_FULL_SCALE_VAL_4G        1
/// Full scale value 2G
#define DATA_CFG_FULL_SCALE_VAL_8G        2

/*----------------------------------------------------------------------------*/
/* Control register 1                                                         */
/*----------------------------------------------------------------------------*/
/// Standby mask
#define MMA845X_STANDBY_SBYB_MASK      0xFE
/// Active mask
#define MMA845X_ACTIVE_SBYB_MASK       0x01

/// F-Read clear mask
#define MMA845X_FREAD_CLEAR_MASK       0xFD
/// F-Read set mask
#define MMA845X_FREAD_SET_MASK         0x02

/// Bitmask output data rate 800 hz
#define MMA845X_DR_BITS_800_HZ         0x00
/// Bitmask output data rate 400 hz
#define MMA845X_DR_BITS_400_HZ         0x08
/// Bitmask output data rate 200 hz
#define MMA845X_DR_BITS_200_HZ         0x10
/// Bitmask output data rate 100 hz
#define MMA845X_DR_BITS_100_HZ         0x18
/// Bitmask output data rate 50 hz
#define MMA845X_DR_BITS_50_HZ          0x20
/// Bitmask output data rate 12,5 hz
#define MMA845X_DR_BITS_12_5_HZ        0x28
/// Bitmask output data rate 6,25 hz
#define MMA845X_DR_BITS_6_25_HZ        0x30
/// Bitmask output data rate 1,563 hz
#define MMA845X_DR_BITS_1_563_HZ       0x38
/// Bitmask output data bits
#define MMA845X_DR_BITS                0x38

/// Bitmask mods normal
#define MMA845X_MODS_BITS_NORMAL       0x00
/// Bitmask mods low noise low power
#define MMA845X_MODS_BITS_LOW_NOISE    0x01
/// Bitmask mods high resolution
#define MMA845X_MODS_BITS_HIGH_RES     0x02
/// Bitmask mods low power
#define MMA845X_MODS_BITS_LOW_POWER    0x03
/// Bitmask mods bits
#define MMA845X_MODS_BITS              0x03

/*----------------------------------------------------------------------------*/
/* Registeraddresses                                                         */
/*----------------------------------------------------------------------------*/

/// status register
#define MMA845X_STATUS_REG             0x00
/// Startaddress of the sample data output registers
#define MMA845X_REG_DATA_REGISTERS     0x01
/// Device identification register
#define MMA845X_REG_WHO_AM_I           0x0D
/// Data config register
#define MMA845X_REG_DATA_CONFIG        0x0E
/// Control register 1
#define MMA845X_REG_CTRL_REG1          0x2A
/// Control register 1
#define MMA845X_REG_CTRL_REG2          0x2B

//-----------------------------------------------------------------------------
// Datatypes
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypes of public functions
//-----------------------------------------------------------------------------

#endif //__MMA8451Q_DEFS_H
