//-----------------------------------------------------------------------------
//  SST25PFx.h
/// @file
///
/// @brief Header for the module SST25PFx.c
///
/// This is the header for the module SST25PFx.c.
///
/// @copyright 2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-04-23 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __SST25PFX_H
 #define __SST25PFX_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------
/// Length for the security id
#define SST25PFX_SECURITY_ID_LENGTH     32
/// Device id of the SST25PF020B device
#define SST25PFX_DEVICE_ID_020B       0x8C
/// Device id of the SST25PF040B device
#define SST25PFX_DEVICE_ID_040B       0x8D
/// Device id of the SST25PF080B device
#define SST25PFX_DEVICE_ID_080B       0x8E

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------
// Init function for the flash memory SST25PFx
void SST25PFX_Init(LDD_TDeviceData * SPI_Handle);
// Read the id of the flash memory
void SST25PFX_ReadID( PUBYTE pManID, PUBYTE pDeviceID);
// Read a data block from the flash memory
UWORD SST25PFX_ReadBlock(UDWORD TargetAddress, PUBYTE pBuffer, UWORD NumOfData);
// Complete chip erase
void SST25PFX_ChipErase();
// SST25PFX_ReadSecurityID
UBYTE SST25PFX_ReadSecurityID( PUBYTE pSecurityID );
// Write a data block to the flash memory
UWORD SST25PFX_WriteBlock(UDWORD TargetAddress, PUBYTE pBuffer, UWORD NumOfData);
// Disable the memory block protection
void SST25PFX_DisableBlockProtection();
// Sector erase
void SST25PFX_SectorErase( UDWORD SectorAddress );
// 32k block erase
void SST25PFX_32KBlockErase( UDWORD SectorAddress );
// 64k block erase
void SST25PFX_64KBlockErase (UDWORD SectorAddress);
// Write a single byte to the flash memory
void SST25PFX_WriteByte (UDWORD TargetAddress, UBYTE DataByte);

#endif //__SST25PFX_H
