/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MK10DX128VFM5
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2012-12-21, 13:02, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "GPIO1.h"
#include "GPIO2.h"
#include "LEDRed.h"
#include "LEDGreen.h"
#include "LEDYellow.h"
#include "TU1.h"
#include "SM1.h"
#include "I2C1.h"
#include "AS1.h"
#include "GPIO3.h"
#include "FRTOS1.h"
#include "RTOSTICKLDD1.h"
#include "UTIL1.h"
#include "TU2.h"
#include "FreeRTOS.h"
#include "task.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "Application.h"
#include "MeasureM.h"
#include "ProcessM.h"
#include "LedM.h"
#include "Tools.h"
#include "OS.h"
#include "MessageDefs.h"

// ISR for the 10ms timer interrupt
void Timer_Interrupt_CB(void);
//  Check the key action
void ProcessKey(void);

/// Structure for detection of the button events
BUTTON_EVENTS m_ButtonEvents;
/// Counter for the 10ms timer interrupts
int m_iMeasureTimer = 0;
/// Timeout for doing a new measurement
int m_MeasureTimeout = 9;

//-----------------------------------------------------------------------------
//  Function Timer_Interrupt_CB
///
/// @brief Interrupt service routine for the 10ms timer interrupt
///
/// This is the interrupt service routine for the 10ms timer interrupt.
///
/// @status  Draft
/// @date    2013-07-07
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-07 Eike Mueller(TABO)
///            Draft
/// @endhistory
//-----------------------------------------------------------------------------
void Timer_Interrupt_CB (void)
{
   // trigger the measuring job
   m_MeasureTimeout = ProcessM_GetMeasureTimeout();

  if( m_iMeasureTimer >= m_MeasureTimeout)
  {
     MeasureM_SetJob( MMJ_DO_MEASURING );
     m_iMeasureTimer = 0;
  }
  else
  {
     m_iMeasureTimer++;
  }

  ProcessKey();

  LedM_CalcLEDState();
  
  taskYIELD();
}

//-----------------------------------------------------------------------------
//  Function ProcessKey
///
/// @brief Calculate the state of the key and generate button events
///
/// This funtion is for calculating the state of the key and generate button
/// events.
///
/// @status  Draft
/// @date    2013-07-07
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-07 Eike Mueller(TABO)
///            Draft
/// @endhistory
//-----------------------------------------------------------------------------
void ProcessKey (void)
{
   MESSAGE Msg;

   switch( m_ButtonEvents.ButtonState )
   {
      case BUTTON_RELEASED:
      {
         if (m_ButtonEvents.ButtonStateEnbounce == BUTTON_PRESSED)
         {
            if(m_ButtonEvents.ButtonPressedDetectedNTimes < 5)
            {
               m_ButtonEvents.ButtonPressedDetectedNTimes++;
            }
            else
            {
               m_ButtonEvents.ButtonPressedDetectedNTimes = 0;
               m_ButtonEvents.ButtonStateEnbounce = BUTTON_RELEASED;
            }
         }
      }
      break;

      case BUTTON_PRESSED:
      {
         if (m_ButtonEvents.ButtonStateEnbounce == BUTTON_RELEASED)
         {
            if(m_ButtonEvents.ButtonReleasedDetectedNTimes < 5)
            {
               m_ButtonEvents.ButtonReleasedDetectedNTimes++;
            }
            else
            {
               m_ButtonEvents.ButtonReleasedDetectedNTimes = 0;
               m_ButtonEvents.ButtonStateEnbounce = BUTTON_PRESSED;
               m_ButtonEvents.ButtonActionDetected = TRUE;
               m_ButtonEvents.ButtonActionTimeout = 0;
               m_ButtonEvents.ButtonEventNTimes++;
            }
         }
      }
      default:
      break;
   }

   if(m_ButtonEvents.ButtonActionDetected == TRUE)
   {
      if(m_ButtonEvents.ButtonActionTimeout < 100)
      {
         m_ButtonEvents.ButtonActionTimeout++;
      }
      else
      {
        // m_ButtonEvents.ButtonAction = m_ButtonEvents.ButtonEventNTimes;

         Msg.MessageID = MSG_KEY_ACTION;
         Msg.pMessageData = (UBYTE *) AllocateMemory(sizeof(UBYTE));
     
         if( Msg.pMessageData )
         {
            Msg.pMessageData[0] = m_ButtonEvents.ButtonEventNTimes;
            (void)OS_SendMessageNB( TASK_ID_PROCESS_M, &Msg );
         }

         m_ButtonEvents.ButtonEventNTimes = 0;
         m_ButtonEvents.ButtonActionDetected = FALSE;
      }
   }
}

//-----------------------------------------------------------------------------
//  Function InitButtonProcess
///
/// @brief Init the button process
///
/// This function init the button process.
///
/// @status  Draft
/// @date    2013-07-07
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-07 Eike Mueller(TABO)
///            Draft
/// @endhistory
//-----------------------------------------------------------------------------
void InitButtonProcess (void)
{
   m_ButtonEvents.ButtonPressedDetected         = FALSE;
   m_ButtonEvents.ButtonReleasedDetected        = FALSE;
   m_ButtonEvents.ButtonActionDetected          = FALSE;
   m_ButtonEvents.ButtonActionTimeout           = 0;
   m_ButtonEvents.ButtonAction                  = NO_ACTION;
   m_ButtonEvents.ButtonPressedDetectedNTimes   = 0;
   m_ButtonEvents.ButtonReleasedDetectedNTimes  = 0;
   m_ButtonEvents.ButtonEventNTimes             = 0;
   m_ButtonEvents.ButtonState                   = BUTTON_RELEASED;
   m_ButtonEvents.ButtonStateEnbounce           = BUTTON_RELEASED;
}

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
//-----------------------------------------------------------------------------
//  Function main
///
/// @brief Main function
///
/// @return int unused
///
/// This is the main function of the app.
///
/// @status  Draft
/// @date    2013-07-07
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-07 Eike Mueller(TABO)
///            Draft
/// @endhistory
//-----------------------------------------------------------------------------
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
    
  InitButtonProcess();

  //xTaskCreate(vaTask,"taskn", 100, NULL, 5, NULL);
  /* For example: for(;;) { } */
  StartApplication();
  
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
       
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
