
// Auswerten der Digitalschnittstelle eines Messschiebers;
// Steckbrett-Aufbau nach CaliperSteckplatine.png

int i;
int sign;
long value;
float result;

int clockpin = 4; // Clock-Pin des Messschiebers an Arduino Pin 4  
int datapin  = 5; // Data-Pin  des Messschiebers an Arduino Pin 5

unsigned long temp;

void setup() 
{

  Serial.begin(9600);
  pinMode( clockpin, INPUT);
  pinMode( datapin, INPUT);
}


 void loop () 
 {
   while ( digitalRead( clockpin) == HIGH) {} // warten bis Clock von LOW nach HIGH wechselt

   temp=micros();

   while ( digitalRead( clockpin) == LOW) {} // warten bis HIGH-Impuls endet

   if ( ( micros()-temp) > 500) 
   { // Ist der HIGH-Impuls länger als 500 Mikrosekunden, beginnt eine neue Bit-Sequenz zum dekodieren.
     decode(); 
   }
}

void decode() 
{
  sign = 1;
  value = 0;

  for ( i = 0; i < 23; i++) 
  {

    while ( digitalRead( clockpin) == HIGH) { } 

    while ( digitalRead( clockpin) == LOW) { }

    if ( digitalRead( datapin) == LOW) 
    {
      if ( i < 20) 
      {
        value|= 1 << i;
      }

      if ( i == 20) 
      {
        sign=-1;
      }
    }
  }

  result = ( value * sign) / 100.00;    

  Serial.println( result, 2); // Ergebnis mit 2 Dezimalstellen anzeigen
  
  delay( 1000);
}
