#module mdso
# -*- coding: utf_8 -*-
# group check os and version
from __future__ import print_function
import sys
p = sys.platform
v = sys.version_info
# choice
if v[0] == 2 and v[1] >= 6 :  
    from Tkinter  import *
    from tkFont import Font
    import tkFileDialog, tkColorChooser,tkSimpleDialog
    import Queue
elif v[0] == 3 :  
    unichr=chr
    import queue as Queue
    import tkinter.filedialog as tkFileDialog, tkinter.colorchooser as tkColorChooser, tkinter.simpledialog as tkSimpleDialog
    from tkinter.font import Font
    from tkinter import *
else:  
    print (v,"is not supported, 2.6 and up required")
    sys.exit()
# end choice
dsoDisplaySize = (320,240); pixmapBufferSize = 320* 240 //2 + 512
if not p.startswith("win") and not p.startswith("lin") :
    print ("This program does not run on",p)
#imports
import os,re,sys,struct,string,ctypes
from os import system
from time import time, sleep,asctime
from math import *
import traceback
from numpy.fft import *
import multiprocessing
import numpy,array
import gc
import usb
# classes
class control (Frame):
    # classes
    class channelsFrame (Frame):
        def __init__(self,root):
            Frame.__init__(self,root)
            self.root = root
            #print( "init channels")
            root.channelFrameList = []  
            mychannelFrame = Control.channelFrame(self,0,CH1)
            root.channelFrameList.append(mychannelFrame)
            mychannelFrame.grid(column=0,row=0,sticky="nes",columnspan=1) 
            mychannelFrame = Control.channelFrame(self,1,CH2)
            root.channelFrameList.append(mychannelFrame)
            mychannelFrame.grid(column=1,row=0,sticky="nws",columnspan=1)
            self.config(bg=brown,relief="flat",borderwidth=0,height=100,pady=10)
        # end init channelsFrame
    # end class channelsFrame
    class channelControl ():
        def __init__(self):
            pass
        # end init channelControl
        def refreshChannels(self,pixmap,channel,req=None):
            t = time()
            status = 0
            if pixmap == None : return
            memfile = extractSubpicture(pixmap)
            signature =getSignature(pixmap, row = 130,  firstColumn = 273,lastColumn = 284)
            if signature == b"bfbffffbbfff" :
                print ("Scope refreshChannels signature %s " % signature)
            try: 
                offset = 0
                signature = getSignature(pixmap,row=7, firstColumn=276,lastColumn=288)
                #print( "sig trigger headline",signature)
                # choice
                if signature == b"bfbbfbbbbbbb" : pass #print( "channel map")
                else:  
                    memfile = extractSubpicture(pixmap,filename="refresh.ppm")
                    print ("refreshChannels trigger headline signature error",signature); return
                # end choice
            except Exception as message : 
                print( "refreshChannels", message )
            signature = getSignature(pixmap, row = 130,  firstColumn = 280,lastColumn = 292)
            # choice
            if signature == b"f111f11111f1"  :  
                CurrentView.channelFrameList[channel].setGainMode("Coarse",req)
            elif signature == b"1f11111f1f11" :  
                CurrentView.channelFrameList[channel].setGainMode("Fine",req)
            else:  
                print( "gain mode error",signature)
                errorData = open("gainModeData.err","wb"); errorData.write(pixmap); errorData.close()
                memfile = extractSubpicture(pixmap, firstRow = 0, lastRow = 240, firstColumn = 0,lastColumn = 320,filename="gainModeError.ppm")
                self.Perr = PhotoImage(); self.Perr.config(file="gainModeError.ppm"); self.Perr = self.Perr.zoom(2)
                PixmapWindow.monitorCanvas.create_image(0,0,image=self.Perr,anchor=NW)
                return
            # end choice
            try: 
                offset = 0
                memfile = extractSubpicture(pixmap,firstRow=216, lastRow = 227,firstColumn=108,lastColumn=160,colorListIndex=0)
                self.PI7 = PhotoImage(); self.PI7.config(data=memfile)
                CurrentView.channelFrameList[1].gainLabel.config(image=self.PI7)
            except Exception as message : 
                print( "refreshChannels", message )
            try: 
                offset = 0
                memfile = extractSubpicture(pixmap,firstRow=216, lastRow = 227,firstColumn=30,lastColumn=80,colorListIndex=0)
                self.PI6 = PhotoImage(); self.PI6.config(data=memfile);
                CurrentView.channelFrameList[0].gainLabel.config(image=self.PI6)
            except Exception as message : 
                print( "refreshChannels", message )
            try: 
                offset = 0
                #memfile = extractSubpicture(parameter,firstRow=0, lastRow = 10,firstColumn=80,lastColumn=130,filename = "triggeredxx.ppm")
                signature = getSignature(pixmap,row=6, firstColumn=104,lastColumn=116)
                #print( "signature",signature)
                # choice
                if   signature == b"6b6bbbbbb666" : # Scan 
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="  Scan  ",fg="red")
                    #print( "Scan")
                elif signature == b"bb6bbb6b6b6b" : # Armed
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="  Armed  ",fg="red")
                    #print( "Armed")
                elif signature == b"bb6bbb6b6666" : # Triggered
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="Triggered",fg="green")
                    #print( "Triggered")
                elif signature == b"6bbb6bbb6bbb" : # Stop
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="  Stop  ",fg="red")
                    #print( "Stop")
                elif signature == b"bb66666bb666" : # Ready
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="  Ready  ",fg="yellow")
                    #print( "Ready")
                elif signature == b"bb6bbb6bbb6b" : # Auto
                    CurrentView.ButtonFrame.triggerStateLabel.config(text="  Auto  ",fg="yellow")
                    #print( "Auto")
                else:  
                    self.ButtonFrame.triggerStateLabel.config(text="  ?  ",fg="yellow")
                    print( "???",signature)
                # end choice
            except Exception as message : 
                print( "refreshChannels", message )
            #print( "Scope end refreshChannels time %3.3f channel %i req %s" % (time()-startTime,channel,req))
            #print( "refreshChannels",time()-t)
        #end refreshChannels
        def scrollGain(self,event,widget):
            #print ("Control.channelControl.scrollGain",event.num,event.delta,widget.Nr)
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.gainUp(widget.Nr)
                else:  
                    self.gainDown(widget.Nr)
                # end choice
            elif event.delta > 0 :  
                self.gainUp(widget.Nr)
            else:  
                self.gainDown(widget.Nr)
            # end choice
        #end scrollGain
        def setGainMode(self,mode,req=""):
            # choice
            if mode != "Coarse" :  
                self.Coarse = False; self.g.config(text="    Gain Fine  ")
            else:  
                self.Coarse = True;  self.g.config(text="Gain Coarse  ")
            # end choice
            #print ("Scope setGainMode time %3.3f channel %i %s %s" %(time()-startTime,self.Nr,mode,req))
        #end setGainMode
        def gainDown(self,channelNr):
            channelCode = [7,9][channelNr]
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,channelCode),GAIN_DN))
            USBQ.put(("ReqChannelMap",channelNr,"gainDown"))
        #end gainDown
        def gainUp(self,channelNr):
            channelCode = [7,9][channelNr]
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,channelCode),GAIN_UP))
            USBQ.put(("ReqChannelMap",channelNr,"gainUp"))
        #end gainUp
        def scrollY(self,event,widget):
            #print ("ChannelControl.scrollY",event.num,event.delta,widget.Nr)
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.yUp(widget.Nr)
                else:  
                    self.yDown(widget.Nr)
                # end choice
            elif event.delta > 0 :  
                self.yUp(widget.Nr)
            else:  
                self.yDown(widget.Nr)
            # end choice
        #end scrollY
        def yDown(self,channelNr):
            channelCode = [7,9][channelNr]
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,channelCode),V_DN))
            USBQ.put(("ReqChannelMap",channelNr))
        #end yDown
        def yUp(self,channelNr):
            channelCode = [7,9][channelNr]
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,channelCode),V_UP))
            USBQ.put(("ReqChannelMap",channelNr))
        #end yUp
    # end class channelControl
    class channelFrame (Frame):
        def __init__(self,root,channelNr,CHn):
            Frame.__init__(self,root)
            #print(self.View)
            self.channelNr = channelNr; self.Nr = channelNr; self.CHn = CHn
            self.dimColor = "gray"
            self.TrackColor = colors[channelNr]
            Cbox = Frame(self)
            Cbox.grid(column=0,row=0,sticky="nsew")
            Cbox.config(bg=brown,bd=0,pady=0)
            self.Channel_var = StringVar()
            self.Channel = Label(Cbox,text='Channel ' + str(channelNr+1))
            self.Channel.grid(column=0,row=0,columnspan=3,sticky="news")
            self.Channel.config(bg=brown,fg="black",borderwidth=0) # ,width=int(sizeFactor*7)
            self.g_var = StringVar()
            self.g = Label(Cbox,text='Gain         ')
            self.g.grid(column=0,row=1,sticky="ew")
            self.g.config(bg=brown,fg=self.dimColor,borderwidth=2,highlightcolor="white",justify="left",relief="flat",anchor="e")
            self.gainLabel_var = StringVar()
            self.gainLabel=MLabel(Cbox,text='')
            self.gainLabel.grid(column=1,row=1,sticky="w")
            self.gainLabel.config(relief='flat',borderwidth=0,bg=brown,fg=self.TrackColor)
            self.gainLabel.command = ChannelControl.scrollGain; self.gainLabel.Nr = channelNr
            self.coupling_var = StringVar()
            self.coupling = Label(Cbox,text='Coupling  ')
            self.coupling.grid(column=0,row=2,sticky="e")
            self.coupling.config(relief='groove',borderwidth=0,bg=brown,fg=self.dimColor)
            self.couplingValue_var = StringVar()
            self.couplingValue = Label(Cbox,text='  ')
            self.couplingValue.grid(column=1,row=2,sticky="w")
            self.couplingValue.config(relief='groove',borderwidth=0,fg=self.TrackColor,bg=brown)
            self.probe_var = StringVar()
            self.probe = Label(Cbox,text='Probe  ')
            self.probe.grid(column=0,row=4,sticky="e")
            self.probe.config(relief='groove',borderwidth=0,bg=brown,fg=self.dimColor)
            invert_var = StringVar()
            invert = Label(Cbox,text='Invert  ')
            invert.grid(column=0,row=5,sticky="e")
            invert.config(relief='groove',borderwidth=0,bg=brown,fg=self.dimColor)
            self.Inversion_var = StringVar()
            self.Inversion = Label(Cbox,text='')
            self.Inversion.grid(column=1,row=5,sticky="w")
            self.Inversion.config(relief='groove',borderwidth=0,fg=self.TrackColor,bg=brown)
            BW_var = StringVar()
            BW = Label(Cbox,text='BW limit  ')
            BW.grid(column=0,row=3,sticky="e")
            BW.config(relief='groove',borderwidth=0,bg=brown,fg=self.dimColor)
            self.BWLimit_var = StringVar()
            self.BWLimit = Label(Cbox,text='none')
            self.BWLimit.grid(column=1,row=3,sticky="w")
            self.BWLimit.config(relief='groove',borderwidth=0,fg=self.TrackColor,bg=brown)
            self.probeFactor_var = StringVar()
            self.probeFactor = Label(Cbox,text='×')
            self.probeFactor.grid(column=1,row=4,sticky="w")
            self.probeFactor.config(relief='groove',borderwidth=0,fg=self.TrackColor,bg=brown)
            self.yPos_var = StringVar()
            self.yPos = Label(Cbox,text='Y Position  ')
            self.yPos.grid(row=6,column=0,sticky="e")
            self.yPos.config(relief='groove',borderwidth=0,bg=brown,fg=self.dimColor)
            self.yPosValue_var = StringVar()
            self.yPosValue=MLabel(Cbox,text='')
            self.yPosValue.grid(row=6,column=1,sticky="w")
            self.yPosValue.config(relief='flat',borderwidth=0,bg=brown,fg=self.TrackColor)
            self.yPosValue.command = ChannelControl.scrollY; self.yPosValue.Nr = channelNr
            params_var = StringVar()
            params = Label(Cbox,text='show Parameter:')
            params.grid(column=0,row=7,columnspan=2,sticky="wns")
            params.config(relief='flat',borderwidth=0,bg=brown,fg=self.dimColor)
            self.paramBox = Frame(Cbox)
            self.paramBox.grid(column=0,row=8,columnspan=2,sticky="wens"); self.paramBox_var = StringVar()
            self.paramBox.config(borderwidth=1,bg=brown,padx=0)
            self.OnOff=Radiobutton(self.paramBox,text=' off ',value='off')
            self.OnOff.config(variable=self.paramBox_var)
            self.OnOff.pack(side="left")
            self.OnOff.config(command=callback(self.setOnOff,self.OnOff),indicatoron = False,bg=brown,fg=self.TrackColor,selectcolor=brown,borderwidth=0,highlightthickness=0,padx=0)
            self.single=Radiobutton(self.paramBox,text=' single ',value='single')
            self.single.config(variable=self.paramBox_var)
            self.single.pack(side="left")
            self.single.config(command=self.setSingle,indicatoron=False,bg=brown,fg=self.dimColor,selectcolor=brown,activeforeground = self.TrackColor,highlightthickness=0,borderwidth=0,padx=0)
            self.repeat=Radiobutton(self.paramBox,text=' repeat ',value='repeat')
            self.repeat.config(variable=self.paramBox_var)
            self.repeat.pack(side="left")
            self.repeat.config(command=self.setRepeat,indicatoron=False,bg=brown,fg=self.dimColor,selectcolor=brown,borderwidth=0,highlightthickness=0,padx=0)
            self.fastRepeat=Radiobutton(self.paramBox,text=' fast repeat ',value='fastRepeat')
            self.fastRepeat.config(variable=self.paramBox_var)
            self.fastRepeat.pack(side="left")
            self.fastRepeat.config(command=self.setFastRepeat,indicatoron=False,bg=brown,fg=self.dimColor,selectcolor=brown,borderwidth=0,highlightthickness=0,padx=0)
            self.config(borderwidth=1,relief="solid",bg="white",pady=1,padx=1)
            self.Channel.config(fg=self.TrackColor,bg=brown)
            self.gainLabel_var.set("-1"); self.setGain(-1)
            self.config(bg="white",pady=1,padx=1)
            self.root=root
            self.gainLabel.config(borderwidth=0,highlightthickness=0); #self.gainLabel.Nr = channelNr
            self.probeText = ("×1","×10","×100","×1000")
            self.g.bind("<Button-1>",self.changeCoarse)
            # choice
            if self.channelNr == 0 :  
                self.channelCode = 7
                self.firstColumn = 26; self.lastColumn = 66
            else:  
                self.channelCode = 9
                self.firstColumn = 108; self.lastColumn = 146
            # end choice
            self.couplingValue.bind("<Button-1>",self.setCoupling)
            self.coupling.bind("<Button-1>",self.setCoupling)
            self.probe.bind("<Button-1>",self.setProbe)
            self.probeFactor.bind("<Button-1>",self.setProbe)
            self.Inversion.bind("<Button-1>",self.setInversion)
            invert.bind("<Button-1>",self.setInversion)
            self.BWLimit.bind("<Button-1>",self.setBW)
            BW.bind("<Button-1>",self.setBW)
            self.Channel.bind("<Button-1>",self.setChannelOn)
            self.Channel.bind("<Button-3>",self.clearChannel)
            #self.yPos.bind("<Button-5>",self.yDown)
            self.yPos.bind("<Button-1>",self.setZero)
            self.posValue = 0
            self.Coarse = True
            USBQ.put(("ReqChannelMap",self.Nr,"init"))
        # end init channelFrame
        def configChannel(self,ch_data, all_data):
            gainValue = 1
            #print( "configChannel",self.Nr,ch_data["active"])
            # choice
            if not ch_data["active"] :  
                #self.gainLabel_var.set("Off"); self.gainLabel.config(text="Off")
                self.Channel.config(fg=self.dimColor)
            else:  
                oldValue = self.gainLabel_var.get(); #print( type(oldValue))
                gainValue = ch_data["V/div"]; #print( "value",value,type(value))
                if oldValue != "Off" :
                    oldValue = float(self.gainLabel_var.get()); #print( type(oldValue))
                # choice
                if gainValue <1.0 :  
                    t = "%3.0f mV/div" % (gainValue*1000)
                else:  
                    t = "%3.0f V/div" % (gainValue)
                # end choice
                self.gainLabel_var.set(gainValue); #self.gainLabel.config(text=t)
                if gainValue != oldValue and False : print( "newValue",value,"old",oldValue,oldValue)
                self.Channel.config(fg=self.TrackColor)
            # end choice
            self.couplingValue.config(text=ch_data["coupling"])
            # choice
            if self.Nr == 0 :  
                probeFactor1 = all_data[Y_PROBE_CH1]
                CurrentView.display.shiftScale((CurrentView.display.leftScale,0))
                self.probeFactor.config(text=self.probeText[probeFactor1])
            else:  
                probeFactor1 = all_data[Y_PROBE_CH2]
                CurrentView.display.shiftScale((CurrentView.display.rightScale,1))
                self.probeFactor.config(text=self.probeText[probeFactor1])
            # end choice
            idx = ch_data["BW_limit"]; bwtext = ("Off","On")[idx]
            self.BWLimit.config(text=bwtext)
            idx = (9,41)[self.Nr]
            value = all_data[idx]; invText = "  "
            if value == 0 or value == 1 : invText = ("Off","On")[value]
            self.Inversion.config(text=invText)
            idx = (6,38)[self.Nr]
            self.posValue = (126.0 - all_data[idx])*gainValue/ 25
            yposText = convertU(self.posValue) # "%3.3f" % (self.posValue)
            self.yPosValue.config(text=yposText)
        #end configChannel
        def setGainMode(self,mode,req=""):
            # choice
            if mode != "Coarse" :  
                self.Coarse = False; self.g.config(text="    Gain Fine  ")
            else:  
                self.Coarse = True;  self.g.config(text="Gain Coarse  ")
            # end choice
            #print ("Scope setGainMode time %3.3f channel %i %s %s" %(time()-startTime,self.Nr,mode,req))
        #end setGainMode
        def setGain(self,arg):
            try: 
                CurrentView.display.clearAverage()
            except Exception as message : 
                pass
            # choice
            if arg == "auto" :  
                self.gainValue = -1
            elif arg == "Off" :  
                self.gainValue = 0
            elif type(arg) == type(0) :  
                self.gainValue = int(arg)
            else: print( "invalid gain",arg)
            # end choice
        #end setGain
        def setCoupling(self,event):
            USBQ.put(("sendControlMessage",self.CHn,(60,),F1))
            USBQ.put(("ReqChannelMap",self.Nr,"coupling"))
        #end setCoupling
        def setProbe(self,event):
            #USBQ.put(("sendControlMessage",(0x42,0xb1,None,self.channelCode),30,(0x42,0xb1,None,0x04)))
            USBQ.put(("sendControlMessage",self.CHn,30,F4))
            USBQ.put(("ReqChannelMap",self.Nr,"probe"))
        #end setProbe
        def setInversion(self,event):
            USBQ.put(("sendControlMessage",self.CHn,(30,),F5))
            USBQ.put(("ReqChannelMap",self.Nr,"inv"))
        #end setInversion
        def setBW(self,event):
            USBQ.put(("sendControlMessage",self.CHn,(30,),F2))
            USBQ.put(("ReqChannelMap",self.Nr,"bw"))
        #end setBW
        def setChannelOn(self,event):
            USBQ.put(("sendControlMessage",self.CHn,30))
            USBQ.put(("CHON",self.Nr))
            self.Channel.config(fg=self.TrackColor)
        #end setChannelOn
        def clearChannel(self,event):
            USBQ.put(("sendControlMessage",self.CHn,OFF,30))
            USBQ.put(("CHOFF",self.Nr))
            self.Channel.config(fg=self.dimColor)
            #USBQ.put(("ReqChannelMap",self.Nr))
        #end clearChannel
        def setZero(self,event=None):
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,0x0c)))
            USBQ.put(("ReqChannelMap",self.Nr,"zero"))
        #end setZero
        def setOnOff(self,args):
            USBQ.put(("PARAMS",self.Nr,"OFF"))
            self.single.config(fg=self.dimColor); self.repeat.config(fg=self.dimColor)
            self.OnOff.config(fg=self.TrackColor); self.fastRepeat.config(fg=self.dimColor)
            CurrentView.display.canvas.delete(CurrentView.display.parameterId[self.Nr][0]); CurrentView.display.canvas.delete(CurrentView.display.parameterId[self.Nr][1])
            CurrentView.showRepeatedParameter[self.Nr] = 0
            CurrentView.showSingleParameter[self.Nr] = False
        #end setOnOff
        def setSingle(self,args=None):
            USBQ.put(("PARAMS",self.Nr,"SINGLE"))
            self.single.config(fg=self.TrackColor,bg=brown); self.repeat.config(fg=self.dimColor)
            self.OnOff.config(fg=self.dimColor); self.fastRepeat.config(fg=self.dimColor)
            CurrentView.showSingleParameter[self.Nr] = True
            CurrentView.showRepeatedParameter[self.Nr] = 0
        #end setSingle
        def setRepeat(self,args=None):
            USBQ.put(("PARAMS",self.Nr,"SINGLE"))
            USBQ.put(("PARAMS",self.Nr,"REPEAT"))
            self.single.config(fg=self.dimColor); self.repeat.config(fg=self.TrackColor,bg=brown)
            self.OnOff.config(fg=self.dimColor); self.fastRepeat.config(fg=self.dimColor)
            CurrentView.showRepeatedParameter[self.Nr] = 1
            CurrentView.showSingleParameter[self.Nr] = True
        #end setRepeat
        def setFastRepeat(self,args=None):
            USBQ.put(("PARAMS",self.Nr,"SINGLE"))
            USBQ.put(("PARAMS",self.Nr,"FASTREPEAT"))
            self.single.config(fg=self.dimColor); self.fastRepeat.config(fg=self.TrackColor,bg=brown)
            self.OnOff.config(fg=self.dimColor); self.repeat.config(fg=self.dimColor)
            CurrentView.showRepeatedParameter[self.Nr] = 2
            CurrentView.showSingleParameter[self.Nr] = True
        #end setFastRepeat
        def changeCoarse(self,event):
            #print ("\nchangeCoarse time %3.3f  channel %i " % (time() - startTime,self.Nr))
            USBQ.put(("sendControlMessage",self.CHn,40,F3))
            USBQ.put(("ReqChannelMap",self.Nr,"req @ %3.3f" % (time()-startTime)))
            #WideView.captionLabel.config(text="changeCoarse",fg="white",bg=scopeGreen)
        #end changeCoarse
    # end class channelFrame
    class buttonControl ():
        def __init__(self):
            self.Pause = False
            self.runButtonValue = 0
            self.Spectrum = False
            self.buttonChannel = 0
        # end init buttonControl
        def setPause(self,event=None):
            # choice
            if self.Pause :  
                self.Pause = False
                USBQ.put(("PAUSE",False))
                WideView.ButtonFrame.PauseButton.config(bg=brown,fg="white")
                StandardView.ButtonFrame.PauseButton.config(bg=brown,fg="white")
                PhotoView.canvas.itemconfigure(PhotoView.IVPause,state="normal")
                PhotoView.canvas.itemconfigure(PhotoView.idPauseY,state="hidden")
            else:  
                self.Pause = True
                USBQ.put(("PAUSE",True))
                WideView.ButtonFrame.PauseButton.config(bg="yellow",fg="black")
                StandardView.ButtonFrame.PauseButton.config(bg="yellow",fg="black")
                #PhotoView.Button4.config(image=PhotoView.PIPausey)
                PhotoView.canvas.itemconfigure(PhotoView.idPauseY,state="normal")
                PhotoView.canvas.itemconfigure(PhotoView.IVPause,state="hidden")
            # end choice
        #end setPause
        def setRunButton(self,value =None):
            #print( "setRunButton value ",value,Control.triggerMode)
            # choice
            if Control.triggerMode == "Single" and value == None :  
                USBQ.put(("STOP",True))
                self.runButtonValue = 1
                USBQ.put("SINGLE")
            elif value == 1 :  
                self.runButtonValue = 1
                USBQ.put(("STOP",True))
            elif value == 0 :  
                self.runButtonValue = 0
            elif value == None :  
                self.runButtonValue +=1; self.runButtonValue %=2
                USBQ.put(("sendControlMessage",RUN))
                USBQ.put(("STOP",self.runButtonValue))
            else:  
                self.runButtonValue +=1; self.runButtonValue = self.runButtonValue % 2
            # end choice
            WideView.ButtonFrame.RunButton.config(text=("Run ","Stop")[self.runButtonValue],bg=("green","red")[self.runButtonValue])
            StandardView.ButtonFrame.RunButton.config(text=("Run ","Stop")[self.runButtonValue],bg=("green","red")[self.runButtonValue])
            WideView.ButtonFrame.RunButton.config(activebackground=("green","red")[self.runButtonValue])
            StandardView.ButtonFrame.RunButton.config(activebackground=("green","red")[self.runButtonValue])
        #end setRunButton
        def setTimeBaseLabel(self,value):
            value = float(value)
            # choice
            if value < 1e-6 :  
                CurrentView.ButtonFrame.timeBaseLabel.config(text="Main Time Base %3.0f ns/div" % (value*1e9))
            elif value < 1e-3 :  
                CurrentView.ButtonFrame.timeBaseLabel.config(text="Main Time Base %3.0f µs/div" % (value*1e6))
            elif value < 1 :  
                CurrentView.ButtonFrame.timeBaseLabel.config(text="Main Time Base %3.0f ms/div" % (value*1e3))
            else:  
                CurrentView.ButtonFrame.timeBaseLabel.config(text="Main Time Base %3.0f s/div" % (value))
            # end choice
            #WideView.timeBase = value
        #end setTimeBaseLabel
        def scrollTimebase(self,event,widget):
            #print ("ButtonControl.scrollTimeBase",event.num,event.delta)
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.decTimeBase(event)
                else:  
                    self.incTimeBase(event)
                # end choice
            elif event.delta < 0 :  
                self.incTimeBase(event)
            else:  
                self.decTimeBase(event)
            # end choice
        #end scrollTimebase
        def incTimeBase(self,event):
            USBQ.put(("sendControlMessage",TB_UP))
            if Control.triggerMode == "Single" : USBQ.put("SINGLE")
            USBQ.put("ReqTriggMap")
        #end incTimeBase
        def decTimeBase(self,event):
            USBQ.put(("sendControlMessage",TB_DN))
            if Control.triggerMode == "Single" : USBQ.put("SINGLE")
            USBQ.put("ReqTriggMap")
        #end decTimeBase
        def setPowerSpectrum(self):
            # choice
            if self.Spectrum == False : self.Spectrum = True; CurrentView.ButtonFrame.SpectrumButton.config(bg="orange",fg="black"); SpectrumQ.put("SHOW")
            else: self.Spectrum = False; CurrentView.ButtonFrame.SpectrumButton.config(bg=brown,fg="white"); SpectrumQ.put("HIDE")
            # end choice
        #end setPowerSpectrum
        def scrollWhen(self,event,widget=None):
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.turnUp(event)
                else:  
                    self.turnDown(event)
                # end choice
            elif event.delta > 0 :  
                self.turnUp(event)
            else:  
                self.turnDown(event)
            # end choice
        #end scrollWhen
        def scrollLineNum(self,event,widget=None):
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.turnUp(event)
                else:  
                    self.turnDown(event)
                # end choice
            elif event.delta > 0 :  
                self.turnUp(event)
            else:  
                self.turnDown(event)
            # end choice
        #end scrollLineNum
        def scrollTPos(self,event,widget=None):
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.TPosLeft(event)
                else:  
                    self.TPosRight(event)
                # end choice
            elif event.delta > 0 :  
                self.TPosLeft(event)
            else:  
                self.TPosRight(event)
            # end choice
        #end scrollTPos
        def scrollTriggerValue(self,event,widget=None):
            #print ("scrollTriggerValue",event.num,event.delta)
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.trigUp(event)
                else:  
                    self.trigDown(event)
                # end choice
            elif event.delta > 0 :  
                self.trigUp(event)
            else:  
                self.trigDown(event)
            # end choice
        #end scrollTriggerValue
        def scrollTimebase(self,event,ignore=None):
            #print ("scrollTimeBase",event.num,event.delta)
            # choice
            if event.delta == 0 :  
                # choice
                if event.num == 4 or event.num == 1 :  
                    self.decTimeBase(event)
                else:  
                    self.incTimeBase(event)
                # end choice
            elif event.delta < 0 :  
                self.incTimeBase(event)
            else:  
                self.decTimeBase(event)
            # end choice
        #end scrollTimebase
        def turnDown(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,TURN_DN))
            USBQ.put(("ReqTriggMap"))
        #end turnDown
        def turnUp(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,TURN_UP))
            USBQ.put(("ReqTriggMap"))
        #end turnUp
        def changeCoarse(self,event):
            if event.state == 17 : return
            USBQ.put(("sendControlMessage",COARSE))
            #print ("changeCoarse",event.num,event.delta,event.state)
            USBQ.put(("ReqTriggMap"))
        #end changeCoarse
        def changeSync(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F4))
            USBQ.put(("ReqTriggMap"))
        #end changeSync
        def changeStandard(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F3))
            USBQ.put(("ReqTriggMap"))
        #end changeStandard
        def changeWhen(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F3))
            USBQ.put(("ReqTriggMap"))
        #end changeWhen
        def changeTriggerSource(self,event):
            # choice
            if self.triggerType == "Pulse" :  
                USBQ.put(("sendControlMessage",TRIGGER_MENUE,F2))
            else:  
                USBQ.put(("sendControlMessage",TRIGGER_MENUE,F2))
            # end choice
            USBQ.put(("ReqTriggMap"))
        #end changeTriggerSource
        def changeTriggerCoupling(self,event):
            # choice
            if Control.triggerType == "Pulse" :  
                USBQ.put(("sendControlMessage",TRIGGER_MENUE,F5,F4))
            else:  
                USBQ.put(("sendControlMessage",TRIGGER_MENUE,F5))
            # end choice
            USBQ.put(("ReqTriggMap"))
        #end changeTriggerCoupling
        def changePolarity(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F5,F2))
            USBQ.put(("ReqTriggMap"))
        #end changePolarity
        def TPosRight(self,event):
            USBQ.put(("sendControlMessage",TP_RI))
            USBQ.put("ReqTriggMap")
        #end TPosRight
        def TPosLeft(self,event):
            USBQ.put(("sendControlMessage",TP_LE))
            USBQ.put("ReqTriggMap")
        #end TPosLeft
        def setAutoButton(self):
            USBQ.put(("sendControlMessage",(0x42,0xb1,None,0x29)))
        #end setAutoButton
        def changeTriggerSource(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F2))
            USBQ.put("ReqTriggMap")
        #end changeTriggerSource
        def changeTriggerSlope(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F3))
            USBQ.put("ReqTriggMap")
        #end changeTriggerSlope
        def changeTriggerType(self,event):
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F1))
            USBQ.put("ReqTriggMap")
        #end changeTriggerType
        def trig50(self,event):
            USBQ.put(("sendControlMessage",TR_50))
            USBQ.put("ReqTriggMap")
        #end trig50
        def trigDown(self,event):
            USBQ.put(("sendControlMessage",TR_DN))
            USBQ.put("ReqTriggMap")
        #end trigDown
        def trigUp(self,event):
            USBQ.put(("sendControlMessage",TR_UP))
            USBQ.put("ReqTriggMap")
        #end trigUp
        def showEdgeLabels(self):
            # group Wide
            WideView.ButtonFrame.whenBox.pack_forget()
            WideView.ButtonFrame.CouplingPulseLabel.pack_forget()
            WideView.ButtonFrame.CouplingEdgeLabel.pack()
            WideView.ButtonFrame.TriggerPolarityBox.pack_forget()
            WideView.ButtonFrame.TriggerSlopeBox.pack()
            WideView.ButtonFrame.ModePulseLabel.pack_forget()
            WideView.ButtonFrame.ModeEdgeLabel.pack()
            WideView.ButtonFrame.SyncContainer.pack_forget()
            WideView.ButtonFrame.StandardBox.pack_forget()
            # group Standard
            StandardView.ButtonFrame.whenBox.pack_forget()
            StandardView.ButtonFrame.CouplingPulseLabel.pack_forget()
            StandardView.ButtonFrame.CouplingEdgeLabel.pack()
            StandardView.ButtonFrame.TriggerPolarityBox.pack_forget()
            StandardView.ButtonFrame.TriggerSlopeBox.pack()
            StandardView.ButtonFrame.ModePulseLabel.pack_forget()
            StandardView.ButtonFrame.ModeEdgeLabel.pack()
            StandardView.ButtonFrame.SyncContainer.pack_forget()
            StandardView.ButtonFrame.StandardBox.pack_forget()
        #end showEdgeLabels
        def showVideoLabels(self):
            # group Wide
            WideView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            WideView.ButtonFrame.SyncContainer.pack()
            WideView.ButtonFrame.StandardBox.pack()
            WideView.ButtonFrame.ModePulseLabel.pack_forget()
            WideView.ButtonFrame.ModeEdgeLabel.pack_forget()
            WideView.ButtonFrame.TriggerPolarityBox.pack_forget()
            WideView.ButtonFrame.TriggerSlopeBox.pack_forget()
            WideView.ButtonFrame.CouplingPulseLabel.pack_forget()
            WideView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            WideView.ButtonFrame.whenBox.pack_forget()
            # group Standard
            StandardView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            StandardView.ButtonFrame.SyncContainer.pack()
            StandardView.ButtonFrame.StandardBox.pack()
            StandardView.ButtonFrame.ModePulseLabel.pack_forget()
            StandardView.ButtonFrame.ModeEdgeLabel.pack_forget()
            StandardView.ButtonFrame.TriggerPolarityBox.pack_forget()
            StandardView.ButtonFrame.TriggerSlopeBox.pack_forget()
            StandardView.ButtonFrame.CouplingPulseLabel.pack_forget()
            StandardView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            StandardView.ButtonFrame.whenBox.pack_forget()
        #end showVideoLabels
        def showPulseLabels(self):
            # group WideView
            WideView.ButtonFrame.StandardBox.pack_forget()
            WideView.ButtonFrame.SyncContainer.pack_forget()
            WideView.ButtonFrame.ModePulseLabel.pack()
            WideView.ButtonFrame.ModeEdgeLabel.pack_forget()
            WideView.ButtonFrame.TriggerPolarityBox.pack()
            WideView.ButtonFrame.TriggerSlopeBox.pack_forget()
            WideView.ButtonFrame.CouplingPulseLabel.pack()
            WideView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            WideView.ButtonFrame.whenBox.pack()
            # group StandardView
            StandardView.ButtonFrame.StandardBox.pack_forget()
            StandardView.ButtonFrame.SyncContainer.pack_forget()
            StandardView.ButtonFrame.ModePulseLabel.pack()
            StandardView.ButtonFrame.ModeEdgeLabel.pack_forget()
            StandardView.ButtonFrame.TriggerPolarityBox.pack()
            StandardView.ButtonFrame.TriggerSlopeBox.pack_forget()
            StandardView.ButtonFrame.CouplingPulseLabel.pack()
            StandardView.ButtonFrame.CouplingEdgeLabel.pack_forget()
            StandardView.ButtonFrame.whenBox.pack()
            USBQ.put(("ReqTriggMap"))
        #end showPulseLabels
    # end class buttonControl
    class valueControl (Frame):
        def __init__(self,root,creator = None):
            Frame.__init__(self,root)
            #print( "init valueControl",creator)
            self.labelDict = {(0,0):11,(0,1):13,(1,0):3,(1,1):5}
            self.valueList = [0,0]; self.timeList = [0,0]
            ConrolQ.put(("Ch",0))
            self.Hys = 0.9; self.HysShift = 0
            self.valueChannel = 0
        # end init valueControl
        def hystUp(self,event):
            ValueControl.Hys *= 1.05
            if ValueControl.Hys >=0.99 : ValueControl.Hys = 0.99
        #end hystUp
        def shifthystUp(self,event):
            ValueControl.HysShift += 1
        #end shifthystUp
        def hystDn(self,event):
            ValueControl.Hys *= 0.95
            if ValueControl.Hys < 0.02 :
                ValueControl.Hys = 0.02
        #end hystDn
        def shifthystDn(self,event):
            ValueControl.HysShift -=1
        #end shifthystDn
        def showHys(self,event=None):
            Control.showHysteresis_var.set(1-Control.showHysteresis_var.get())
        #end showHys
        def resetHys(self,event=None):
            ValueControl.HysShift = 0; ValueControl.Hys = 0.95
        #end resetHys
    # end class valueControl
    class valueFrame (Frame):
        def __init__(self,root,creator = None):
            Frame.__init__(self,root)
            #print( "init valueFrame",creator)
            self.config(bd=1,bg=brown,relief="solid")
            self.labelList = [0,0]
            self.dimColor  = "gray"
            self.h1 = Frame(self)
            self.h1.grid(column=0,row=0,columnspan=2,sticky="ew")
            self.h1.config(borderwidth=1,bg="white"); self.h1_var = StringVar()
            header_var = StringVar()
            header = Label(self.h1,text='cursor values')
            header.grid(column=0,row=1,sticky="ew")
            header.config(borderwidth=0,bg=brown,fg="grey")
            BF = Frame(self.h1)
            BF.grid(column=1,row=1,sticky="news")
            BF.config(bg=brown)
            self.leftButton_var = StringVar()
            self.leftButton = Label(BF,text=' Ch 1 ')
            self.leftButton.grid(column=0,row=0,sticky="ew")
            self.leftButton.config(bg=colors[0],bd=0)  # callback(WideView.display.setSliderChannel,(0))
            self.rightButton_var = StringVar()
            self.rightButton = Label(BF,text=' Ch 2 ')
            self.rightButton.grid(column=1,row=0,sticky="ew")
            self.rightButton.config(bg=brown,fg=colors[1],bd=0)
            self.leftButton.bind("<Button-1>",self.setChannelButton)
            self.rightButton.bind("<Button-1>",self.setChannelButton)
            T=["","","upper","","lower","","diff","","burstf","","left","","right","","diff","","scan",""]
            # choice
            if paintWidth < 1200 :  
                labelWidth = 7; header.config(text="cursor ")
                for i in range(0,18,2): T[i] = ""
            elif paintWidth <= 1280 :  
                labelWidth = 7; header.config(text="cursor ")
                T[8] = "burst"
            else: labelWidth = 15;     T[8] = "burst frequency"
            # end choice
            for i in range(2,18): 
                # choice
                if i % 2 == 0 :  
                    stick = "nse"; justify="right"; anchor = "e"
                else:  
                    stick = "nsw"; justify="left"; anchor = "w"
                # end choice
                lw = labelWidth + (i%2)*4
                L = Label(self.h1,text=T[i]); L.grid(column=i%2,row=2 + i//2,sticky=stick); 
                L.config(width=lw,bg=brown,fg=self.dimColor,padx=2,justify=justify,anchor = anchor)
                self.labelList.append(L)
            self.valueList = [0,0]; self.timeList = [0,0]
            self.labelList[8].bind("<Button-4>",ValueControl.hystUp); self.labelList[8].bind("<Button-5>",ValueControl.hystDn)
            self.labelList[8].bind("<Control-Button-4>",ValueControl.shifthystUp); self.labelList[8].bind("<Control-Button-5>",ValueControl.shifthystDn)
            self.labelList[8].bind("<Shift-Button-1>",ValueControl.hystUp); self.labelList[8].bind("<Shift-Button-3>",ValueControl.hystDn)
            self.labelList[8].bind("<Button-1>",ValueControl.showHys); self.labelList[8].bind("<Button-3>",ValueControl.resetHys)
            ConrolQ.put(("Ch",0))
            self.Hys = 0.9
        # end init valueFrame
        def configLabels(self,value,i,k):
            try: 
                view = CurrentView ; #print( "C.configLabels",CurrentView.name,value,i,k)
            except Exception as message : 
                return
            labelIndex = ValueControl.labelDict[(i,k)]
            #print( "labelIndex",labelIndex)
            # choice
            if i ==  1 : #upper lower
                factor = Control.timeBase * CurrentView.stretch * CurrentView.display.wx/ 25000
                CurrentView.lreso.config(text="sample distance "+ convertT(factor))
                v = value * factor * CurrentView.compress
                self.timeList[k] = v
                diff = self.timeList[0] - self.timeList[1]
                s = convertT(v) ;  #print ("stretch",CurrentView.stretch,"value",value,"v",v)
                self.labelList[labelIndex].config(text=s)
                s = convertT(diff)
                self.labelList[7].config(text=s)
                # choice
                if diff != 0 :  
                    f = CurrentView.burstFrequency
                    # choice
                    if f == None :  
                        self.labelList[9].config(text=" -- ")
                    else:  
                        s = convertF(f)
                        self.labelList[9].config(text=s); #print ("burst text",s)
                    # end choice
                    CurrentView.cursorFrequency = 1.0/diff
                else:  
                    self.labelList[9].config(text="")
                # end choice
            else: # left right
                try: 
                    try: 
                        v = CurrentView
                    except Exception as message : 
                        print("cL",message)
                        return # currentView not yet defined
                    channelFrame = CurrentView.channelFrameList[ValueControl.valueChannel]
                    gain = channelFrame.gainLabel_var.get(); 
                    posValue = channelFrame.posValue
                    if gain == "Off" :
                        text = "Off  " + str(value)
                        self.labelList[labelIndex].config(text=text)
                        self.labelList[13].config(text=text)
                        return
                    value = (250-value) * float(gain)*20e-3 - posValue
                    s = convertU(value)
                    self.labelList[labelIndex].config(text=s)  # "%3.3f mV" % (value))
                    self.valueList[k] = value
                    diff = self.valueList[0] - self.valueList[1]
                    s = convertU(diff);
                    self.labelList[15].config(text=s) # "%3.3f mV" % (diff))
                except Exception as message : 
                    print( "configLabels")
                    print( Exception,message)
                    traceback.print_exc()
                    pass
            # end choice
            # choice
            if Control.showHysteresis_var.get() :  
                self.labelList[8].config(fg="orange")
            else:  
                self.labelList[8].config(fg="grey")
            # end choice
        #end configLabels
        def configScanRate(self,rate):
            frames_per_second = 16.0 / rate
            self.labelList[17].config(text = "%1.2f fps" % frames_per_second)
            log("Scope scan rate %5.2f" % rate)
        #end configScanRate
        def setChannelButton(self,event = None):
            #print ("setChannelButton",event.widget,self.nametowidget(event.widget))
            # choice
            if event == None or self.nametowidget(event.widget) == self.leftButton :  
                ValueControl.valueChannel = 0
                StandardView.myValueFrame.rightButton.config(bg=brown,fg=colors[1])
                WideView.myValueFrame.rightButton.config(bg=brown,fg=colors[1])
                WideView.myValueFrame.leftButton.config(bg=colors[0],fg="black")
                StandardView.myValueFrame.leftButton.config(bg=colors[0],fg="black")
            else:  
                ValueControl.valueChannel = 1
                WideView.myValueFrame.rightButton.config(bg=colors[1],fg="black")
                StandardView.myValueFrame.rightButton.config(bg=colors[1],fg="black")
                WideView.myValueFrame.leftButton.config(bg=brown,fg=colors[0])
                StandardView.myValueFrame.leftButton.config(bg=brown,fg=colors[0])
            # end choice
            try: 
                WideView.display.setSliderChannel(ValueControl.valueChannel)
                StandardView.display.setSliderChannel(ValueControl.valueChannel)
            except Exception as message : pass
        #end setChannelButton
    # end class valueFrame
    class displayControl ():
        def __init__(self):
            pass
        # end init displayControl
        def clearSynth(self):
            try: 
                self.canvas.delete(self.idSine)
            except Exception as message : pass
        #end clearSynth
        def configSine(self):
            try: 
                self.canvas.delete(self.idSine)
            except Exception as message : 
                pass
            les = self.leftScale.get(); rs = self.rightScale.get(); us = self.upperScale.get(); los = self.lowerScale.get()
            base = (les + rs ) /2;  width = abs(los - us);# print ("base",base,"width",width,"left",les)
            step = ( 2*pi)/width; A = (rs - les) / 2; l = []; #print ("A",A,"step",step);
            for i in range(0,paintWidth): 
                y =A * sin(step*((i-los)%width))
                x = i +17; y = int(17+ base - y)
                l.append(x); l.append(y)
            self.idSine = self.canvas.create_line(l)
        #end configSine
    # end class displayControl
    class referenceControl (object):
        def __init__(self):
            pass
        # end init referenceControl
        def __del__(self,arg=None):
            pass # print( "__del__",self.caption)
        #end __del__
        def createReference(self,event,channel):
            #print( "createReference",channel)
            if event == None : return
            r = Control.reference(event.x,event.y,channel)
        #end createReference
        def findReference(self,event=None,item=None):
            #print( "findReference",event,item )#.x,event.y)
            if event != None :
                item = CurrentView.canvas.find_closest(event.x,event.y,halo=5); item=item[0]
            # choice
            if item in CurrentView.display.referenceTraceDict :  
                for id in CurrentView.display.referenceTraceDict: 
                    CurrentView.canvas.itemconfigure(id,width=1)
                CurrentView.canvas.itemconfigure(item,width=3)
                CurrentView.display.selectedItem = item
                return CurrentView.display.referenceTraceDict[item]
            elif item in CurrentView.display.traceList :  
                channel = CurrentView.display.traceList.index(item)
                #print( "findRef",channel)
                self.createReference(event,channel)
            elif item in CurrentView.display.captionDict :  
                ref = CurrentView.display.captionDict[item]
                CurrentView.textItem = item
            else:  
                pass # print( "item not found",event,item)
                CurrentView.canvas.itemconfigure(CurrentView.display.selectedItem,width=1)
            # end choice
        #end findReference
        def deleteReference(self,event=None):
            try: 
                r = self.findReference(item=CurrentView.display.selectedItem); #print( "delRef",r.caption)
                if r == None : return
                CurrentView.canvas.delete(r.textId)
                CurrentView.display.referenceList.remove(r)
                del(CurrentView.display.referenceTraceDict[CurrentView.display.selectedItem])
                CurrentView.canvas.delete(CurrentView.display.selectedItem)
                CurrentView.display.selectedItem = None
                del(CurrentView.display.captionDict[r.textId])
            except Exception as message : 
                print( "del ref",message )
                traceback.print_exc()
        #end deleteReference
        def deleteUnselected(self):
            CurrentView.display.deleteUnselected()
        #end deleteUnselected
        def hideReferences(self):
            for ref in CurrentView.display.referenceList: 
                CurrentView.canvas.itemconfigure(ref.traceId,state="hidden")
                CurrentView.canvas.itemconfigure(ref.textId,state="hidden")
        #end hideReferences
        def showReferences(self):
            for ref in CurrentView.display.referenceList: 
                CurrentView.canvas.itemconfigure(ref.traceId,state="normal")
                CurrentView.canvas.itemconfigure(ref.textId,state="normal")
        #end showReferences
        def scrollRefDown(self,event):
            if CurrentView.display.selectedItem != None :
                CurrentView.canvas.move(CurrentView.display.selectedItem,0,-5)
        #end scrollRefDown
        def scrollRefUp(self,event):
            if CurrentView.display.selectedItem != None :
                CurrentView.display.canvas.move(CurrentView.display.selectedItem,0,5) # ! false direction!
        #end scrollRefUp
        def released(self,event):
            #print( "released at ",event.x,event.y, self.textItem)
            if CurrentView.display.textItem == None : return
            CurrentView.display.canvas.move(CurrentView.display.textItem,event.x-CurrentView.display.pressedAt[0],event.y-CurrentView.display.pressedAt[1])
        #end released
        def pressed(self,event):
            #print( "pressed at ",event.x,event.y)
            CurrentView.display.pressedAt = (event.x,event.y)
        #end pressed
    # end class referenceControl
    class reference ():
        def __init__(self,x,y,channel):
            self.color =tkColorChooser.askcolor("#777777"); #print (self.color)
            if self.color[0] == None : return
            self.caption = tkSimpleDialog.askstring("","enter annotation",parent=WideView.captionFrame); #print (self.caption)
            if self.caption == None : return
            self.textId = CurrentView.canvas.create_text(x+20,y+20,text=self.caption,fill=self.color[1])
            CurrentView.canvas.tag_bind(self.textId,"<ButtonPress-1>",ReferenceControl.pressed)
            r = CurrentView.canvas.tag_bind(self.textId,"<ButtonRelease-1>",ReferenceControl.released)
            # choice
            if channel == 2 : # math
                self.traceId = CurrentView.canvas.create_line(CurrentView.display.mathPointList,fill=self.color[1])
                self.pointList = CurrentView.display.mathPointList
            else:  
                self.traceId = CurrentView.canvas.create_line(CurrentView.display.oldPointList[channel],fill=self.color[1])
                self.pointList = CurrentView.display.oldPointList[channel]
            # end choice
            CurrentView.display.referenceList.append(self)
            CurrentView.display.referenceTraceDict[self.traceId] = self
            CurrentView.display.captionDict[self.textId] = self
        # end init reference
    # end class reference
    class parameterControl ():
        def __init__(self):
            pass
            self.myFont = Font(family="Courier",size=12,weight="bold")
        # end init parameterControl
        def configParameters(self,parameters,channel):
            #print( "configParameters",channel,map(hex,parameters[0:7]))
            if parameters == None : return
            stringList = []
            self.startField = 7; self.parameters = parameters; self.lastIx = 7
            line = self.parseItem("Frequency","z"); stringList.append(line)
            line = self.parseItem("   Period","s"); stringList.append(line)
            line = self.parseItem("     Rise","s"); stringList.append(line)
            line = self.parseItem("     Fall","s"); stringList.append(line)
            line = self.parseItem("   +Width","s"); stringList.append(line)
            line = self.parseItem("   -Width","s"); stringList.append(line)
            line = self.parseItem(" Overshot","%"); stringList.append(line)
            line = self.parseItem("  Preshot","%"); stringList.append(line)
            line = self.parseItem("    +Duty","%"); stringList.append(line)
            line = self.parseItem("    -Duty","%"); stringList.append(line)
            line = self.parseItem("  Average","V"); stringList.append(line)
            line = self.parseItem("     Peak","V"); stringList.append(line)
            line = self.parseItem("      RMS","V"); stringList.append(line)
            line = self.parseItem("     High","V"); stringList.append(line)
            line = self.parseItem("      Low","V"); stringList.append(line)
            line = self.parseItem("   Middle","V"); stringList.append(line)
            line = self.parseItem("      Max","V"); stringList.append(line)
            line = self.parseItem("      Min","V"); stringList.append(line)
            line = self.parseItem("Amplitude","V"); stringList.append(line)
            self.displayParameters(stringList,channel)
            #print (map(chr,parameters[self.startField:])) #print (parameters[self.startField:]) 
            return
        #end configParameters
        def parseItem(self,header,terminator):
            #print( "parseItem",header)
            strValue = "  --  "
            s = bytearray(); empty =  b"--  "
            try: 
                s = bytearray(self.parameters[self.startField:self.startField+4]);
                # choice
                if s == empty :  
                    strValue = "  --  "
                else:  
                    try: 
                        f = struct.unpack("f",s)[0]; self.unKnown = f
                    except Exception as message : 
                        f = struct.unpack("f",str(s))[0]; self.unKnown = f
                    strValue = "%7.2f" % f;
                # end choice
                ss = self.parameters.tostring();
                try: 
                    ix = ss.index(terminator,self.startField + 4); s = ""
                except Exception as message : 
                    ix = ss.index(ord(terminator),self.startField + 4); s = ""
                if ix - self.lastIx > 10 :
                    print( "error",ix - self.lastIx)
                for i in range(self.startField+4, ix + 1): 
                    p = self.parameters[i]; 
                    # choice
                    if p == 148 : c = " µ"
                    else:  
                        c = chr(p)
                    # end choice
                    s = s + c
                unitLen = ix - self.startField -3
                self.startField = ix + 4 - unitLen; self.lastIx = ix
            except Exception as message : 
                print( "parseItem",message)
                traceback.print_exc()
            return "%9s %7s %3s" % (header,strValue,s)
        #end parseItem
        def displayParameters(self,stringList,channel):
            l1 = stringList[0:10]; l2 = stringList[10:]
            string1 = "\n".join(l1)
            string2 = "\n".join(l2)
            CurrentView.canvas.delete(CurrentView.display.parameterId[channel][0]);CurrentView.canvas.delete(CurrentView.display.parameterId[channel][1])
            # choice
            if channel == 0 : x = 40
            else: x = 300
            # end choice
            CurrentView.display.parameterId[channel][0] = CurrentView.display.canvas.create_text(x,115,text=string1,fill=colors[channel + 4],font=self.myFont,anchor="w")
            CurrentView.display.parameterId[channel][1] = CurrentView.display.canvas.create_text(x,430,text=string2,fill=colors[channel + 4],font=self.myFont,anchor="w")
        #end displayParameters
    # end class parameterControl
    def __init__(self,root):
        Frame.__init__(self,root)
        self.root=root
        self.Stop = False
        self.lastSweepIndex = -1; self.sweepIndex = 0
        self.samples = [[],[]]
        self.ch1_data = {}; self.ch2_data = {}; self.data=None
        self.showHysteresis_var = IntVar(); self.showHysteresis_var.set(0)
        self.timeBase = 0
        self.MouseWidget = None
        self.initDicts()
        self.lastTriggerType = "-"
        self.triggerCouplingValue = 0
        self.runButtonValue = 0
        self.triggerModeValue = 0; self.triggerMode = "-"
        self.RunButtonValue = 0
        #global ChannelsControl; ChannelsControl = self.channelsControl()
        global ChannelControl; ChannelControl = self.channelControl()
        global ButtonControl; ButtonControl = self.buttonControl()
        global ValueControl ; ValueControl = self.valueControl(root,"Control")
        global DisplayControl; DisplayControl = self.displayControl()
        global ReferenceControl; ReferenceControl = self.referenceControl()
        global ParameterControl; ParameterControl = self.parameterControl()
    # end init control
    def createMenu(self):
        menuBar = Menu()
        root.config(menu=menuBar)
        mainMenu = Menu(menuBar)
        menuBar.add_cascade(label="Menues",menu=mainMenu)
        mainMenu_var = StringVar()
        Tuning = Menu(mainMenu)
        mainMenu.add_cascade(label="sleep timing",menu=Tuning)
        Tuning_var = StringVar()
        self.dataTimeout = Menu(Tuning)
        Tuning.add_cascade(label="general control",menu=self.dataTimeout)
        self.dataTimeout_var = StringVar()
        self.dataTimeout.add_radiobutton(label='10',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='20',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='30',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='40',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='50',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='60',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='70',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='80',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='90',variable=self.dataTimeout_var)
        self.dataTimeout.add_radiobutton(label='100',variable=self.dataTimeout_var)
        self.pixmapTimeout = Menu(Tuning)
        Tuning.add_cascade(label="pixmap",menu=self.pixmapTimeout)
        self.pixmapTimeout_var = StringVar()
        self.pixmapTimeout.add_radiobutton(label='10',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='20',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='30',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='40',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='50',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='60',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='70',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='80',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='90',variable=self.pixmapTimeout_var)
        self.pixmapTimeout.add_radiobutton(label='100',variable=self.pixmapTimeout_var)
        self.parameterTimeout = Menu(Tuning)
        Tuning.add_cascade(label="parameter",menu=self.parameterTimeout)
        self.parameterTimeout_var = StringVar()
        self.parameterTimeout.add_radiobutton(label='10',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='20',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='30',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='40',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='50',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='60',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='70',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='80',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='90',variable=self.parameterTimeout_var)
        self.parameterTimeout.add_radiobutton(label='100',variable=self.parameterTimeout_var)
        Math = Menu(mainMenu)
        mainMenu.add_cascade(label="Math",menu=Math)
        Math_var = StringVar()
        self.setMultiplicationDivisor = Menu(Math)
        Math.add_cascade(label="set multiplication scaler",menu=self.setMultiplicationDivisor)
        self.setMultiplicationDivisor_var = StringVar()
        self.setMultiplicationDivisor.add_radiobutton(label='0.1',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='0.2',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='0.5',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='1.0',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='2.0',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='5.0',variable=self.setMultiplicationDivisor_var)
        self.setMultiplicationDivisor.add_radiobutton(label='10.0',variable=self.setMultiplicationDivisor_var)
        self.setDivisionDivisor = Menu(Math)
        Math.add_cascade(label="set devision scaler",menu=self.setDivisionDivisor)
        self.setDivisionDivisor_var = StringVar()
        self.setDivisionDivisor.add_radiobutton(label='0.1',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='0.2',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='0.5',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='1.0',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='2.0',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='5.0',variable=self.setDivisionDivisor_var)
        self.setDivisionDivisor.add_radiobutton(label='10.0',variable=self.setDivisionDivisor_var)
        fileMenu = Menu(mainMenu)
        mainMenu.add_cascade(label="File",menu=fileMenu)
        fileMenu_var = StringVar()
        fileMenu.add_command(label="save data csv horizontal",command=self.saveH)
        fileMenu.add_command(label="save data csv vertical",command=self.saveV)
        fileMenu.add_command(label="save pixmap green background",command=self.savePixmapG)
        fileMenu.add_command(label="save pixmap white background",command=self.savePixmapW)
        fileMenu.add_command(label="save pixmap monochrome",command=self.savePixmapM)
        fileMenu.add_command(label="save DSO screen",command=self.saveDSOScreen)
        ref = Menu(mainMenu)
        mainMenu.add_cascade(label="Reference",menu=ref)
        ref_var = StringVar()
        ref.add_command(label="delete selected reference",command=ReferenceControl.deleteReference)
        ref.add_command(label="delete unselected references",command=ReferenceControl.deleteUnselected)
        ref.add_command(label="hide references",command=ReferenceControl.hideReferences)
        ref.add_command(label="show references",command=ReferenceControl.showReferences)
        diag = Menu(mainMenu)
        mainMenu.add_cascade(label="Diagnostic",menu=diag)
        diag_var = StringVar()
        self.PrintEvents_var = IntVar()
        diag.add_checkbutton(label="log events",variable=self.PrintEvents_var,command=self.setPrintEvents)
        self.showTimeOuts_var = IntVar()
        diag.add_checkbutton(label="print time out messages",variable=self.showTimeOuts_var,command=None)
        self.showDiffs_var = IntVar()
        diag.add_checkbutton(label="print data changes",variable=self.showDiffs_var,command=None)
        self.showDiffsP_var = IntVar()
        diag.add_checkbutton(label="print parameter changes",variable=self.showDiffsP_var,command=None)
        diag.add_command(label="show diagnostic panel",command=self.showDiagnosticPanel)
        diag.add_command(label="show pixmap panel",command=self.showPixmapPanel)
        self.setAllSamples_var = IntVar()
        diag.add_checkbutton(label="show all samples",variable=self.setAllSamples_var,command=None)
        self.loadSamples_var = IntVar()
        diag.add_checkbutton(label="load samples from File",variable=self.loadSamples_var,command=None)
        diag.add_command(label="print response",command=self.showResponse)
        diag.add_command(label="show system information",command=self.showInfo)
        mainMenu.add_separator()
        mainMenu.add_command(label="Quit",command=shutDown)
        menuBar.config(bg=brown,fg="white",borderwidth=0)
        self.dataTimeout_var.set(sleepData); self.pixmapTimeout_var.set(sleepPixmap); self.parameterTimeout_var.set(sleepParameter)
        self.TimeoutList = [self.dataTimeout_var,self.pixmapTimeout_var,self.parameterTimeout_var,self.pixmapTimeout_var]
        cb=self.parameterTimeout_var.trace_variable(mode="w",callback=self.parChanged)
        cb=self.pixmapTimeout_var.trace_variable(mode="w",callback=self.pixChanged)
        cb=self.dataTimeout_var.trace_variable(mode="w",callback=self.dataChanged)
        self.setDivisionDivisor_var.set(1.0)
        self.setMultiplicationDivisor_var.set(1.0)
    #end createMenu
    def initDicts(self):
        self.StandardDict = {
        b"111f" : "NTSC",
        b"1111" : "PAL"
        }
        
        self.prevDict = {
        b"11ff" : "Prev",
        b"1111" : "Next"
        }
        self.whenDict = {
        b"11111111" : ">",
        b"11ffffff" : "=",
        b"111f1111" : "<"
        }
        self.couplingDict = {
        b"111111111111111111111f11" : "AC",
        b"f111f1f1111111111111f111" : "HF Reject",
        b"fffff1f1111111111111f111" : "LF Reject",
        b"111111111111111111111fff" : "DC"
        }
        self.triggerModeDict = {
        b"111f111f" : "Auto",
        b"f111f11f" : "Normal",
        b"11fff11f" : "Single"
        }
        self.triggerTypeDict = {
        b"1111f111" : "Video",
        b"11f11111" : "Pulse" ,
        b"111f1111" : "Edge"
        }
        self.triggerSourceDict = {
        b"1f111f11" : ("CH1","cyan",0),
        b"f111f11f" : ("CH2","yellow",4),
        b"1f1f1111" : ("EXT","white",4),
        b"11f111f1" : ("EXT/5","white",16),
        b"111f1111" : ("AC Line","white",28),
        b"1f111fff" : ("Alter","white",12),
        b"bbbbbbbfbfbfbfbbbfbf" : ("XY","white",0)
        }
        self.polDict= {
        b"111f" : "Positive",
        b"1f11" : "Negative"
        }
        self.syncDict = {
        b"f111" : "Line Number ",
        b"ff11" : "Odd Field",
        b"1fff" : "Even Field",
        b"f1f1" : "All Line"
        }
    #end initDicts
    def changeView(self,newView):
        global CurrentView
        # choice
        if newView == "P" :  
            PhotoView.pack()
            WideView.pack_forget(); StandardView.pack_forget()
            CurrentView = PhotoView
            root.wm_minsize(width=1280,height=606)
            root.wm_geometry(PhotoView.geometry); 
        elif newView == "W" or newView == "Z" :  
            WideView.pack()
            PhotoView.pack_forget(); StandardView.pack_forget()
            USBQ.put(("SHORT",0))
            CurrentView = WideView
            root.wm_minsize(width=screenWidth,height=822)
            root.wm_geometry(WideViewGeometry)
        elif newView == "S" :  
            StandardView.pack(side="left",fill="both",expand=1)
            PhotoView.pack_forget(); WideView.pack_forget()
            USBQ.put(("SHORT",1))
            CurrentView = StandardView
            root.wm_minsize(width=800,height=750)
            root.wm_geometry(StandardView.geometry)
        # end choice
        USBQ.put(("VIEW",newView))
        USBQ.put(("ReqChannelMap",0,0))
        USBQ.put(("ReqChannelMap",1,0))
        USBQ.put("ReqTriggMap")
        global currentViewName; currentViewName = newView
        #print ("changeView",newView)
    #end changeView
    def RefreshLoop(self):
        while not self.Stop : 
            while not ConrolQ.empty() and not self.Stop : 
                t1 = time()
                message = ConrolQ.get(); #print( "Scope got ",message)
                # choice
                if type(message) == type("") : tag = message
                else: tag = message[0]
                # end choice
                #print( "Qwait %5.3f" % (time() - t1))
                # choice
                if tag == "CLAV" :  
                    if CurrentView  == PhotoView :
                        continue
                    try: 
                        CurrentView.display.clearAverage(); CurrentView.display.clearPersistence()
                    except Exception as message : 
                        pass #print ("CLAV",message)
                elif tag == "TERMINATE" :  
                    #print( "\n\n\nTERMINATE\n\n\n")
                    #shutDown()
                    self.logfile.close()
                    self.Stop = True; break
                elif tag == "SAMPLES" :  
                    if CurrentView  == PhotoView :
                        continue
                    try: 
                        self.data = message[1]
                        #print("\nRefreshLoop Samples",message[1][0:10])
                        self.refreshData()
                    except Exception as message : 
                        print ("RefreshLoop,SAMPLES",message)
                        traceback.print_exc()
                elif tag == "PARAMS" :  
                    if CurrentView  == PhotoView :
                        continue
                    t=time()
                    try: 
                        self.refreshParameter(message[1],message[2])
                    except Exception as message : 
                        print("PARAMS",message)
                    #print( "PARAMS    %5.3f" % (time()-t))
                elif tag == "CHANNELMAP" :  
                    try: 
                        signature = getSignature(message[1],firstColumn=101,lastColumn=116,row=4)
                        # choice
                        if signature == "b66bbb66666bb666" :  
                            if ButtonControl.runButtonValue == 0 :
                                ButtonControl.setRunButton(2)
                        else:  
                            if self.runButtonValue == 1 :
                                ButtonControl.setRunButton(2)
                        # end choice
                    except Exception as message : 
                        print ("prctpm stop",message)
                    t=time()
                    Control.channelPixmap = message[1]
                    if CurrentView == PhotoView :
                        PhotoView.refreshChannels(message[1])
                        continue
                    ChannelControl.refreshChannels(message[1],message[2],message[3])
                elif tag == "TRIGMAP" :  
                    t=time()
                    self.refreshTriggerPixmap(message[1])
                    log("Scope TRIGMAP end duration  %5.3f" % (time()-t))
                elif tag == "LED" :  
                    #print( "message",message,type(message),len(message))
                    try: 
                        self.setLed(message[1],message[2]); #self.update()
                    except Exception as msg : 
                        print ("setLed",msg,message)
                elif tag == "Ch" :  
                    WideView.display.setSliderChannel(message[1])
                elif tag == "CYCLE" :  
                    #print( "scan rate %1.2f" % rate)
                    try: 
                        CurrentView.myValueFrame.configScanRate(message[1])
                    except Exception as message : 
                        pass
                elif tag == "DUMP" :  
                    self.saveDump(message[1])
                elif tag == "DUMP2" :  
                    self.saveDump2(message[1])
                elif tag == "DUMP3" :  
                    PhotoView.refreshTriggerPixmap(message[1])
                elif tag == "RESPONSE" :  
                    control.response = message[1]
                    #print (message)
                else:  
                    print( "unhandeled message",message,"tag",tag)
                # end choice
                self.update()
            while not LogQ.empty() : self.logfile.write(LogQ.get() +"\n")
            tidle = time()
            if ConrolQ.empty() : log("Scope idle start")
            while ConrolQ.empty() and not self.Stop : 
                sleep(0.02); self.update() ; 
            log("Scope idle duration %5.3f " % (time() - tidle))
        if self.Stop :
            #print( "RL STOP, quit ")
            root.quit(); return
        t=time()
        if self.Stop :
            #print( "RL STOP terminated, quit")
            root.quit(); return
    #end RefreshLoop
    def refreshData(self):
        if CurrentView == PhotoView : return
        if self.data == None : return None
        # choice
        if self.loadSamples_var.get() :  
            print ("load samples")
            infile = open("f1.sav","rb")
            self.data = infile.read(); self.data = array.array("B",self.data); print ("got",len(self.data),"bytes")
            infile.close()
        else:  
            if len(self.data) != 26112 and len(self.data) != 1024 : return None
        # end choice
        t1 = time()
        try: 
            if CurrentView == PhotoView : return
            #print("refreshData len(self.data)",len(self.data))
            self.ch1_data , self.ch2_data = self.fillDict()
            if self.ch1_data == {} : return None
            if self.ch1_data == None : return None
            #print( "refresh data from fillDict",self.ch1_data,self.ch2_data ,  self.samples[0][0:10], self.samples[1][0:10])
        except Exception as message : 
            self.setLed(0,"red")
            print( "refreshData fill",message,type(self.data),len(self.data))
            traceback.print_exc()
            return -1
        t2 = time()
        if CurrentView == PhotoView : return
        CurrentView.display.configDisplay(self.ch1_data,self.ch2_data,self.data)
        #print( "configDisp %5.3f" % (time() - t2)); t3 = time()
        #self.update()
        try: 
            if CurrentView == PhotoView : return
            CurrentView.channelFrameList[0].configChannel(self.ch1_data,self.data)
            CurrentView.channelFrameList[1].configChannel(self.ch2_data,self.data)
        except Exception as message : 
            #self.dataTimeoutCounter +=1
            print( "refreshData from config channel",message,CurrentView.name)
            #traceback.print_exc()
        #print( "configChan %5.3f" % (time() - t3))
        #self.update()
        #print ("ch1_data",self.ch1_data,"\nch2_data",self.ch2_data)
        return 0
    #end refreshData
    def fillDict(self):
        if self.data == None or CurrentView == None : return None,None
        self.compress = float(WideView.ButtonFrame.h3_var.get())
        # choice
        if len(self.data) == 26112 :  
            try: 
                # choice
                if self.setAllSamples_var.get() :  
                    self.sweepIndex = 0; WideView.ButtonFrame.sampleRangeLabel.config(text="all samples")
                    WideView.scroller2.config(from_=13312,to=26111)
                    WideView.scroller1.config(from_=0,to=13311)
                else:  
                    self.sweepIndex = self.data[T_SCALE_CH1]; WideView.ButtonFrame.sampleRangeLabel.config(text="sample range")
                # end choice
                if self.sweepIndex != self.lastSweepIndex :
                    #print ("sweep change last",self.lastSweepIndex,"new",self.sweepIndex)
                    self.lastSweepIndex = self.sweepIndex
                    WideView.display.adjustScrollers()
                    WideView.syncChannels(True)
                v1start = WideView.scroller1_var.get(); v2start = WideView.scroller2_var.get(); self.v1start = v1start; self.v2start = v2start
                v1end=WideView.display.sweepDict[self.sweepIndex]["rightScroll1"]; self.v1end = v1end; 
                v2end=WideView.display.sweepDict[self.sweepIndex]["rightScroll1"] + 12800; self.v2end = v2end
                v2end= v1end + 12800
                self.v1right = min(int(WideView.scroller1_var.get() + WideView.display.paintWidth*WideView.compress),v1end)
                self.v2right = min(int(WideView.scroller2_var.get() + WideView.display.paintWidth*self.compress),v2end)
                self.ch1_data = {}; self.ch2_data = {}
                WideView.active = self.data[CHANNEL_STATE]
                self.ch1_data["s/div"] = T_RANGE[self.data[T_SCALE_CH1]]
                self.ch2_data["s/div"] = T_RANGE[self.data[T_SCALE_CH2]]
                self.timeBase = self.ch1_data["s/div"];   
                self.ch1_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH1]] * (10**(self.data[Y_PROBE_CH1]))
                self.ch2_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH2]] * (10**(self.data[Y_PROBE_CH2]))
                self.ch1_data["coupling"] = COUPLING[self.data[COUPLING_CH1]]
                self.ch2_data["coupling"] = COUPLING[self.data[COUPLING_CH2]]
                data0 = self.data[v1start:min(int(WideView.scroller1_var.get() + WideView.display.paintWidth*self.compress),v1end)]; self.samples[0] = numpy.array(data0,dtype="uint16")
                data1 = self.data[v2start:min(int(WideView.scroller2_var.get() + WideView.display.paintWidth*self.compress),v2end)]; self.samples[1] = numpy.array(data1,dtype="uint16")
                #print ("sweepIndex %i  timeBase %s v1start %i paintWidth %i compress %i  v1end %i  v1right %i" % (self.sweepIndex,self.timeBase,v1start,  WideView.display.paintWidth, self.compress,v1end,self.v1right))
                if WideView.active == 2 :
                    self.samples[1] = self.samples[0]
                self.ch1_data["active"] = bool(self.data[CHANNEL_STATE] & 1)
                self.ch2_data["active"] = bool(self.data[CHANNEL_STATE] & 2)
                self.ch1_data["y_offset"] = 0x7e - self.data[Y_POS_CH1]
                self.ch2_data["y_offset"] = 0x7e - self.data[Y_POS_CH2]
                self.ch1_data["BW_limit"] = bool(self.data[BW_LIMIT_CH1])
                self.ch2_data["BW_limit"] = bool(self.data[BW_LIMIT_CH2])
                #print( "fillDict",self.samples[0][0:10])
                newTpos= self.data[7] + 256*self.data[8]
                self.ch1_data["Tpos"] = newTpos
                ButtonControl.setTimeBaseLabel(self.timeBase)
                if len(data0) == 0 : return None,None
            except IndexError as message : 
                print( "fillDict index",message,self.sweepIndex)
                traceback.print_exc()
                return None,None
            except KeyError as message : 
                print( "fillDict key",message,self.sweepIndex)
                traceback.print_exc()
                return None,None
            except Exception as message : 
                print( "fillDict exc",message);  print ("ch1_data",self.ch1_data)
                traceback.print_exc()
                return None,None
            try: 
                stretch = WideView.display.sweepDict[self.sweepIndex]["stretch"]
            except Exception as message : 
                skip = WideView.display.sweepDict[self.sweepIndex]["skip"]
                stretch = 5.0/skip
            finally: 
                if (5 <= self.sweepIndex <= 8) and WideView.active != 3 : stretch /= 2
                self.stretch = stretch; WideView.stretch = stretch
                #print("fillDict stretch",WideView.stretch)
            return self.ch1_data,self.ch2_data
        elif len(self.data) == 1024 :  
            try: 
                if False and self.sweepIndex <= 0 or self.sweepIndex > 30 : return ({},{})
                if self.sweepIndex != self.lastSweepIndex :
                    self.lastSweepIndex = self.sweepIndex
                v1start = 516; v2start = 770; self.v1start = v1start; self.v2start = v2start
                v1end= 766; self.v1end = v1end
                v2end=1020; self.v2end = v2end
                #v2end= v1end + 12800
                self.v1right = 766
                
                self.v2right = 1020
                StandardView.active = self.data[CHANNEL_STATE]
                self.ch1_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH1]] * (10**(self.data[Y_PROBE_CH1]))
                self.ch2_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH2]] * (10**(self.data[Y_PROBE_CH2]))
                self.ch1_data["coupling"] = COUPLING[self.data[COUPLING_CH1]]
                self.ch2_data["coupling"] = COUPLING[self.data[COUPLING_CH2]]
                data0 = self.data[516:766]; self.samples[0] = numpy.array(data0,dtype="uint16")
                data1 = self.data[770:1020]; self.samples[1] = numpy.array(data1,dtype="uint16")
                if StandardView.active == 2 :
                    self.samples[1] = self.samples[0]
                self.ch1_data["s/div"] = T_RANGE[self.data[T_SCALE_CH1]]
                self.ch2_data["s/div"] = T_RANGE[self.data[T_SCALE_CH2]]
                self.ch1_data["active"] = bool(self.data[CHANNEL_STATE] & 1)
                self.ch2_data["active"] = bool(self.data[CHANNEL_STATE] & 2)
                self.ch1_data["y_offset"] = 0x7e - self.data[Y_POS_CH1]
                self.ch2_data["y_offset"] = 0x7e - self.data[Y_POS_CH2]
                self.ch1_data["BW_limit"] = bool(self.data[BW_LIMIT_CH1])
                self.ch2_data["BW_limit"] = bool(self.data[BW_LIMIT_CH2])
                #print( "\n",self.ch1_data,"\n",self.ch2_data)
                newTpos= self.data[7] + 256*self.data[8]
                self.ch1_data["Tpos"] = newTpos
                self.timeBase = self.ch1_data["s/div"];  
                ButtonControl.setTimeBaseLabel(self.timeBase)
            except IndexError as message : 
                print( "fillDict index",message,self.sweepIndex)
                #traceback.print_exc()
                return ({},{})
            except KeyError as message : 
                print( "fillDict key",message,self.sweepIndex)
                #traceback.print_exc()
                return ({},{})
            except Exception as message : 
                print( "fillDict",message)
                #traceback.print_exc()
                return ({},{})
            return self.ch1_data,self.ch2_data
        elif len(self.data) > 26112 :  
            try: 
                # choice
                if self.setAllSamples_var.get() or True :  
                    l = len(self.data); Control.half = l//2; print("l",l,"half",Control.half)
                    # choice
                    if l > 60000 :  
                        self.sweepIndex = 34
                    else:  
                        self.sweepIndex = 33
                    # end choice
                    WideView.ButtonFrame.sampleRangeLabel.config(text="all samples")
                    WideView.scroller2.config(from_=self.half,to=l)
                    WideView.scroller1.config(from_=0,to=self.half)
                else:  
                    self.sweepIndex = self.data[T_SCALE_CH1]; WideView.ButtonFrame.sampleRangeLabel.config(text="sample range")
                # end choice
                if False and self.sweepIndex != self.lastSweepIndex :
                    #print ("sweep change last",self.lastSweepIndex,"new",self.sweepIndex)
                    self.lastSweepIndex = self.sweepIndex
                    WideView.display.adjustScrollers()
                    WideView.syncChannels(True)
                v1start = WideView.scroller1_var.get(); v2start = WideView.scroller2_var.get(); self.v1start = v1start; self.v2start = v2start
                v1end=WideView.display.sweepDict[self.sweepIndex]["rightScroll1"]; self.v1end = v1end; 
                v2end=WideView.display.sweepDict[self.sweepIndex]["rightScroll1"] + self.half; self.v2end = v2end
                v2end= v1end + self.half
                self.v1right = min(int(WideView.scroller1_var.get() + WideView.display.paintWidth*WideView.compress),v1end)
                self.v2right = min(int(WideView.scroller2_var.get() + WideView.display.paintWidth*self.compress),v2end)
                self.ch1_data = {}; self.ch2_data = {}
                WideView.active = self.data[CHANNEL_STATE]
                #self.ch1_data["s/div"] = T_RANGE[self.data[T_SCALE_CH1]]
                #self.ch2_data["s/div"] = T_RANGE[self.data[T_SCALE_CH2]]
                #self.timeBase = self.ch1_data["s/div"];   
                #self.ch1_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH1]] * (10**(self.data[Y_PROBE_CH1]))
                #self.ch2_data["V/div"] = Y_RANGE[self.data[Y_SENSE_CH2]] * (10**(self.data[Y_PROBE_CH2]))
                #self.ch1_data["coupling"] = COUPLING[self.data[COUPLING_CH1]]
                #self.ch2_data["coupling"] = COUPLING[self.data[COUPLING_CH2]]
                data0 = self.data[v1start:min(int(WideView.scroller1_var.get() + WideView.display.paintWidth*self.compress),v1end)]; self.samples[0] = numpy.array(data0,dtype="uint16")
                data1 = self.data[v2start:min(int(WideView.scroller2_var.get() + WideView.display.paintWidth*self.compress),v2end)]; self.samples[1] = numpy.array(data1,dtype="uint16")
                print ("sweepIndex %i  timeBase %s v1start %i paintWidth %i compress %i  v1end %i  v1right %i" % (self.sweepIndex,self.timeBase,v1start,  WideView.display.paintWidth, self.compress,v1end,self.v1right))
                print ("len array",len(self.samples[0]),len(self.samples[1]))
                if WideView.active == 2 :
                    self.samples[1] = self.samples[0]
                self.ch1_data["active"] = bool(self.data[CHANNEL_STATE] & 1)
                self.ch2_data["active"] = bool(self.data[CHANNEL_STATE] & 2)
                self.ch1_data["y_offset"] = 0x7e - self.data[Y_POS_CH1]
                self.ch2_data["y_offset"] = 0x7e - self.data[Y_POS_CH2]
                self.ch1_data["BW_limit"] = bool(self.data[BW_LIMIT_CH1])
                self.ch2_data["BW_limit"] = bool(self.data[BW_LIMIT_CH2])
                #print( "fillDict",self.samples[0][0:10])
                newTpos= self.data[7] + 256*self.data[8]
                self.ch1_data["Tpos"] = newTpos
                ButtonControl.setTimeBaseLabel(self.timeBase)
                if len(data0) == 0 : return None,None
            except IndexError as message : 
                print( "fillDict index",message,self.sweepIndex)
                traceback.print_exc()
                return None,None
            except KeyError as message : 
                print( "fillDict key",message,self.sweepIndex)
                traceback.print_exc()
                return None,None
            except Exception as message : 
                print( "fillDict exc",message);  print ("ch1_data",self.ch1_data)
                traceback.print_exc()
                return None,None
            try: 
                stretch = WideView.display.sweepDict[self.sweepIndex]["stretch"]
            except Exception as message : 
                skip = WideView.display.sweepDict[self.sweepIndex]["skip"]
                stretch = 5.0/skip
            finally: 
                if (5 <= self.sweepIndex <= 8) and WideView.active != 3 : stretch /= 2
                self.stretch = stretch; WideView.stretch = stretch
                #print("fillDict stretch",WideView.stretch)
            return self.ch1_data,self.ch2_data
        else: return None,None
        # end choice
    #end fillDict
    def refreshParameter(self,params,channel):
        if CurrentView == PhotoView : return
        #print( "refreshParameter",self.showRepeatedParameter)
        if CurrentView.channelFrameList[channel].paramBox_var.get() == "off" : return
        if params == None : return
        CurrentView.showSingleParameter[channel] = False
        ParameterControl.configParameters(params,channel); 
    #end refreshParameter
    def refreshTriggerPixmap(self,parameter,status=0):
        if CurrentView  == PhotoView :
            PhotoView.refreshTriggerPixmap(parameter); return
        # choice
        if status == 0 :  
            if parameter == None :
                self.pixmapTimeoutCounter +=1
                self.requestTriggerMap = True
                return
            self.processTriggerPixmap(parameter)
            #CurrentView.ButtonFrame.processTriggerPixmap(parameter)
            self.requestTriggerMap = False
            #self.update()
            Control.triggerPixmap = parameter
        else:  
            self.pixmapTimeoutCounter +=1
            self.requestTriggerMap = True
        # end choice
        #print( "refreshTrigger",time()-t)
        try: 
            self.display.configZoom(self.data,1)
            self.display.configZoom(self.data,0)
        except Exception as message : 
            pass
    #end refreshTriggerPixmap
    def processTriggerPixmap(self,parameter):
        if parameter == None or CurrentView == None : return
        #print( "processTriggerPixmap")
        try: 
            offset = 0
            signature = getSignature(parameter,row=7, firstColumn=276,lastColumn=288)
            #print( "sig trigger Headline",signature)
            if signature != b"bfbffffbbfff" :
                return # no trigger pixmap! print ("no trigger pixmap",signature) ; 
        except Exception as message : 
            print( "not triggermap", message )
        try: 
            signature = getSignature(parameter,firstColumn=101,lastColumn=116,row=4)
            # choice
            if signature == "b66bbb66666bb666" :  
                if ButtonControl.runButtonValue == 0 :
                    ButtonControl.setRunButton(2)
            else:  
                if ButtonControl.runButtonValue == 1 :
                    ButtonControl.setRunButton(2)
            # end choice
        except Exception as message : 
            print ("prctpm stop",message)
        try: 
            offset = 0
            memfile = extractSubpicture(parameter,firstRow=1, lastRow = 12,firstColumn=204,lastColumn=268,colorListIndex=0)
            self.PI5 = PhotoImage(); self.PI5.config(data=memfile)
            CurrentView.ButtonFrame.TPosValue.config(image=self.PI5)
        except Exception as message : 
            print( "trigger position", message )
        try: 
            offset = 0
            signature = getSignature(parameter,row=6,firstColumn=104,lastColumn=116)
            #print( "signature",signature)
            # choice
            if   signature == b"6b6bbbbbb666" : # Scan 
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  Scan  ",fg="red")
                #print( "Scan")
            elif signature == b"bb6bbb6b6b6b" : # Armed
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  Armed  ",fg="red")
                #print( "Armed")
            elif signature == b"bb6bbb6b6666" : # Triggered
                CurrentView.ButtonFrame.triggerStateLabel.config(text="Triggered",fg="green")
                #print( "Triggered")
            elif signature == b"6bbb6bbb6bbb" : # Stop
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  Stop  ",fg="red")
                #print( "Stop")
            elif signature == b"bb66666bb666" : # Ready
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  Ready  ",fg="yellow")
                #print( "Ready")
            elif signature == b"bb6bbb6bbb6b" : # Auto
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  Auto  ",fg="yellow")
                #print( "Auto")
            else:  
                CurrentView.ButtonFrame.triggerStateLabel.config(text="  ?  ",fg="yellow")
                print( "trigger state unknown")
            # end choice
        except Exception as message : 
            print( "trigger state", message )
        try: 
            signature = getSignature(parameter,row = 42,firstColumn=279,lastColumn=285)
            try: 
                self.triggerType = self.triggerTypeDict[signature]
            except Exception as message : 
                print( "processTrigger Pixmap Type ?",message,signature,len(parameter))
                memfile = extractSubpicture(parameter,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename="triggerTypexx.ppm")
                self.triggerType = "?"
            #print(" triggerType",self.triggerType)
            CurrentView.ButtonFrame.triggerTypeLabel.config(text="Trigger Type " + self.triggerType)
        except Exception as message : 
            print( "triggerType not found",message)
            #USBQ.put("ReqTriggMap")
        # choice
        if self.triggerType == "Edge" : self.processEdge(parameter)
        elif self.triggerType == "Pulse" : self.processPulse(parameter)
        elif self.triggerType == "Video" : self.processVideo(parameter)
        else: return
        # end choice
    #end processTriggerPixmap
    def processPulse(self,parameter):
        if self.lastTriggerType != "Pulse" :
            ButtonControl.showPulseLabels(); self.lastTriggerType = "Pulse"; return
        try: 
            signature = getSignature(parameter,row = 223,firstColumn=280,lastColumn=286)
            try: 
                #print( "prevNext",signature,"\n",self.prevDict)
                subField = self.prevDict[signature]
            except Exception as message : 
                subField = "?"
                print( "illegal prevnext field",signature)
        except Exception as message : 
            print( "subField not found",message)
        # choice
        if subField == "Next" :  
            try: 
                triggerSource = None
                signature = getSignature(parameter,row = 85,firstColumn=291,lastColumn=298)
                triggerSource ,color,self.slopeOffset= self.triggerSourceDict[signature]
                CurrentView.ButtonFrame.triggerSourceLabel.config(text="Trigger Source " + triggerSource,fg=color)
                self.triggerSource = triggerSource
            except Exception as message : 
                print( "triggerSource not found",message,signature)
                USBQ.put("ReqTriggMap")
                return
            try: 
                offset = 0
                if triggerSource == "EXT/5" : offset = 10
                if triggerSource == "AC Line" : offset = 20
                memfile = extractSubpicture(parameter,firstRow=229, lastRow = 240,firstColumn=188+offset,lastColumn=236 + offset)
                self.PI4 = PhotoImage(); self.PI4.config(data=memfile);
                CurrentView.ButtonFrame.triggerValueLabel.config(image=self.PI4)
            except Exception as message : 
                print( "triggerLevel",message  )
            try: 
                When = None
                signature = getSignature(parameter,row = 132,firstColumn=285,lastColumn=293)
                when = self.whenDict[signature]
                CurrentView.ButtonFrame.whenLabel.config(text="when " + when + "    Setting ")
            except Exception as message : 
                print( "when not found",message,signature,self.whenDict)
                return
            try: 
                offset = 0
                memfile = extractSubpicture(parameter,firstRow=181, lastRow = 191,firstColumn=268,lastColumn=316)  #,filename="err_setting.ppm")
                self.PIsetting = PhotoImage(); self.PIsetting.config(data=memfile);
                CurrentView.ButtonFrame.SettingValue.config(image=self.PIsetting)
            except Exception as message : 
                print( "setting not found",message  )
                sf=open("err_setting.ppm","wb"); sf.write(memfile); sf.close()
        elif subField == "Prev" :  
            try: 
                signature = getSignature(parameter,row=86, firstColumn=271,lastColumn=275)
                polarity = self.polDict[signature];
                CurrentView.ButtonFrame.triggerPolarityValue.config(text=polarity)
            except Exception as message : 
                print( "polarity not found",signature)
            try: 
                signature = getSignature(parameter,row = 133,firstColumn=276,lastColumn=285)
                try: 
                    self.triggerMode = self.triggerModeDict[signature]
                    if self.triggerMode == "Single" : ButtonControl.setRunButton(1)
                    USBQ.put(("MODE",self.triggerMode))
                except Exception as message : 
                    self.triggerMode = "?"
                    print( "trigger mode",self.triggerMode,signature,message)
                CurrentView.ButtonFrame.ModePulseLabel.config(text="Trigger Mode " + self.triggerMode)
            except Exception as message : 
                print( "trigger mode not found",message)
            try: 
                signature = getSignature(parameter,row = 178,firstColumn=264,lastColumn=289)
                try: 
                    #print( "coupling",signature,"\n",self.couplingDict)
                    coupling = self.couplingDict[signature]
                except Exception as message : 
                    coupling = "?"
                    USBQ.put("ReqTriggMap");print( "coupling ?",signature)
                #print( "coupling",coupling)
                CurrentView.ButtonFrame.CouplingPulseLabel.config(text="Trigger Coupling " + coupling)
            except Exception as message : 
                print( "coupling not found",message)
        else:  
            pass# print( "invalid subfield")
        # end choice
        #USBQ.put("ReqTriggMap")
    #end processPulse
    def processVideo(self,parameter):
        if self.lastTriggerType != "Video" :
            ButtonControl.showVideoLabels(); self.lastTriggerType ="Video"
        try: 
            triggerSource = None; signature = b"??"
            signature = getSignature(parameter,row = 85,firstColumn=291,lastColumn=298)
            triggerSource ,color,self.slopeOffset= self.triggerSourceDict[signature]
            #print( "processTriggerPixmap",triggerSource,signature)
            CurrentView.ButtonFrame.triggerSourceLabel.config(text="Trigger Source " + triggerSource,fg=color)
            self.triggerSource = triggerSource
        except Exception as message : 
            print( "Video triggerSource not found",message,signature)
            USBQ.put("ReqTriggMap")
            return
        try: 
            Standard = "?"
            signature = getSignature(parameter,row = 132,firstColumn=285,lastColumn=289)
            Standard = self.StandardDict[signature]
            CurrentView.ButtonFrame.StandardValue.config(text=Standard)
        except Exception as message : 
            print( "Standard not found",message,signature)
            return
        try: 
            signature = getSignature(parameter,row = 178,firstColumn=276,lastColumn=280)
            try: 
                #print( "trigger mode",signature,"\n",self.syncDict)
                self.sync = self.syncDict[signature]
            except Exception as message : 
                self.sync = "?"
                print( "sync ?",signature)
            #print( "trigger mode",triggerMode)
            CurrentView.ButtonFrame.SyncValue.config(text=self.sync)
        except Exception as message : 
            print( "sync",message)
        # choice
        if self.sync == "Line Number " :  
            try: 
                memfile = extractSubpicture(parameter,firstRow=226, lastRow = 235,firstColumn=280,lastColumn=302)
                self.PI4 = PhotoImage(); self.PI4.config(data=memfile);
                CurrentView.ButtonFrame.LineNum.pack(fill="both"); CurrentView.ButtonFrame.LineNum.config(image=self.PI4)
            except Exception as message : 
                print( "LineNumber",message  )
        else:  
            CurrentView.ButtonFrame.LineNum.pack_forget()
        # end choice
    #end processVideo
    def processEdge(self,parameter):
        if self.lastTriggerType != "Edge" :
            ButtonControl.showEdgeLabels(); self.lastTriggerType ="Edge"
        try: 
            triggerSource = None
            signature = getSignature(parameter,row = 85,firstColumn=291,lastColumn=298)
            triggerSource ,color,self.slopeOffset= self.triggerSourceDict[signature]
            #print( "triggerSource",triggerSource)
            CurrentView.ButtonFrame.triggerSourceLabel.config(text="Trigger Source " + triggerSource,fg=color)
            self.triggerSource = triggerSource
        except Exception as message : 
            print( "triggerSource not found",message,signature)
            USBQ.put("ReqTriggMap")
            return
        try: 
            offset = 0
            if triggerSource == "EXT/5" : offset = 10
            if triggerSource == "AC Line" : offset = 20
            memfile = extractSubpicture(parameter,firstRow=228, lastRow = 240,firstColumn=188+offset,lastColumn=234 + offset,colorListIndex = 0)
            self.PI4 = PhotoImage(); self.PI4.config(data=memfile);
            CurrentView.ButtonFrame.triggerValueLabel.config(image=self.PI4)
        except Exception as message : 
            print( "triggerLevel",message  )
        try: 
            offset = 0
            memfile = extractSubpicture(parameter,firstRow=216, lastRow = 227,firstColumn=30,lastColumn=80,colorListIndex=0)
            self.PI6 = PhotoImage(); self.PI6.config(data=memfile);
            CurrentView.channelFrameList[0].gainLabel.config(image=self.PI6)
        except Exception as message : 
            print( "processEdge gain1", message )
        try: 
            offset = 0
            memfile = extractSubpicture(parameter,firstRow=216, lastRow = 227,firstColumn=108,lastColumn=160,colorListIndex=0)
            self.PI7 = PhotoImage(); self.PI7.config(data=memfile);
            CurrentView.channelFrameList[1].gainLabel.config(image=self.PI7)
        except Exception as message : 
            print( "processEdge gain2", message )
        try: 
            offset = 0
            memfile= extractSubpicture(parameter,firstRow=228, lastRow = 240,firstColumn=170+self.slopeOffset,lastColumn=180 + self.slopeOffset,colorListIndex = 0)
            self.PI3 = PhotoImage(); self.PI3.config(data=memfile);
            CurrentView.ButtonFrame.triggerSlopeValue.config(image=self.PI3)
        except Exception as message : 
            print( "extract trigger Slope",message )
        try: 
            signature = getSignature(parameter,row = 178,firstColumn=276,lastColumn=285)
            try: 
                #print( "trigger mode",signature,"\n",self.triggerModeDict)
                lastTriggerMode = self.triggerMode
                self.triggerMode = self.triggerModeDict[signature]
                # choice
                if self.triggerMode == "Single" : ButtonControl.setRunButton(1)
                elif lastTriggerMode == "Single"and not self.triggerMode == "Single" :  
                    pass #self.setRunButton(0)
                else: pass #self.setRunButton(0)
                # end choice
                USBQ.put(("MODE",self.triggerMode))
            except Exception as message : 
                self.triggerMode = "?"
                print( "processTriggerMode",message,signature)
                memfile = extractSubpicture(parameter,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320)
                PImode = PhotoImage(); PImode.config(data=memfile)
                #DiagnosticWindow.monitorLabel.config(image=PImode)
                USBQ.put("ReqTriggMap")
            #print( "trigger mode",self.triggerMode)
            CurrentView.ButtonFrame.ModeEdgeLabel.config(text="Trigger Mode " + self.triggerMode)
        except Exception as message : 
            print( "trigger mode not found",message)
        try: 
            signature = getSignature(parameter,row = 223,firstColumn=264,lastColumn=289)
            try: 
                #print( "coupling",signature,"\n",self.couplingDict)
                coupling = self.couplingDict[signature]
            except Exception as message : 
                coupling = "?"
                USBQ.put("ReqTriggMap");print( "coupling ?",signature)
            #print( "coupling",coupling)
            CurrentView.ButtonFrame.CouplingEdgeLabel.config(text="Trigger Coupling " + coupling)
        except Exception as message : 
            print( "coupling not found",message)
        self.lastTriggerType= "Edge"
    #end processEdge
    def setLed(self,nr,color="green",channel=0):
        bgcolor = brown
        idx = int(self.TimeoutList[nr].get())//10
        ch = unichr(0x2789 + idx); # ch = unichr(0x24c9) (T)
        try: 
            CurrentView.LedList[nr].config(text=ch,fg=color,bg=bgcolor)
        except Exception as message : 
            pass
        #print( "setLed",nr,self.LedList[nr].cget("text"),color)
        return
    #end setLed
    def saveReference(self):
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("csv files","*.csv")])
        outfile = open(outFileName,"w")
        for i in range(0,len(s1),2): 
            outfile.write("%i,%i\n" % (s1[i],s1[i+1]))
        outfile.close()
    #end saveReference
    def savePixmapG(self):
        if CurrentView == PhotoView :
            print("not possible"); return
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("postscript","*.ps")])
        CurrentView.display.canvas.postscript(file=outFileName)
    #end savePixmapG
    def savePixmapM(self):
        if CurrentView == PhotoView :
            print("not possible"); return
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("postscript","*.ps")])
        CurrentView.display.canvas.itemconfigure(CurrentView.backgroundId,fill="white")
        CurrentView.display.canvas.itemconfigure(CurrentView.display.id1,fill="black")
        CurrentView.display.canvas.itemconfigure(CurrentView.display.id2,fill="black")
        for i in range(2): 
            for k in range(2): 
                CurrentView.canvas.itemconfigure(WideView.display.parameterId[i][k],fill="black")
        CurrentView.display.canvas.postscript(file=outFileName)
        CurrentView.display.canvas.itemconfigure(CurrentView.backgroundId,fill=scopeGreen)
        CurrentView.display.canvas.itemconfigure(CurrentView.display.id1,fill=colors[0])
        CurrentView.display.canvas.itemconfigure(CurrentView.display.id2,fill=colors[1])
        for i in range(2): 
            for k in range(2): 
                WideView.canvas.itemconfigure(WideView.display.parameterId[i][k],fill=colors[k])
    #end savePixmapM
    def savePixmapW(self):
        if CurrentView == PhotoView :
            print("not possible"); return
        print ("curv",CurrentView.name)
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("postscript","*.ps")])
        CurrentView.display.canvas.itemconfigure(CurrentView.backgroundId,fill="white")
        CurrentView.display.canvas.itemconfigure(CurrentView.display.traceList[0],fill="#009999")
        CurrentView.display.canvas.itemconfigure(CurrentView.display.traceList[1],fill="#999900")
        CurrentView.display.canvas.postscript(file=outFileName)
        CurrentView.display.canvas.itemconfigure(CurrentView.backgroundId,fill=scopeGreen)
        CurrentView.display.canvas.itemconfigure(CurrentView.display.traceList[0],fill=colors[0])
        CurrentView.display.canvas.itemconfigure(CurrentView.display.traceList[1],fill=colors[1])
    #end savePixmapW
    def saveV(self):
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("csv files","*.csv")])
        outfile = open(outFileName,"w")
        s1 = self.samples[0]
        s2 = self.samples[1]
        for i in range(len(s1)): 
            outfile.write("%i,%i\n" % (s1[i],s2[i]))
        outfile.close()
    #end saveV
    def saveH(self):
        outFileName = tkFileDialog.asksaveasfilename(filetypes=[("csv files","*.csv")])
        outfile = open(outFileName,"w")
        s1 = self.samples[0]
        for i,s in enumerate(s1): 
            if i > 0 : outfile.write(",")
            outfile.write(str(s))
        outfile.write("\n")
        s2 = self.samples[1]
        for i,s in enumerate(s2): 
            if i > 0 : outfile.write(",")
            outfile.write(str(s))
        outfile.write("\n")
        outfile.close()
    #end saveH
    def saveDSOScreen(self):
        USBQ.put("DUMP")
    #end saveDSOScreen
    def showResponse(self):
        print ("Response",self.response)
    #end showResponse
    def setPrintEvents(self,event=None):
        global logging; logging = self.PrintEvents_var.get()
        USBQ.put(("LOG",logging))
        ZoomQ.put(("LOG",logging))
        SpectrumQ.put(("LOG",logging))
        print ("logging",logging)
    #end setPrintEvents
    def showPixmapPanel(self):
        PixmapWindow.deiconify()
    #end showPixmapPanel
    def showDiagnosticPanel(self):
        DiagnosticWindow.deiconify()
    #end showDiagnosticPanel
    def showInfo(self,pixmap = None):
        self.showPixmapPanel()
        if pixmap == None :
            USBQ.put(("PAUSE",True))
            USBQ.put(("sendControlMessage",UTILITY,F5,F5,F1))
            USBQ.put("DUMP2")
            USBQ.put(("sendControlMessage",UTILITY,F1))
            USBQ.put(("PAUSE",ButtonControl.Pause))
            return
    #end showInfo
    def dataChanged(self,event=None,p2=None,p3=None):
        return
        newValue = int(WideView.getvar(event))
        USBQ.put(("TIMEOUT",0,newValue))
        self.dataTimeout_var.set(newValue)
        print( "dataChanged " ,newValue)
    #end dataChanged
    def pixChanged(self,event=None,p2=None,p3=None):
        #print( "parChanged event %s p2 %s p3 %s" % (event,p2,p3))
        newValue = int(WideView.getvar(event))
        self.setLed(1,"GREEN",newValue)
        USBQ.put(("TIMEOUT",1,newValue))
    #end pixChanged
    def parChanged(self,event=None,p2=None,p3=None):
        newValue = int(WideView.getvar(event))
        self.setLed(2,"GREEN",newValue)
        USBQ.put(("TIMEOUT",2,newValue))
        #print( "parChanged event %s p2 %s p3 %s" % (event,p2,p3),newValue)
    #end parChanged
    def changeTriggerMode(self,event):
        #print ("changeTriggerMode")
        # choice
        if Control.triggerType == "Edge" :  
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F4))
        elif Control.triggerType == "Pulse" :  
            USBQ.put(("sendControlMessage",TRIGGER_MENUE,F5,F3))
        else: pass
        # end choice
        USBQ.put("ReqTriggMap")
    #end changeTriggerMode
    def saveDump2(self,parameter):
        try: 
            self.Pixmap = extractSubpicture(parameter,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename = "version.ppm",ext=True)
            self.Pixmap = parameter
            PixmapWindow.showCurrentPixmap(parameter)
        except Exception as message : 
            print( "dump2",message)
    #end saveDump2
    def saveDump(self,parameter):
        try: 
            outFileName = tkFileDialog.asksaveasfilename(filetypes=[("ppm","*.ppm")])
            memfile = extractSubpicture(parameter,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename=outFileName)
        except Exception as message : 
            print( "dump",message)
    #end saveDump
# end class control
class wideView (Frame):
    # classes
    class displayFrame (Frame):
        def __init__(self,root):
            Frame.__init__(self,root)
            #print( "init display")
            self.initEarlyValues()
            wx = self.wx; wy = self.wy; offy = self.offy; offx = self.offx
            self.leftFrame = Frame(self)
            self.leftFrame.grid(column=0,row=1)
            self.leftFrame.config(bg="black",bd=0)
            self.leftScale_var = IntVar()
            self.leftScale = Scale(self.leftFrame,label=None,from_=0, to=10*wy, length=10*wy + 2*offy,orient='vertical', command=None ,variable=self.leftScale_var)
            self.leftScale.pack(side="top"); self.leftScale.lastValue = 0
            self.leftScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.rightFrame = Frame(self)
            self.rightFrame.grid(column=2,row=1)
            self.rightFrame.config(bg="black")
            self.rightScale_var = IntVar()
            self.rightScale = Scale(self.rightFrame,label=None,from_=0, to=10*wy, length=10*wy + 2*offy,orient='vertical', command=None ,variable=self.rightScale_var)
            self.rightScale.pack(side="top"); self.rightScale.lastValue = 0
            self.rightScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.upperFrame = Frame(self)
            self.upperFrame.grid(column=1,row=0)
            self.upperFrame.config(bg="black")
            self.upperScale_var = IntVar()
            self.upperScale = Scale(self.upperFrame,label=None,from_=0, to=self.paintWidth, length=self.paintWidth + 2*offx,orient='horizontal', command=None ,variable=self.upperScale_var)
            self.upperScale.pack(side="top"); self.upperScale.lastValue = 0
            self.upperScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False,command=self.setUpperScale)
            self.lowerFrame = Frame(self)
            self.lowerFrame.grid(column=1,row=2)
            self.lowerFrame.config(bg="black")
            self.lowerScale_var = IntVar()
            self.lowerScale = Scale(self.lowerFrame,label=None,from_=0, to=self.paintWidth, length=self.paintWidth + 2*offx,orient='horizontal', command=None ,variable=self.lowerScale_var)
            self.lowerScale.pack(side="top"); self.lowerScale.lastValue = 0
            self.lowerScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.config(relief="solid",borderwidth=2,bg=scopeGreen,width=self.paintWidth + 80)
            self.centerFrame=Frame(self); self.centerFrame.grid(row=1,column=1,sticky="news")
            self.canvas = Canvas(self.centerFrame,bg=scopeGreen,width=self.paintWidth + 2*offx,height=10*wy + 2*offy)
            WideView.backgroundId = self.canvas.create_rectangle(0,0,self.paintWidth + 2*offx,10*wy + 2*offy,fill=scopeGreen)
            self.canvas.pack(fill="both",expand=1,anchor= "w")
            WideView.canvas = self.canvas
            self.leftScale.line = self.canvas.create_line(offx,offy,offx + self.paintWidth, offy,fill="white",dash=[2,8])
            self.upperScale.line = self.canvas.create_line(offx,offy,offx, offy + 10*wy,fill="white",dash=[2,8])
            self.lowerScale.line = self.canvas.create_line(offx ,offy,offx, offy + 10*wy,fill="white",dash=[2,8])
            self.rightScale.line = self.canvas.create_line(offx+5, offy, offx + self.paintWidth-5, offy,fill="white",dash=[2,8])
            #print( (self.leftScale.config()))
            self.id1 = None; self.id2 = None; self.id3 = None
            self.data = None; self.params = None
            self.upperScale.set(self.paintWidth); self.rightScale.set(500)
            self.lowerScale.set(0);  self.leftScale.set(0)
            self.initLateValues()
            for y in range(11): # grid lines
                # choice
                if y == 5 : myColor = "#777777"
                else: myColor = "#004400"
                # end choice
                self.canvas.create_line(offx, y*wy + offy, self.paintWidth + offx, y*wy + offy,fill=myColor)
            self.initSweepDict()
            WideView.captionFrame = Frame(self.canvas); WideView.captionFrame.place(x=100,y=300,width=1200,height=1); WideView.captionFrame.config(bg=scopeGreen)
            WideView.captionLabel = Label(WideView.captionFrame); WideView.captionLabel.pack(anchor = "w"); WideView.captionLabel.config(bg=scopeGreen,fg="white",anchor = "w")
        # end init displayFrame
        def initEarlyValues(self):
            self.paintWidth = paintWidth
            self.wx = 50
            self.offx = 17; self.wy=50; self.offy = 17 ; self.yZero = self.offy + 10*self.wy # wxy für raster
            self.xRange = self.paintWidth // 50 + 1
            self.textItem = None
            start = self.offx + 3; end = start + 12800
        #end initEarlyValues
        def initLateValues(self):
            self.textId = None
            self.y1Id = None; self.y2Id = None
            self.myFont = Font(family="Courier",size=12,weight="bold")
            self.persist = [[],[]]
            self.parameterId  = [[0,0],[0,0]]
            self.clearAV = True
            self.oldParameters = None
            self.gridList = None
            self.midId = 0 ;self.hysId = 0
            self.period = 1
            self.selectedItem = -1
            self.zoomId = [0,0,0,0,0,0]
            self.olddata = None
            self.oldPointList = [None,None]
            self.canvas.bind("<Button-1>",ReferenceControl.findReference); self.canvas.bind("<Button-3>",ReferenceControl.deleteReference)
            self.canvas.bind("<Button-4>",ReferenceControl.scrollRefDown);self.canvas.bind("<Button-5>",ReferenceControl.scrollRefUp);
            self.canvas.bind("<Shift-Button-3>",ReferenceControl.scrollRefUp);self.canvas.bind("<Shift-Button-1>",ReferenceControl.scrollRefDown);
            self.traceDict = {}; self.captionDict= {}; self.referenceTraceDict= {}; self.traceList = [0,0,0,0,0]
            self.referenceList = []
        #end initLateValues
        def initSweepDict(self):
            self.sweepDict = {} # key is sweep index (data[10])
            self.sweepDict[0] = {"leftScroll1" : 512, "rightScroll1" : 13312,"skip" : 0.5 ,"stretch" :10.0,"triggerSample":7000,"scrollOffset":0} # these are all samples values
            self.sweepDict[1] = {"leftScroll1" : 2131, "rightScroll1" : 13312,  "skip":0.5,  "scrollOffset" : 127,"triggerSample" : 13045, "stretch" : 10.0}# 2 ns/div
            self.sweepDict[2] = {"leftScroll1" : 2131, "rightScroll1" : 10552,  "skip":0.5,  "scrollOffset" : 46, "triggerSample" : 5526, "stretch" : 10.0} # 5 ns/div
            self.sweepDict[3] = {"leftScroll1" : 2131, "rightScroll1" : 10552,  "skip":1,  "scrollOffset" : 50, "triggerSample" : 5523, "stretch" : 5.0} # 10 ns/div
            self.sweepDict[4] = {"leftScroll1" : 1090, "rightScroll1" : 10552,  "skip":2,  "scrollOffset" : 52,"triggerSample" : 5523, "stretch" : 2.5} # 20 ns/div
            self.sweepDict[5] = {"leftScroll1" : 1090, "rightScroll1" : 13008,  "skip": 0.25, "triggerSample" : 6900,"stretch" : 20} # 50 ns/div
            self.sweepDict[6] = {"leftScroll1" : 512, "rightScroll1" : 13008,  "skip":0.5, "triggerSample" : 7025 ,"stretch" : 10.0} # 100 ns/div
            self.sweepDict[7] = {"leftScroll1" : 512, "rightScroll1" : 13008,"skip":1,  "triggerSample" : 7270,"stretch" : 5.0 } # 200 ns/div
            self.sweepDict[8] = {"leftScroll1" : 512, "rightScroll1" : 13008,"skip":2.5,  "triggerSample" : 8020 , "stretch" : 2.0} # 500 ns/div
            self.sweepDict[9] = {"leftScroll1" : 512, "rightScroll1" : 13008,"skip":5,  "triggerSample" : 6768, "stretch" : 1.0} # 1 µs/div
            self.sweepDict[10] = {"leftScroll1" : 512, "rightScroll1" : 13008,"skip":10, "triggerSample" : 6771, "stretch": 0.5} # 2 µs/div
            self.sweepDict[11] = {"leftScroll1" : 512, "rightScroll1" : 13008,  "skip":12.5, "triggerSample" : 6735, "stretch" : 0.4} # 5 µs/div
            self.sweepDict[12] = {"leftScroll1" : 512, "rightScroll1" : 7612,  "skip":6.25,  "triggerSample" : 3633, "stretch" : 0.8} # 10 µs/div
            self.sweepDict[13] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5,  "triggerSample" : 3003, "stretch" : 1.0} # 20 µs/div
            self.sweepDict[14] = {"leftScroll1" : 512, "rightScroll1" : 7762,  "skip":6.25,  "triggerSample" : 3627, "stretch" : 0.8} # 50 µs/div
            self.sweepDict[15] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5,  "triggerSample" : 3000, "stretch" : 1.0} # 100 µs/div
            self.sweepDict[16] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5,  "triggerSample" : 3000,"stretch" : 1.0 } # 200 µs/div
            self.sweepDict[17] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5, "triggerSample" : 3000,"stretch" : 1.0} # 500 µs/div
            self.sweepDict[18] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5, "triggerSample" : 3000,"stretch" : 1.0} # 1 ms/div
            self.sweepDict[19] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5, "triggerSample" : 3000} # 2 ms
            self.sweepDict[20] = {"leftScroll1" : 512, "rightScroll1" : 6312, "skip":5, "triggerSample" : 3000} # 5 ms
            self.sweepDict[21] = {"leftScroll1" : 512, "rightScroll1" : 6312,  "skip":5, "triggerSample" : 3000} # 10 ms
            self.sweepDict[22] = {"leftScroll1" : 512, "rightScroll1" : 6312, "skip": 5, "triggerSample" : 3000} # 20 ms
            self.sweepDict[23] = {"leftScroll1" : 512, "rightScroll1" : 6312, "skip":5, "triggerSample" : 3000} # 50 ms
            self.sweepDict[24] = {"leftScroll1" : 512, "rightScroll1" : 3412, "skip":2.5, "triggerSample" : 1764} # 100 ms
            self.sweepDict[25] = {"leftScroll1" : 512, "rightScroll1" : 3412,  "skip":2.5, "triggerSample" : 1764} # 200 ms
            self.sweepDict[26] = {"leftScroll1" : 512, "rightScroll1" : 3412, "skip":2.5, "triggerSample" : 1764} # 500 ms
            self.sweepDict[27] = {"leftScroll1" : 512, "rightScroll1" : 3412,  "skip":2.5, "triggerSample" : 1764} # 1 s
            self.sweepDict[28] = {"leftScroll1" : 512, "rightScroll1" : 3400, "skip":2.5, "triggerSample" : 1764} # 2s/div
            self.sweepDict[29] = {"leftScroll1" : 512, "rightScroll1" : 1300 , "skip" : 2.5, "triggerSample" : 1764} # 5 s/div
            self.sweepDict[30] = {"leftScroll1" : 512, "rightScroll1" : 1300 , "skip" : 2.5, "triggerSample" : 1764} # 10 s/div
            self.sweepDict[31] = {"leftScroll1" : 512, "rightScroll1" : 1300 , "skip" : 2.5, "triggerSample" : 1764} # 20 s/div
            self.sweepDict[32] = {"leftScroll1" : 512, "rightScroll1" : 1300 , "skip" : 2.5, "triggerSample" : 1764} # 50 s/div
            self.sweepDict[33] = {"leftScroll1" : 0, "rightScroll1" : 32765, "skip" : 2.5, "triggerSample" : 16380} # samples from file
            self.sweepDict[34] = {"leftScroll1" : 0, "rightScroll1" : 2**19, "skip" : 2.5, "triggerSample" : 2**18} # samples from file
        #end initSweepDict
        def configDisplay(self,ch1,ch2,newdata,):
            if len(newdata) == 1024 and WideView.ButtonFrame.zoomed :
                self.configShort(ch1,ch2,newdata)
                return
            if len(newdata) == 1024 : return
            t=time()
            #print( "\nconfigDisplay ",Control.samples[0][0:10], Control.samples[1][0:10])
            if ch1 == None or ch2 == None or newdata == None : return
            self.compress = compress = int(WideView.ButtonFrame.h3_var.get()); 
            # choice
            if WideView.ButtonFrame.Zoom :  
                self.configZoom(newdata)
            else:  
                self.configZoom(None)
            # end choice
            if ButtonControl.Spectrum and SpectrumQ.empty() :
                try: 
                    message = ("SAMPLES",WideView.lower1,WideView.upper1,WideView.lower2,WideView.upper2,self.oldYArray,WideView.burstFrequency,WideView.cursorFrequency)
                    SpectrumQ.put(message)
                except Exception as message : 
                    print("ConfDis",message)
            self.configGrid()
            if self.clearAV :
                self.oldYArray = [None,None]; #print("confDis clearAV",self.oldYArray)
                self.clearAV = False
            self.averageShift = WideView.ButtonFrame.averageScale.get()  # 0 bis 8
            #self.averageFactor = 2 **  -WideView.ButtonFrame.averageScale.get(); #print( "aver",averageFactor)
            self.averageComplement = 8- self.averageShift
            self.persistenceCount = 2**WideView.ButtonFrame.persistenceScale.get()
            li1 = self.configChannel(ch1,0,newdata); #print("confDis li1",self.oldYArray[0],li1)
            li2 = self.configChannel(ch2,1,newdata); #print("        li2",self.oldYArray[1],li2)
            self.processCursors(); self.getBurstFrequency()
            if self.data != None and newdata != None and Control.showDiffs_var.get() :  # changed data
                for i in range(512): 
                    if newdata[i] != self.data[i] and i != 4 and i != 50 :
                        print( "%3i %3i -> %3i" % (i,self.data[i],newdata[i]))
            self.data = newdata
            if self.textId != None : self.canvas.delete(self.textId)
            if self.y1Id != None :
                self.canvas.delete(self.y1Id); self.canvas.delete(self.y2Id)
            #WideView.v1 = 512*0.9 - newdata[6] *2 +self.offy
            self.y1Id = self.canvas.create_text(10,2*newdata[6] +16, text=unichr(0x25b6), fill=colors[0])  # triangles for baseline
            self.y2Id = self.canvas.create_text(10,2*newdata[38] +16, text=unichr(0x25b6), fill=colors[1])
            self.shiftScale2((self.upperScale,0)); self.shiftScale2((self.lowerScale,1))
            if not ch1["active"] :
                while len(self.persist[0]) > 0 : id = self.persist[0].pop(0); self.canvas.delete(id)
            if not ch2["active"] :
                while len(self.persist[1]) > 0 : id = self.persist[1].pop(0); self.canvas.delete(id)
            self.configMath(ch1,ch2,li1,li2)
            try: 
                self.canvas.delete(self.idXY)
            except Exception as message : pass
            if WideView.ButtonFrame.XY :
                self.configXY(self.oldYArray)
            t=time()
            self.update()
            #print ("configDisplay update %5.3f " % (time() - t))
        #end configDisplay
        def configChannel(self,ch,channelNr,newdata):
            if not ch["active"] or len(Control.samples[channelNr]) < 10 :
                #print("confCha len samples",len(Control.samples[channelNr]))
                return None
            t = time()
            #print ("confCha", channelNr,self.oldYArray[channelNr])
            #YArray = numpy.random.normal(10,10,10); YArray += 100; YArray = YArray.astype("uint16")
            YArray = Control.samples[channelNr]; 
            if self.oldYArray[channelNr] == None or len(self.oldYArray[channelNr]) != len(YArray) :
                self.oldYArray[channelNr] = YArray.copy() <<8; #print("confCha new oldY len",len(self.oldYArray[channelNr]))
            try: 
                subtractor = self.oldYArray[channelNr]  >> self.averageShift; 
                additor =  YArray <<self.averageComplement ; 
                newYArray = self.oldYArray[channelNr] -subtractor +additor
            except Exception as message : 
                print( "configDisplay average",message)
            self.oldYArray[channelNr] = newYArray.copy(); #print("confCha old from new",len(self.oldYArray[channelNr]))
            # group produce canvas line
            start = self.offx +3; num=newYArray.size; end = num//self.compress + start
            # choice
            if self.compress == 1 :  
                pointList = numpy.empty(2*num,dtype="uint16")
                pointList[0::2] = numpy.arange(start,start+num)
                pointList[1::2] = 523 - 2*(newYArray>>8); 
                pointList = pointList.tolist()
            else:  
                compressedSize = num //self.compress; 
                compressedSize = (compressedSize//self.compress)  * self.compress;  
                newSize = compressedSize * self.compress;  
                newYArray.resize(newSize)
                pointArray= numpy.empty(4*compressedSize,dtype="uint16")
                pointArray[0::4] = numpy.arange(start,start+compressedSize)
                pointArray[2::4] = pointArray[0::4]
                compressedArray = 523 - 2*(newYArray.reshape(compressedSize,self.compress)>>8)
                maxArray = numpy.amax(compressedArray,axis=1); minArray = numpy.amin(compressedArray,axis=1)
                pointArray[1::4] = minArray; pointArray[3::4] = maxArray
                pointList = pointArray.tolist()
            # end choice
            #rint( "configCH",channelNr,"len(pointList)",len(pointList),"Y",newYArray[0:10], "pointList", pointList[0:10])
            try: 
                self.traceList[channelNr] = self.id1 = self.canvas.create_line(pointList,fill=colors[channelNr])
            except Exception as message : 
                print( "configDisplay len pointList create_line",message,len(pointList))
                return None
            self.persist[channelNr].append(self.id1)
            while len(self.persist[channelNr]) > self.persistenceCount : id = self.persist[channelNr].pop(0); self.canvas.delete(id)
            if len(self.persist[channelNr]) >=4 :
                l = len(self.persist[channelNr])
                self.canvas.itemconfigure(self.persist[channelNr][l-2],fill=colors[channelNr+2])
                self.canvas.itemconfigure(self.persist[channelNr][l-3],fill=colors[channelNr+4])
                self.canvas.itemconfigure(self.persist[channelNr][l-4],fill=colors[channelNr+6])
            self.oldPointList[channelNr]= pointList
            #print( "c_channel  %5.3f" % (time() - t))
            t2 = time()
            log("Scope configChannel %i duration %5.3f" % (channelNr,t2-t))
            return pointList
        #end configChannel
        def configShort(self,ch1,ch2,newdata,):
            t=time()
            if ch1 == None or ch2 == None or newdata == None : return
            li1 = self.configChannelShort(ch1,0,newdata)
            li2 = self.configChannelShort(ch2,1,newdata)
            self.update()
            memfile = extractSubpicture(Control.triggerPixmap,218,228,176,216,colorListIndex=0); # zoom time base
            self.Pi = PhotoImage(); self.Pi.config(data=memfile);
            WideView.ButtonFrame.zoomLabel.config(image=self.Pi)
            StandardView.ButtonFrame.zoomLabel.config(image=self.Pi)
        #end configShort
        def configChannelShort(self,ch,channelNr,newdata):
            if not ch["active"] or len(Control.samples[channelNr]) < 10 : return None
            t = time()
            log("Scope configChannel start %i" % channelNr)
            YArray =  Control.samples[channelNr]; 
            # group produce canvas line
            start = paintWidth // 2 - 250
            start = start + self.offx +3; num=YArray.size; end = num + start
            pointList = numpy.empty(2*num,dtype="uint16")
            pointList[0::2] = numpy.arange(start,start+2*num,2)
            pointList[1::2] = 523 - 2*(YArray) -50; 
            pointList = pointList.tolist()
            #rint( "configCH",channelNr,"len(pointList)",len(pointList),"Y",newYArray[0:10], "pointList", pointList[0:10])
            try: 
                self.canvas.delete(self.traceList[channelNr+3])
                self.traceList[channelNr+3]  = self.canvas.create_line(pointList,fill=colors[channelNr],width=3)
            except Exception as message : 
                print( "configDisplay len pointList create_line",message,len(pointList))
                return None
            #print( "c_channel  %5.3f" % (time() - t))
            t2 = time()
            log("Scope configChannel %i duration %5.3f" % (channelNr,t2-t))
            return pointList
        #end configChannelShort
        def configZoom(self,data):
            try: 
                # group channel1
                p1 = self.sweepDict[Control.sweepIndex]["leftScroll1"]; s1 = p1
                p2 = Control.v1start; s2 = p2
                p3 = Control.v1right; s3 = p3
                p4 = self.sweepDict[Control.sweepIndex]["rightScroll1"] ; s4 = p4
                c1 = (p1,p2,p3,p4,s1,s2,s3,s4)
                # group channel 2
                p1 = self.sweepDict[Control.sweepIndex]["leftScroll1"]; s1 = p1 + 12800
                p2 = Control.v2start - 12800; s2 = p2 + 12800
                p3 = Control.v2right - 12800; s3 = p3 + 12800
                p4 = self.sweepDict[Control.sweepIndex]["rightScroll1"] ; s4 = p4 + 12800
                c2 = (p1,p2,p3,p4,s1,s2,s3,s4)
            except Exception as message : 
                pass
                print( "configZoom",message)
            ZoomQ.put(("SAMPLES",(data,self.paintWidth,c1,c2)))
            log("Scope put ZoomQ")
        #end configZoom
        def configMath(self,ch1,ch2,li1=None,li2=None):
            ld = []
            try: 
                if li1 == None or li2 == None : return
                if self.id3 != None : self.canvas.delete(self.id3); self.id3 = None;
                if ch1["active"] and ch2["active"] and WideView.ButtonFrame.MathBox_var.get() == "\\" :
                    ld = li1[:]; divisor = float(Control.setDivisionDivisor_var.get()) 
                    for i in range(1,len(li1),2): 
                        try: 
                            ld[i] = divisor *  (li2[i]-268) /  (li1[i] -268)* (-50) +220
                        except Exception as message : 
                            ld[i] = 0
                            #print( "configDisplay l[d]=0",message)
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and WideView.ButtonFrame.MathBox_var.get() == "/" :
                    ld = li1[:]; divisor = float(Control.setDivisionDivisor_var.get()) 
                    for i in range(1,len(li1),2): 
                        try: 
                            ld[i] = divisor *  (li1[i]-268) /  (li2[i] -268)* (-50) +220
                        except Exception as message : 
                            ld[i] = 0
                            #print( "configDisplay l[d]=0",message)
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and WideView.ButtonFrame.MathBox_var.get() == "*" :
                    ld = li1[:]; divisor= float(Control.setMultiplicationDivisor_var.get());# print( "divisor",divisor)
                    for i in range(1,len(li1),2): 
                        ld[i] = divisor * (li1[i]-268) *  (li2[i] -268) *(-1)/(250) +268
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and WideView.ButtonFrame.MathBox_var.get() == "+" :
                    ld = li1[:]
                    for i in range(1,len(li1),2): 
                        ld[i] = li1[i] + li2[i] -268
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and WideView.ButtonFrame.MathBox_var.get() == "-" :
                    ld = li1[:]
                    for i in range(1,len(li1),2): 
                        ld[i] = li1[i] - li2[i] + 268
                    self.id3 = self.canvas.create_line(ld,fill="red")
                log("Scope configmath")
                self.traceList[2] = self.id3; self.mathPointList = ld[:]
            except Exception as message : 
                pass
                print( "configMath",message)
                traceback.print_exc()
        #end configMath
        def processCursors(self):
            if self.data == None : return
            if WideView.active == 0 : return
            if WideView.active == 1 and ButtonControl.buttonChannel  != 0 : return
            if WideView.active == 2 and ButtonControl.buttonChannel  != 1 : return
            try: 
                #print("procCur 1 len oldY",len(self.oldYArray[0]),len(self.oldYArray[1]))
                sweepIndex=Control.sweepIndex; #print ("sweepIndex",sweepIndex)
                #sweep = T_RANGE[sweepIndex]; 
                upper = self.upperScale_var.get(); lower = self.lowerScale_var.get(); 
                WideView.upper1 = int(upper * WideView.samplesPerDot + int(WideView.scroller1_var.get()))
                WideView.upper2 = int(upper * WideView.samplesPerDot  + int(WideView.scroller2_var.get()))
                WideView.lower1 = int(lower * WideView.samplesPerDot  + int(WideView.scroller1_var.get()))
                WideView.lower2 = int(lower * WideView.samplesPerDot  + int(WideView.scroller2_var.get()))
                # choice
                if ButtonControl.buttonChannel == 0 or (ButtonControl.buttonChannel == 1 and WideView.active == 2) :  
                    WideView.lowerSample = lowerSample = WideView.lower1
                    WideView.upperSample = upperSample = WideView.upper1
                else:  
                    WideView.upperSample = upperSample = WideView.upper2
                    WideView.lowerSample = lowerSample = WideView.lower2
                # end choice
                sampleDiff = upperSample - lowerSample; 
            except Exception as message : 
                print( "processCursors",message)
                traceback.print_exc()
            #print("procCur 2 len oldY",len(self.oldYArray[0]),len(self.oldYArray[1]))
        #end processCursors
        def getBurstFrequency(self):
            upper = self.upperScale_var.get(); lower = self.lowerScale_var.get(); 
            try: 
                self.canvas.delete(self.midId)
                self.canvas.delete(self.hysId)
            except Exception as message : 
                pass
            try: 
                sampleRange = self.oldYArray[ButtonControl.buttonChannel][lower*WideView.compress : upper*WideView.compress]
            except Exception as message : 
                print ("procCur button channel",ButtonControl.buttonChannel,message); return
            if len(sampleRange) == 0 :
                print( "sampleRange is empty")
                return
            meanValue =int(sampleRange.mean()) ; #print ("ValueControl.Hys",ValueControl.Hys)
            MAX =max(sampleRange); MIN =min(sampleRange); MID = meanValue; zeroCount = 0; first = -1; last =-1;  hys = int(ValueControl.Hys* 0.45*(MAX-MIN)) ; #print ("hys",hys)
            #MAX =max(sampleRange); MIN =min(sampleRange); MID = (MAX +  MIN) //2; zeroCount = 0; first = -1; last =-1;  hys = int(ValueControl.Hys* 0.45*(MAX-MIN)) ; #print ("hys",hys)
            upperThresh = MID + hys + (ValueControl.HysShift<<7); lowerThresh = MID - hys + (ValueControl.HysShift<<7); thresh = MID; midThresh = int((upperThresh + lowerThresh ) / 2)
            hystPointList = []
            for i,sample in enumerate(sampleRange): 
                #print ("i %i sample %i upper %i lower %i thresh %i" % (i,sample,upperThresh,lowerThresh,thresh)); print (type(sample))
                if i == 0 :
                    # choice
                    if sample > upperThresh : thresh = lowerThresh
                    elif sample < lowerThresh : thresh = upperThresh
                    else:  
                        pass
                    # end choice
                    lastSample = sample
                # choice
                if thresh == MID :  
                    # choice
                    if sample > upperThresh  : thresh = lowerThresh
                    elif sample < lowerThresh  : thresh = upperThresh
                    # end choice
                    lastSample = sample
                elif thresh == lowerThresh :  
                    if sample < lowerThresh and lastSample >= lowerThresh :
                        zeroCount +=1
                        # choice
                        if first == -1 : first = i; last = i
                        else: last = i
                        # end choice
                        lastSample = sample; thresh = upperThresh
                        hystPointList.append(lower + 20 + i//WideView.compress);hystPointList.append(self.yZero - (lowerThresh>>7) )
                        hystPointList.append(lower + 20 + i//WideView.compress);hystPointList.append( self.yZero - (upperThresh>>7) )
                        #print("<l",lowerThresh,sample,upperThresh,)
                elif thresh == upperThresh :  
                    if sample > upperThresh and lastSample <= upperThresh :
                        zeroCount += 1
                        # choice
                        if first == -1 : first = i; last = i
                        else: last = i
                        # end choice
                        lastSample = sample; thresh = lowerThresh
                        hystPointList.append(lower + 20 + i//WideView.compress);hystPointList.append( self.yZero - (upperThresh>>7) )
                        hystPointList.append(lower + 20 + i//WideView.compress);hystPointList.append( self.yZero - (lowerThresh>>7) )
                        #print(">u",lowerThresh,sample,upperThresh)
                # end choice
            try: 
                #print( "first %i last %i zeros %i" % (first,last,zeroCount)); print ("hystpoints",hystPointList[0:10])
                if zeroCount < 3 :
                    WideView.burstFrequency = None
                    if Control.showHysteresis_var.get() :
                        self.hysId  = self.canvas.create_line((lower+20, self.yZero - (midThresh>>7),lower+20 + len(sampleRange)/WideView.compress, self.yZero - (midThresh>>7)),fill="red")
                    #print("Zero",zeroCount,"mean",meanValue>>7)
                    return
                dotsPerPeriod = 2*(last - first) / (zeroCount-1); #print("dotsPerPeriod",dotsPerPeriod)
                stretch = WideView.stretch; #print ("stretch",stretch)
                period = dotsPerPeriod * Control.timeBase * stretch * self.wx / 25000; #print("period",period)
                # choice
                if period != 0 :  
                    WideView.burstFrequency = 1.0 / period;
                else:  
                    WideView.burstFrequency= None
                # end choice
                if Control.showHysteresis_var.get() :
                    # choice
                    if len(hystPointList) > 0 :  
                        self.hysId = self.canvas.create_line(hystPointList,fill = "white")
                        #self.hysId = self.canvas.create_line(hystPointList,fill=colors[ButtonControl.buttonChannel])
                        #print( hystPointList)
                        self.canvas.move(self.hysId,0,7)
                    else:  
                        self.hysId  = self.canvas.create_line((lower+20,self.yZero - meanValue>>7,lower+20 + len(sampleRange)/WideView.compress,self.yZero - meanValue>>7),fill="blue")
                        #print("lower",lower,"mean",meanValue>>7,"len",len(sampleRange))
                    # end choice
            except Exception as message : 
                dotsPerPeriod = None
                print( "processCursors",message)
                traceback.print_exc()
        #end getBurstFrequency
        def configXY(self,data):
            tp = self.sweepDict[Control.sweepIndex]["triggerSample"]
            try: 
                x1 = WideView.lower1; x2 = WideView.upper1; y1 = WideView.lower2; y2 = WideView.upper2
                xs = data[0][1 : 2*(x2-x1) + 1 : 2]; 
                ys = data[1][1 : 2*(y2-y1) + 1 : 2]
                pointList = []
                for i in range(len(xs)): 
                    pointList.append((285 - (xs[i])>>7)+self.paintWidth//2); pointList.append(ys[i]>>7)
                self.idXY = self.canvas.create_line(pointList,fill="magenta");
            except Exception as message : 
                print ("xy",message)
                return
        #end configXY
        def configGrid(self):
            sweepIndex = Control.sweepIndex; compress = self.compress
            if sweepIndex < 0 : return
            if self.gridList != None :
                for id in self.gridList: 
                    self.canvas.delete(id)
            try: 
                skip = int(1000*self.sweepDict[sweepIndex]["skip"]//compress); 
                if WideView.active != 3 and (5 <= Control.sweepIndex <=8) : skip *= 2
                if False and self.lastSweepIndex != Control.sweepIndex :
                    #print( "configGrid sweepIndex %i skip %f compress %f self.lastSweepIndex %s" % (sweepIndex,skip,compress,self.lastSweepIndex))
                    self.lastSweepIndex= Control.sweepIndex
                start = self.sweepDict[sweepIndex]["leftScroll1"]
                to = self.sweepDict[sweepIndex]["rightScroll1"] - compress * self.paintWidth; #print( "to",to)
                if to <= start : to = start+1
                #print("configGrid setScroller",start,to)
                WideView.scroller1.config(from_=start,to=to)
                # choice
                if Control.sweepIndex == 33 or Control.sweepIndex == 34 :  
                    WideView.scroller2.config(from_=start + Control.half,to=to + Control.half)
                else:  
                    WideView.scroller2.config(from_=start + 12800,to=to + 12800)
                # end choice
                triggerSample = self.sweepDict[sweepIndex]["triggerSample"]
            except Exception as message : 
                start = 1; skip = int(200//compress)
                print( "key error",message,"sweepIndex",sweepIndex)
                WideView.scroller1.config(from_=512,to=4800)
                WideView.scroller2.config(from_=13312,to=17600)
                triggerSample = 1000
                traceback.print_exc()
            self.gridList = []; xStart = int((triggerSample -  WideView.scroller1_var.get())//compress - 50*skip) ; xEnd = int((triggerSample - WideView.scroller1_var.get())//compress + 60*skip)
            xMid = int((triggerSample -  WideView.scroller1_var.get()) // compress)
            #print( "xStart",xStart,"xMmid",xMid,"triggerSample",triggerSample,"xEnd",xEnd,"skip",skip)
            if skip >= 5000 :
                for x in range(100*xStart,100*xEnd,skip): # grid lines
                    if x >= 0 and x <= 100*self.paintWidth :
                        self.gridList.append(self.canvas.create_line(x//100 +  self.offx , self.offy, x//100 + self.offx, 10*self.wy + self.offy,fill="#00cc00",dash=[2,8]))
            for x in range(10*xStart,10*xEnd,skip): # grid lines
                if x >= 0 and x <= 10*self.paintWidth :
                    self.gridList.append(self.canvas.create_line(x//10 +  self.offx , self.offy, x//10 + self.offx, 10*self.wy + self.offy,fill="#008800"))
            self.gridList.append(self.canvas.create_line(xMid +  self.offx , self.offy, xMid + self.offx, 10*self.wy + self.offy, fill="#00ff00"))
            log("Scope configGrid")
        #end configGrid
        def shiftScale(self,arg=None):
            #print( "shiftScale",arg);
            value = int(arg[0].get())
            if value == arg[0].lastValue and False : return
            self.canvas.move(arg[0].line,0,value - arg[0].lastValue)
            arg[0].lastValue = value
            WideView.myValueFrame.configLabels(value,0,arg[1])
            self.canvas.itemconfigure(arg[0].line,fill=colors[ButtonControl.buttonChannel])
            self.canvas.tag_raise(arg[0].line)
            #self.update()
        #end shiftScale
        def shiftScale2(self,arg=None):
            t=time()
            # upper lower
            value = int(arg[0].get())
            #print(("shiftScale2",value,"arg",arg))
            diff = value - arg[0].lastValue
            if diff == None : return
            self.canvas.move(arg[0].line,diff,0)
            arg[0].lastValue = value
            WideView.myValueFrame.configLabels(value,1,arg[1])
            self.canvas.tag_raise(arg[0].line)
            #self.update()
        #end shiftScale2
        def setSliderChannel(self,channel):
            #print( "WW.setSliderChannel",channel,type(channel))
            try: 
                ButtonControl.buttonChannel = channel = int(channel)
                self.leftScale.config(bg=colors[channel])
                self.rightScale.config(bg=colors[channel])
                WideView.myValueFrame.labelList[9].config(fg=colors[channel])
                WideView.myValueFrame.labelList[15].config(fg=colors[channel])
                WideView.myValueFrame.labelList[11].config(fg=colors[channel])
                WideView.myValueFrame.labelList[13].config(fg=colors[channel])
            except Exception as message : 
                print( "setSliderChannel",Exception,message)
                traceback.print_exc()
        #end setSliderChannel
        def clearAverage(self,event=None):
            self.oldYArray = [None,None]
        #end clearAverage
        def clearPersistence(self,event=None):
            while len(self.persist[1]) > 1 : id = self.persist[1].pop(0); self.canvas.delete(id)
            while len(self.persist[0]) > 1 : id = self.persist[0].pop(0); self.canvas.delete(id)
        #end clearPersistence
        def setUpperScale(self,value):
            self.shiftScale2((self.upperScale,0))
        #end setUpperScale
        def adjustScrollers(self,event=None):
            #print("adj")
            try: 
                triggerSample = self.sweepDict[Control.sweepIndex]["triggerSample"]
                midX = self.paintWidth //2
                deltaSamples = midX * WideView.compress
                leftSample = triggerSample - deltaSamples
                WideView.scroller1_var.set(leftSample)
                ConrolQ.put("CLAV")
                WideView.syncChannels()
            except Exception as message : 
                pass #print( "adjS",message)
        #end adjustScrollers
    # end class displayFrame
    class buttonFrame (Frame):
        def __init__(self,root):
            Frame.__init__(self,root)
            self.ConrolQ = WideView.ConrolQ
            triggerBox1 = Frame(self)
            triggerBox1.pack(side='left',fill="both",expand=1)
            triggerBox1.config(bg=brown,bd=0,relief="flat",pady=0)
            ButtonBox = Frame(triggerBox1)
            ButtonBox.pack(side="top",fill="both",expand=1)
            ButtonBox.config(bg=brown,relief="flat",bd=0)
            self.RunButton = Button(ButtonBox,text='  Run  ')
            self.RunButton.grid(column=0,row=0,sticky="nsew"); self.RunButton.config(command=ButtonControl.setRunButton,bg="green",fg="black",activebackground="green",padx=0)
            self.PauseButton = Button(ButtonBox,text='Pause')
            self.PauseButton.grid(column=1,row=0,sticky="nsew"); self.PauseButton.config(command=ButtonControl.setPause,bg=brown,fg="white",padx=0)
            self.ExitButton = Button(ButtonBox,text='Exit ')
            self.ExitButton.grid(column=2,row=0,sticky="nsew"); self.ExitButton.config(command=shutDown,bg="#550000",fg="white",padx=0)
            self.SpectrumButton = Button(ButtonBox,text='Power Spectrum')
            self.SpectrumButton.grid(column=0,row=1,sticky="ew"); self.SpectrumButton.config(command=ButtonControl.setPowerSpectrum,bg=brown,fg="white",relief="flat",padx=0)
            self.ZoomButton = Button(ButtonBox,text='Scroll Indicator')
            self.ZoomButton.grid(column=1,row=1,sticky="ew"); self.ZoomButton.config(command=self.setZoom,bg=brown,fg="white",relief="flat",padx=0)
            self.XYButton = Button(ButtonBox,text='  XY Display  '  )
            self.XYButton.grid(column=2,row=1,sticky="ew"); self.XYButton.config(command=self.setXY,bg=brown,fg="white",relief="flat",padx=0)
            self.ViewP = Button(ButtonBox,text='Photo View')
            self.ViewP.grid(column=0,row=2,sticky="ew"); self.ViewP.config(command=self.setPhotoView,bg=brown,fg="white",relief="flat",padx=0)
            self.DSOZoom = Button(ButtonBox,text='DSO Zoom')
            self.DSOZoom.grid(column=1,row=2,sticky="ew"); self.DSOZoom.config(command=self.setDSOZoom,bg=brown,fg="white",relief="flat",padx=0)
            self.ViewS = Button(ButtonBox,text='Small View')
            self.ViewS.grid(column=2,row=2,sticky="ew"); self.ViewS.config(command=self.setStandardView,bg=brown,fg="white",relief="flat",padx=0)
            TOBox = Frame(ButtonBox)
            TOBox.grid(column=0,row=3,columnspan=3,sticky="nsew")
            TOBox.config(bg="white",relief="flat",bd=1)
            WideView.TimeoutLabel_var = StringVar()
            WideView.TimeoutLabel = Label(TOBox,text='sleep timing')
            WideView.TimeoutLabel.pack(side="top",fill="both",expand=1)
            WideView.TimeoutLabel.config(borderwidth=1,relief="flat",bg=brown,fg="white")
            HLED = Frame(TOBox)
            HLED.pack(side="top",fill="both",expand=1)
            HLED.config(bg="red")
            HLed0 = Frame(HLED)
            HLed0.pack(side="left",fill="both",expand=1)
            HLed0.config(relief="flat",bd=0,bg="white")
            LT00_var = StringVar()
            LT00 = Label(HLed0,text='control')
            LT00.pack(side="left",fill="both",expand=1)
            LT00.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            WideView.LED0_var = StringVar()
            WideView.LED0 = Label(HLed0,text=unichr(0x2798))
            WideView.LED0.pack(side="left",fill="both"); 
            WideView.LED0.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed1 = Frame(HLED)
            HLed1.pack(side="left",fill="both",expand=1)
            HLed1.config(relief="flat",bd=0,bg="white")
            LTO1_var = StringVar()
            LTO1 = Label(HLed1,text=' trig ')
            LTO1.pack(side="left",fill="both",expand=1)
            LTO1.config(borderwidth=0,bg=brown,fg="white")
            WideView.LED1_var = StringVar()
            WideView.LED1 = Label(HLed1,text=unichr(0x2798))
            WideView.LED1.pack(side="left",fill="y"); WideView.LED1.color = "green"
            WideView.LED1.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed4 = Frame(HLED)
            HLed4.pack(side="left",fill="both",expand=1)
            HLed4.config(relief="flat",bd=0,bg="white")
            LTO4_var = StringVar()
            LTO4 = Label(HLed4,text='chann')
            LTO4.pack(side="left",fill="both",expand=1)
            LTO4.config(borderwidth=0,bg=brown,fg="white")
            WideView.LED4_var = StringVar()
            WideView.LED4 = Label(HLed4,text=unichr(0x2798))
            WideView.LED4.pack(side="left",fill="y"); WideView.LED4.color = "green"
            WideView.LED4.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed3 = Frame(HLED)
            HLed3.pack(side="left",fill="both",expand=1)
            HLed3.config(relief="flat",bd=0,bg="white")
            LT02_var = StringVar()
            LT02 = Label(HLed3,text=' params')
            LT02.pack(side="left",fill="both",expand=1)
            LT02.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            WideView.LED2_var = StringVar()
            WideView.LED2 = Label(HLed3,text=unichr(0x2798) + " ")
            WideView.LED2.pack(side="left",fill="y");
            WideView.LED2.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            dummy_var = StringVar()
            dummy = Label(HLed3,text=' ')
            dummy.pack(fill='y',expand=1)
            dummy.config(relief='flat',borderwidth=0,bg=brown)
            self.MathBox = Frame(ButtonBox)
            self.MathBox.grid(column=0,row=4,columnspan=3,sticky="nsew"); self.MathBox_var = StringVar()
            self.MathBox.config(bg="grey",borderwidth=1,relief="flat",padx=0)
            L_var = StringVar()
            L = Label(self.MathBox,text='Math')
            L.pack(fill="x")
            L.config(relief='groove',borderwidth=0,bg=brown,fg="white",padx=0)
            rb0=Radiobutton(self.MathBox,text='Off',value="Off")
            rb0.config(variable=self.MathBox_var)
            rb0.pack(side="left",fill="x",expand=1)
            rb0.config(bg=brown,selectcolor="#660000",fg="white",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb1=Radiobutton(self.MathBox,text='+',value="+")
            rb1.config(variable=self.MathBox_var)
            rb1.pack(side="left",fill="x",expand=1)
            rb1.config(bg=brown,fg="white",indicatoron=0,width=2,bd=0,selectcolor="orange",highlightthickness=0,padx=0)
            rb2=Radiobutton(self.MathBox,text=unichr(0x2013),value="-")
            rb2.config(variable=self.MathBox_var)
            rb2.pack(side="left",fill="x",expand=1)
            rb2.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb3=Radiobutton(self.MathBox,text='*',value="*")
            rb3.config(variable=self.MathBox_var)
            rb3.pack(side="left",fill="x",expand=1)
            rb3.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb4=Radiobutton(self.MathBox,text='/',value="/")
            rb4.config(variable=self.MathBox_var)
            rb4.pack(side="left",fill="x",expand=1)
            rb4.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb5=Radiobutton(self.MathBox,text='\\',value="\\")
            rb5.config(variable=self.MathBox_var)
            rb5.pack(side="left",fill="x",expand=1)
            rb5.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            scrollBox = Frame(ButtonBox)
            scrollBox.grid(column=0,row=5,columnspan=3,sticky="nsew")
            scrollBox.config(bg=brown,padx=0)
            self.channelCoupling_var = IntVar()
            self.channelCoupling=Checkbutton(scrollBox,text='scroll coupling')
            self.channelCoupling.config(variable=self.channelCoupling_var)
            self.channelCoupling.pack(side="left",fill="both",expand=1)
            self.channelCoupling.config(command=self.setChannelCoupling,indicatoron=False,selectcolor="orange",background=brown,padx=0)
            setScroll = Button(scrollBox,text='set scroll coupling')
            setScroll.pack(side="left",fill="both",expand=1); setScroll.config(command=self.setScrollCoupling,bg=brown,fg="white",borderwidth=0,padx=0)
            triggerBox2 = Frame(self)
            triggerBox2.pack(side='left',fill="both",expand=1)
            triggerBox2.config(bg=brown,bd=0,relief="solid")
            AverBox = Frame(triggerBox2)
            AverBox.pack(side="top",fill="both",expand=1)
            AverBox.config()
            self.averageScale_var = IntVar()
            self.averageScale = Scale(AverBox,label='Average 100',from_=0, to=8, length=85,orient='horizontal', command=None,variable=self.averageScale_var)
            self.averageScale.pack(side="left",padx=0,ipadx=0,fill="both",expand=1)
            self.averageScale.config(showvalue=0,bg=brown,fg="white",troughcolor=brown,command=self.setAverage)
            self.persistenceScale_var = IntVar()
            self.persistenceScale = Scale(AverBox,label='Persistence 100',from_=0, to=9, length=85,orient='horizontal', command=None,variable=self.persistenceScale_var)
            self.persistenceScale.pack(side="left",fill="both",expand=1)
            self.persistenceScale.config(showvalue=0,bg=brown,fg="white",troughcolor=brown,command=self.setPersistence)
            timeBox = Frame(triggerBox2)
            timeBox.pack(side="top",fill="both",expand=1)
            timeBox.config(bd=1,bg="white")
            self.timeBaseLabel_var = StringVar()
            self.timeBaseLabel=MLabel(timeBox,text= ' Main Time Base   ')
            self.timeBaseLabel.pack(side="top",fill='both',expand=1)
            self.timeBaseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.timeBaseLabel.command = ButtonControl.scrollTimebase
            Zoom = Frame(timeBox)
            Zoom.pack(side="top",fill="both",expand=1)
            Zoom.config(bg=brown)
            self.ztb_var = StringVar()
            self.ztb = Label(Zoom,text='   Zoom Time Base ')
            self.ztb.pack(fill='both',side="left",expand=1)
            self.ztb.config(relief='groove',borderwidth=0,bg=brown,fg=brown,anchor="e")
            self.zoomLabel_var = StringVar()
            self.zoomLabel=MLabel(Zoom,text='')
            self.zoomLabel.pack(fill='both',side="left",expand=1)
            self.zoomLabel.config(relief='groove',borderwidth=0,bg=brown,anchor="w")
            self.zoomLabel.command = ButtonControl.scrollTimebase
            LL_var = StringVar()
            LL = Label(Zoom,text='      ')
            LL.pack(fill='both',side="left" )
            LL.config(relief='groove',borderwidth=0,bg=brown,fg=brown)
            WideView.lreso_var = StringVar()
            WideView.lreso = Label(timeBox,text='sample distance')
            WideView.lreso.pack(fill='both',expand=1)
            WideView.lreso.config(borderwidth=0,bg=brown,fg="white")
            H8 = Frame(triggerBox2)
            H8.pack(side='top',fill="both",expand=1)
            H8.config(bg="white",bd=1)
            self.sampleRangeLabel_var = StringVar()
            self.sampleRangeLabel = Label(H8,text='sample range')
            self.sampleRangeLabel.pack(fill='both',expand=1)
            self.sampleRangeLabel.config(borderwidth=0,bg=brown,fg="white")
            H7 = Frame(H8)
            H7.pack(side="top",fill="both",expand=1)
            H7.config(bg=brown,bd=0)
            self.rangeLabel1_var = StringVar()
            self.rangeLabel1 = Label(H7,text='00000-00000')
            self.rangeLabel1.pack(side="left",anchor="w")
            self.rangeLabel1.config(borderwidth=0,bg=brown,fg=colors[0],justify="left")
            self.rangeLabel2_var = StringVar()
            self.rangeLabel2 = Label(H7,text='00000-00000')
            self.rangeLabel2.pack(side="right",anchor="e")
            self.rangeLabel2.config(borderwidth=0,bg=brown,fg=colors[1],justify="right")
            self.h3 = Frame(triggerBox2)
            self.h3.pack(side="top",fill="both",expand=1); self.h3_var = StringVar()
            self.h3.config(bg="white",borderwidth=1,relief="flat")
            res_var = StringVar()
            res = Label(self.h3,text='trace compress')
            res.pack(side="left",fill="both",expand=1)
            res.config(borderwidth=0,bg=brown,fg="grey")
            self.dots20=Radiobutton(self.h3,text='20 ',value='20')
            self.dots20.config(variable=self.h3_var)
            self.dots20.pack(side="left",fill="both",expand=1)
            self.dots20.config(command=callback(self.configDots,(20,self.dots20)),indicatoron=False,selectcolor="orange",fg="grey",bg=brown)
            self.dots10=Radiobutton(self.h3,text='10 ',value='10')
            self.dots10.config(variable=self.h3_var)
            self.dots10.pack(side="left",fill="both",expand=1)
            self.dots10.config(command=callback(self.configDots,(10,self.dots10)),indicatoron=False,selectcolor="orange",fg="grey",bg=brown)
            self.dots5=Radiobutton(self.h3,text=' 5 ',value='5')
            self.dots5.config(variable=self.h3_var)
            self.dots5.pack(side="left",fill="both",expand=1)
            self.dots5.config(command=callback(self.configDots,(5,self.dots5)),indicatoron=False,selectcolor="orange",fg="grey",bg=brown)
            self.dots2=Radiobutton(self.h3,text=' 2 ',value='2')
            self.dots2.config(variable=self.h3_var)
            self.dots2.pack(side="left",fill="both",expand=1)
            self.dots2.config(command=callback(self.configDots,(2,self.dots2)),indicatoron=False,selectcolor="orange",bg=brown,fg="grey")
            self.dots1=Radiobutton(self.h3,text=' 1 ',value='1')
            self.dots1.config(variable=self.h3_var)
            self.dots1.pack(side="left",fill="both",expand=1)
            self.dots1.config(command=callback(self.configDots,(1,self.dots1)),indicatoron=False,bg=brown,selectcolor="orange",fg="grey")
            triggerBox3 = Frame(self)
            triggerBox3.pack(side='left',fill="both",expand=1)
            triggerBox3.config(bg=brown,bd=0,relief="solid")
            triggerBox2 = Frame(triggerBox3)
            triggerBox2.pack(side="top",fill="both",expand=1)
            triggerBox2.config(bg="white",bd=1)
            triggerTypeBox = Frame(triggerBox2)
            triggerTypeBox.pack(side="top",fill="both",expand=1)
            triggerTypeBox.config(relief="flat",bd=0,bg="grey")
            self.triggerTypeLabel_var = StringVar()
            self.triggerTypeLabel = Label(triggerTypeBox,text='Trigger Type ')
            self.triggerTypeLabel.pack(fill='both',expand=1,side="left")
            self.triggerTypeLabel.config(relief='flat',borderwidth=0,bg=brown,fg="white")
            self.triggerStateLabel_var = StringVar()
            self.triggerStateLabel = Label(triggerTypeBox,text='    ')
            self.triggerStateLabel.pack(fill='both',expand=1,side="left")
            self.triggerStateLabel.config(relief='flat',borderwidth=0,bg=brown,width=8)
            self.triggerSourceLabel_var = StringVar()
            self.triggerSourceLabel = Label(triggerBox2,text='Trigger Source')
            self.triggerSourceLabel.pack(fill='both',expand=1,side="top")
            self.triggerSourceLabel.config(borderwidth=0,bg=brown,fg=colors[0],padx=0)
            self.slopeContainer = Frame(triggerBox2)
            self.slopeContainer.pack(side="top",fill="both",expand=1)
            self.slopeContainer.config(bg = brown)
            self.TriggerSlopeBox = Frame(self.slopeContainer)
            self.TriggerSlopeBox.pack(side="top",fill="both",expand=1)
            self.TriggerSlopeBox.config(bg=brown)
            self.triggerSlopeLabel_var = StringVar()
            self.triggerSlopeLabel = Label(self.TriggerSlopeBox,text='Trigger Slope ')
            self.triggerSlopeLabel.pack(fill='both',expand=1,side="left")
            self.triggerSlopeLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerSlopeValue_var = StringVar()
            self.triggerSlopeValue = Label(self.TriggerSlopeBox,text='')
            self.triggerSlopeValue.pack(fill='both',expand=1,side="left")
            self.triggerSlopeValue.config(relief='groove',borderwidth=0,bg=brown,anchor="w")
            self.TriggerPolarityBox = Frame(self.slopeContainer)
            self.TriggerPolarityBox.pack(side="top",fill="both",expand=1)
            self.TriggerPolarityBox.config(bg=brown)
            self.triggerPolarityLabel_var = StringVar()
            self.triggerPolarityLabel = Label(self.TriggerPolarityBox,text='Polarity ')
            self.triggerPolarityLabel.pack(fill='both',expand=1,side="left")
            self.triggerPolarityLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerPolarityValue_var = StringVar()
            self.triggerPolarityValue = Label(self.TriggerPolarityBox,text='')
            self.triggerPolarityValue.pack(fill='both',expand=1,side="left")
            self.triggerPolarityValue.config(relief='groove',borderwidth=0,bg=brown,fg="white",anchor="w")
            self.StandardBox = Frame(self.slopeContainer)
            self.StandardBox.pack(side="top",fill="both",expand=1)
            self.StandardBox.config(bg=brown)
            self.StandardLabel_var = StringVar()
            self.StandardLabel = Label(self.StandardBox,text='Standard ')
            self.StandardLabel.pack(fill='both',expand=1,side="left")
            self.StandardLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.StandardValue_var = StringVar()
            self.StandardValue = Label(self.StandardBox,text='PAL/NTSC')
            self.StandardValue.pack(fill='both',expand=1,side="left")
            self.StandardValue.config(relief='groove',borderwidth=0,bg=brown,fg="white",anchor="w")
            self.ModeContainer = Frame(triggerBox2)
            self.ModeContainer.pack(side="top",fill="both",expand=1)
            self.ModeContainer.config(bg=brown)
            self.ModeEdgeLabel_var = StringVar()
            self.ModeEdgeLabel = Label(self.ModeContainer,text='Trigger Mode')
            self.ModeEdgeLabel.pack(fill='both',expand=1,side="top")
            self.ModeEdgeLabel.config(borderwidth=0,bg=brown,fg="white")
            self.ModePulseLabel_var = StringVar()
            self.ModePulseLabel = Label(self.ModeContainer,text='Trigger Mode')
            self.ModePulseLabel.pack(fill='both',expand=1,side="top")
            self.ModePulseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.SyncContainer = Frame(self.ModeContainer)
            self.SyncContainer.pack(side="top")
            self.SyncContainer.config(bg=brown)
            self.SyncLabel_var = StringVar()
            self.SyncLabel = Label(self.SyncContainer,text='Sync ')
            self.SyncLabel.pack(fill='both',side="left")
            self.SyncLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.SyncValue_var = StringVar()
            self.SyncValue = Label(self.SyncContainer,text='Line Num')
            self.SyncValue.pack(fill='both',side="left")
            self.SyncValue.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.LineNum_var = StringVar()
            self.LineNum=MLabel(self.SyncContainer,text='  ')
            self.LineNum.pack(fill='both',side="left")
            self.LineNum.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.LineNum.command = ButtonControl.scrollLineNum
            self.couplingContainer = Frame(triggerBox2)
            self.couplingContainer.pack(side="top",fill="both",expand=1)
            self.couplingContainer.config(bg=brown)
            self.CouplingEdgeLabel_var = StringVar()
            self.CouplingEdgeLabel = Label(self.couplingContainer,text='Trigger Coupling ')
            self.CouplingEdgeLabel.pack(fill='both',expand=1,side="top")
            self.CouplingEdgeLabel.config(borderwidth=0,bg=brown,fg="white")
            self.CouplingPulseLabel_var = StringVar()
            self.CouplingPulseLabel = Label(self.couplingContainer,text='Trigger Coupling ')
            self.CouplingPulseLabel.pack(fill='both',expand=1,side="top")
            self.CouplingPulseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.WhenContainer = Frame(triggerBox2)
            self.WhenContainer.pack(side="top",fill="both",expand=1)
            self.WhenContainer.config(bg=brown,bd=0)
            self.whenBox = Frame(self.WhenContainer)
            self.whenBox.pack(side="top")
            self.whenBox.config(bg=brown)
            self.whenLabel_var = StringVar()
            self.whenLabel = Label(self.whenBox,text='When')
            self.whenLabel.pack(fill='both',expand=1,side="left")
            self.whenLabel.config(borderwidth=0,bg=brown,fg="white")
            self.SettingValue_var = StringVar()
            self.SettingValue=MLabel(self.whenBox,text='0. 00 ns')
            self.SettingValue.pack(fill='x',side="left")
            self.SettingValue.config(relief='groove',borderwidth=0,bg=brown)
            self.SettingValue.command = ButtonControl.scrollWhen
            HTriggerLevel = Frame(triggerBox2)
            HTriggerLevel.pack(side="top",fill="both",expand=1)
            HTriggerLevel.config(borderwidth=0,relief="flat",bg="grey")
            self.triggerLevelLabel_var = StringVar()
            self.triggerLevelLabel = Label(HTriggerLevel,text='Trigger Level  ')
            self.triggerLevelLabel.pack(fill='both',expand=1,side="left")
            self.triggerLevelLabel.config(borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerValueLabel_var = StringVar()
            self.triggerValueLabel=MLabel(HTriggerLevel,text='')
            self.triggerValueLabel.pack(fill='both',expand=1,side="left")
            self.triggerValueLabel.config(borderwidth=0,bg=brown,anchor="w")
            self.triggerValueLabel.command = ButtonControl.scrollTriggerValue
            triggerPos = Frame(triggerBox2)
            triggerPos.pack(side="top",fill="both",expand=1)
            triggerPos.config(borderwidth=0,relief="flat")
            self.TPosLabel_var = StringVar()
            self.TPosLabel = Label(triggerPos,text='  Trigger Position')
            self.TPosLabel.pack(fill='both',expand=1,side="left")
            self.TPosLabel.config(borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.TPosValue_var = StringVar()
            self.TPosValue=MLabel(triggerPos,text=None)
            self.TPosValue.pack(fill='both',expand=1,side="left")
            self.TPosValue.config(borderwidth=0,bg=brown,fg="white",justify="left",anchor="w")
            self.TPosValue.command = ButtonControl.scrollTPos
            self.initBindings()
            self.config(bg="white",relief="solid",borderwidth=0,pady=0)
            self.MathBox_var.set("Off")
            self.showParameters = False
            WideView.LedList = [WideView.LED0,WideView.LED1,WideView.LED2,WideView.LED4]
            self.channelCoupling.invoke()
            self.TriggerPolarityBox.pack_forget()
            self.lastTriggerType = ""
            self.dotList = [self.dots1,self.dots2,self.dots5,self.dots10,self.dots20]
            self.dots1.invoke()
            self.Zoom = False
            self.XY = False
            self.zoomed = False
        # end init buttonFrame
        def initBindings(self):
            self.whenLabel.bind("<Button-1>",ButtonControl.changeWhen)
            self.triggerPolarityLabel.bind("<Button-1>",ButtonControl.changePolarity)
            self.RunButton.bind("<Button-3>",ButtonControl.setRunButton)
            self.TPosLabel.bind("<Button-1>",WideView.display.adjustScrollers); 
            self.triggerSourceLabel.bind("<Button-1>",ButtonControl.changeTriggerSource)
            self.CouplingPulseLabel.bind("<Button-1>",ButtonControl.changeTriggerCoupling)
            self.CouplingEdgeLabel.bind("<Button-1>",ButtonControl.changeTriggerCoupling)
            self.ModePulseLabel.bind("<Button-1>",Control.changeTriggerMode)
            self.ModeEdgeLabel.bind("<Button-1>",Control.changeTriggerMode)
            self.triggerSlopeValue.bind("<Button-1>",ButtonControl.changeTriggerSlope)
            self.triggerSlopeLabel.bind("<Button-1>",ButtonControl.changeTriggerSlope)
            self.triggerTypeValue = 0
            self.triggerTypeLabel.bind("<Button-1>",ButtonControl.changeTriggerType)
            self.triggerValueLabel.bind("<Button-1>",ButtonControl.trig50)
            self.triggerLevelLabel.bind("<Button-1>",ButtonControl.trig50)
            self.StandardLabel.bind("<Button-1>",ButtonControl.changeStandard)
            self.StandardValue.bind("<Button-1>",ButtonControl.changeStandard)
            self.SyncLabel.bind("<Button-1>",ButtonControl.changeSync)
            self.SyncValue.bind("<Button-1>",ButtonControl.changeSync)
            self.triggerType = ""
            self.LineNum.bind("<Button-1>",ButtonControl.changeCoarse)
            self.SettingValue.bind("<Button-1>",ButtonControl.changeCoarse)
            self.averageScale.bind("<Button-3>",WideView.display.clearAverage)
            self.persistenceScale.bind("<Button-3>",WideView.display.clearPersistence)
            self.DSOZoom.bind("<Button-3>",self.resetDSOZoom)
        #end initBindings
        def setZoom(self):
            # choice
            if self.Zoom == False : self.Zoom = True; self.ZoomButton.config(bg="orange",fg="black"); ZoomQ.put("SHOW")
            else:  
                self.Zoom = False; self.ZoomButton.config(bg=brown,fg="white"); ZoomQ.put("HIDE")
            # end choice
        #end setZoom
        def setXY(self):
            # choice
            if self.XY == False : self.XY = True; self.XYButton.config(bg="orange",fg="black"); 
            else: self.XY = False; self.XYButton.config(bg=brown,fg="white");
            # end choice
        #end setXY
        def setPersistence(self,arg=None):
            persistence = 2**self.persistenceScale.get()
            # choice
            if persistence == 0 : self.persistenceScale.config(label="Persistence off")
            else: self.persistenceScale.config(label="Persistence "+str(persistence))
            # end choice
        #end setPersistence
        def setAverage(self,arg=None):
            v = self.averageScale.get()
            # choice
            if v == 0 :  
                self.averageScale.config(label="Average off")
            else:  
                self.averageScale.config(label="Average "+str(2**v))
            # end choice
        #end setAverage
        def setChannelCoupling(self,value=None):
            # choice
            if self.channelCoupling_var.get() : self.channelCoupling.config(text="scroll coupling on",bg="orange",fg="black"); WideView.syncChannels()
            else: self.channelCoupling.config(text="scroll coupling off",bg=brown,fg="white")
            # end choice
        #end setChannelCoupling
        def configDots(self,arg):
            #print( "configDots value",arg)
            for dot in self.dotList: 
                dot.config(fg="grey")
            arg[1].config(fg="black")
            WideView.syncChannels(True)
            WideView.samplesPerDot = arg[0]; #print( "spd",WideView.samplesPerDot)
            WideView.display.adjustScrollers()
            self.ConrolQ.put("CLAV")
        #end configDots
        def setScrollCoupling(self):
            try: 
                #print( "setScrollCoupling")
                v1 = int(WideView.scroller1_var.get()); v2 = int(WideView.scroller2_var.get()) ; diff = v2 -12800 -v1 ; #print( "scroll coupling diff",diff)
                WideView.display.sweepDict[Control.sweepIndex]["scrollOffset"] =  diff
                WideView.syncChannels(True)
                self.channelCoupling_var.set(0)
                self.channelCoupling.invoke()
            except Exception as message : 
                print( "setScrollCoupling",Exception,message)
        #end setScrollCoupling
        def setPhotoView(self):
            Control.changeView("P")
        #end setPhotoView
        def setStandardView(self):
            Control.changeView("S")
        #end setStandardView
        def setDSOZoom(self):
            # choice
            if self.zoomed :  
                self.zoomed = False
                USBQ.put(("sendControlMessage",MENU,F1))
                self.DSOZoom.config(bg=brown,fg="white")
                #StandardView.ButtonFrame.DSOZoom.config(bg=brown,fg="white")
                Control.changeView("W")
                WideView.canvas.delete(WideView.display.traceList[3]) ; WideView.canvas.delete(WideView.display.traceList[4])
                self.ztb.config(fg=brown,bg=brown); self.zoomLabel.pack_forget()
                StandardView.ButtonFrame.ztb.config(fg=brown,bg=brown); StandardView.ButtonFrame.zoomLabel.pack_forget()
                self.TPosLabel.config(text=" Trigger Position")
                StandardView.ButtonFrame.TPosLabel.config(text=" Trigger Position")
            else:  
                USBQ.put(("sendControlMessage",MENU,F3))
                self.DSOZoom.config(bg="orange",fg="black")
                #StandardView.ButtonFrame.DSOZoom.config(bg="orange",fg="black")
                self.zoomed = True
                Control.changeView("Z")
                self.ztb.config(fg="white")
                StandardView.ButtonFrame.ztb.config(fg="white")
                self.zoomLabel.pack(fill='both',side="left")
                StandardView.ButtonFrame.zoomLabel.pack(fill='both',side="left")
                self.TPosLabel.config(text=" Zoom Position")
                StandardView.ButtonFrame.TPosLabel.config(text=" Zoom Position")
            # end choice
        #end setDSOZoom
        def resetDSOZoom(self,event):
            self.zoomed = not self.zoomed
        #end resetDSOZoom
    # end class buttonFrame
    def __init__(self,root):
        Frame.__init__(self,root)
        self.initEarlyValues()
        self.display = self.displayFrame(self);
        self.display.grid(column=0,row=1,columnspan=7,sticky="ns")
        self.myChannelsFrame = Control.channelsFrame(self); self.myChannelsFrame.grid(column=0,row=2,sticky = "nsew",rowspan=2,columnspan=2); 
        self.ButtonFrame = self.buttonFrame(self); 
        self.ButtonFrame.grid(column=2,row=2,columnspan=4,rowspan=2,sticky="news")
        self.myValueFrame=Control.valueFrame(self); self.myValueFrame.grid(column=6,row=2,columnspan=2,sticky="news",rowspan=2) 
        if screenWidth >= 1280 :
            self.myValueFrame.grid(column=6,row=2,columnspan=2,rowspan=2,sticky="news");
        self.scrollFrame = Frame(self)
        self.scrollFrame.grid(column=0,row=4,columnspan=8,sticky="ew")
        self.scrollFrame.config(bg=brown)
        self.scroller1_var = IntVar()
        self.scroller1 = Scale(self.scrollFrame,label='',from_=512, to=4800, length=self.display.paintWidth + 73,orient='horizontal', command=self.syncChannels,variable=self.scroller1_var)
        self.scroller1.pack(fill="x",expand=1)
        self.scroller1.config(bg=colors[0],troughcolor=colors[0])
        self.scroller2_var = IntVar()
        self.scroller2 = Scale(self.scrollFrame,label='',from_=13312, to=17600, length=self.display.paintWidth+73,orient='horizontal', command=self.syncChannels,variable=self.scroller2_var)
        self.scroller2.pack(side="top",fill="x",expand=1)
        self.scroller2.config(bg=colors[1],troughcolor=colors[1])
        self.initLateValues()
    # end init wideView
    def initEarlyValues(self):
        global WideView; WideView  = self; self.ConrolQ = ConrolQ
        self.name = "WideView"
        self.config(bg=brown,width=screenWidth) 
        menuBar_var = IntVar()
        self.Stop = False
        self.channelFrameList = []
        ButtonControl.buttonChannel = 0
        self.showRepeatedParameter = [0,0]
        self.showSingleParameter = [True,True]
        self.parameterChannel = 0
        self.pixmapIdList = [0,0]; self.pixmapId = 0
        self.refreshCounter = 0
        self.configDiagnostic = False
        self.triggerSource = ""
        self.requestChannelMap = [True,True]
        self.upperSample = 2000; self.lowerSample = 1000
        self.cursorFrequency = 1; self.burstFrequency = 1
        self.lastTriggerType = ""
        self.doChangePolarity = False
        self.recursion=0
        self.ButtonFrame = None; self.data = None
        #WideView.MouseWidget = None
        self.compress = 1; self.stretch = 1 # to avoid exceptions only
        self.active = 0
    #end initEarlyValues
    def initLateValues(self):
        #self.LED0.config(fg="green");  self.LED1.config(fg="green"); self.LED2.config(fg="green")
        
        
        #self.ch1_data = {}; self.ch2_data = {}
        self.compress = 1
        ZoomQ.put("HIDE")
        #self.logfile =open("log.log","w")
        self.syncChannels()
        #USBQ.put("ReqTriggMap")
    #end initLateValues
    def syncChannels(self,value=False):
        if Control.data == None  : return
        #print("sync",Control.samples[0][0:10])
        if self.recursion > 0 and False : return
        if self.ButtonFrame == None : return # or self.data == None : return
        if value != True : self.display.clearAverage()
        # choice
        if Control.sweepIndex == 33 :  
            channel2Start = Control.half
        else:  
            channel2Start = 13311
        # end choice
        try: 
            scrollOffset = WideView.display.sweepDict[Control.sweepIndex]["scrollOffset"]; #print ("scrollOffset",scrollOffset)
        except KeyError as message : 
            scrollOffset = 0
            #print( "sync Key error",message,scrollOffset,WideView.display.sweepDict[Control.sweepIndex])
            #return
        except Exception as message : 
            scrollOffset = 0
            print( "sync",Exception,message) ; traceback.print_exc()
            return
        try: 
            self.recursion +=1
            self.compress = float(self.ButtonFrame.h3_var.get())
            value1 = int(self.scroller1_var.get())
            end=value1 + int(self.display.paintWidth * self.compress); end = min(end,channel2Start)
            s = "%5i - %5i" % (value1,end); 
            self.ButtonFrame.rangeLabel1.config(text=s)
            value2 = int(self.scroller2_var.get())
            diff = value1 - 512 + scrollOffset; #print ("scrollOffset",scrollOffset,"diff",diff) # channelCoupling_var",self.ButtonFrame.channelCoupling_var.get())
            if self.ButtonFrame.channelCoupling_var.get() :
                self.scroller2_var.set(channel2Start+diff);
                value2 = int(self.scroller2_var.get())
            end=value2 + int(self.display.paintWidth * self.compress); end =min(end,2*channel2Start)
            s = "%5i - %5i" % (value2,end);
            self.ButtonFrame.rangeLabel2.config(text=s)
            if self.recursion == 1 :
                #print("sync vor refresh self.data",Control.data[0:10],"samples",Control.samples[0][0:10])
                Control.refreshData()
                #print("sync nach refresh self.data",Control.data[0:10],"samples",Control.samples[0][0:10])
            self.recursion -= 1
            #self.update()
        except Exception as message : 
            self.recursion -=1
            print( "sync Exception",message,) ; traceback.print_exc()
            return
    #end syncChannels
# end class wideView
class standardView (Frame):
    # classes
    class displayFrame (Frame):
        def __init__(self,parent):
            Frame.__init__(self,parent)
            #print "init display"
            self.offx = 17; self.wy=50; self.offy = 17 ; self.yZero = self.offy + 10*self.wy # wxy für raster
            wx=50; offx = 17; wy=50; offy = 17; self.paintWidth=500
            self.leftFrame = Frame(self)
            self.leftFrame.grid(column=0,row=1)
            self.leftFrame.config(bg="black",bd=0)
            self.leftScale_var = IntVar()
            self.leftScale = Scale(self.leftFrame,label=None,from_=0, to=10*wy, length=10*wy + 2*offy,orient='vertical', command=None ,variable=self.leftScale_var)
            self.leftScale.pack(side="top"); self.leftScale.lastValue = 0
            self.leftScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.rightFrame = Frame(self)
            self.rightFrame.grid(column=2,row=1)
            self.rightFrame.config(bg="black")
            self.rightScale_var = IntVar()
            self.rightScale = Scale(self.rightFrame,label=None,from_=0, to=10*wy, length=10*wy + 2*offy,orient='vertical', command=None ,variable=self.rightScale_var)
            self.rightScale.pack(side="top"); self.rightScale.lastValue = 0
            self.rightScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.upperFrame = Frame(self)
            self.upperFrame.grid(column=1,row=0)
            self.upperFrame.config(bg="black")
            self.upperScale_var = IntVar()
            self.upperScale = Scale(self.upperFrame,label=None,from_=0, to=10*wx, length=10*wx + 2*offx,orient='horizontal', command=None ,variable=self.upperScale_var)
            self.upperScale.pack(side="top"); self.upperScale.lastValue = 0
            self.upperScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False,command=self.setUpperScale)
            self.lowerFrame = Frame(self)
            self.lowerFrame.grid(column=1,row=2)
            self.lowerFrame.config(bg="black")
            self.lowerScale_var = IntVar()
            self.lowerScale = Scale(self.lowerFrame,label=None,from_=0, to=10*wx, length=10*wx + 2*offx,orient='horizontal', command=None ,variable=self.lowerScale_var)
            self.lowerScale.pack(side="top"); self.lowerScale.lastValue = 0
            self.lowerScale.config(troughcolor=scopeGreen,bg=scopeGreen,fg=scopeGreen,bd=0,highlightcolor=scopeGreen,showvalue=False)
            self.root = root
            self.config(relief="solid",borderwidth=2,bg="#005500")
            self.centerFrame=Frame(self); self.centerFrame.grid(row=1,column=1)
            self.canvas = Canvas(self.centerFrame,bg="#005500",width=10*wx + 2*offx,height=10*wy + 2*offy)
            StandardView.backgroundId = self.canvas.create_rectangle(0,0,self.paintWidth + 2*offx,10*wy + 2*offy,fill=scopeGreen)
            self.canvas.pack()
            for x in range(11): 
                self.canvas.create_line(x*wx +  offx , offy, x*wx + offx, 10*wy + offy,fill="black")
            for y in range(11): 
                # choice
                if y == 5 : myColor = "#777777"
                else: myColor = "black"
                # end choice
                self.canvas.create_line(offx,y*wy + offy,10*wx + offx,y*wy + offy,fill=myColor)
            StandardView.canvas = self.canvas
            self.leftScale.line = self.canvas.create_line(offx,offy,offx + 10*wx, offy,fill="#ffffff",dash=[2,8])
            self.upperScale.line = self.canvas.create_line(offx,offy,offx, offy + 10*wy,fill="#ffffff",dash=[2,8])
            self.lowerScale.line = self.canvas.create_line(offx ,offy,offx, offy + 10*wy,fill="#ffffff",dash=[2,8])
            self.rightScale.line = self.canvas.create_line(offx+5,offy,offx + 10*wx-5, offy,fill="#ffffff",dash=[2,8])
            #print (self.leftScale.config())
            self.wx = wx; self.wy = wy
            self.offx = offx;  self.offy = offy
            self.id1 = None; self.id2 = None; self.id3 = None
            self.data = None; self.params = None
            self.upperScale.set(500); self.rightScale.set(500)
            self.lowerScale.set(0);  self.leftScale.set(0)
            self.textId = None
            self.y1Id = None; self.y2Id = None
            ButtonControl.buttonChannel = 0
            self.shiftScale((self.leftScale,0))
            self.shiftScale((self.rightScale,1))
            self.oldli = [None,None]; self.oldYArray = [None,None]
            self.persist = [[],[]]
            self.parameterId  = [[0,0],[0,0]]
            self.myFont = Font(family="Courier",size=12,weight="bold")
            #print "end init display"
            self.referenceList = []; self.selectedItem = -1
            self.clearAV = False
            self.traceDict = {}; self.captionDict= {}; self.referenceTraceDict= {}; self.traceList = [0,0,0]
            self.oldPointList = [None,None]
            self.midId = 0 ;self.hysId = 0
            self.canvas.bind("<Shift-Button-3>",ReferenceControl.scrollRefUp);self.canvas.bind("<Shift-Button-1>",ReferenceControl.scrollRefDown);
            self.canvas.bind("<Button-4>",ReferenceControl.scrollRefDown);self.canvas.bind("<Button-5>",ReferenceControl.scrollRefUp);
            self.canvas.bind("<Button-1>",ReferenceControl.findReference); self.canvas.bind("<Button-3>",ReferenceControl.deleteReference)
        # end init displayFrame
        def configDisplay(self,ch1,ch2,newdata,):
            t=time()
            #print( "\nconfigDisplay clearAV",self.clearAV)
            if ch1 == None or ch2 == None or newdata == None : return
            #self.compress = compress = int(WideView.ButtonFrame.h3_var.get()); 
            if ButtonControl.Spectrum and SpectrumQ.empty() :
                try: 
                    message = ("SAMPLES",self.lower1,self.upper1,self.lower2,self.upper2,self.oldYArray,StandardView.burstFrequency,StandardView.cursorFrequency)
                    SpectrumQ.put(message)
                except Exception as message : 
                    print("Spec",message)
            #self.configGrid()
            if self.clearAV :
                self.oldYArray = [None,None]
                self.clearAV = False
            self.averageShift = StandardView.ButtonFrame.averageScale.get()  # 0 bis 8
            #self.averageFactor = 2 **  -WideView.ButtonFrame.averageScale.get(); #print( "aver",averageFactor)
            self.averageComplement = 8- self.averageShift
            self.persistenceCount = 2**StandardView.ButtonFrame.persistenceScale.get()
            li1 = self.configChannel(ch1,0,newdata)
            li2 = self.configChannel(ch2,1,newdata)
            self.processCursors()
            if self.data != None and newdata != None and Control.showDiffs_var.get() :  # changed data
                for i in range(512): 
                    if newdata[i] != self.data[i] and i != 4 and i != 50 :
                        print( "%3i %3i -> %3i" % (i,self.data[i],newdata[i]))
            self.data = newdata
            if self.textId != None : self.canvas.delete(self.textId)
            if self.y1Id != None :
                self.canvas.delete(self.y1Id); self.canvas.delete(self.y2Id)
            #WideView.v1 = 512*0.9 - newdata[6] *2 +self.offy
            self.y1Id = self.canvas.create_text(10,2*newdata[6] +16, text=unichr(0x25b6), fill=colors[0])  # triangles for baseline
            self.y2Id = self.canvas.create_text(10,2*newdata[38] +16, text=unichr(0x25b6), fill=colors[1])
            self.shiftScale2((self.upperScale,0)); self.shiftScale2((self.lowerScale,1))
            if not ch1["active"] :
                while len(self.persist[0]) > 0 : id = self.persist[0].pop(0); self.canvas.delete(id)
            if not ch2["active"] :
                while len(self.persist[1]) > 0 : id = self.persist[1].pop(0); self.canvas.delete(id)
            self.configMath(ch1,ch2,li1,li2)
            try: 
                self.canvas.delete(self.idXY)
            except Exception as message : pass
            if StandardView.ButtonFrame.XY :
                self.configXY(self.oldYArray)
            t=time()
            self.update()
            #print ("configDisplay update %5.3f " % (time() - t))
        #end configDisplay
        def configChannel(self,ch,channelNr,newdata):
            if not ch["active"] or len(Control.samples[channelNr]) < 10 : return None
            t = time()
            log("Scope configChannel start %i" % channelNr)
            #YArray = numpy.random.normal(10,10,10); YArray += 100; YArray = YArray.astype("uint16")
            YArray = Control.samples[channelNr]; 
            if self.oldYArray[channelNr] == None or len(self.oldYArray[channelNr]) != len(YArray) :
                self.oldYArray[channelNr] = YArray.copy() <<8
            try: 
                subtractor = self.oldYArray[channelNr]  >> self.averageShift; 
                additor =  YArray <<self.averageComplement ; 
                newYArray = self.oldYArray[channelNr] -subtractor +additor
            except Exception as message : 
                print( "configDisplay average",message)
            self.oldYArray[channelNr] = newYArray.copy();
            # group produce canvas line
            start = self.offx +3; num=newYArray.size; end = num + start
            pointList = numpy.empty(2*num,dtype="uint16")
            pointList[0::2] = numpy.arange(start,start+2*num,2)
            pointList[1::2] = 523 - 2*(newYArray>>8); 
            pointList = pointList.tolist()
            #rint( "configCH",channelNr,"len(pointList)",len(pointList),"Y",newYArray[0:10], "pointList", pointList[0:10])
            try: 
                self.traceList[channelNr] = self.id1 = self.canvas.create_line(pointList,fill=colors[channelNr])
            except Exception as message : 
                print( "configDisplay len pointList create_line",message,len(pointList))
                return None
            self.persist[channelNr].append(self.id1)
            while len(self.persist[channelNr]) > self.persistenceCount : id = self.persist[channelNr].pop(0); self.canvas.delete(id)
            if len(self.persist[channelNr]) >=4 :
                l = len(self.persist[channelNr])
                self.canvas.itemconfigure(self.persist[channelNr][l-2],fill=colors[channelNr+2])
                self.canvas.itemconfigure(self.persist[channelNr][l-3],fill=colors[channelNr+4])
                self.canvas.itemconfigure(self.persist[channelNr][l-4],fill=colors[channelNr+6])
            self.oldPointList[channelNr]= pointList
            #print( "c_channel  %5.3f" % (time() - t))
            t2 = time()
            log("Scope configChannel %i duration %5.3f" % (channelNr,t2-t))
            return pointList
        #end configChannel
        def processCursors(self):
            if self.data == None : return
            if StandardView.active == 0 : return
            if StandardView.active == 1 and ButtonControl.buttonChannel != 0 : return
            if StandardView.active == 2 and ButtonControl.buttonChannel != 1 : return
            try: 
                sweepIndex=Control.sweepIndex
                sweep = T_RANGE[sweepIndex]; 
                upper = self.upperScale_var.get()//2; lower = self.lowerScale_var.get()//2; #print("lower",lower,"upper",upper)
                self.upper1 = int(upper)
                self.upper2 = int(upper)
                self.lower1 = int(lower)
                self.lower2 = int(lower)
                # choice
                if ButtonControl.buttonChannel == 0 or (ButtonControl.buttonChannel == 1 and StandardView.active == 2) :  
                    self.lowerSample = lowerSample = self.lower1
                    self.upperSample = upperSample = self.upper1
                else:  
                    self.upperSample = upperSample = self.upper2
                    self.lowerSample = lowerSample = self.lower2
                # end choice
                sampleDiff = upperSample - lowerSample;
                # group get burst frequency
                try: 
                    self.canvas.delete(self.midId)
                    self.canvas.delete(self.hysId)
                except Exception as message : 
                    print("procur",message)
                try: 
                    sampleRange = self.oldYArray[ButtonControl.buttonChannel][lower : upper]
                except Exception as message : 
                    print ("procCur",message); return
                if len(sampleRange) == 0 :
                    print( "sampleRange is empty",lower,upper)
                    return
                meanValue =int(sampleRange.mean())
                MAX =max(sampleRange); MIN =min(sampleRange); MID = meanValue; zeroCount = 0; first = -1; last =-1; hys = int(ValueControl.Hys* 0.45*(MAX-MIN))
                #MAX =max(sampleRange); MIN =min(sampleRange); MID =(MAX + MIN) /2; zeroCount = 0; first = -1; last =-1; hys = WideView.Hys * (MAX - MIN)
                upperThresh = MID + hys; lowerThresh = MID - hys; thresh = MID;
                hystPointList = []
                for i,sample in enumerate(sampleRange): 
                    #print ("i %i sample %i upper %i lower %i thresh %i" % (i,sample,upperThresh,lowerThresh,thresh)); #print (type(sample))
                    if i == 0 :
                        # choice
                        if sample > upperThresh : thresh = lowerThresh
                        elif sample < lowerThresh : thresh = upperThresh
                        else:  
                            pass
                        # end choice
                        lastSample = sample
                    # choice
                    if thresh == MID :  
                        # choice
                        if sample > upperThresh  : thresh = lowerThresh
                        elif sample < lowerThresh  : thresh = upperThresh
                        # end choice
                        lastSample = sample
                    elif thresh == lowerThresh :  
                        if sample < lowerThresh and lastSample >= lowerThresh :
                            zeroCount +=1
                            # choice
                            if first == -1 : first = i; last = i
                            else: last = i
                            # end choice
                            lastSample = sample; thresh = upperThresh
                            hystPointList.append(2*lower + 20 + 2*i);hystPointList.append(self.yZero - (lowerThresh>>7))
                            hystPointList.append(2*lower + 20 + 2*i);hystPointList.append( self.yZero - (upperThresh>>7))
                    elif thresh == upperThresh :  
                        if sample > upperThresh and lastSample <= upperThresh :
                            zeroCount += 1
                            # choice
                            if first == -1 : first = i; last = i
                            else: last = i
                            # end choice
                            lastSample = sample; thresh = lowerThresh
                            hystPointList.append(2*lower + 20 + 2*i);hystPointList.append( self.yZero - (upperThresh>>7))
                            hystPointList.append(2*lower + 20 + 2*i);hystPointList.append( self.yZero - (lowerThresh>>7))
                    # end choice
                try: 
                    #print( "first %i last %i zeros %i" % (first,last,zeroCount)); print ("hystpoints",hystPointList[0:10])
                    if zeroCount < 3 : StandardView.burstFrequency = None; return
                    dotsPerPeriod = 2*(last - first) / (zeroCount-1)
                    period =  dotsPerPeriod * Control.timeBase /25 
                    # choice
                    if period != 0 :  
                        StandardView.burstFrequency = 1.0/ period;  #print ("burstf",StandardView.burstFrequency)
                    else:  
                        StandardView.burstFrequency= None
                    # end choice
                    if Control.showHysteresis_var.get() :
                        if len(hystPointList) > 0 :
                            self.hysId = self.canvas.create_line(hystPointList,fill="white")
                            #print( hystPointList)
                            self.canvas.move(self.hysId,0,7)
                except Exception as message : 
                    dotsPerPeriod = None
                    print( "processCursors",message)
                    traceback.print_exc()
            except Exception as message : 
                print( "processCursors",message)
                traceback.print_exc()
            #print("procCur 2 len oldY",len(self.oldYArray[0]),len(self.oldYArray[1]))
        #end processCursors
        def configMath(self,ch1,ch2,li1=None,li2=None):
            ld = []
            try: 
                if li1 == None or li2 == None : return
                if self.id3 != None : self.canvas.delete(self.id3); self.id3 = None;
                if ch1["active"] and ch2["active"] and StandardView.ButtonFrame.MathBox_var.get() == "\\" :
                    ld = li1[:]; divisor = float(Control.setDivisionDivisor_var.get()) 
                    for i in range(1,len(li1),2): 
                        try: 
                            ld[i] = divisor *  (li2[i]-268) /  (li1[i] -268)* (-50) +220
                        except Exception as message : 
                            ld[i] = 0
                            #print( "configDisplay l[d]=0",message)
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and StandardView.ButtonFrame.MathBox_var.get() == "/" :
                    ld = li1[:]; divisor = float(Control.setDivisionDivisor_var.get()) 
                    for i in range(1,len(li1),2): 
                        try: 
                            ld[i] = divisor *  (li1[i]-268) /  (li2[i] -268)* (-50) +220
                        except Exception as message : 
                            ld[i] = 0
                            #print( "configDisplay l[d]=0",message)
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and StandardView.ButtonFrame.MathBox_var.get() == "*" :
                    ld = li1[:]; divisor= float(Control.setMultiplicationDivisor_var.get());# print( "divisor",divisor)
                    for i in range(1,len(li1),2): 
                        ld[i] = divisor * (li1[i]-268) *  (li2[i] -268) *(-1)/(250) +268
                        #print( ld[i])
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and StandardView.ButtonFrame.MathBox_var.get() == "+" :
                    ld = li1[:]
                    for i in range(1,len(li1),2): 
                        ld[i] = li1[i] + li2[i] -268
                    self.id3 = self.canvas.create_line(ld,fill="red")
                if ch1["active"] and ch2["active"] and StandardView.ButtonFrame.MathBox_var.get() == "-" :
                    ld = li1[:]
                    for i in range(1,len(li1),2): 
                        ld[i] = li1[i] - li2[i] + 268
                    self.id3 = self.canvas.create_line(ld,fill="red")
                log("Scope configmath")
                self.traceList[2] = self.id3; self.mathPointList = ld[:]
            except Exception as message : 
                pass
                print( "configMath",message)
                traceback.print_exc()
        #end configMath
        def shiftScale(self,arg=None):
            value = int(arg[0].get())
            if value == arg[0].lastValue and False : return
            self.canvas.move(arg[0].line,0,value - arg[0].lastValue)
            arg[0].lastValue = value
            StandardView.myValueFrame.configLabels(value,0,arg[1])
            self.canvas.itemconfigure(arg[0].line,fill=colors[ButtonControl.buttonChannel])
            self.canvas.tag_raise(arg[0].line)
            try: 
                self.update()
            except Exception as message : 
                pass
        #end shiftScale
        def shiftScale2(self,arg=None):
            value = int(arg[0].get())
            self.canvas.move(arg[0].line,value - arg[0].lastValue,0)
            arg[0].lastValue = value
            StandardView.myValueFrame.configLabels(value,1,arg[1])
            self.canvas.tag_raise(arg[0].line)
            try: 
                self.update()
            except Exception as message : 
                print ("shiftScale2",message)
        #end shiftScale2
        def setSliderChannel(self,channel):
            try: 
                ButtonControl.buttonChannel = channel
                self.leftScale.config(bg=colors[channel])
                self.rightScale.config(bg=colors[channel])
                StandardView.myValueFrame.labelList[15].config(fg=colors[channel])
                StandardView.myValueFrame.labelList[11].config(fg=colors[channel])
                StandardView.myValueFrame.labelList[13].config(fg=colors[channel])
            except Exception as message : 
                print ("setSlider",Exception,message)
            #print ("SW.setSliderChannel",channel)
        #end setSliderChannel
        def clearAverage(self,event=None):
            self.oldli = [None, None]
            while len(self.persist[1]) > 1 : id = self.persist[1].pop(0); self.canvas.delete(id)
            while len(self.persist[0]) > 1 : id = self.persist[0].pop(0); self.canvas.delete(id)
            self.oldYArray = [None,None]
        #end clearAverage
        def setUpperScale(self,value):
            self.shiftScale2((self.upperScale,0))
        #end setUpperScale
        def clearPersistence(self,event=None):
            while len(self.persist[1]) > 1 : id = self.persist[1].pop(0); self.canvas.delete(id)
            while len(self.persist[0]) > 1 : id = self.persist[0].pop(0); self.canvas.delete(id)
        #end clearPersistence
        def configXY(self,data):
            try: 
                pointArray = numpy.zeros(500,dtype="uint16")
                pointArray[0::2] = data[0]>>7; pointArray[1::2] = data[1][0:250]>>7; pointList = pointArray.tolist()
                #
                #pointList.append((285 - (xs[i])>>7)+self.paintWidth//2); pointList.append(ys[i]>>7)
                self.idXY = self.canvas.create_line(pointList,fill="magenta");
                #print("pointList",pointList)
            except Exception as message : 
                print ("xy",message)
                return
        #end configXY
    # end class displayFrame
    class buttonFrame (Frame):
        def __init__(self,root):
            Frame.__init__(self,root)
            triggerBox1 = Frame(self)
            triggerBox1.pack(side='top',fill="both",expand=1)
            triggerBox1.config(bg=brown,bd=0,relief="flat",pady=0)
            ButtonBox = Frame(triggerBox1)
            ButtonBox.pack(side="top",fill="both",expand=1)
            ButtonBox.config(bg=brown,relief="flat",bd=0)
            self.RunButton = Button(ButtonBox,text='  Run  ')
            self.RunButton.grid(column=0,row=0,sticky="nsew",columnspan=3); self.RunButton.config(command=ButtonControl.setRunButton,bg="green",fg="black",activebackground="green",padx=0)
            self.PauseButton = Button(ButtonBox,text='Pause')
            self.PauseButton.grid(column=0,row=1,sticky="nsew",columnspan=3); self.PauseButton.config(command=ButtonControl.setPause,bg=brown,fg="white",padx=0)
            self.ExitButton = Button(ButtonBox,text='Exit ')
            self.ExitButton.grid(column=0,row=2,sticky="nsew",columnspan=3); self.ExitButton.config(command=shutDown,bg="#550000",fg="white",padx=0)
            self.SpectrumButton = Button(ButtonBox,text='Power Spectrum')
            self.SpectrumButton.grid(column=0,row=3,sticky="ew",columnspan=3); self.SpectrumButton.config(command=ButtonControl.setPowerSpectrum,bg=brown,fg="white",relief="flat",padx=0)
            self.XYButton = Button(ButtonBox,text='  XY Display  '  )
            self.XYButton.grid(column=0,row=4,sticky="ew",columnspan=3); self.XYButton.config(command=self.setXY,bg=brown,fg="white",relief="flat",padx=0)
            self.WideButton = Button(ButtonBox,text='Wide View')
            self.WideButton.grid(column=0,row=5,columnspan=3,sticky="ew"); self.WideButton.config(command=self.setWide,bg=brown,fg="white")
            self.PhotoButton = Button(ButtonBox,text='Photo View')
            self.PhotoButton.grid(column=0,row=6,columnspan=3,sticky="ew"); self.PhotoButton.config(command=self.setPhoto,bg=brown,fg="white")
            TOBox = Frame(ButtonBox)
            TOBox.grid(column=0,row=7,columnspan=3,sticky="nsew")
            TOBox.config(bg="white",relief="flat",bd=1)
            StandardView.TimeoutLabel_var = StringVar()
            StandardView.TimeoutLabel = Label(TOBox,text='sleep timing')
            StandardView.TimeoutLabel.pack(side="top",fill="both",expand=1)
            StandardView.TimeoutLabel.config(borderwidth=1,relief="flat",bg=brown,fg="white")
            HLED = Frame(TOBox)
            HLED.pack(side="top",fill="both",expand=1)
            HLED.config(bg="red")
            HLed0 = Frame(HLED)
            HLed0.pack(side="left",fill="both",expand=1)
            HLed0.config(relief="flat",bd=0,bg="white")
            LT00_var = StringVar()
            LT00 = Label(HLed0,text='control')
            LT00.pack(side="left",fill="both",expand=1)
            LT00.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            StandardView.LED0_var = StringVar()
            StandardView.LED0 = Label(HLed0,text=unichr(0x2798))
            StandardView.LED0.pack(side="left",fill="both"); 
            StandardView.LED0.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed1 = Frame(HLED)
            HLed1.pack(side="left",fill="both",expand=1)
            HLed1.config(relief="flat",bd=0,bg="white")
            LTO1_var = StringVar()
            LTO1 = Label(HLed1,text=' trig ')
            LTO1.pack(side="left",fill="both",expand=1)
            LTO1.config(borderwidth=0,bg=brown,fg="white")
            StandardView.LED1_var = StringVar()
            StandardView.LED1 = Label(HLed1,text=unichr(0x2798))
            StandardView.LED1.pack(side="left",fill="y"); StandardView.LED1.color = "green"
            StandardView.LED1.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed4 = Frame(HLED)
            HLed4.pack(side="left",fill="both",expand=1)
            HLed4.config(relief="flat",bd=0,bg="white")
            LTO4_var = StringVar()
            LTO4 = Label(HLed4,text='chann')
            LTO4.pack(side="left",fill="both",expand=1)
            LTO4.config(borderwidth=0,bg=brown,fg="white")
            StandardView.LED4_var = StringVar()
            StandardView.LED4 = Label(HLed4,text=unichr(0x2798))
            StandardView.LED4.pack(side="left",fill="y"); StandardView.LED4.color = "green"
            StandardView.LED4.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            HLed3 = Frame(HLED)
            HLed3.pack(side="left",fill="both",expand=1)
            HLed3.config(relief="flat",bd=0,bg="white")
            LT02_var = StringVar()
            LT02 = Label(HLed3,text=' params')
            LT02.pack(side="left",fill="both",expand=1)
            LT02.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            StandardView.LED2_var = StringVar()
            StandardView.LED2 = Label(HLed3,text=unichr(0x2798) + " ")
            StandardView.LED2.pack(side="left",fill="y");
            StandardView.LED2.config(borderwidth=0,bg=brown,font=Font(size=13)); 
            dummy_var = StringVar()
            dummy = Label(HLed3,text=' ')
            dummy.pack(fill='y',expand=1)
            dummy.config(relief='flat',borderwidth=0,bg=brown)
            self.MathBox = Frame(ButtonBox)
            self.MathBox.grid(column=0,row=8,columnspan=3,sticky="nsew"); self.MathBox_var = StringVar()
            self.MathBox.config(bg="grey",borderwidth=1,relief="flat",padx=0)
            L_var = StringVar()
            L = Label(self.MathBox,text='Math')
            L.pack(fill="x")
            L.config(relief='groove',borderwidth=0,bg=brown,fg="white",padx=0)
            rb0=Radiobutton(self.MathBox,text='Off',value="Off")
            rb0.config(variable=self.MathBox_var)
            rb0.pack(side="left",fill="x",expand=1)
            rb0.config(bg=brown,selectcolor="#660000",fg="white",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb1=Radiobutton(self.MathBox,text='+',value="+")
            rb1.config(variable=self.MathBox_var)
            rb1.pack(side="left",fill="x",expand=1)
            rb1.config(bg=brown,fg="white",indicatoron=0,width=2,bd=0,selectcolor="orange",highlightthickness=0,padx=0)
            rb2=Radiobutton(self.MathBox,text=unichr(0x2013),value="-")
            rb2.config(variable=self.MathBox_var)
            rb2.pack(side="left",fill="x",expand=1)
            rb2.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb3=Radiobutton(self.MathBox,text='*',value="*")
            rb3.config(variable=self.MathBox_var)
            rb3.pack(side="left",fill="x",expand=1)
            rb3.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb4=Radiobutton(self.MathBox,text='/',value="/")
            rb4.config(variable=self.MathBox_var)
            rb4.pack(side="left",fill="x",expand=1)
            rb4.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            rb5=Radiobutton(self.MathBox,text='\\',value="\\")
            rb5.config(variable=self.MathBox_var)
            rb5.pack(side="left",fill="x",expand=1)
            rb5.config(bg=brown,fg="white",selectcolor="orange",indicatoron=0,width=2,bd=0,highlightthickness=0,padx=0)
            triggerBox2 = Frame(self)
            triggerBox2.pack(side='top',fill="both",expand=1)
            triggerBox2.config(bg=brown,bd=0,relief="solid")
            AverBox = Frame(triggerBox2)
            AverBox.pack(side="top",fill="both",expand=1)
            AverBox.config()
            self.averageScale_var = IntVar()
            self.averageScale = Scale(AverBox,label='Average 100',from_=0, to=8, length=85,orient='horizontal', command=None,variable=self.averageScale_var)
            self.averageScale.pack(side="left",padx=0,ipadx=0,fill="both",expand=1)
            self.averageScale.config(showvalue=0,bg=brown,fg="white",troughcolor=brown,command=self.setAverage)
            self.persistenceScale_var = IntVar()
            self.persistenceScale = Scale(AverBox,label='Persistence 100',from_=0, to=9, length=85,orient='horizontal', command=None,variable=self.persistenceScale_var)
            self.persistenceScale.pack(side="left",fill="both",expand=1)
            self.persistenceScale.config(showvalue=0,bg=brown,fg="white",troughcolor=brown,command=self.setPersistence)
            timeBox = Frame(triggerBox2)
            timeBox.pack(side="top",fill="both",expand=1)
            timeBox.config(bd=1,bg="white")
            self.timeBaseLabel_var = StringVar()
            self.timeBaseLabel=MLabel(timeBox,text= 'Time Base   ')
            self.timeBaseLabel.pack(side="top",fill='both',expand=1)
            self.timeBaseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.timeBaseLabel.command = ButtonControl.scrollTimebase
            Zoom = Frame(timeBox)
            Zoom.pack(side="top",fill="both",expand=1)
            Zoom.config(bg=brown)
            self.ztb_var = StringVar()
            self.ztb = Label(Zoom,text='   Zoom Time Base ')
            self.ztb.pack(fill='both',side="left",expand=1)
            self.ztb.config(relief='groove',borderwidth=0,bg=brown,fg=brown,anchor="e")
            self.zoomLabel_var = StringVar()
            self.zoomLabel=MLabel(Zoom,text='')
            self.zoomLabel.pack(fill='both',side="left",expand=1)
            self.zoomLabel.config(relief='groove',borderwidth=0,bg=brown,anchor="w")
            self.zoomLabel.command = ButtonControl.scrollTimebase
            StandardView.lreso_var = StringVar()
            StandardView.lreso = Label(timeBox,text='sample distance')
            StandardView.lreso.pack(fill='both',expand=1)
            StandardView.lreso.config(borderwidth=0,bg=brown,fg="white")
            triggerBox3 = Frame(self)
            triggerBox3.pack(side='left',fill="both",expand=1)
            triggerBox3.config(bg=brown,bd=0,relief="solid")
            triggerBox2 = Frame(triggerBox3)
            triggerBox2.pack(side="top",fill="both",expand=1)
            triggerBox2.config(bg="white",bd=1)
            triggerTypeBox = Frame(triggerBox2)
            triggerTypeBox.pack(side="top",fill="both",expand=1)
            triggerTypeBox.config(relief="flat",bd=0,bg="grey")
            self.triggerTypeLabel_var = StringVar()
            self.triggerTypeLabel = Label(triggerTypeBox,text='Trigger Type ')
            self.triggerTypeLabel.pack(fill='both',expand=1,side="left")
            self.triggerTypeLabel.config(relief='flat',borderwidth=0,bg=brown,fg="white")
            self.triggerStateLabel_var = StringVar()
            self.triggerStateLabel = Label(triggerTypeBox,text='    ')
            self.triggerStateLabel.pack(fill='both',expand=1,side="left")
            self.triggerStateLabel.config(relief='flat',borderwidth=0,bg=brown,width=8)
            self.triggerSourceLabel_var = StringVar()
            self.triggerSourceLabel = Label(triggerBox2,text='Trigger Source')
            self.triggerSourceLabel.pack(fill='both',expand=1,side="top")
            self.triggerSourceLabel.config(borderwidth=0,bg=brown,fg=colors[0],padx=0)
            self.slopeContainer = Frame(triggerBox2)
            self.slopeContainer.pack(side="top",fill="both",expand=1)
            self.slopeContainer.config(bg = brown)
            self.TriggerSlopeBox = Frame(self.slopeContainer)
            self.TriggerSlopeBox.pack(side="top",fill="both",expand=1)
            self.TriggerSlopeBox.config(bg=brown)
            self.triggerSlopeLabel_var = StringVar()
            self.triggerSlopeLabel = Label(self.TriggerSlopeBox,text='Trigger Slope ')
            self.triggerSlopeLabel.pack(fill='both',expand=1,side="left")
            self.triggerSlopeLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerSlopeValue_var = StringVar()
            self.triggerSlopeValue = Label(self.TriggerSlopeBox,text='')
            self.triggerSlopeValue.pack(fill='both',expand=1,side="left")
            self.triggerSlopeValue.config(relief='groove',borderwidth=0,bg=brown,anchor="w")
            self.TriggerPolarityBox = Frame(self.slopeContainer)
            self.TriggerPolarityBox.pack(side="top",fill="both",expand=1)
            self.TriggerPolarityBox.config(bg=brown)
            self.triggerPolarityLabel_var = StringVar()
            self.triggerPolarityLabel = Label(self.TriggerPolarityBox,text='Polarity ')
            self.triggerPolarityLabel.pack(fill='both',expand=1,side="left")
            self.triggerPolarityLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerPolarityValue_var = StringVar()
            self.triggerPolarityValue = Label(self.TriggerPolarityBox,text='')
            self.triggerPolarityValue.pack(fill='both',expand=1,side="left")
            self.triggerPolarityValue.config(relief='groove',borderwidth=0,bg=brown,fg="white",anchor="w")
            self.StandardBox = Frame(self.slopeContainer)
            self.StandardBox.pack(side="top",fill="both",expand=1)
            self.StandardBox.config(bg=brown)
            self.StandardLabel_var = StringVar()
            self.StandardLabel = Label(self.StandardBox,text='Standard ')
            self.StandardLabel.pack(fill='both',expand=1,side="left")
            self.StandardLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.StandardValue_var = StringVar()
            self.StandardValue = Label(self.StandardBox,text='PAL/NTSC')
            self.StandardValue.pack(fill='both',expand=1,side="left")
            self.StandardValue.config(relief='groove',borderwidth=0,bg=brown,fg="white",anchor="w")
            self.ModeContainer = Frame(triggerBox2)
            self.ModeContainer.pack(side="top",fill="both",expand=1)
            self.ModeContainer.config(bg=brown)
            self.ModeEdgeLabel_var = StringVar()
            self.ModeEdgeLabel = Label(self.ModeContainer,text='Trigger Mode')
            self.ModeEdgeLabel.pack(fill='both',expand=1,side="top")
            self.ModeEdgeLabel.config(borderwidth=0,bg=brown,fg="white")
            self.ModePulseLabel_var = StringVar()
            self.ModePulseLabel = Label(self.ModeContainer,text='Trigger Mode')
            self.ModePulseLabel.pack(fill='both',expand=1,side="top")
            self.ModePulseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.SyncContainer = Frame(self.ModeContainer)
            self.SyncContainer.pack(side="top")
            self.SyncContainer.config(bg=brown)
            self.SyncLabel_var = StringVar()
            self.SyncLabel = Label(self.SyncContainer,text='Sync ')
            self.SyncLabel.pack(fill='both',side="left")
            self.SyncLabel.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.SyncValue_var = StringVar()
            self.SyncValue = Label(self.SyncContainer,text='Line Num')
            self.SyncValue.pack(fill='both',side="left")
            self.SyncValue.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.LineNum_var = StringVar()
            self.LineNum=MLabel(self.SyncContainer,text='  ')
            self.LineNum.pack(fill='both',side="left")
            self.LineNum.config(relief='groove',borderwidth=0,bg=brown,fg="white")
            self.LineNum.command = ButtonControl.scrollLineNum
            self.couplingContainer = Frame(triggerBox2)
            self.couplingContainer.pack(side="top",fill="both",expand=1)
            self.couplingContainer.config(bg=brown)
            self.CouplingEdgeLabel_var = StringVar()
            self.CouplingEdgeLabel = Label(self.couplingContainer,text='Trigger Coupling ')
            self.CouplingEdgeLabel.pack(fill='both',expand=1,side="top")
            self.CouplingEdgeLabel.config(borderwidth=0,bg=brown,fg="white")
            self.CouplingPulseLabel_var = StringVar()
            self.CouplingPulseLabel = Label(self.couplingContainer,text='Trigger Coupling ')
            self.CouplingPulseLabel.pack(fill='both',expand=1,side="top")
            self.CouplingPulseLabel.config(borderwidth=0,bg=brown,fg="white")
            self.WhenContainer = Frame(triggerBox2)
            self.WhenContainer.pack(side="top",fill="both",expand=1)
            self.WhenContainer.config(bg=brown,bd=0)
            self.whenBox = Frame(self.WhenContainer)
            self.whenBox.pack(side="top")
            self.whenBox.config(bg=brown)
            self.whenLabel_var = StringVar()
            self.whenLabel = Label(self.whenBox,text='When')
            self.whenLabel.pack(fill='both',expand=1,side="left")
            self.whenLabel.config(borderwidth=0,bg=brown,fg="white")
            self.SettingValue_var = StringVar()
            self.SettingValue=MLabel(self.whenBox,text='0. 00 ns')
            self.SettingValue.pack(fill='x',side="left")
            self.SettingValue.config(relief='groove',borderwidth=0,bg=brown)
            self.SettingValue.command = ButtonControl.scrollWhen
            HTriggerLevel = Frame(triggerBox2)
            HTriggerLevel.pack(side="top",fill="both",expand=1)
            HTriggerLevel.config(borderwidth=0,relief="flat",bg="grey")
            self.triggerLevelLabel_var = StringVar()
            self.triggerLevelLabel = Label(HTriggerLevel,text='Trigger Level  ')
            self.triggerLevelLabel.pack(fill='both',expand=1,side="left")
            self.triggerLevelLabel.config(borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.triggerValueLabel_var = StringVar()
            self.triggerValueLabel=MLabel(HTriggerLevel,text='')
            self.triggerValueLabel.pack(fill='both',expand=1,side="left")
            self.triggerValueLabel.config(borderwidth=0,bg=brown,anchor="w")
            self.triggerValueLabel.command = ButtonControl.scrollTriggerValue
            triggerPos = Frame(triggerBox2)
            triggerPos.pack(side="top",fill="both",expand=1)
            triggerPos.config(borderwidth=0,relief="flat")
            self.TPosLabel_var = StringVar()
            self.TPosLabel = Label(triggerPos,text='  Trigger Position')
            self.TPosLabel.pack(fill='both',expand=1,side="left")
            self.TPosLabel.config(borderwidth=0,bg=brown,fg="white",justify="right",anchor="e")
            self.TPosValue_var = StringVar()
            self.TPosValue=MLabel(triggerPos,text=None)
            self.TPosValue.pack(fill='both',expand=1,side="left")
            self.TPosValue.config(borderwidth=0,bg=brown,fg="white",justify="left",anchor="w")
            self.TPosValue.command = ButtonControl.scrollTPos
            #self.initDicts()
            self.initBindings()
            self.config(bg="white",relief="solid",borderwidth=0,pady=0)
            self.triggerCouplingValue = 0
            self.MathBox_var.set("Off")
            self.Spectrum = False
            self.showParameters = False
            StandardView.LedList = [StandardView.LED0,StandardView.LED1,StandardView.LED2,StandardView.LED4]
            #self.channelCoupling.invoke()
            self.TriggerPolarityBox.pack_forget()
            self.lastTriggerType = ""
            self.Zoom = False
            self.XY = False
            self.ModeEdgeLabel.bind("<Button-1>",Control.changeTriggerMode), self.ModePulseLabel.bind("<Button-1>",Control.changeTriggerMode)
        # end init buttonFrame
        def initBindings(self):
            self.whenLabel.bind("<Button-1>",ButtonControl.changeWhen)
            self.triggerPolarityLabel.bind("<Button-1>",ButtonControl.changePolarity)
            self.RunButton.bind("<Button-3>",ButtonControl.setRunButton)
            self.triggerSourceLabel.bind("<Button-1>",ButtonControl.changeTriggerSource)
            self.CouplingPulseLabel.bind("<Button-1>",ButtonControl.changeTriggerCoupling)
            self.CouplingEdgeLabel.bind("<Button-1>",ButtonControl.changeTriggerCoupling)
            self.ModePulseLabel.bind("<Button-1>",Control.changeTriggerMode)
            self.ModeEdgeLabel.bind("<Button-1>",Control.changeTriggerMode)
            self.triggerSlopeValue.bind("<Button-1>",ButtonControl.changeTriggerSlope)
            self.triggerSlopeLabel.bind("<Button-1>",ButtonControl.changeTriggerSlope)
            self.triggerTypeValue = 0
            self.triggerTypeLabel.bind("<Button-1>",ButtonControl.changeTriggerType)
            #self.triggerValueLabel.bind("<Button-1>",ButtonControl.trig50)
            self.triggerLevelLabel.bind("<Button-1>",ButtonControl.trig50)
            self.StandardLabel.bind("<Button-1>",ButtonControl.changeStandard)
            self.StandardValue.bind("<Button-1>",ButtonControl.changeStandard)
            self.SyncLabel.bind("<Button-1>",ButtonControl.changeSync)
            self.SyncValue.bind("<Button-1>",ButtonControl.changeSync)
            self.triggerType = ""
            self.LineNum.bind("<Button-1>",ButtonControl.changeCoarse)
            #self.LineNum.bind("<Button-4>",ButtonControl.turnUp); self.LineNum.bind("<Button-5>",ButtonControl.turnDown)
            self.SettingValue.bind("<Button-1>",ButtonControl.changeCoarse)
            #self.SettingValue.bind("<Button-4>",ButtonControl.turnUp); self.SettingValue.bind("<Button-5>",ButtonControl.turnDown)
            self.averageScale.bind("<Button-3>",StandardView.display.clearAverage)
            self.persistenceScale.bind("<Button-3>",StandardView.display.clearPersistence)
        #end initBindings
        def setPersistence(self,arg=None):
            persistence = 2**self.persistenceScale.get()
            # choice
            if persistence == 0 : self.persistenceScale.config(label="Persist. off")
            else: self.persistenceScale.config(label="Persist. "+str(persistence))
            # end choice
        #end setPersistence
        def setAverage(self,arg=None):
            v = self.averageScale.get()
            # choice
            if v == 0 :  
                self.averageScale.config(label="Average off")
            else:  
                self.averageScale.config(label="Average "+str(2**v))
            # end choice
        #end setAverage
        def setXY(self):
            # choice
            if self.XY == False : self.XY = True; self.XYButton.config(bg="orange",fg="black"); 
            else: self.XY = False; self.XYButton.config(bg=brown,fg="white");
            # end choice
        #end setXY
        def setWide(self,event=None):
            # choice
            if WideView.ButtonFrame.zoomed :  
                Control.changeView("Z")
            else:  
                Control.changeView("W")
            # end choice
        #end setWide
        def setPhoto(self,event=None):
            Control.changeView("P")
        #end setPhoto
    # end class buttonFrame
    def __init__(self,root):
        Frame.__init__(self,root)
        global StandardView; StandardView = self
        self.name = "StandardView"
        self.geometry = "800x750+%s+%s" % (windowX,windowY)
        try: 
            self.initEarlyValues()
        except Exception as message : 
            print ("early",message)
        self.compress = 0.5; self.burstFrequency = 0; self.stretch = 20
        self.myChannelsFrame = Control.channelsFrame(self); self.myChannelsFrame.grid(column=1,row=2,sticky = "ns",rowspan=2,columnspan=4); 
        self.myValueFrame=Control.valueFrame(self); self.myValueFrame.grid(column=5,row=2,columnspan=2,rowspan=2,sticky="news");
        self.display = self.displayFrame(self);
        self.display.grid(column=1,row=1,columnspan=4,sticky="news")
        self.ButtonFrame = self.buttonFrame(self); 
        self.ButtonFrame.grid(column=5,row=1,columnspan=1,rowspan=1,sticky="news")
        self.leftBorder = Label(self); self.leftBorder.config(bg=brown,width=0);
        self.rightBorder = Label(self); self.rightBorder.config(bg=brown,width=0);
        #self.leftBorder.grid(column=0,row=0,rowspan=4,sticky="ns")
        #self.rightBorder.grid(column=7,row=0,rowspan=4,sticky="news")
        self.initLateValues()
    # end init standardView
    def initEarlyValues(self):
        #print "scope early"
        self.config(bg=brown,width=screenWidth) 
        self.showSingleParameter = [True,True]
        self.showRepeatedParameter = [0,0]
        self.active = 0
    #end initEarlyValues
    def initLateValues(self):
        self.myValueFrame.setChannelButton()
        pass
    #end initLateValues
# end class standardView
class photoView (Frame):
    def __init__(self,root):
        Frame.__init__(self,root)
        self.geometry = "1280x606+%s+%s" % (windowX,windowY); self.config(bg="black",bd=0)
        self.indexDict = {}; buttonBackground = "#202020"; self.buttonBackground = buttonBackground; buttonForeground = "white"
        self.canvas = Canvas(self,width=1280,height=606,bg="black"); self.canvas.pack(fill="both"); self.canvas.config(bd=0)
        self.Skin = PhotoImage(file="U_1280.ppm") 
        self.Skin.write("pause.ppm",format="PPM",from_coords=(348,276,404,307))
        self.canvas.create_image(0,0,image=self.Skin,anchor="nw")
        self.IV = PhotoImage(width=50,height=40); self.IV.blank()
        self.PIPausey = PhotoImage(); self.PIPausey.config(file="pause.ppm")
        self.dumpCanvas = Canvas(self.canvas,width=640,height=480,background="black",borderwidth=0); self.dumpCanvas.place(x=10,y=50)
        self.createIVButton(692,146,BTN_F1)  # ..........................
        self.createIVButton(690,207,BTN_F2)
        self.createIVButton(692,271,BTN_F3)
        self.createIVButton(691,334,BTN_F4)
        self.createIVButton(693,399,BTN_F5)
        self.createIVButton(784,66,BTN_SELECT)
        self.createIVButton(783,131,BTN_COARSE)
        self.createIVButton(781,228,BTN_CH1)
        self.createIVButton(784,290,BTN_CH2)
        self.createIVButton(780,351,BTN_MATH)
        self.createIVButton(781,415,BTN_REF)
        self.createIVButton(868,94,UNI_PLUS,UNI_MINUS)
        self.createIVButton(906,242,VERT_UP,VERT_DN)
        self.createIVButton(898,306,BTN_OFF)
        self.createIVButton(898,387,VOLTS_UP,VOLTS_DN)
        self.createIVButton(948,65,BTN_MEAS)
        self.createIVButton(946,133,BTN_CURSOR)
        self.createIVButton(968,305,SET_TO_0)
        self.createIVButton(1022,66,BTN_ACQU)
        self.createIVButton(1024,129,BTN_DISPLAY)
        self.createIVButton(1045,235,HORIZ_UP,HORIZ_DN)
        self.createIVButton(1037,305,BTN_MENU)
        self.createIVButton(1042,396,SEC_DIV_UP,SEC_DIV_DN)
        self.createIVButton(1100,67,BTN_STOR)
        self.createIVButton(1096,132,BTN_UTILITY)
        self.createIVButton(1181,72,BTN_RUN_STOP)
        self.createIVButton(1182,131,BTN_AUTO)
        self.createIVButton(1185,236,TRIG_UP,TRIG_DN)
        self.createIVButton(1181,299,MENU_TRIG,)
        self.createIVButton(1184,348,SET_TO_50)
        self.createIVButton(1184,392,FORCE_TRIG)
        self.createIVButton(1186,440,BTN_HELP)
        id = self.createIVButton(796,517,command=self.changeViewW); self.ViewW = id
        id = self.createIVButton(910,520,command=self.changeViewN);  self.ViewN = id
        id = self.createIVButton( 1070,520,command=ButtonControl.setPause); self.IVPause = id
        id = self.createIVButton(1180,520,command=shutDown)
        #self.lastMap = None
        self.name = "PhotoView"
        self.idPauseY = self.canvas.create_image(1074,525,image=self.PIPausey,state="hidden")
        self.canvas.tag_bind(self.IVPause,"<Button-1>",self.send); self.canvas.tag_bind(self.idPauseY,"<Button-1>",self.send)
        self.indexDict[self.IVPause] = (None,None,ButtonControl.setPause)
        self.indexDict[self.idPauseY] = (None,None,ButtonControl.setPause)
    # end init photoView
    def createIVButton(self,x,y,But1=None,But3=None,command=None):
        id = self.canvas.create_image(x,y,image=self.IV,anchor="nw")
        self.canvas.tag_bind(id,"<Button-1>",self.send); self.canvas.tag_bind(id,"<Button-3>",self.send)
        self.indexDict[id] = (But1,But3,command)
        return id
    #end createIVButton
    def send(self,event):
        ix = self.canvas.find_closest(event.x,event.y)[0]
        b = event.num
        try: 
            vl1,vl2,command = self.indexDict[ix]; 
            if not ButtonControl .Pause and not ix == self.ViewW and not ix == self.ViewN and not ix == self.IVPause :
                ButtonControl.setPause()
            # choice
            if command != None :  
                command()
            elif b == 1 :  
                USBQ.put(("sendControlMessage",(0x42,0xb1,None,vl1)))
            elif vl2 != None :  
                USBQ.put(("sendControlMessage",(0x42,0xb1,None,vl2)))
            # end choice
            USBQ.put("DUMP3")
        except Exception as message : 
            print("send",Exception,message)
    #end send
    def changeViewW(self,event=None):
        Control.changeView("W")
    #end changeViewW
    def changeViewN(self,event=None):
        Control.changeView("S")
    #end changeViewN
    def refreshChannels(self,pixmap,channel=0,arg3=None):
        try: 
            self.pixmap = pixmap
            memfile = extractSubpicture(self.pixmap,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,colorListIndex=1)
            self.PIALL =PhotoImage(); self.PIALL.config(data=memfile); self.PIALL = self.PIALL.zoom(2);self.dumpCanvas.create_image(0,0,image=self.PIALL,anchor=NW)
        except Exception as message : 
            print ("refreshChannels",message)
    #end refreshChannels
    def refreshTriggerPixmap(self,pixmap):
        try: 
            self.pixmap = pixmap
            memfile = extractSubpicture(self.pixmap,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,colorListIndex=1)
            self.PIALL =PhotoImage(); self.PIALL.config(data=memfile); self.PIALL = self.PIALL.zoom(2);self.dumpCanvas.create_image(0,0,image=self.PIALL,anchor=NW)
        except Exception as message : 
            print ("refreshTriggerPixmap",message)
    #end refreshTriggerPixmap
    def printXY(self,event):
        print (event.x,event.y)
    #end printXY
    def setLed(self,nr,color):
        pass
    #end setLed
# end class photoView
class USB (object):
    def __init__(self,USBQ,ConrolQ,DiagQ,PID,BUS,DEV):
        self.ConrolQ = ConrolQ; self.Pause = False; self.Stop = False; self.SHORT = False
        self.DiagQ = DiagQ; self.USBQ = USBQ
        self.device_setup(PID,BUS,DEV)
        if not self.device : self.ConrolQ.put("TERMINATE"); return
        self.device_init()
        global logging; logging = False
        self.lastChannel = -1; refreshCounter = -1;self.parmlist = ["OFF","OFF"]
        self.activeChannels = [True,True]; t = time()
        self.timeoutFactors = [50,50,50]; self.triggerType = ""
        self.t = time()
        self.lastStamp = 0.0
        self.triggerTypeDict = {
        b"1111f111" : "Video",
        b"11f11111" : "Pulse" ,
        b"111f1111" : "Edge"
        }
        self.currentView = "S"
        self.scanLoop()
    # end init USB
    def device_setup(self,PID,BUS,DEV):
        try: 
            f=open("PID.txt","r")
            pidr = f.readline()
        except Exception as message : 
            #print( "error opening VIDPID.txt",message)
            pidr = None
        # choice
        if BUS != None and DEV != None :  
            self.device = usb.core.find(idVendor=0x5656,bus=int(BUS),address=int(DEV))
        elif PID != None :  
            self.device = usb.core.find(idVendor=0x5656,idProduct = int(PID,16))
        elif pidr != None :  
            self.device = usb.core.find(idVendor=0x5656,idProduct = int(pidr,16))
        else:  
            self.device = usb.core.find(idVendor=0x5656)
        # end choice
        if not self.device :
            print( "no DSO device found, check your cables")
            self.shutDown();return
        self.setProtection()
        try: 
            self.device.set_configuration()
        except Exception as message : 
            print ("device_setup",message)
            self.shutDown();return
        self.ConrolQ.put(("FOUND",self.device.idProduct)); self.idProduct = self.device.idProduct
    #end device_setup
    def setProtection(self):
        if sys.platform.startswith("win") : return
        # set protection of dso  ....
        dn = self.device.bus; fn = self.device.address
        string = "/dev/bus/usb/%03i/%03i" % (dn,fn)
        prot = os.stat(string).st_mode
        if prot & 2 : return
        s = "sudo chmod a+rw " + string
        print( "I want to set protection with ",s)
        system(s)
    #end setProtection
    def device_init(self):
        response= self.device.ctrl_transfer(0xc2,0xb2,wIndex=4,wValue=0x08,timeout=300,data_or_wLength=8); sleep(0.02)
        self.device.ctrl_transfer(0x42,0xb1,0x2c,0,None); sleep(0.02)
        self.device.ctrl_transfer(0x42,0xb1,0xdc,0,None); sleep(0.02)
        self.device.ctrl_transfer(0x42,0xb1,0xcc,0,None); sleep(0.02)
        ConrolQ.put(("RESPONSE",response));# print ("response",response)
    #end device_init
    def scanLoop(self):
        refreshCounter = -1; tcycle = time() - 3.0
        while True : 
            terminate = self.processUSBQ()
            if terminate : return
            # choice
            if self.Pause :  
                refreshCounter = -2
                sleep(0.1); continue
            else:  
                refreshCounter +=1; refreshCounter = refreshCounter % 16; self.refreshCounter = refreshCounter
                log("USB refreshCounter %2i\n" % refreshCounter)
                if refreshCounter== 0 :
                    cycleTime = time()-tcycle; #print( "cycle time %5.3f" % cycleTime );
                    log("USB refreshCounter %2i cycle time %5.3f\n" % (refreshCounter,cycleTime))
                    tcycle = time()
                    self.ConrolQ.put(("CYCLE",cycleTime))
            # end choice
            if self.Stop :
                sleep(0.2); continue
            if refreshCounter == 0 :
                self.processTriggerPixmap()
            if not self.Pause and ((refreshCounter == 3 and self.parmlist[0] != "OFF" ) or self.parmlist[0] == "FASTREPEAT" or self.parmlist[0] == "SINGLE") :
                status,params = self.getParameters(0)
                # choice
                if status == 0 and self.parmlist[0] != "OFF" :  
                    if self.parmlist[0] == "SINGLE" : self.parmlist[0] = "OFF"
                    self.ConrolQ.put(("PARAMS",params,0))
                    self.ConrolQ.put(("LED",2,"GREEN",1))
                elif status != 0 :  
                    self.ConrolQ.put(("LED",2,"RED",1))
                # end choice
            if (refreshCounter == 6 and self.parmlist[1] != "OFF" ) or self.parmlist[1] == "FASTREPEAT" or self.parmlist[1] == "SINGLE" :
                status,params = self.getParameters(1)
                # choice
                if status ==   0 and self.parmlist[1] != "OFF" :  
                    if self.parmlist[1] == "SINGLE" : self.parmlist[1] = "OFF"
                    self.ConrolQ.put(("PARAMS",params,1))
                    self.ConrolQ.put(("LED",2,"GREEN",2))
                else:  
                    self.ConrolQ.put(("LED",2,"RED",2))
                # end choice
            if (refreshCounter == 9 and self.activeChannels[0]) :
                self.processChannelPixmap(0,"loop channel 0 @ %3.3f" % (time()-startTime))
            if refreshCounter == 12 and self.activeChannels[1] :
                self.processChannelPixmap(1,"loop channel 1 @ %3.3f" % (time()-startTime))
            # choice
            if self.currentView == "P" :  
                # choice
                if refreshCounter < 4 :  
                    self.processTriggerPixmap()
                elif refreshCounter < 10 :  
                    self.processChannelPixmap(0)
                else:  
                    self.processChannelPixmap(1)
                # end choice
            elif not self.Pause and self.currentView == "W" :  
                status,data = self.getLongSamples()
                startData = time()
                # choice
                if status == 0 :  
                    stamp = time(); cycl = stamp - self.lastStamp; self.lastStamp = stamp
                    self.ConrolQ.put(("SAMPLES",data,stamp))
                    self.ConrolQ.put(("LED",0,"GREEN"))
                else:  
                    self.ConrolQ.put(("LED",0,"RED"))
                # end choice
                log("USB put SAMPLES start %5.3f" % (startData -startTime))
                sleep(0.02)
            elif not self.Pause and self.currentView == "S" :  
                status,data = self.getShortSamples()
                startData = time()
                # choice
                if status == 0 :  
                    stamp = time(); cycl = stamp - self.lastStamp; self.lastStamp = stamp
                    self.ConrolQ.put(("SAMPLES",data,stamp))
                    self.ConrolQ.put(("LED",0,"GREEN"))
                else:  
                    self.ConrolQ.put(("LED",0,"RED"))
                # end choice
                log("USB put SAMPLES start %5.3f" % (startData -startTime))
                sleep(0.02)
            elif not self.Pause and self.currentView == "Z" :  
                status,data = self.getShortSamples()
                # choice
                if status == 0 :  
                    stamp = time(); cycl = stamp - self.lastStamp; self.lastStamp = stamp
                    self.ConrolQ.put(("SAMPLES",data,stamp))
                    self.ConrolQ.put(("LED",0,"GREEN"))
                else:  
                    self.ConrolQ.put(("LED",0,"RED"))
                # end choice
                status,data = self.getLongSamples()
                # choice
                if status == 0 :  
                    stamp = time(); cycl = stamp - self.lastStamp; self.lastStamp = stamp
                    self.ConrolQ.put(("SAMPLES",data,stamp))
                    self.ConrolQ.put(("LED",0,"GREEN"))
                else:  
                    self.ConrolQ.put(("LED",0,"RED"))
                # end choice
                sleep(0.02)
            # end choice
            t=time()
            while self.ConrolQ.qsize() > 2 : 
                terminate = self.processUSBQ()
                sleep(0.05); #print( "USB sleeping",self.ConrolQ.qsize())
                if terminate : return
            #print( "waked")
            #print( "USB idle            %5.3f" % (time() - t),self.ConrolQ.qsize())
            log("USB refreshLoop end")
    #end scanLoop
    def processUSBQ(self):
        try: 
            msg = self.USBQ.get_nowait(); #print (msg); 
            # choice
            if msg == "TERMINATE" :  
                self.device_close()
                return True;  
            elif msg == "ReqTriggMap" :  
                self.processTriggerPixmap()
            elif msg[0] == "sendControlMessage" : self.sendControlMessage(msg)
            elif msg[0] == "sendControlMessage2" : self.sendControlMessage2(msg)
            elif msg[0] == "CTL4" : self.CTL4(msg)
            elif msg[0] == "BULK" :  
                t = time(); #print( "BULK",msg)
                #sleep(0.02); self.remote_on(); sleep(0.05)
                parms = msg[1]; #print( "parms",parms)
                try: 
                    data = self.device.read(parms[0],parms[1],parms[2]); print( "get bulkdata: bulk read len data",len(data))
                    self.DiagQ.put(("BULK",data))
                except Exception as message : 
                    self.DiagQ.put(("BULK",None))
                    print( "bulk",message)
                #self.remote_off()
                #print( "USB %s %1.2f" % (msg,time()-t))
            elif msg[0] == "PARAMS" :  
                self.parmlist[msg[1]] = msg[2]
            elif msg[0] == "SPECPARAMS" :  
                pass #print("should not happen",msg)
            elif msg[0] == "ReqChannelMap" : # request channel map
                self.processChannelPixmap(msg[1])
            elif msg == "DUMP" : # request screen dump
                print( "USB DUMP",msg)
                status,parameters = self.getScreenDump()
                ConrolQ.put(("DUMP",parameters))
            elif msg == "DUMP2" : # request screen dump
                status,parameters = self.getScreenDump()
                ConrolQ.put(("DUMP2",parameters))
            elif msg == "DUMP3" : # request screen dump
                status,parameters = self.getScreenDump()
                ConrolQ.put(("DUMP3",parameters))
            elif msg[0] == "CHON" : # set channel on
                #print( "USB CHON",msg)
                self.activeChannels[msg[1]] = True
            elif msg[0] == "CHOFF" : # set channel off
                #print( "USB CHOFF",msg)
                self.activeChannels[msg[1]] = False
            elif msg[0] == "PAUSE" : self.Pause = msg[1]; #print( "USB Pause",msg[1])
            elif msg[0] == "STOP" :  
                if msg[0] != self.Stop :
                    pass ; #print( "USB Stop",msg[1])
                self.Stop = msg[1]
            elif msg[0] == "LOG" : global logging; logging=msg[1]; print( "USB log",logging)
            elif msg[0] == "MODE" :  
                self.Mode = msg[1]
            elif msg[0] == "TIMEOUT" : self.timeoutFactors[msg[1]] = msg[2] ; #print( self.timeoutFactors)
            elif msg[0] == "TR_TYPE" :  
                print("should not happen",msg)
            elif msg == "SINGLE" :  
                self.processSingle()
            elif msg[0] == "SHORT" :  
                self.SHORT = msg[1]
            elif msg[0] == "VIEW" :  
                self.currentView = msg[1]
            else:  
                print( "USB unhandeled msg",msg)
            # end choice
        except Queue.Empty as message : 
            pass
        except Exception as message : 
            print( "USB",Exception,message)
            traceback.print_exc()
        return False
    #end processUSBQ
    def remote_off(self):
        try: 
            status = self.controlMsg(0x42,0xb1,None,value=0xf1)
        except Exception as message : 
            print( "error remote off",message)
            status = -1
        return status
    #end remote_off
    def remote_on(self):
        try: 
            status = self.controlMsg(0x42,0xb1,None,value=0xf0)
        except Exception as message : 
            print( "error remote on",message)
            status = -1
            self.shutDown()
        return status
    #end remote_on
    def getLongSamples_old(self):
        #print( "getLongSamples",self.refreshCounter)
        #print( "gLD %5.3f" % (time() - self.t)); self.t = time()
        t = time(); data= None; status = 0; timeout = 500; 
        log("USB getLongSamples start")
        try: 
            t = time()
            factor = float(self.timeoutFactors[1]) * 0.001 
            self.controlMsg(0x42,0xb1,None,index=0,value=0xe0); #sleep(factor)
            # original: self.controlMsg(0x42,0xb0,None,index=2,value=0x01);  sleep(0.005*factor)
            self.controlMsg(0x42,0xb0,None,index=2,value=0);  sleep(0.005*factor)
            data = self.device.read(130,26112,timeout=timeout);  sleep(factor); #print( "get long data: bulk read len data",len(data));
            #print( "data bulk time %6.4f" % (time()-t),"len",len(data))
        except USBError as message : 
            # choice
            if "Connection timed out" in str(message) :  
                print( "getLongSamples",repr(message))
                data = None; status = -1; 
            else:  
                data = None; status = -1
                print( "getLongSamples bulk",message)
            # end choice
        except Exception as message : 
            print( "getLongSamples",time()-t,"data",data,message)
            data = None; status = -1
        finally: 
            try: 
                self.controlMsg(0x42,0xb0,None,index=0,value=0xdc); #sleep(0.09)
                #self.remote_off(); #sleep(0.09)
                pass
            except Exception as message : 
                pass # print( "getLongSamples finally",message)
                #self.shutDown()
        if logging : print ("USB getLongSamples   end %1.3f" % (time()-t))
        return status ,data
    #end getLongSamples_old
    def getLongSamples(self):
        #print( "getLongSamples",self.refreshCounter)
        #print( "gLD %5.3f" % (time() - self.t)); self.t = time()
        t = time(); data= None; status = 0; timeout = 500; 
        log("USB getLongSamples start")
        try: 
            t = time()
            factor = float(self.timeoutFactors[1]) * 0.001 
            #self.controlMsg(0x42,0xb1,None,index=0,value=0x2c); #sleep(factor)
            #self.controlMsg(0x42,0xb1,None,index=0,value=0xcc);  sleep(0.005*factor)
            self.controlMsg(0x42,0xb1,None,index=0,value=0xe0);  sleep(0.005*factor)
            self.controlMsg(0x42,0xb0,None,index=0x19,value=0);  sleep(0.005*factor)
            data = self.device.read(130,26112,timeout=timeout);  sleep(factor); #print( "get long data: bulk read len data",len(data));
            #print( "data bulk time %6.4f" % (time()-t),"len",len(data))
        except USBError as message : 
            # choice
            if "Connection timed out" in str(message) :  
                print( "getLongSamples",repr(message))
                data = None; status = -1; 
            else:  
                data = None; status = -1
                print( "getLongSamples bulk",message)
            # end choice
        except Exception as message : 
            print( "getLongSamples",time()-t,"data",data,message)
            data = None; status = -1
        finally: 
            try: 
                self.controlMsg(0x42,0xb0,None,index=0,value=0xdc); #sleep(0.09)
                #self.remote_off(); #sleep(0.09)
                pass
            except Exception as message : 
                pass # print( "getLongSamples finally",message)
                #self.shutDown()
        if logging : print ("USB getLongSamples   end %1.3f" % (time()-t))
        return status ,data
    #end getLongSamples
    def getShortSamples(self):
        #print( "getShortSamples",self.refreshCounter)
        #print( "gLD %5.3f" % (time() - self.t)); self.t = time()
        t = time(); data= None; status = 0; timeout = 500; 
        log("USB getShortSamples start")
        try: 
            t = time()
            factor = float(self.timeoutFactors[1]) * 0.001 
            self.controlMsg(0x42,0xb1,None,index=0,value=0xe1); sleep(factor*0.3)
            # original: self.controlMsg(0x42,0xb0,None,index=2,value=0x01);  sleep(0.005*factor)
            self.controlMsg(0x42,0xb0,None,index=2,value=1);  sleep(0.005*factor)
            data = self.device.read(130,1024,timeout=timeout);  sleep(factor); #print( "get short data: bulk read len data",len(data));
            #print( "data bulk time %6.4f" % (time()-t),"len",len(data))
        except USBError as message : 
            # choice
            if "timed out" in str(message) :  
                print( "getShortSamples",repr(message))
                data = None; status = -1; 
            else:  
                data = None; status = -1
                print( "getShortSamples bulk",message)
            # end choice
        except Exception as message : 
            print( "getShortSamples",time()-t,"data",data,message)
            data = None; status = -1
        finally: 
            try: 
                self.controlMsg(0x42,0xb0,None,index=0,value=0xdc); #sleep(0.09)
                #self.remote_off(); #sleep(0.09)
                pass
            except Exception as message : 
                pass # print( "getShortSamples finally",message)
                #self.shutDown()
        if logging : print ("USB getLongSamples   end %1.3f" % (time()-t))
        return status ,data
    #end getShortSamples
    def getParameters(self,channel):
        #print( "USB.getParameters ",channel)
        parameters = None; status = 0; t = time()
        factor = float(self.timeoutFactors[2]) * 0.03
        #self.remote_on(); sleep(0.02)
        try: 
            channelCode = (7,9)[channel]
            self.controlMsg(0x42,0xb1,None,value=channelCode);   sleep(0.01*factor) # channel
            #self.controlMsg(0x42,0xb0,None,index=0,value=0xdc); #sleep(0.02)
            #self.controlMsg(0x42,0xb1,None,index=0,value=0x2c); t2 = time(); sleep(0.01)
            #self.controlMsg(0x42,0xb1,None,index=0,value=0xcc); t2 = time(); sleep(0.01)
            self.controlMsg(0x42,0xb1,None,index=0,value=0xe3) ; #t3 = time(); sleep(0.01) # ch1
            #self.controlMsg(0x42,0xb0,None,index=0x26); t4 = time(); sleep(0.01)
            t = time()
            parameters = self.device.read(0x82,512,timeout=500); #t5 = time(); sleep(0.01) #print( "\n2\n",parameters2)
        except USBError as message : 
            # choice
            if str(message) == "Connection timed out" :  
                print( "getParameters USBError",message)
            else:  
                raise
            # end choice
        except Exception as message : 
            print( "getParameters",message)
            #StandardView.parameterTimeoutCounter += 1
        self.controlMsg(0x42,0xb0,None,index=0,value=0xdc); #sleep(0.02)
        #self.remote_off(); sleep(0.09)
        #print ("getParameters %1.4f channel %i" % (time() - t,channel))
        return (status,parameters)
    #end getParameters
    def processTriggerPixmap(self):
        status = -1 #print("USB processTriggerPixmap start")
        if True :
            #print( "ReqTriggMap")
            try: 
                status,pixmap1 = self.getTriggerPixmap(False)
                signature = getSignature(pixmap1,row = 42,firstColumn=279,lastColumn=285)
                try: 
                    #print( "triggerType",signature,"\n",self.triggerTypeDict)
                    self.triggerType = self.triggerTypeDict[signature]
                    #print( self.triggerType)
                except Exception as message : 
                    #print( "triggerType ?",message,signature)
                    memfile = extractSubpicture(parameter,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename="triggerTypeError.ppm")
                    self.triggerType = "?"
                #print( triggerType)
            except Exception as message : 
                pass #print( "USB triggerType not found",message)
                #USBQ.put("ReqTriggMap")
            if self.triggerType == "Pulse" :
                status,pixmap2 = self.getTriggerPixmap(True)
            # choice
            if status == 0 :  
                self.ConrolQ.put(("TRIGMAP",pixmap1))
                if self.triggerType == "Pulse" :
                    self.ConrolQ.put(("TRIGMAP",pixmap2))
                self.ConrolQ.put(("LED",1,"GREEN"))
            else:  
                self.ConrolQ.put(("LED",1,"RED"))
            # end choice
        log("USB processTriggerPixmap end")
    #end processTriggerPixmap
    def getTriggerPixmap(self,next):
        #print ("getTriggerPixmap")
        pixmapBufferSize = 38912
        t = time()
        status = -1; pixmap = None; timeoutvalue = 500
        factor = 0.01 * self.timeoutFactors[1] #print( "getTriggerPixmap factor",factor)
        try: 
            #self.remote_on(); #sleep(0.07*factor)
            self.controlMsg(0x42,0xb1,None,value=0x2E);   sleep(0.05*factor) # trigger Menue
            if next :
                self.controlMsg(0x42,0xb1,None,value=0x05);   sleep(0.05*factor) # prev -> next
            return self.getScreenDump()
        except USBError as message : 
            print( "getTriggerPixmap USBError",message)
            return -1,None
        except Exception as message : 
            print( "getTriggerPixmap",message)
    #end getTriggerPixmap
    def processChannelPixmap(self,nr,req=None):
        t = time()
        #print ("USB processChannelPixmap time %3.3f channel %i req %s" % (time()-startTime,nr,req))
        status,pixmap = self.getChannelPixmap(nr)
        # choice
        if status == 0 :  
            self.ConrolQ.put(("CHANNELMAP",pixmap,nr,req))
            self.ConrolQ.put(("LED",3,"GREEN"))
        else:  
            self.ConrolQ.put(("LED",3,"RED"))
            print ("USB processChannelPixmap status",status)
        # end choice
        #print( "USB processChannelPixmap  %3.3f took %4.2f %s" % (time()-startTime,time()-t,req))
        #sleep(0.1)
    #end processChannelPixmap
    def getChannelPixmap(self,channel):
        t = time()
        #print ("getChannelPixmap",channel)
        log("USB getChannelPixmap start")
        try: 
            status = 0; parameters = None; timeoutvalue = 500
            factor = 0.001 *float(self.timeoutFactors[1]) #print( "getChannelPixmap factor",factor)
            channelCode = (7,9)[channel]
            self.controlMsg(0x42,0xb1,None,value=channelCode);   sleep(factor) # channel#
            return self.getScreenDump()
        except USBError as message : 
            print( "getChannelPixmap USBError",message)
            return -1,None
    #end getChannelPixmap
    def getScreenDump(self):
        status = 0; parameters = None; timeoutvalue = 500
        factor = float(self.timeoutFactors[1]) * 0.001; #print( "getScreenDump factor",factor)
        try: 
            # choice
            if self.idProduct== 0x0834 : # UT2202CE
                #self.controlMsg(0x42,0xb1,None,value=0x2C);   sleep(0.05*factor) # 
                #self.controlMsg(0x42,0xb1,None,value=0xcc);   sleep(0.5*factor) # 
                self.controlMsg(0x42,0xb1,None,index=0,value=0xe2); sleep(0.05*factor) # ! critical wait
                self.controlMsg(0x42,0xb0,None,index=0x26,value=0x00); sleep(0.02*factor)
            else: #OTHER
                #self.controlMsg(0x42,0xb1,None,value=0xcc);   sleep(0.5*factor) # 
                #self.controlMsg(0x42,0xb1,None,value=0x2C);   sleep(0.05*factor) # 
                self.controlMsg(0x42,0xb1,None,index=0,value=0xe2); sleep(0.05*factor) # ! critical wait
                self.controlMsg(0x42,0xb0,None,index=2,value=0x26); sleep(0.02)
            # end choice
        except USBError as message : 
            print( "getScreenDump USBError",message)
        except Exception as message : 
            print( "getScreenDump",message)
        try: 
            t = time()
            parameters = self.device.read(130,pixmapBufferSize,timeout=timeoutvalue)
            dt = time() - t; #print( "dt",dt)
            # choice
            if dt > timeoutvalue :  
                if True : print( "getScreenDump Timeout",asctime())
                status = -1
            elif len(parameters) != 38912 and len(parameters) != 38400 :  
                if True  : print( "getScreenDump len error " ,len(parameters))
                status = -2; parameters = None
            else: status = 0
            # end choice
        except USBError  as message : 
            # choice
            if str(message) == "Connection timed out" :  
                print( "getScreenDump",message)
            else:  
                print( "getScreenDump",message)
                #self.shutDown()
            # end choice
        except Exception as message : 
            self.ConrolQ.put(("LED",1,"red"))
            print( "getScreenDump",message)
            status = -3
        #self.remote_off();# sleep(0.09*factor)
        #print( "getScreenDump took %4.2f" % (time()-t))
        #self.ConrolQ.put(("DUMP",parameters))
        return status,parameters
    #end getScreenDump
    def processSingle(self):
        #print( "processSingle")
        self.sendControlMessage(("sendControlMessage",RUN))
        sleep(0.01)
        status,pixmap = self.getTriggerPixmap(False); #print ("status triggmap",status)
        if status == 0 :
            self.ConrolQ.put(("TRIGMAP",pixmap))
        sleep(0.1)
        status,data = self.getLongSamples(); #print ("status data",status)
        if status == 0 :
            self.ConrolQ.put(("SAMPLES",data,time()))
    #end processSingle
    def sendControlMessage(self,msg):
        factor =1 # 0.1 *float(self.timeoutFactors[1]) #print( "getTriggerPixmap factor",factor)
        if msg[0] == "sendControlMessage" :
            #print( "sendControlMessage",msg)
            sleep(0.02)
            self.controlMsg(0x42,0xb1,None,value=0x2C);   sleep(0.05*factor) # 
            self.controlMsg(0x42,0xb1,None,value=0xcc);   sleep(0.05*factor) # 
            for parms in msg[1:]: 
                # choice
                if type(parms) == type(0) :  
                    sleep(0.001*parms)
                elif len(parms) == 1 :  
                    sleep(0.001*parms[0])
                elif len(parms) == 4 :  
                    if parms[2] == 0 : parms[2] = None
                    #print ("parms 4: %02x %02x %s %02x " % parms)
                    result=self.controlMsg(parms[0],parms[1],value=parms[3],Buffer=parms[2],index=0,timeout=100); #sleep(0.02)
                elif len(parms) == 5 :  
                    #print ("parms 5: %04x %04x %04x %04x %04x" % (parms[0],parms[1],parms[2],parms[3],parms[4]))
                    if parms[4] == 0 : parms[4] = None
                    #result=self.device.ctrl_transfer(parms[0],parms[1],parms[2],parms[3],parms[4]); sleep(0.05)
                    result=self.controlMsg(parms[0],parms[1],value=parms[3],index=parms[4],Buffer=parms[2]); #sleep(0.02)
                elif len(parms) == 3 :  
                    try: 
                        data = self.device.read(parms[0],parms[1],timeout=parms[2]+100)
                        if len(data) != parms[1] :
                            print( "get bulkdata: bulk read len data",len(data),"expected",parms[1])
                            data = None
                        self.DiagQ.put(("BULK",data))
                    except Exception as message : 
                        self.DiagQ.put(("BULK",None))
                        #print( "bulk",message)
                # end choice
            self.ConrolQ.put(("CLAV"))
            #self.controlMsg(0x42,0xb0,None,value=0xdc,index=0)
        #self.getTriggerPixmap(0)
        return result
    #end sendControlMessage
    def sendControlMessage2(self,msg):
        factor =1 # 0.1 *float(self.timeoutFactors[1]) #print( "getTriggerPixmap factor",factor)
        if msg[0] == "sendControlMessage2" :
            #print( "sendControlMessage",msg)
            sleep(0.02)
            self.controlMsg(0x42,0xb1,None,value=0x2C);   sleep(0.05*factor) # 
            self.controlMsg(0x42,0xb1,None,value=0xcc);   sleep(0.05*factor) # 
            for parms in msg[1:]: 
                # choice
                if type(parms) == type(0) :  
                    sleep(0.001*parms)
                elif len(parms) == 1 :  
                    sleep(0.001*parms[0])
                elif len(parms) == 4 :  
                    if parms[2] == 0 : parms[2] = None
                    #print ("parms 4: %02x %02x %s %02x " % parms)
                    result=self.controlMsg(parms[0],parms[1],value=parms[2],Buffer=parms[3],index=0,timeout=100); #sleep(0.02)
                elif len(parms) == 5 :  
                    #print ("parms 5: %04x %04x %04x %04x %04x" % (parms[0],parms[1],parms[2],parms[3],parms[4]))
                    if parms[4] == 0 : parms[4] = None
                    #result=self.device.ctrl_transfer(parms[0],parms[1],parms[2],parms[3],parms[4]); sleep(0.05)
                    result=self.controlMsg(parms[0],parms[1],value=parms[2],index=parms[3],Buffer=parms[4]); #sleep(0.02)
                elif len(parms) == 3 :  
                    try: 
                        data = self.device.read(parms[0],parms[1],timeout=parms[2]+100)
                        if len(data) != parms[1] :
                            print( "get bulkdata: bulk read len data",len(data),"expected",parms[1])
                            data = None
                        self.DiagQ.put(("BULK",data))
                    except Exception as message : 
                        self.DiagQ.put(("BULK",None))
                        #print( "bulk",message)
                # end choice
            self.ConrolQ.put(("CLAV"))
            #self.controlMsg(0x42,0xb0,None,value=0xdc,index=0)
        if self.Mode == "Single" and False : self.processSingle()
        #self.getTriggerPixmap(0)
        return result
    #end sendControlMessage2
    def controlMsg(self,R,RT,Buffer,value=0,index=0,timeout=100):
        #print ("controlMsg R %2x RT %2x Buffer %s value %2x index %2x timeout %s" % (R,RT,Buffer,value,index,timeout))
        sleepTime = self.timeoutFactors[0]; #print ("sleep time %sms" % sleepTime)
        self.device.ctrl_transfer(R,RT,value,index,Buffer); sleep(sleepTime*0.001)
    #end controlMsg
    def shutDown(self):
        #print( "USB.shutDown now")
        try: 
            pass # self.device_close()
        except Exception as message : 
            pass # print( "USB.shutDown Exception",message)
        self.ConrolQ.put("TERMINATE")
        msg = None
        while msg != "TERMINATE" : 
            msg = self.USBQ.get()
            #print( "USB.shutDown get",msg)
        #print( "USB exit"); sys.exit()
    #end shutDown
    def device_close(self):
        try: 
            self.remote_off()
        except Exception as message : 
            pass
        try: 
            self.releaseInterface()
        except Exception as message : 
            pass
    #end device_close
    def CTL4(self,msg):
        sleepTime = float(self.timeoutFactors[0])*0.001;# print ("CTL4",msg)
        for m in msg[1:]: 
            # choice
            if m == "RTMP" :  
                self.processTriggerPixmap()
            elif m == "RCMP" :  
                sleep(sleepTime); self.processChannelPixmap(1)
            elif m[0] == "RCMP" :  
                sleep(sleepTime); self.processChannelPixmap(m[1])
            else:  
                RT,R,Bu,Val = m
                self.device.ctrl_transfer(RT,R,Val,0,Bu); sleep(sleepTime) # sleep time is necessary!
                #print("ctrl_transfer",RT,R,Val,0,Bu)
            # end choice
    #end CTL4
# end class USB
class Zoom (object):
    def __init__(self,ZoomQ,ConrolQ):
        self.root = Tk(); self.root.wm_title("Scroll Indicator")
        self.root.wm_protocol("WM_DELETE_WINDOW",self.root.iconify)
        global colors; self.colors = colors; logging= False
        self.id = [0,0,0,0,0,0,0,0,0]
        self.ZoomQ = ZoomQ; self.ConrolQ = ConrolQ
        self.root.iconify()
        self.canvas = Canvas(self.root,width=256,height=75,bg=scopeGreen)
        self.canvas.pack(); self.root.update()
        self.ScanLoop()
        #print( "Zoom terminated")
    # end init Zoom
    def ScanLoop(self):
        msg = None
        while msg != "TERMINATE" : 
            msg = self.ZoomQ.get(); #print ("Zoom.ScanLoop",msg[0])
            # choice
            if msg[0] == "SAMPLES" :  
                data, paintWidth,c1,c2 = msg[1]
                #print( msg[1])
                self.configZoom(data,paintWidth,c1,c2)
                
                self.canvas.update()
            elif msg == "HIDE" : self.root.iconify()
            elif msg[0] == "LOG" : global logging; logging = msg[1]
            elif msg == "SHOW" : self.root.deiconify()
            # end choice
        while not self.ZoomQ.empty() : 
            dummy = self.ZoomQ.get(True,3)
            print( "reading dummy")
    #end ScanLoop
    def configZoom(self,data=None,paintWidth=None,c1=None,c2=None):
        t=time(); y0 =75
        try: 
            log("Zoom configZoom start")
            for id in self.id: self.canvas.delete(id)
            if data == None : return
            # group channel 1
            screenWidth = 256
            p1,p2,p3,p4,s1,s2,s3,s4 = c1
            startx = screenWidth - 256; starty = 0; squeeze = 50
            sampleArray = 75 - (numpy.array(data[s1:s4])>>2)
            saSize = sampleArray.size; saRest = saSize % squeeze;  newSize = saSize-saRest; sampleArray.resize(newSize); #print ("len sA",sampleArray.size);
            newArray = sampleArray.reshape(newSize//squeeze,squeeze);#print ("newArray",newArray.shape)
            maxArray = numpy.amax(newArray,axis=1); minArray = numpy.amin(newArray,axis=1);  pointListSize = 4 * maxArray.size
            pointArray = numpy.empty(pointListSize);  xArray = numpy.arange(startx,startx+maxArray.size); 
            pointArray[0::4] = xArray; pointArray[2::4] = xArray; pointArray[1::4] = minArray; pointArray[3::4] = maxArray
            pointList = pointArray.tolist()
            try: 
                self.id[0] = self.canvas.create_line(pointList[0:((s2-s1 + squeeze)//squeeze)*4],fill=colors[4])
            except Exception as message : pass
            try: 
                self.id[1] = self.canvas.create_line(pointList[((s2-s1)//squeeze)*4:((s3-s1 + squeeze)//squeeze)*4],fill=colors[0])
            except Exception as message : pass
            try: 
                self.id[2] = self.canvas.create_line(pointList[((s3-s1)//squeeze)*4:((s4-s1)//squeeze)*4],fill=colors[4])
            except Exception as message : pass
            # group channel 2
            p1,p2,p3,p4,s1,s2,s3,s4 = c2
            startx = screenWidth - 256; starty = 0; squeeze = 50
            sampleArray = 75 - (numpy.array(data[s1:s4])>>2)
            saSize = sampleArray.size; saRest = saSize % squeeze;  newSize = saSize-saRest; sampleArray.resize(newSize); #print ("len sA",sampleArray.size);
            newArray = sampleArray.reshape(newSize//squeeze,squeeze);#print ("newArray",newArray.shape)
            maxArray = numpy.amax(newArray,axis=1); minArray = numpy.amin(newArray,axis=1);  pointListSize = 4 * maxArray.size
            pointArray = numpy.empty(pointListSize);  xArray = numpy.arange(startx,startx+maxArray.size); 
            pointArray[0::4] = xArray; pointArray[2::4] = xArray; pointArray[1::4] = minArray; pointArray[3::4] = maxArray
            pointList = pointArray.tolist()
            try: 
                self.id[3] = self.canvas.create_line(pointList[0:((s2-s1 + 50)//50)*4],fill=colors[5])
            except Exception as message : pass
            try: 
                self.id[4] = self.canvas.create_line(pointList[((s2-s1)//squeeze)*4:((s3-s1 + squeeze)//squeeze)*4],fill=colors[1])
            except Exception as message : pass
            try: 
                self.id[5] = self.canvas.create_line(pointList[((s3-s1)//squeeze)*4:((s4-s1)//squeeze)*4],fill=colors[5])
            except Exception as message : pass
        except Exception as message : 
            print( "Zoom.configZoom",message)
            traceback.print_exc()
        log("Zoom configZoom duration %5.3f" % (time() -t))
        return
    #end configZoom
# end class Zoom
class callback ():
    def __init__(self,function,arguments):
        self.function = function; self.arguments = arguments
    # end init callback
    def __call__(self):
        self.function(self.arguments)
    #end __call__
# end class callback
class spectrum (object):
    # classes
    class spectrumWindow (Frame):
        def __init__(self,root,SpectrumQ,ConrolQ,USBQ,screenWidth):
            Frame.__init__(self,root)
            self.root = root
            root.wm_protocol("WM_DELETE_WINDOW",root.iconify)
            self.SpectrumQ = SpectrumQ; self.ConrolQ = ConrolQ; self.USBQ = USBQ
            wx=25; offx = 20; wy=25; offy = 14; self.offx = offx; self.wx = wx
            V1 = Frame(self)
            V1.pack(side='left')
            V1.config()
            H = Frame(V1)
            H.pack(side="top",fill="x",expand=1)
            H.config()
            v11 = Frame(H)
            v11.pack(side='top')
            v11.config()
            headline_var = StringVar()
            headline = Label(v11,text='Power Spectrum')
            headline.pack(side="left",fill="x",expand=1)
            headline.config(relief='groove',borderwidth=0,width=20)
            V22 = Frame(H)
            V22.pack(side='top')
            V22.config()
            l1_var = StringVar()
            l1 = Label(V22,text='               number of bins')
            l1.pack(fill='y',side="left")
            l1.config(borderwidth=0)
            self.BinScale_var = IntVar()
            self.BinScale = Scale(V22,label=None,from_=0, to=7, length=900,orient='horizontal', command=self.setScale,variable=self.BinScale_var)
            self.BinScale.pack(side="left")
            self.BinScale.config(showvalue=False)
            self.L2_var = StringVar()
            self.L2 = Label(V22,text='10')
            self.L2.pack(fill='y',side="left")
            self.L2.config(borderwidth=0,width=5)
            V23 = Frame(H)
            V23.pack(side='top')
            V23.config()
            l1_var = StringVar()
            l1 = Label(V23,text='compensate bin 1 artefact')
            l1.pack(fill='x',side="left")
            l1.config(borderwidth=0)
            self.artScale_var = IntVar()
            self.artScale = Scale(V23,label=None,from_=-400, to=-300, length=900,orient='horizontal', command=self.setArtScale,variable=self.artScale_var)
            self.artScale.pack(side="left")
            self.artScale.config(showvalue=False)
            self.L23_var = StringVar()
            self.L23 = Label(V23,text='10')
            self.L23.pack(fill='y',side="left")
            self.L23.config(borderwidth=0,width=5)
            self.H2 = Frame(V1)
            self.H2.pack(side="top",fill="x",expand=1); self.H2_var = StringVar(); self.WindowVar = StringVar(); self.RangeVar = StringVar(); self.ScaleVar = StringVar(); self.ChannelVar = StringVar()
            self.H2.config()
            self.RB1=Radiobutton(self.H2,text='Channel 1',value='Ch1')
            self.RB1.config(variable=self.H2_var)
            self.RB1.grid(column=0,row=0,ipadx=10,columnspan=1)
            self.RB1.config(command=self.setChannel,indicatoron=False,selectcolor=colors[0])
            self.RB2=Radiobutton(self.H2,text='Channel 2',value='Ch2')
            self.RB2.config(variable=self.H2_var)
            self.RB2.grid(column=1,row=0,ipadx=10,columnspan=1)
            self.RB2.config(command=self.setChannel,indicatoron = False,selectcolor=colors[1])
            self.RB3=Radiobutton(self.H2,text='Test Data',value='Ch3')
            self.RB3.config(variable=self.H2_var)
            self.RB3.grid_forget() #column=2,row=0,ipadx=40,columnspan=2)
            self.RB3.config(command=self.setChannel,indicatoron = False,selectcolor="orange")
            L1_var = StringVar()
            L1 = Label(self.H2,text='   Window: ')
            L1.grid(column=0,row=1)
            L1.config(relief='groove',borderwidth=0)
            self.RB9=Radiobutton(self.H2,text='Rectangle',value='No')
            self.RB9.config(variable=self.WindowVar)
            self.RB9.grid(column=1,row=1,sticky="ew")
            self.RB9.config(command=None,indicatoron=False,selectcolor="orange",width=8)
            self.RB10=Radiobutton(self.H2,text='Hamming',value='Ham')
            self.RB10.config(variable=self.WindowVar)
            self.RB10.grid(column=2,row=1,ipadx=1,sticky="ew")
            self.RB10.config(command=None,indicatoron=False,selectcolor="orange",width=8)
            self.RB11=Radiobutton(self.H2,text='Hann',value='Han')
            self.RB11.config(variable=self.WindowVar)
            self.RB11.grid(column=3,row=1,ipadx=1,sticky="ew")
            self.RB11.config(command=None,indicatoron = False,selectcolor="orange",width=8)
            self.RB12=Radiobutton(self.H2,text='Blackman',value='Black')
            self.RB12.config(variable=self.WindowVar)
            self.RB12.grid(column=4,row=1,ipadx=1,sticky="ew")
            self.RB12.config(command=None,indicatoron = False,selectcolor="orange",width=8)
            self.RB13=Radiobutton(self.H2,text='Bartlett',value='Bart')
            self.RB13.config(variable=self.WindowVar)
            self.RB13.grid(column=5,row=1,ipadx=1,sticky="ew")
            self.RB13.config(command=None,indicatoron = False,selectcolor="orange",width=8)
            self.RB14=Radiobutton(self.H2,text='Kaiser 14',value='Kaiser')
            self.RB14.config(variable=self.WindowVar)
            self.RB14.grid(column=6,row=1,ipadx=1,sticky="ew")
            self.RB14.config(command=None,indicatoron = False,selectcolor="orange",width=8)
            L2_var = StringVar()
            L2 = Label(self.H2,text='  Scaling:  ')
            L2.grid(column=7,row=1)
            L2.config(relief='groove',borderwidth=0)
            self.RB5=Radiobutton(self.H2,text='linear',value='linear')
            self.RB5.config(variable=self.ScaleVar)
            self.RB5.grid(column=8,row=1,sticky="ew")
            self.RB5.config(command=None,indicatoron=False,selectcolor="orange",width=9)
            self.RB6=Radiobutton(self.H2,text='log 40 dB',value='40 dB')
            self.RB6.config(variable=self.ScaleVar)
            self.RB6.grid(column=9,row=1,sticky="ew")
            self.RB6.config(command=None,indicatoron = False,selectcolor="orange",width=9)
            self.RB7=Radiobutton(self.H2,text='log 60 dB',value='60 dB')
            self.RB7.config(variable=self.ScaleVar)
            self.RB7.grid(column=10,row=1,sticky="ew")
            self.RB7.config(command=None,indicatoron = False,selectcolor="orange",width=9)
            self.CHB1_var = IntVar()
            self.CHB1=Checkbutton(self.H2,text='  drop bin0 ')
            self.CHB1.config(variable=self.CHB1_var)
            self.CHB1.grid(column=4,row=0,sticky="ew")
            self.CHB1.config(command=None,indicatoron=0,selectcolor = "orange")
            self.CHB2_var = IntVar()
            self.CHB2=Checkbutton(self.H2,text='  drop bin1  ')
            self.CHB2.config(variable=self.CHB2_var)
            self.CHB2.grid(column=5,row=0,sticky="ew")
            self.CHB2.config(command=None,indicatoron=0,selectcolor = "orange")
            self.CHBAA_var = IntVar()
            self.CHBAA=Checkbutton(self.H2,text=' Amplitude Spectrum')
            self.CHBAA.config(variable=self.CHBAA_var)
            self.CHBAA.grid(column=6,row=0,sticky="ew")
            self.CHBAA.config(command=self.configSpectrumtype,indicatoron=0,width = 16)
            self.L3_var = StringVar()
            self.L3 = Label(self.H2,text='mouse frequency')
            self.L3.grid(column=7,row=0,columnspan=3)
            self.L3.config(borderwidth=0,width=24)
            self.L4_var = StringVar()
            self.L4 = Label(self.H2,text='cursor diff frequency')
            self.L4.grid(column=10,row=0,columnspan=3)
            self.L4.config(borderwidth=0,width=26)
            self.canvas=Canvas(V1,width=48*wx + 2*offx,height=10*wy + 2*offy)
            self.canvas.pack(); self.canvas.config(bg=scopeGreen);  self.canvasHeight = 10*wy + 2*offy
            root.wm_title("Power Spectrum")
            root.iconify()
            #spectrumWindow.pack()
            #self.canvas.pack(side="top")
            self.SpectrumId = None
            #self.options_var.set("10")
            self.textIds = None
            self.RB1.invoke();  self.RB5.invoke(); self.RB9.invoke(); self.CHB1.invoke()
            self.bins = 1024
            #print( "init Spec2 done")
            self.canvas.bind("<Button-1>",self.showMousePosition)
            self.doPrint = 1
            self.frequency = 1.0,"Hz"; self.width = 1; self.cursorFrequency = 1.0
            l1.bind("<Button-1>",self.artClicked)
            global logging; logging = False
            self.pack()
            self.update()
            self.after(10,self.refreshLoop)
            self.hammingCache = dict(); self.hanCache = dict(); self.blackCache = dict(); self.bartCache = dict(); self.kaiserCache = dict()
            self.CHBAA.invoke()
            self.artScale.set(-327)
        # end init spectrumWindow
        def refreshLoop(self):
            log("Spectrum refreshLoop")
            while True : 
                # group get message
                empty = True
                while empty : 
                    try: 
                        message = self.SpectrumQ.get_nowait()
                        empty = False
                    except Exception as message : 
                        sleep(0.01)
                #print ("Spec message",message[0])
                # choice
                if message == "TERMINATE" :  
                    log("Spectrum terminating")
                    #self.ConrolQ.put(specRoot.wm_geometry())
                    self.root.quit(); return
                elif message == "HIDE" :  
                    self.root.iconify()
                    continue
                elif message == "SHOW" :  
                    self.root.deiconify()
                    self.setChannel()
                    continue
                elif message[0] == "LOG" :  
                    global logging; logging = message[1]
                    continue
                elif message[0] == "SAMPLES" :  
                    v1 = message[1]; v2 = message[2]; v3 = message[3]; v4 =message[4];data = message[5]; self.burstFrequency = message[6] ;self.cursorFrequency = message[7]
                    #print( "burstfrequency",self.burstFrequency)
                    if self.H2_var.get() == "Ch3" : return
                    self.configSpectrum(v1,v2,v3,v4,data,self.burstFrequency,self.cursorFrequency)
                elif message[0] == "PARAMS" :  
                    v1 = message[1]
                    self.frequency = v1
                # end choice
                self.root.update()
            #self.update()
            log("Spectrum refresh end")
        #end refreshLoop
        def configSpectrum(self,v1=0,v2=-1,v3=0,v4=-1,data=None,burstFrequency=1000,cursorFrequency=1000):
            ##print( "configSpectrum",v1,v2,v3,v4,len(data),len(data[0]),len(data[1]))
            if data == None or data[0] == None or data[1] == None : return # print ("None data")
            t1 = time(); log("Spec configSpectrum  start")
            if self.SpectrumId != None :
                for id in self.SpectrumId: 
                    self.canvas.delete(id)
            if self.textIds != None :
                for id in self.textIds: 
                    self.canvas.delete(id)
            try: 
                # choice
                if self.H2_var.get() == "Ch1" :  
                    actcol=colors[0];  samples = data[0][0: (v2-v1)] ;
                elif self.H2_var.get() == "Ch2" :  
                    actcol=colors[1]; samples = data[1][0 : (v4-v3)] 
                else:  
                    print("no data"); eturn
                # end choice
            except Exception as message : 
                print( "configSpectrum no samples",message, type(data),"v1",v1,"v2",v2)
                self.SpectrumId.append(self.canvas.create_text(100,100,text="channel not active",fill=actcol))
                return
            myFont = Font(family="Courier",size=7,weight="bold")
            self.SpectrumId = []; self.textIds = []; offx = self.offx; wx = self.wx; v1 = int(v1); v2 = int(v2); v3 = int(v3); v4 =int(v4)
            self.cursorFrequency = cursorFrequency
            yText=self.canvasHeight-5; minWidth = 20; y0 = 127; mode = self.ScaleVar.get(); yBase = self.canvasHeight - 15; yStart = 5; yDist = (yBase - yStart) // 10; yHeight=yBase - yStart
            N = len(samples);
            if N == 0 : print ("N==0"); return
            compensation = self.artScale.get( ) * 100; # print ("comp",compensation) #samples = samples + compensation*0.1
            # choice
            if self.WindowVar.get() == "No" : # Rectangle
                wSamples = samples 
            elif self.WindowVar.get() == "Ham" : # Hamming
                samples = samples - 269 + compensation
                try: 
                    hamming = self.hammingCache[N]
                except Exception as message : 
                    hamming =self.hammingCache[N] = numpy.hamming(N)
                wSamples = samples * hamming;  
            elif self.WindowVar.get() == "Han" : # Hann
                samples = samples -269 + compensation
                try: 
                    han = self.hanCache[N]
                except Exception as message : 
                    han = self.hanCache[N] = numpy.hanning(N); 
                wSamples = han * samples
            elif self.WindowVar.get() == "Black" : # Blackman
                samples = samples -269 + compensation
                try: 
                    blackman = self.blackCache[N]
                except Exception as message : 
                    blackman = self.blackCache[N] = numpy.blackman(N)
                wSamples = samples * blackman
            elif self.WindowVar.get() == "Bart" : # Bartlett
                samples = samples -269 + compensation
                try: 
                    bartlett = self.bartCache[N]
                except Exception as message : 
                    bartlett = self.bartCache[N] = numpy.bartlett(N)
                wSamples = samples * bartlett
            elif self.WindowVar.get() == "Kaiser" : # Kaiser
                samples = samples -269 + compensation
                try: 
                    kaiser = self.kaiserCache[N]
                except Exception as message : 
                    kaiser = self.kaiserCache[N] = numpy.kaiser(N,14); 
                wSamples = kaiser * samples
            else: print( "no window type"); return
            # end choice
            mean = wSamples.mean(); wSamples = wSamples - mean
            try: 
                S = fftpack.rfft(wSamples); S = abs(S) ; # compute fft
                if self.CHB2_var.get() : # suppress bin 1?
                    S[1] = 0
                if not self.CHBAA_var.get() :
                    S = S * S
            except Exception as message : 
                self.SpectrumId.append(self.canvas.create_text(200,100,text=message,fill=actcol))
                print( "fft",message)
                return
            M = max(S)
            if M == 0.0 : return
            number_of_points = self.bins; width = 1024.0/number_of_points; self.width = width;
            S = S[0:number_of_points]; S = S  / M
            # choice
            if mode == "linear" :  
                Y = yStart + yHeight - yHeight*S
                for i,y in enumerate(Y): 
                    self.SpectrumId.append( self.canvas.create_rectangle(offx +width*i,yBase,offx + width*(i+1),y,fill=actcol,outline=actcol))
            elif mode == "40 dB" :  
                S = S.clip(0.01); # calibration S = (0,0,1,0.316,0.1,0.0316,0.01)
                Slog = numpy.log10(S); Slog = 20*Slog + 40; y40 = yBase - 0.25*yDist*Slog
                for i,y in enumerate(y40): 
                    self.SpectrumId.append( self.canvas.create_rectangle(offx +width*i,yBase,offx + width*(i+1),y,fill=actcol,outline=actcol))
            else: # "60 dB"
                S = S.clip(0.001); # calibration: S = (1,1,1,0.316,0.1,0.0316,0.01,0.00316,0.001)
                Slog = numpy.log10(S)* 20 + 60
                y60 = yBase - 0.165 * yDist * Slog
                for i,y in enumerate(y60): 
                    self.SpectrumId.append(self.canvas.create_rectangle(offx + width*i,yBase,offx + width*(i+1),y,fill=actcol,outline=actcol))
            # end choice
            # choice
            if width > minWidth :  
                for i in range(0,number_of_points+1): 
                    x = width*(i+0.5) + offx; v = i
                    self.textIds .append(self.canvas.create_text(x,yText,text=str(v),fill="white"))
            else:  
                dropFactor = int(minWidth/width) + 2
                for i in range(0,number_of_points+1,dropFactor): 
                    x = width*(i+0.5)+ offx; v = i
                    self.textIds .append(self.canvas.create_text(x,yText,text=str(v),fill="white",font=myFont))
            # end choice
            # choice
            if mode == "linear" :  
                for i in range(0,11): 
                    y = yStart + yDist*i; k = 1.0 - i / 10.0
                    self.SpectrumId.append(self.canvas.create_line(offx,y,2*offx + 50*wx,y,fill="white"))
                    self.SpectrumId.append(self.canvas.create_text(10,y,text="%0.1f" % k,fill="white"))
            elif mode == "40 dB" :  
                for i in range(5): 
                    y = yStart + yHeight*i//4
                    self.SpectrumId.append(self.canvas.create_line(offx,y,2*offx + 50*wx,y,fill="white"))
                    dbtext =("0","-10","-20","-30","-40")[i]
                    self.SpectrumId.append(self.canvas.create_text(10,y,text=dbtext,fill="white"))
            elif mode == "60 dB" :  
                for i in range(7): 
                    y = yStart + i*yHeight//6
                    self.SpectrumId.append(self.canvas.create_line(offx,y,2*offx + 50*wx,y,fill="white"))
                    dbtext =("0","-10","-20","-30","-40","-50","-60")[i]
                    self.SpectrumId.append(self.canvas.create_text(10,y,text=dbtext,fill="white"))
            else: print( "no mode",mode)
            # end choice
            log("Spec configSpectrum end duration %5.3f" % (time()- t1))
            self.root.update()
        #end configSpectrum
        def setScale(self,value):
            self.bins = (16,32,64,128,256,512,1024,2048)[int(value)]
            #print( value)
            self.L2.config(text=str(self.bins))
        #end setScale
        def setArtScale(self,value):
            self.L23.config(text=str(value))
        #end setArtScale
        def showMousePosition(self,event):
            #print( "showMousePosition")
            freq= self.cursorFrequency * ((event.x - self.offx) // self.width)
            #freq= self.burstFrequency * ((event.x - self.offx) // self.width)
            try: 
                freqs = convertF(freq)  #freq= freq * self.cursorFrequency // f;  
                self.L3.config(text="frequency @ mouse "+ freqs)
                freqs2 = convertF(self.cursorFrequency)
                self.L4.config(text="cursor diff frequency %s " % freqs2)
            except Exception as message : 
                self.L3.config(text="      frequency  ?")
                pass
        #end showMousePosition
        def setChannel(self,Channel=None):
            # choice
            if Channel == None :  
                Ch = self.H2_var.get()
            else:  
                Ch = Channel
            # end choice
        #end setChannel
        def artClicked(self,event):
            self.artScale_var.set(0)
            self.setArtScale(0)
        #end artClicked
        def configSpectrumtype(self):
            # choice
            if self.CHBAA_var.get() :  
                self.CHBAA.config(text="Amplitude Spectrum")
            else:  
                self.CHBAA.config(text="Power Spectrum")
            # end choice
        #end configSpectrumtype
    # end class spectrumWindow
    def __init__(self,SpectrumQ,ConrolQ,USBQ,screenWidth):
        root = Tk()
        specWin = self.spectrumWindow(root,SpectrumQ,ConrolQ,USBQ,screenWidth)
        root.mainloop()
        #print( "spectrum terminated")
    # end init spectrum
# end class spectrum
class USBError (Exception):
    def __init__(self):
        Exception.__init__(self)
        self.st = st
        
        global usbError; usbError = self
    # end init USBError
    def __str__(self):
        return self.st
        
    #end __str__
# end class USBError
class Mouse (Widget):
    def __init__(self):
        self.bind("<Enter>",self.enter)
        self.bind("<Leave>",self.leave)
    # end init Mouse
    def enter(self,event):
        Control.MouseWidget = self
    #end enter
    def leave(self,event):
        Control.MouseWidget = None
    #end leave
# end class Mouse
class MLabel (Label,Mouse):
    def __init__(self,parent,text):
        Label.__init__(self,parent,text=text)
        Mouse.__init__(self)
    # end init MLabel
    def command(self,event,widget):
        print ("MLabel.command",self.cget("text"),event.num)
        raise NotImplementedError
    #end command
# end class MLabel
class pixmapPanel (Toplevel):
    def __init__(self,root):
        Toplevel.__init__(self,root)
        V3 = Frame(self)
        V3.pack(side='top')
        V3.config()
        B0 = Button(V3,text='show current pixmap')
        B0.pack(side="left"); B0.config(command=self.showCurrentPixmap)
        B1 = Button(V3,text='show trigger pixmap')
        B1.pack(side="left"); B1.config(command=self.showTriggerPixmap)
        B2 = Button(V3,text='show channel pixmap')
        B2.pack(side="left"); B2.config(command=self.showChannelPixmap)
        B3 = Button(V3,text='save signature')
        B3.pack(side="left"); B3.config(command=self.saveSignature)
        self.sigLabel_var = StringVar()
        self.sigLabel = Label(V3,text='signature')
        self.sigLabel.pack(side="left",fill="both")
        self.sigLabel.config(relief='groove',borderwidth=1,width=30,font=Font(family="Courier",size=10))
        V8 = Frame(self)
        V8.pack(side='top')
        V8.config(width=30,height=20)
        self.monitorCanvas=Canvas(V8,width=640,height=490)
        self.monitorCanvas.grid(column=1,row=1); self.monitorCanvas.config()
        self.upperhorScale_var = IntVar()
        self.upperhorScale = Scale(V8,label=None,from_=0, to=320, length=640,orient='horizontal', command=None,variable=self.upperhorScale_var)
        self.upperhorScale.grid(column=1,row=0)
        self.upperhorScale.config(command=self.extract,resolution=4)
        self.lowerhorScale_var = IntVar()
        self.lowerhorScale = Scale(V8,label=None,from_=0, to=320, length=640,orient='horizontal', command=None,variable=self.lowerhorScale_var)
        self.lowerhorScale.grid(column=1,row=2)
        self.lowerhorScale.config(command=self.extract,resolution=4)
        self.leftvertScale_var = IntVar()
        self.leftvertScale = Scale(V8,label=None,from_=0, to=240, length=480,orient='vertical', command=None,variable=self.leftvertScale_var)
        self.leftvertScale.grid(column=0,row=1)
        self.leftvertScale.config(command=self.extract)
        self.rightvertScale_var = IntVar()
        self.rightvertScale = Scale(V8,label=None,from_=0, to=240, length=480,orient='vertical', command=None,variable=self.rightvertScale_var)
        self.rightvertScale.grid(column=2,row=1)
        self.rightvertScale.config(command=self.extract)
        self.wm_title("Pixmap Panel")
        self.packageString = None
        self.subId = 0; self.pixmap = None
        self.iconify()
        self.upperhorScale.set(320); self.rightvertScale.set(240)
    # end init pixmapPanel
    def showCurrentPixmap(self,pixmap=None):
        try: 
            if pixmap == None :
                USBQ.put("DUMP2")
                return
            self.pixmap = Control.Pixmap;
            memfile = extractSubpicture(self.pixmap,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename="triggerMap.ppm",colorListIndex=2)
            self.PIALL =PhotoImage(); self.PIALL.config(data=memfile); self.PIALL = self.PIALL.zoom(2);self.monitorCanvas.create_image(1,1,image=self.PIALL,anchor=NW)
            self.extract()
        except Exception as message : 
            print ("showCur",message)
            return
    #end showCurrentPixmap
    def showTriggerPixmap(self):
        try: 
            self.pixmap = Control.triggerPixmap;
            memfile = extractSubpicture(self.pixmap,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename="triggerMap.ppm",colorListIndex=2)
            self.PIALL =PhotoImage(); self.PIALL.config(file="triggerMap.ppm"); self.PIALL = self.PIALL.zoom(2);self.monitorCanvas.create_image(1,1,image=self.PIALL,anchor=NW)
        except Exception as message : 
            print ("showTrPm",message)
            USBQ.put("ReqTriggMap")
            return
        self.extract()
    #end showTriggerPixmap
    def showChannelPixmap(self):
        try: 
            self.pixmap = Control.channelPixmap
            memfile = extractSubpicture(self.pixmap,firstRow = 0,lastRow=240,firstColumn=0,lastColumn=320,filename="channelMap.ppm",colorListIndex=2)
            self.PIALL =PhotoImage(); self.PIALL.config(file="channelMap.ppm"); self.PIALL = self.PIALL.zoom(2);self.monitorCanvas.create_image(1,1,image=self.PIALL,anchor=NW)
        except Exception as message : 
            print ("showChannelPixmap",message)
        self.extract()
    #end showChannelPixmap
    def extract(self,value=None):
        if not self.pixmap : return
        self.monitorCanvas.delete(self.subId)
        self.sigLabel.config(text="")
        up = self.upperhorScale.get();lo=self.lowerhorScale.get();  up = (up//4) * 4; lo = (lo//4) * 4
        # choice
        if up == lo : return
        elif lo < up : up,lo = lo,up
        # end choice
        le = self.leftvertScale.get(); ri = self.rightvertScale.get()
        # choice
        if le == ri : return
        elif ri < le : ri,le = le,ri
        # end choice
        #print( "le %i ri %i up %i lo %i" % (le,ri,up,lo))
        memfile = extractSubpicture(self.pixmap,firstRow = le,lastRow=ri ,firstColumn=up,lastColumn=lo,filename="triggerMap2.ppm",colorListIndex=1)
        self.PIALL2 =PhotoImage(); self.PIALL2.config(file="triggerMap2.ppm"); self.PIALL2 = self.PIALL2.zoom(2)
        self.subId = self.monitorCanvas.create_image(1+2*up,1+2*le,image=self.PIALL2,anchor=NW)
        self.firstRow = le; self.lastRow = ri; self.firstColumn = up; self.lastColumn = lo
        self.signature = getSignature(self.pixmap,self.firstRow,self.firstColumn,min(self.lastColumn,self.firstColumn+20)); self.sigLabel.config(text=self.formatSignature(self.signature))
    #end extract
    def saveSignature(self):
        #print( "save signature")
        infileName = tkFileDialog.asksaveasfilename(filetypes=[("signature","*.sig")])
        if infileName == "" : return
        namelist = infileName.split("/")
        s = namelist[-1]; sl = s.split(".")
        ss = "%s_%i_%i_%i_%i.%s" % (sl[0],self.firstRow,self.lastRow,self.firstColumn,self.lastColumn,sl[1])
        namelist[-1] = ss; sn = "/".join(namelist); print( "saving on ",sn)
        f = open(sn,"w"); f.write('b"%s"' % self.signature); f.close()
    #end saveSignature
    def formatSignature(self,sig):
        result=""
        for i,c in enumerate(sig): 
            try: 
                result = result + chr(c)
            except Exception as message : 
                result = result + c
            if i % 4 == 3 and i > 0 : result = result + " "
        return result
    #end formatSignature
# end class pixmapPanel
class diagnosticPanel (Toplevel):
    def __init__(self,root):
        Toplevel.__init__(self,root)
        #print "cons diag"
        V1 = Frame(self)
        V1.pack(side='top',fill="x",expand=1)
        V1.config()
        HL_var = StringVar()
        HL = Label(V1,text='Enter values in hex!')
        HL.pack(fill='both',side="top")
        HL.config(relief='groove',borderwidth=1)
        V20 = Frame(self)
        V20.pack(side='top')
        V20.config()
        V2 = Frame(V20)
        V2.pack(side="left")
        V2.config()
        V3 = Frame(V20)
        V3.pack(side='left')
        V3.config()
        B3 = Button(V3,text='load package')
        B3.pack(side="top"); B3.config(command=self.loadPackage)
        B2 = Button(V3,text='save package')
        B2.pack(side="top"); B2.config(command=self.savePackage)
        B5 = Button(V3,text='save data')
        B5.pack(side="top"); B5.config(command=self.saveData)
        B5 = Button(V3,text='load data')
        B5.pack(side="top"); B5.config(command=self.loadData)
        self.B1 = Button(V3,text='send')
        self.B1.pack(side="top",fill="x",expand=1); self.B1.config(command=self.sendPackage)
        B4 = Button(V3,text='quit')
        B4.pack(side="top",fill="x",expand=1); B4.config(command=self.iconify)
        V4 = Frame(self)
        V4.pack(side='top')
        V4.config()
        self.diagLabel_var = StringVar()
        self.diagLabel = Label(V4,text='')
        self.diagLabel.pack(fill='y')
        self.diagLabel.config(relief='groove',borderwidth=1)
        self.wm_title("Diagnostic Panel")
        self.packageString = None
        rowList = [0,0,0,0,0];  row0Text = ["","rq","rqt","vl","ix","bu"]; labeltext=["","CTL","CTL","CTL","BLK"]; 
        self.VList = []; self.EList = [];self.bulkList =[]
        
        for col in range(0,6): 
            L = Label(V2,text=row0Text[col]); L.grid(column=col,row=0)
        self.iconify()
        for row in range(1,4): 
            L = Label(V2,text=labeltext[row]); L.grid(column=0,row=row)
            for col in range(1,6): 
                v = StringVar(); self.VList.append(v)
                E =Entry(V2); E.config(width=2,textvariable=v); E.grid(column=col,row=row) ; self.EList.append(E)
        row = 5; L = Label(V2,text="BLK"); L.grid(column=0,row=row)
        row4text=["","rq","bu","Tout"]
        L=Label(V2,text="rq"); L.grid(column=1,row=4) # ...
        L=Label(V2,text="buffer"); L.grid(column=2,columnspan=2,row=4)
        L=Label(V2,text="TO"); L.grid(column=4,row=4,columnspan=2)
        v = StringVar(); E = Entry(V2); E.config(width=2,textvariable=v); E.grid(column=1,row=5); self.bulkList.append(E) ; self.VList.append(v) # ...
        v = StringVar(); E = Entry(V2); E.config(width=4,textvariable=v); E.grid(column=2,row=5,columnspan=2); self.bulkList.append(E); self.VList.append(v)
        v = StringVar(); E = Entry(V2); E.config(width=4,textvariable=v); E.grid(column=4,row=5,columnspan=2); self.bulkList.append(E); self.VList.append(v)
    # end init diagnosticPanel
    def sendPackage(self,doSend = True):
        commandList = ["sendControlMessage"]; EntryIndex = 0; bulk=[0,0,0]
        try: 
            for row in range(3): 
                E = self.EList[row*5]
                T=E.get()
                # choice
                if T != "" :  
                    itemList = []
                    for col,E in enumerate(self.EList[row*5:row*5+5]): 
                        E.config(bg="lightgrey"); v = E.get()
                        try: 
                            value =int(v,16)
                        except Exception as message : 
                            #print "illegal entry ",row,col,v
                            E.config(bg="red")
                            return
                        itemList.append(value)
                    commandList.append(itemList)
                else: break
                # end choice
            # choice
            if self.bulkList[0] == "" :  
                USBQ.put((commandList))
            else:  
                try: 
                    for i,E in enumerate(self.bulkList): 
                        v = E.get()
                        bulk[i] = int(v,16)
                    #print "bulk",bulk
                    if len (bulk) == 3 :
                        data = None; commandList.append(bulk)
                        try: 
                            USBQ.put((commandList))
                            data = DiagQ.get(); self.data = data[1];
                            i = 0; length = len(data[1])
                            # choice
                            if length == 38912 or length == 38400 :  
                                self.diagLabel.pack(); self.diagLabel.config(text="")
                                extractSubpicture(data[1],firstRow = 0,lastRow=240,firstColumn = 0,lastColumn=320,filename="diag.ppm")
                                self.PI = PhotoImage(); self.PI.config(file="diag.ppm"); self.diagLabel.config(image=self.PI)
                            elif length >= 192000 :  
                                self.diagLabel.pack()
                                extractSubpicture(data[1],lastColumn=800,lastRow=480,width=800,height=480,filename="diag2.ppm")
                                self.PI = PhotoImage(); self.PI.config(file="diag2.ppm"); self.diagLabel.config(image=self.PI)
                            else:  
                                print ("unexpected pixmap size",length)
                            # end choice
                            #print(); #self.diagLabel.pack_forget()
                        except Exception as message : 
                            print ("\ndiag bulk",message)
                except Exception as message : 
                    print ("sendPackage",message)
            # end choice
            #print (commandList)
        except Exception as message : 
            print ("illegal entry",message)
            traceback.print_exc()
            return
    #end sendPackage
    def loadPackage(self):
        filename = tkFileDialog.askopenfilename(filetypes=[("package","*pkg")])
        f=open(filename,"r")
        values = f.read().split(",")
        try: 
            for i,V in enumerate(values): 
                self.VList[i].set(V)
        except Exception as message : 
            pass
        f.close()
    #end loadPackage
    def savePackage(self):
        filename = tkFileDialog.asksaveasfilename(filetypes=[("package","*pkg")])
        f = open(filename,"w")
        for V in self.VList: 
            f.write("%s," % V.get())
        f.close()
    #end savePackage
    def saveData(self):
        filename = tkFileDialog.asksaveasfilename(filetypes=[("data","*dat")])
        f = open(filename,"wb")
        f.write(self.data)
        f.close()
    #end saveData
    def loadData(self):
        filename = tkFileDialog.askopenfilename(filetypes=[("data","*dat")])
        f = open(filename,"rb")
        data = f.read() ; data = array.array("b",data)
        f.close()
        # choice
        if len(data) <=38912 :  
            width = 320; height = 240; lastRow = 240; lastColumn=320
        else:  
            width=800; height = 480; lastColumn=800; lastRow = 480
        # end choice
        extractSubpicture(data,firstRow = 0, lastRow=lastRow, firstColumn=0, lastColumn=lastColumn ,width = width,height=height,filename="diag.ppm")
        self.PI = PhotoImage(); self.PI.config(file="diag.ppm"); self.diagLabel.config(image=self.PI)
        self.update()
    #end loadData
# end class diagnosticPanel
# functions
def parseArgs ():
    global screenWidth, paintWidth, VID, PID, BUS, DEV,W
    screenWidth = None; VID = 0x5656; PID = None; W=None; BUS = None; DEV = None
    arglist = list(sys.argv)
    for i,arg in enumerate(arglist): 
        # choice
        if arg == "-w" :  
            W = "-w"
            try: 
                screenWidth = int(arglist[i+1])
                #print ("screenWidth",screenWidth)
            except Exception as message : 
                pass #print ("screenWidth",message)
        elif arg == "-b" :  
            try: 
                BUS = arglist[i+1]
            except Exception as message : 
                pass
        elif arg == "-d" :  
            try: 
                DEV = arglist[i+1]
            except Exception as message : 
                pass
        elif arg == "-p" :  
            try: 
                PID = arglist[i+1]
            except Exception as message : 
                pass
        elif arg == "--pause" :  
            USBQ.put(("PAUSE",True))
        else:  
            pass
        # end choice
    try: 
        if screenWidth < 1150 :
            print( "\nthis monitor is too small %i, use 1280 width or more!\n" % screenWidth)
            shutDown()
            ZoomProcess.join(1.0); ZoomProcess.terminate(); #print( "Zoom Process terminated")
            USBProcess.join(1.0); USBProcess.terminate(); #print( "USBProcess terminated")
            SpectrumProcess.join(1.0); #print( "Spectrum joined"); 
            root.destroy() ;sys.exit();
        paintWidth = screenWidth - 80
    except Exception as message : 
        pass #print( "get screen width",message)
    #print ("parseArgs BUS",BUS,"DEV",DEV,"screenWidth",screenWidth)
    myName = arglist[0]
def setConfiguration ():
    global geometry; geometry = None
    global screenWidth,paintWidth
    #print ("setConf,screenWidth",screenWidth)
    # choice
    if W == None :  
        try: 
            infile=open("mdso.config","r")
            for line in infile: 
                try: 
                    exec(line,globals())
                except Exception as message : 
                    print( "load",message,line)
            infile.close()
        except Exception as message : 
            print( "loadConfiguration",message)
            screenWidth = 1280; paintWidth = 1200
    elif screenWidth == None :  
        screenWidth = root.winfo_vrootwidth()
    # end choice
    if not screenWidth : screenWidth=1280
    paintWidth = screenWidth - 80
    if geometry == None : geometry = "%ix833+0+0" % screenWidth
    g = geometry.split("x"); g1 = g[0];   g2,g3,g4 = tuple(g[1].split("+"));
    global WideViewGeometry; WideViewGeometry = geometry ; #root.wm_geometry (geometry); root.update(); root.update_idletasks(); 
    global windowX,windowY; windowX = g3 ; windowY = g4
def saveConfiguration ():
    scopeGeo = root.wm_geometry(); #print( "save root.wm_geometry",scopeGeo)
    specGeo = "1280x382+581+869"
    if scopeGeo.startswith("1x1") :
        return
    #specGeo = ConrolQ.get();
    outfile=open("mdso.config","w")
    outfile.write("global screenWidth, geometry; screenWidth = %i\n" % screenWidth)
    outfile.write("global geometry; geometry = '%s'\n" % scopeGeo)
    outfile.write("global sleepData; sleepData = '%s'\n" % Control.dataTimeout_var.get())
    outfile.write("global sleepPixmap; sleepPixmap = '%s'\n" % Control.pixmapTimeout_var.get())
    outfile.write("global sleepParameter; sleepParameter = '%s'\n" % Control.parameterTimeout_var.get())
    outfile.write("global currentViewName; currentViewName = '" + currentViewName + "'\n")
    outfile.close()
def convertU (U):
    ua = abs(U)
    # choice
    if ua < 0.01 : return "%1.2f mV" % (U*1000)
    elif ua < 0.1 : return "%2.1f mV" % (U*1000)
    elif ua < 1.0 : return "%3.0f  mV" % (U*1000)
    elif ua < 10.0 : return "%1.2f  V" % (U)
    elif ua < 100.0 : return "%2.1f  V" % (U)
    else: return "%3.0f   V" % (U)
    # end choice
def convertT (T):
    at = abs(T)
    # choice
    if at < 1.e-9 : return "%3.1f ps" % (T*1e12)
    elif at < 10.e-9 : return "%1.3f ns" % (T*1e9)
    elif at < 100.e-9 : return "%2.2f ns" %(T*1e9)
    elif at < 1.0e-6 : return "%3.1f  ns" % (T*1.e9)
    elif at < 10.e-6 : return "%1.3f µs" % (T*1.e6)
    elif at < 100.e-6 : return "%2.2f µs" % (T*1e6)
    elif at < 1.e-3 : return "%3.1f  µs" % (T*1e6)
    elif at < 10.e-3 : return "%1.3f ms" % (T*1e3)
    elif at < 100.e-3 : return "%2.2f ms" % (T*1e3)
    elif at < 1.0 : return "%3.1f  ms" % (T*1e3)
    elif at < 10.0 : return "%1.3f s" %(T)
    else: return "%2.2f s" % (T)
    # end choice
def convertF (F):
    F = abs(F)
    # choice
    if F < 10.e0 : return "%1.2f Hz" % (F)
    elif F < 100.e0 : return "%2.1f Hz" %(F)
    elif F < 1.0e3 : return "%3.0f  Hz" % (F)
    elif F < 10.e3 : return "%1.2f kHz" % (F*1.e-3)
    elif F < 100.e3 : return "%2.1f kHz" % (F*1e-3)
    elif F < 1.e6 : return "%3.0f  kHz" % (F*1e-3)
    elif F < 10.e6 : return "%1.3f MHz" % (F*1e-6)
    elif F < 100.e6 : return "%2.2f MHz" % (F*1e-6)
    elif F < 1.0e9 : return "%3.1f  MHz" % (F*1e-6)
    else: return "%3.1f MHz" % (F*1e-6)
    # end choice
def createSpectrumProcess (SpectrumQ,ConrolQ,USBQ,screenWidth):
    #print( "create Spectrum")
    specProcess = spectrum(SpectrumQ,ConrolQ,USBQ,screenWidth); 
    #print( "Spec root terminated")
def createZoomProcess (ZoomQ,ConrolQ):
    #print( "create Zoom")
    global ZoomProcess
    ZoomProcess = Zoom(ZoomQ,ConrolQ)
def createUSBProcess (USBQ,ConrolQ,DiagQ,PID,BUS,DEV):
    #print( "create USB")
    global USBProcess
    USBProcess = USB(USBQ,ConrolQ,DiagQ,PID,BUS,DEV)
    #print( "USB terminated")
    #return #sys.exit()
def log (text):
    try: 
        if logging :
            LogQ.put("%08.5f  on cpu %i %s" % ((time() - startTime), get_cpu(),text))
    except Exception as message : print( message)
def shutDown (arg=None):
    #print( "\nshutDown\n")
    USBQ.put("TERMINATE")
    ZoomQ.put("TERMINATE")
    SpectrumQ.put("TERMINATE")
    saveConfiguration()
    try: 
        Control.Stop = True
        Control.Pause = False
    except Exception as message : 
        return # pass
def dispatchWheelEvent (event):
    if Control.MouseWidget != None :
        Control.MouseWidget.command(event,Control.MouseWidget)
def extractSubpicture (pixmap,firstRow = 0, lastRow = 240, firstColumn = 0, lastColumn = 320, width = 320,height=240,filename=None,colorListIndex=1,ext=None):
    #print ("extractSubpicture firstRow %i lastRow %i firstColumn %i lastColumn %i width %i height %i" % (firstRow,lastRow,firstColumn,lastColumn,width,height))
    if pixmap == None : return # print( "None Pixmap"); return
    colorArray = colorArrayList[colorListIndex]
    #colorList = colorListList[colorListIndex]
    try: #create pixmap
        firstColumn = firstColumn & -3 # must be multiple of 4
        lastColumn = lastColumn & -3 # must be multiple of 4
        actualWidth = lastColumn - firstColumn
        actualHeight = lastRow - firstRow; signature = ""; actualLength = width*height//2; #print ("actualLength",actualLength,"type(pixmap)",pixmap.typecode)
        
        bitmap_data = bytearray()
        bitmap_data += b"P6\n" ; bitmap_data += ("%d %d\n" % (actualWidth, actualHeight)).encode() ;bitmap_data += b"255\n"   ; ###print ("bitmap_data",bitmap_data)
        A = numpy.array(pixmap[0:actualLength], dtype = "uint8") ; # discard last 512 byte if present
        #print ("A",A.size,A.shape)
        A = A.reshape(height,width/2); # convert to row / columns (2 pixels per byte!)
        B = A[firstRow:lastRow,firstColumn//2:lastColumn//2] # extract subpicture
        C = B.reshape(-1)  # flatten again
        D = C.view(dtype="uint16"); D=D.byteswap(); D=D.view("uint8") ; #swap bytes
        E = D.repeat(2)  # duplicate data for getting one byte per pixel
        E[0::2] >>= 4; E[1::2] &= 0x0f  # select upper/lower nibble
        F = colorArray[E] # colorindex to rgb tripel
        ba = F.tostring(); bitmap_data += bytearray(ba)
        if filename != None :
            ppmfile=open(filename,'wb')
            #print ("writing",filename)
            ppmfile.write(bitmap_data); 
            if ext :
                s = " " + str(Control.response); s= bytes(s.encode()); ppmfile.write(s)
                pid = " 0x%04x \n" % productId ; pid = bytes(pid.encode()); ppmfile.write(pid)
            ppmfile.close()
    except Exception as message : 
        print ("extract",message)
        traceback.print_exc()
    return bytes(bitmap_data)
def getSignature (pixmap,row = 0, firstColumn = 0, lastColumn = 320, width = 320,height=240,filename=None,colorListIndex=1):
    #print ("getSignature row %i  firstColumn %i lastColumn %i width %i height %i" % (row,firstColumn,lastColumn,width,height))
    if pixmap == None : return # print( "None Pixmap"); return
    try: #create pixmap matrix
        firstColumn = firstColumn & -3 # must be multiple of 4
        lastColumn = lastColumn & -3 # must be multiple of 4
        actualWidth = lastColumn - firstColumn
        actualHeight = 1; signature = ""; actualLength = width*height//2
        
        A = numpy.array(pixmap[0:actualLength], dtype = "uint8") ; # discard last 512 byte if present
        #print ("A",A.size,A.shape)
        B = A.reshape(height,width//2);# print ("B",B.shape)
        C = B[row,firstColumn//2:lastColumn//2]; #print ("C",C)
        D = numpy.zeros(C.size,dtype="uint8")
        D[0::2] = C[1::2];  D[1::2] = C[0::2]  ; #print ("D",D) # exchange odd and even bytes
        E = D.repeat(2)  # duplicate data
        E[0::2] >>= 4; E[1::2] &= 0x0f  ; #print ("E",E) # select upper/lower nibble
        F = hexarray[E];# print ("F",F)
        ba = F.tostring()
        signature = ba.replace(b"c",b"f").replace(b"d",b"f"); #print ("new signature",signature)
        if filename != None :
            ppmfile=open(filename,'wb')
            ppmfile.write(bitmap_data); ppmfile.close()
    except Exception as message : 
        print ("getSignature",message)
        traceback.print_exc()
    getSignature2(pixmap,row,firstColumn)
    return signature
def getSignature2 (pixmap,row = 0, firstColumn = 0,filename=None,colorListIndex=1):
    return # will be used later
    #print ("getSignature2 row %i  firstColumn %i" % (row,firstColumn))
    if pixmap == None : return # print( "None Pixmap"); return
    try: #create pixmap matrix
        firstByteOffset = firstColumn //2
        sigSize = 4
        rowOffset = 160*row
        start = firstByteOffset + rowOffset
        sig = pixmap[start:start+sigSize]
        #print ("sig",sig)
        return sig
    except Exception as message : 
        print ("getSignature2",message)
        traceback.print_exc()
#module init
afterId = 0; startTime = time(); logging = False
sleepData = 50; sleepPixmap = 20; sleepParameter = 20;  #print("module init sleepData ",sleepData); # sleep between control transfers
hexarray = numpy.array([c for c in string.hexdigits[0:16]], dtype="c")
# group colors
colors = ["#00ffff","#ffff00","#00cccc","#cccc00","#00aaaa","#aaaa00","#008888","#888800"]  # for channel : normal , dim
scopeGreen = "#005500"
brown = "#444400" 
# constants for ctl and data ...
REMOTE_ON  = 0xf0 
REMOTE_OFF = 0xf1

# F1 - F5 buttons
# tlacitka F1 - F5
BTN_F1 = 0xF7 ; F1 = (0x42,0xb1,None,0xf7)
BTN_F2 = 0xF6 ; F2 = (0x42,0xb1,None,0xf6)
BTN_F3 = 0x03 ; F3 = (0x42,0xb1,None,0x03)
BTN_F4 = 0x04 ; F4 = (0x42,0xb1,None,0x04)
BTN_F5 = 0x05 ; F5 = (0x42,0xb1,None,0x05)

# display control buttons
# tlacitka pro zobrazovani
BTN_CH1  = 0x07 ; CH1 = (0x42,0xb1,None,0x07)
BTN_CH2  = 0x09 ; CH2 = (0x42,0xb1,None,0x09)
BTN_MATH = 0x0a
BTN_REF  = 0x0b
BTN_OFF  = 0x18 ; OFF = (0x42,0xb1,None,0x18)
BTN_SELECT = 0x10

# funtion buttons
# tlacitka funkci
BTN_MEAS     = 0x16
BTN_ACQU     = 0x1c
BTN_STOR     = 0x22
BTN_RUN_STOP = 0x28 ; RUN =   (0x42,0xb1,None,0x28)
BTN_CURSOR   = 0x17
BTN_DISPLAY  = 0x1d
BTN_UTILITY  = 0x23; UTILITY = (0x42,0xb1,None,0x23)
BTN_AUTO     = 0x29
BTN_MENU     = 0x24; MENU = (0x42,0xb1,None,0x24)
BTN_COARSE   = 0x11 ; COARSE = (0x42,0xb1,None,0x11)

# Y axis control
# ovladani Y osy
VOLTS_UP = 0x36 ; GAIN_UP = (0x42,0xb1,None,0x36)
VOLTS_DN = 0x35 ; GAIN_DN = (0x42,0xb1,None,0x35)
VERT_UP  = 0x33 ; V_UP = (0x42,0xb1,None,0x33)
VERT_DN  = 0x34 ; V_DN = (0x42,0xb1,None,0x34)
SET_TO_0 = 0x0c

# T axis control
# ovladani T osy
SEC_DIV_UP = 0x39 ; TB_UP = (0x42,0xb1,None,0x39)
SEC_DIV_DN = 0x3a ; TB_DN = (0x42,0xb1,None,0x3a)
HORIZ_UP   = 0x38 ; TP_LE = (0x42,0xb1,None,0x38)
HORIZ_DN   = 0x37 ; TP_RI = (0x42,0xb1,None,0x37)

# trigger control
# ovladani trigeru
TRIG_UP    = 0x3b ; TR_UP = (0x42,0xb1,None,0x3b)
TRIG_DN    = 0x3c ; TR_DN = (0x42,0xb1,None,0x3c)
MENU_TRIG  = 0x2e ; TRIGGER_MENUE = (0x42,0xb1,None,0x2e)
SET_TO_50  = 0x2f ; TR_50 = (0x42,0xb1,None,0x2f)
FORCE_TRIG = 0x30

# universal turning part
# univerzalni tocitko
UNI_PLUS  = 0x31  ;  TURN_UP = (0x42,0xb1,None,0x31)
UNI_MINUS = 0x32  ;  TURN_DN = (0x42,0xb1,None,0x32)

# help
# napoveda
BTN_HELP = 0x2a

# data load
# nacitani dat
DATA_CH1 = 0xf9
DATA_CH2 = 0xfa
GET_WAVE = 0x06

# ranges
# Y axis range in V/div
Y_RANGE = [2E-3, 5E-3, 10E-3, 20E-3, 50E-3, 100E-3, 200E-3, 500E-3, 1, 2, 5]

T_RANGE = [0, 2E-9, 5E-9, 10E-9, 20E-9, 50E-9, 100E-9, 200E-9, 500E-9, 1E-6, 2E-6, 5E-6, 10E-6, 20E-6, 50E-6, 100E-6, 200E-6, 500E-6,
	1E-3, 2E-3, 5E-3, 10E-3, 20E-3, 50E-3, 100E-3, 200E-3, 500E-3, 1, 2, 5, 10, 20, 50]
	
COUPLING = ["DC","AC","GND"]
	
# indexes of data sections
CHANNEL_STATE = 2

CH_OFFSET    = 32

Y_SENSE_CH1  = 5
Y_SENSE_CH2  = Y_SENSE_CH1 + CH_OFFSET	

Y_POS_CH1    = 6
Y_POS_CH2    = Y_POS_CH1 + CH_OFFSET

Y_PROBE_CH1  = 19
Y_PROBE_CH2  = Y_PROBE_CH1 + CH_OFFSET

COUPLING_CH1 = 12
COUPLING_CH2 = COUPLING_CH1 + CH_OFFSET

T_SCALE_CH1 = 10
T_SCALE_CH2 = 10 + CH_OFFSET

BW_LIMIT_CH1= 15
BW_LIMIT_CH2= 15 + CH_OFFSET


if __name__ == "__main__" :
    print ("mdso 0.9.6")
    # group misc
    gc.disable(); currentViewName = "S"
    try: 
        libc=ctypes.cdll.LoadLibrary("libc.so.6"); get_cpu = libc.sched_getcpu
    except Exception as message : 
        def get_cpu(): return 0
    colorList1 = [
    (0,20,0),        # 0  bg crt bottom labels
    (0,20,0),          # 1 bg riight labels
    (255,255,250),      # 2 ?
    (70,70,70),          # 3 rahmen um label
    (255,255,250),      # 4 ?
    (0,0,0),      # 5 ?
    (255,0,0),      # 6 when setting triggered alle turns red
    (0,0,0),      # 7  ?? 
    (0,0,0),      # 8 ? 
    (0,0,0),      # 9 ? 
    (0,0,0),      # 0A ?
    (50,50,50),       # 0B  background black
    (0,255,255),     # 0C Channel 1 cyan
    (255,255,0),     # 0D Channel 2 yellow
    (250,0,0),          # 0E math red
    (255,255,255)  # 0F white labels
    ]
    colorList2 = [
    (0,68,0),      # 0 background footline values
    (0,68,0),      # 1 background channel
    (200,0,0),      # 2
    (0,86,0),      # 3
    (64,0,0),      # 4
    (100,0,0),     # 5
    (100,0,0),     # 6
    (100,0,0),     # 7  ? math? nein
    (200,0,0),     # 8 math? 
    (200,0,0),     # 9 math? nein
    (200,200,200), # 0A
    (68,68,0),     # 0B  background
    (0,150,150),   # 0C Channel 1
    (150,150,0),   # 0D Channel 2
    (200,0,0),     # 0E 
    (128,128,128)  # 0F white labels
    ]
    colorList0 = [
    (68,68,0),     # 0 background footline values
    (68,68,0),     # 1 background channel
    (64,0,0),      # 2
    (0,68,0),     # 3
    (64,0,0),      # 4
    (255,0,0),     # 5
    (255,0,0),     # 6
    (255,0,0),     # 7  ? math? nein
    (255,0,0),     # 8 math? 
    (255,0,0),     # 9 math? nein
    (125,125,125), # 0A
    (68,68,0),     # 0B  background
    (0,255,255),   # 0C Channel 1
    (255,255,0),   # 0D Channel 2
    (255,0,0),     # 0E 
    (255,255,255)  # 0F white labels
    ]
    colorListList = [colorList0,colorList1,colorList2]
    colorArray0 = numpy.array(colorList0,dtype="uint8")
    colorArray2 = numpy.array(colorList2,dtype="uint8")
    colorArray1 = numpy.array(colorList1,dtype="uint8")
    colorArrayList = [colorArray0,colorArray1,colorArray2]
    # group Queues
    LogQ = multiprocessing.Queue()
    ZoomQ = multiprocessing.Queue()
    ConrolQ = multiprocessing.Queue()
    DiagQ = multiprocessing.Queue()
    SpectrumQ = multiprocessing.Queue()
    USBQ = multiprocessing.Queue()
    parseArgs()
    # group processes
    USBProcess = multiprocessing.Process(target=createUSBProcess,args=(USBQ,ConrolQ,DiagQ,PID,BUS,DEV),name="USB_server")
    USBProcess.start();  sleep(0.1)
    msg = ConrolQ.get(); # print( "moduleInit",msg)
    # choice
    if msg[0] == "FOUND" :  
        print( "found productId 0x%04x" % msg[1])
        global productId; productId = msg[1]
    else:  
        USBQ.put("TERMINATE")
        USBProcess.join(0.1); USBProcess.terminate(); print( "USB finished")
        try: 
            sys.exit()
        except Exception as message : 
            pass
    # end choice
    SpectrumProcess = multiprocessing.Process(target=createSpectrumProcess,args=(SpectrumQ,ConrolQ,USBQ,screenWidth),name="Spectrum")
    SpectrumProcess.start();  sleep(0.1)
    ZoomProcess = multiprocessing.Process(target=createZoomProcess,args=(ZoomQ,ConrolQ),name="Zoom")
    ZoomProcess.start();  sleep(0.1)
    # group root
    root=Tk()
    root.wm_title("UNI-TREND CINERAMA SCOPE")
    root.wm_sizefrom(who="program")
    setConfiguration()
    root.wm_protocol("WM_DELETE_WINDOW",shutDown)
    #root.wm_minsize(width=screenWidth,height=822)
    root.bind("<Button-5>",dispatchWheelEvent)
    root.bind("<Button-4>",dispatchWheelEvent)
    root.bind("<Shift-Button-3>",dispatchWheelEvent)
    root.bind("<Shift-Button-1>",dispatchWheelEvent)
    root.bind("<MouseWheel>",dispatchWheelEvent)
    # group Windows
    Control = control(root); Control.pack()
    WideView = wideView(Control); #WideView.pack(side="top",fill="x",expand=1); Control.currentView = WideView
    StandardView = standardView(Control); 
    DiagnosticWindow = diagnosticPanel(root); #print( "diag panel")
    PixmapWindow = pixmapPanel(root); #print( "pixmap panel")
    DiagnosticWindow.wm_protocol("WM_DELETE_WINDOW",DiagnosticWindow.iconify)
    PixmapWindow.wm_protocol("WM_DELETE_WINDOW",PixmapWindow.iconify)
    PhotoView = photoView(Control);
    #WideView.wm_protocol("WM_DELETE_WINDOW",WideView.iconify); WideView.wm_title("WideView")
    Control.changeView(currentViewName);  Control.createMenu(); root.after(10,Control.RefreshLoop)
    try: 
        root.mainloop()
    except Exception as message : 
        print( "abnormal exit",message)
        SpectrumQ.put("TERMINATE")
        USBQ.put("TERMINATE")
    SpectrumProcess.join(1.0); #print( "Spectrum joined"); 
    ZoomProcess.join(1.0); ZoomProcess.terminate(); #print( "ZoomProcess terminated")
    USBProcess.join(1.0); USBProcess.terminate(); #print( "USBProcess terminated")
    print( "finished")
# end mdso
