/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.inputs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import moppydesk.MoppyStatusConsumer;

public class MoppySequencer
implements MetaEventListener,
Transmitter {
    Sequencer sequencer;
    Sequence currentSequence = null;
    ArrayList<MoppyStatusConsumer> listeners = new ArrayList(1);

    public MoppySequencer() throws MidiUnavailableException {
        this.sequencer = MidiSystem.getSequencer(false);
        this.sequencer.open();
        this.sequencer.addMetaEventListener(this);
    }

    public void loadFile(String filePath) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        this.sequencer.stop();
        Sequence sequence = MidiSystem.getSequence(new File(filePath));
        this.sequencer.setSequence(sequence);
        System.out.println("Loaded sequence with " + (sequence.getTracks().length - 1) + " MIDI channels.");
        this.currentSequence = sequence;
    }

    public void startSequencer() {
        this.sequencer.start();
    }

    public boolean isRunning() {
        return this.sequencer.isRunning();
    }

    public void stopSequencer() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
    }

    public void resetSequencer() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.setTickPosition(0L);
        }
    }

    public void setTempo(float newTempo) {
        this.sequencer.setTempoInBPM(newTempo);
    }

    public long getSecondsLength() {
        return this.sequencer.getMicrosecondLength() / 1000000L;
    }

    public long getSecondsPosition() {
        return this.sequencer.getMicrosecondPosition() / 1000000L;
    }

    public void setSecondsPosition(long seconds) {
        this.sequencer.setMicrosecondPosition(seconds * 1000000L);
    }

    public void addListener(MoppyStatusConsumer newListener) {
        this.listeners.add(newListener);
    }

    public void removeListener(MoppyStatusConsumer oldListener) {
        this.listeners.remove(oldListener);
    }

    public void closeSequencer() {
        this.stopSequencer();
        this.sequencer.close();
    }

    public void meta(MetaMessage meta) {
        if (meta.getType() == 81) {
            int uSecondsPerQN = 0;
            uSecondsPerQN |= meta.getData()[0] & 0xFF;
            uSecondsPerQN <<= 8;
            uSecondsPerQN |= meta.getData()[1] & 0xFF;
            uSecondsPerQN <<= 8;
            int newTempo = 60000000 / (uSecondsPerQN |= meta.getData()[2] & 0xFF);
            this.sequencer.setTempoInBPM(newTempo);
            for (MoppyStatusConsumer c : this.listeners) {
                c.tempoChanged(newTempo);
            }
            System.out.println("Tempo changed to: " + newTempo);
        }
    }

    public void setReceiver(Receiver receiver) {
        try {
            this.sequencer.getTransmitter().setReceiver(receiver);
        }
        catch (MidiUnavailableException ex) {
            Logger.getLogger(MoppySequencer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Receiver getReceiver() {
        try {
            return this.sequencer.getReceiver();
        }
        catch (MidiUnavailableException ex) {
            Logger.getLogger(MoppySequencer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void close() {
        this.closeSequencer();
    }
}

