/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.midputs;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

public class DrivePooler
implements Receiver,
Transmitter {
    Receiver receiver = null;
    private int startInput = 0;
    private int endInput = 0;
    private int startOutput = 0;
    private int endOutput = 7;
    private PoolingStrategy currentStrategy = PoolingStrategy.STRAIGHT_THROUGH;
    private int[] currentNotes = new int[16];
    private int rrNextNote = 0;

    public void setInputRange(int start, int end) {
        this.startInput = start - 1;
        this.endInput = end - 1;
    }

    public void setOutputRange(int start, int end) {
        this.startOutput = start - 1;
        this.endOutput = end - 1;
    }

    public void setStrategy(PoolingStrategy newStrat) {
        this.allOff();
        this.currentStrategy = newStrat;
    }

    public void send(MidiMessage message, long timeStamp) {
        if (this.receiver != null && message instanceof ShortMessage && (message.getMessage()[0] & 0xFF) > 127 && (message.getMessage()[1] & 0xFF) < 160) {
            switch (this.currentStrategy) {
                case STRAIGHT_THROUGH: {
                    this.receiver.send(message, timeStamp);
                    break;
                }
                case ROUND_ROBIN: {
                    this.receiver.send(this.roundRobinMap(message), timeStamp);
                    break;
                }
                case STACK: {
                    this.receiver.send(this.stackMap(message), timeStamp);
                }
            }
        }
    }

    private MidiMessage roundRobinMap(MidiMessage message) {
        ShortMessage mappedMessage;
        block9: {
            if (this.rrNextNote < this.startOutput || this.rrNextNote > this.endOutput) {
                this.rrNextNote = this.startOutput;
            }
            mappedMessage = (ShortMessage)message;
            try {
                if (mappedMessage.getChannel() >= this.startInput && mappedMessage.getChannel() <= this.endInput) {
                    if (mappedMessage.getCommand() == 128 || mappedMessage.getCommand() == 144 && mappedMessage.getData2() == 0) {
                        int noteNumber = mappedMessage.getData1();
                        for (int n = this.startOutput; n <= this.endOutput; ++n) {
                            if (this.currentNotes[n] != noteNumber) continue;
                            this.currentNotes[n] = -1;
                            mappedMessage.setMessage(mappedMessage.getCommand(), n, mappedMessage.getData1(), mappedMessage.getData2());
                        }
                    } else if (mappedMessage.getCommand() == 144) {
                        int targetNote = this.rrNextNote;
                        while (targetNote <= this.endOutput && this.currentNotes[targetNote] >= 0) {
                            targetNote = targetNote == this.endOutput ? this.startOutput : ++targetNote;
                            if (targetNote != this.rrNextNote) continue;
                        }
                        this.currentNotes[targetNote] = mappedMessage.getData1();
                        mappedMessage.setMessage(mappedMessage.getCommand(), targetNote, mappedMessage.getData1(), mappedMessage.getData2());
                        ++this.rrNextNote;
                    }
                    break block9;
                }
                return message;
            }
            catch (InvalidMidiDataException ex) {
                Logger.getLogger(DrivePooler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return mappedMessage;
    }

    private MidiMessage stackMap(MidiMessage message) {
        ShortMessage mappedMessage;
        block8: {
            mappedMessage = (ShortMessage)message;
            try {
                if (mappedMessage.getChannel() >= this.startInput && mappedMessage.getChannel() <= this.endInput) {
                    if (mappedMessage.getCommand() == 128 || mappedMessage.getCommand() == 144 && mappedMessage.getData2() == 0) {
                        int noteNumber = mappedMessage.getData1();
                        for (int n = this.startOutput; n <= this.endOutput; ++n) {
                            if (this.currentNotes[n] != noteNumber) continue;
                            this.currentNotes[n] = -1;
                            mappedMessage.setMessage(mappedMessage.getCommand(), n, mappedMessage.getData1(), mappedMessage.getData2());
                        }
                    } else if (mappedMessage.getCommand() == 144) {
                        int targetChannel = 0;
                        for (int n = this.startOutput; n <= this.endOutput; ++n) {
                            if (this.currentNotes[n] >= 0) continue;
                            targetChannel = n;
                            break;
                        }
                        this.currentNotes[targetChannel] = mappedMessage.getData1();
                        mappedMessage.setMessage(mappedMessage.getCommand(), targetChannel, mappedMessage.getData1(), mappedMessage.getData2());
                    }
                    break block8;
                }
                return message;
            }
            catch (InvalidMidiDataException ex) {
                Logger.getLogger(DrivePooler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return mappedMessage;
    }

    private void allOff() {
        Arrays.fill(this.currentNotes, -1);
    }

    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
            this.receiver = null;
        }
    }

    public void setReceiver(Receiver newReceiver) {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = newReceiver;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PoolingStrategy {
        STRAIGHT_THROUGH,
        ROUND_ROBIN,
        STACK;

    }
}

