/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.outputs;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MoppyCOMBridge {
    static int FIRST_PIN = 2;
    static int MAX_PIN = 17;
    int SERIAL_RATE = 9600;
    OutputStream os;
    SerialPort com;
    private boolean isOutputOpen = false;

    public MoppyCOMBridge(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        CommPortIdentifier cpi = CommPortIdentifier.getPortIdentifier(portName);
        this.com = (SerialPort)cpi.open("MoppyDesk", 2000);
        this.com.setSerialPortParams(this.SERIAL_RATE, 8, 1, 0);
        this.os = this.com.getOutputStream();
        this.isOutputOpen = true;
    }

    public void sendEvent(byte pin, int periodData) {
        this.sendEvent(pin, (byte)(periodData >> 8 & 0xFF), (byte)(periodData & 0xFF));
    }

    public void sendEvent(byte pin, byte b1, byte b2) {
        this.sendArray(new byte[]{pin, b1, b2});
    }

    private void sendArray(byte[] message) {
        try {
            this.os.write(message);
            this.os.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(MoppyCOMBridge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void silenceDrives() {
        for (int d = FIRST_PIN; d <= MAX_PIN; d += 2) {
            this.sendArray(new byte[]{(byte)d, 0, 0});
        }
    }

    public void resetDrives() {
        if (this.isOutputOpen) {
            this.sendArray(new byte[]{100, 0, 0});
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MoppyCOMBridge.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void close() {
        if (this.os != null) {
            if (this.isOutputOpen) {
                this.silenceDrives();
            }
            try {
                this.os.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MoppyCOMBridge.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.com != null) {
            this.com.close();
        }
        this.isOutputOpen = false;
    }

    public static String[] getAvailableCOMPorts() {
        ArrayList<String> portIdentifierStrings = new ArrayList<String>();
        Enumeration comPorts = CommPortIdentifier.getPortIdentifiers();
        while (comPorts.hasMoreElements()) {
            portIdentifierStrings.add(((CommPortIdentifier)comPorts.nextElement()).getName());
        }
        return portIdentifierStrings.toArray(new String[portIdentifierStrings.size()]);
    }
}

