/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.outputs;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import moppydesk.outputs.MoppyReceiver;

public class ReceiverMarshaller
implements MoppyReceiver {
    private final MoppyReceiver[] outputReceivers = new MoppyReceiver[16];

    public void setReceiver(int MIDIChannel, MoppyReceiver channelReceiver) {
        if (MIDIChannel < 1 || MIDIChannel > 16) {
            throw new IllegalArgumentException("Only channels 1-16 are supported by the ReceiverMarshaller!");
        }
        if (this.outputReceivers[MIDIChannel - 1] != null) {
            this.outputReceivers[MIDIChannel - 1].close();
        }
        this.outputReceivers[MIDIChannel - 1] = channelReceiver;
    }

    public void clearReceivers() {
        this.close();
    }

    public void send(MidiMessage message, long timeStamp) {
        int ch = ((ShortMessage)message).getChannel();
        if (this.outputReceivers[ch] != null) {
            this.outputReceivers[ch].send(message, timeStamp);
        }
    }

    public void close() {
        for (MoppyReceiver r : this.outputReceivers) {
            if (r == null) continue;
            r.close();
        }
        Arrays.fill(this.outputReceivers, null);
    }

    public void reset() {
        ArrayList<MoppyReceiver> uniqueReceivers = new ArrayList<MoppyReceiver>();
        for (MoppyReceiver r : this.outputReceivers) {
            if (r == null || uniqueReceivers.contains(r)) continue;
            uniqueReceivers.add(r);
        }
        for (MoppyReceiver r : uniqueReceivers) {
            r.reset();
        }
    }
}

