/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.ui;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import moppydesk.MoppyUI;
import moppydesk.OutputSetting;
import moppydesk.outputs.MoppyCOMBridge;
import moppydesk.outputs.MoppyMIDIOutput;
import moppydesk.outputs.MoppyPlayerOutput;
import moppydesk.outputs.MoppyReceiver;
import moppydesk.ui.ChannelOutControl;
import moppydesk.ui.InputPanel;
import moppydesk.ui.MIDIInControls;
import moppydesk.ui.PoolingControls;
import moppydesk.ui.SequencerControls;

public class MoppyControlWindow
extends JFrame {
    MoppyUI app;
    HashMap<String, MidiDevice.Info> availableMIDIOuts;
    OutputSetting[] outputSettings = new OutputSetting[16];
    HashMap<String, MoppyReceiver> outputPlayers = new HashMap();
    MIDIInControls midiInControls;
    SequencerControls seqControls;
    InputPanel currentInputPanel;
    private JButton connectButton;
    private JComboBox inputSelectBox;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JPanel mainInputPanel;
    private JPanel mainOutputPanel;
    private JLabel mainStatusLabel;
    private PoolingControls poolingControls1;

    public MoppyControlWindow(MoppyUI app) {
        this.app = app;
        this.midiInControls = new MIDIInControls(app.midiIn);
        this.seqControls = new SequencerControls(app, this, app.ms);
        app.ms.addListener(this.seqControls);
        this.availableMIDIOuts = MoppyMIDIOutput.getMIDIOutInfos();
        this.loadOutputSettings();
        this.initComponents();
        this.updateInputPanel();
        this.setupOutputControls();
    }

    private void loadOutputSettings() {
        OutputSetting[] os = (OutputSetting[])this.app.getPreferenceObject("outputSettingsArray");
        if (os == null) {
            for (int i = 1; i <= 16; ++i) {
                this.outputSettings[i - 1] = new OutputSetting(i);
            }
            this.app.putPreferenceObject("outputSettingsArray", this.outputSettings);
        } else {
            this.outputSettings = os;
        }
    }

    private void setupOutputControls() {
        for (OutputSetting s : this.outputSettings) {
            ChannelOutControl newControl = new ChannelOutControl(this, s);
            this.mainOutputPanel.add(newControl);
        }
        this.mainOutputPanel.revalidate();
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.mainStatusLabel = new JLabel();
        this.mainInputPanel = new JPanel();
        this.inputSelectBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.mainOutputPanel = new JPanel();
        this.connectButton = new JButton();
        this.poolingControls1 = new PoolingControls(this.app);
        this.setDefaultCloseOperation(3);
        this.setTitle("Moppy Control Application");
        this.mainStatusLabel.setText("Loaded.");
        this.mainStatusLabel.setToolTipText("Current status");
        this.mainInputPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainInputPanel.setPreferredSize(new Dimension(350, 400));
        this.inputSelectBox.setModel(new DefaultComboBoxModel<String>(new String[]{"MIDI File", "MIDI IN Port"}));
        this.inputSelectBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoppyControlWindow.this.inputSelectBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Input Mode");
        this.mainOutputPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainOutputPanel.setPreferredSize(new Dimension(350, 400));
        this.mainOutputPanel.setLayout(new BoxLayout(this.mainOutputPanel, 1));
        this.connectButton.setText("Connect");
        this.connectButton.setToolTipText("Saves current output settings and connects as specified.");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoppyControlWindow.this.connectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputSelectBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(493, 493, 493).addComponent(this.connectButton, -2, 99, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainInputPanel, -1, 529, Short.MAX_VALUE).addComponent(this.poolingControls1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainOutputPanel, -2, 550, -2)).addComponent(this.mainStatusLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputSelectBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mainOutputPanel, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.mainInputPanel, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.poolingControls1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.connectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainStatusLabel).addContainerGap()));
        this.pack();
    }

    private void connect() {
        try {
            for (Component c : this.mainOutputPanel.getComponents()) {
                if (!(c instanceof ChannelOutControl)) continue;
                ((ChannelOutControl)c).lockControl();
            }
            this.app.putPreferenceObject("outputSettingsArray", this.outputSettings);
            this.app.savePreferences();
            this.setStatus("Initializing Receivers...");
            this.initializeReceivers();
            this.inputSelectBox.setEnabled(false);
            if (this.poolingControls1.isPoolingEnabled()) {
                this.currentInputPanel.getTransmitter().setReceiver(this.poolingControls1.getDrivePooler());
                this.poolingControls1.getDrivePooler().setReceiver(this.app.rm);
            } else {
                this.currentInputPanel.getTransmitter().setReceiver(this.app.rm);
            }
            this.currentInputPanel.connected();
            this.poolingControls1.connected();
            this.connectButton.setText("Disconnect");
            this.setStatus("Connected.");
        }
        catch (Exception ex) {
            Logger.getLogger(MoppyControlWindow.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.rootPane, ex.toString(), ex.getMessage(), 0);
            this.disconnect();
        }
    }

    private void disconnect() {
        this.setStatus("Disconnecting...");
        this.currentInputPanel.disconnected();
        this.poolingControls1.disconnected();
        this.app.rm.close();
        for (Component c : this.mainOutputPanel.getComponents()) {
            if (!(c instanceof ChannelOutControl)) continue;
            ((ChannelOutControl)c).unlockControl();
        }
        this.inputSelectBox.setEnabled(true);
        this.connectButton.setText("Connect");
        this.setStatus("Disconnected.");
    }

    private void initializeReceivers() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException, MidiUnavailableException {
        this.app.rm.clearReceivers();
        this.outputPlayers.clear();
        for (int ch = 1; ch <= 16; ++ch) {
            OutputSetting os = this.outputSettings[ch - 1];
            if (!os.enabled) continue;
            if (os.type.equals((Object)OutputSetting.OutputType.MOPPY)) {
                if (!this.outputPlayers.containsKey(os.comPort)) {
                    this.outputPlayers.put(os.comPort, new MoppyPlayerOutput(new MoppyCOMBridge(os.comPort)));
                }
                this.app.rm.setReceiver(ch, this.outputPlayers.get(os.comPort));
                continue;
            }
            if (!os.type.equals((Object)OutputSetting.OutputType.MIDI)) continue;
            if (!this.outputPlayers.containsKey(os.midiDeviceName)) {
                this.outputPlayers.put(os.midiDeviceName, new MoppyMIDIOutput(os.midiDeviceName));
            }
            this.app.rm.setReceiver(ch, this.outputPlayers.get(os.midiDeviceName));
        }
    }

    private void updateInputPanel() {
        this.mainInputPanel.removeAll();
        this.currentInputPanel = this.inputSelectBox.getSelectedIndex() == 0 ? this.seqControls : this.midiInControls;
        this.mainInputPanel.add(this.currentInputPanel);
        this.mainInputPanel.revalidate();
        this.mainInputPanel.repaint();
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        this.connectButton.setEnabled(false);
        if (this.connectButton.getText().equals("Connect")) {
            this.connect();
        } else {
            this.disconnect();
        }
        this.connectButton.setEnabled(true);
    }

    private void inputSelectBoxActionPerformed(ActionEvent evt) {
        this.updateInputPanel();
    }

    public void setStatus(String newStatus) {
        this.mainStatusLabel.setText(newStatus);
        this.mainStatusLabel.repaint();
    }
}

