/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import moppydesk.MoppyUI;
import moppydesk.midputs.DrivePooler;

public class PoolingControls
extends JPanel {
    private DrivePooler pooler;
    private MoppyUI app;
    private JCheckBox enablePoolingCB;
    private JSpinner inputEndSpinner;
    private JSpinner inputStartSpinner;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner outputEndSpinner;
    private JSpinner outputStartSpinner;

    public PoolingControls() {
        this.initComponents();
    }

    public PoolingControls(MoppyUI app) {
        this.app = app;
        this.initComponents();
        this.pooler = new DrivePooler();
        this.loadSettings();
        this.updatePooler();
    }

    public boolean isPoolingEnabled() {
        return this.enablePoolingCB.isSelected();
    }

    public DrivePooler getDrivePooler() {
        return this.pooler;
    }

    public void connected() {
        this.saveSettings();
        for (Component c : this.getComponents()) {
            c.setEnabled(false);
        }
    }

    public void disconnected() {
        this.pooler.close();
        for (Component c : this.getComponents()) {
            c.setEnabled(true);
        }
    }

    private void loadSettings() {
        this.enablePoolingCB.setSelected(this.app.prefs.getBoolean("poolingEnabled", false));
        this.inputStartSpinner.setValue(this.app.prefs.getInt("poolingFromStart", 1));
        this.inputEndSpinner.setValue(this.app.prefs.getInt("poolingFromEnd", 1));
        this.outputStartSpinner.setValue(this.app.prefs.getInt("poolingToStart", 1));
        this.outputEndSpinner.setValue(this.app.prefs.getInt("poolingToEnd", 1));
        this.jComboBox1.setSelectedIndex(this.app.prefs.getInt("poolingStrategy", 0));
        this.updatePooler();
    }

    private void saveSettings() {
        this.app.prefs.putBoolean("poolingEnabled", this.enablePoolingCB.isSelected());
        this.app.prefs.putInt("poolingFromStart", (Integer)this.inputStartSpinner.getValue());
        this.app.prefs.putInt("poolingFromEnd", (Integer)this.inputEndSpinner.getValue());
        this.app.prefs.putInt("poolingToStart", (Integer)this.outputStartSpinner.getValue());
        this.app.prefs.putInt("poolingToEnd", (Integer)this.outputEndSpinner.getValue());
        this.app.prefs.putInt("poolingStrategy", this.jComboBox1.getSelectedIndex());
        this.app.savePreferences();
    }

    private void updatePooler() {
        this.pooler.setInputRange((Integer)this.inputStartSpinner.getValue(), (Integer)this.inputEndSpinner.getValue());
        this.pooler.setOutputRange((Integer)this.outputStartSpinner.getValue(), (Integer)this.outputEndSpinner.getValue());
        this.pooler.setStrategy(DrivePooler.PoolingStrategy.values()[this.jComboBox1.getSelectedIndex()]);
    }

    private void initComponents() {
        this.enablePoolingCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.inputStartSpinner = new JSpinner();
        this.inputEndSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.outputEndSpinner = new JSpinner();
        this.outputStartSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(525, 149));
        this.enablePoolingCB.setText("Enable Drive-Pooling");
        this.jLabel1.setText("Pool channels:");
        this.inputStartSpinner.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        this.inputStartSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PoolingControls.this.poolingControlChanged(evt);
            }
        });
        this.inputEndSpinner.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        this.inputEndSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PoolingControls.this.poolingControlChanged(evt);
            }
        });
        this.jLabel2.setText("Into channels:");
        this.outputEndSpinner.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        this.outputEndSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PoolingControls.this.poolingControlChanged(evt);
            }
        });
        this.outputStartSpinner.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        this.outputStartSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PoolingControls.this.poolingControlChanged(evt);
            }
        });
        this.jLabel3.setText("Using strategy:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Straight-through", "Round-Robin", "Stacking (Start-biased)"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PoolingControls.this.strategyDropdownChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enablePoolingCB).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.inputStartSpinner, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputEndSpinner, -2, 41, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(38, 38, 38).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.outputStartSpinner, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputEndSpinner, -2, 41, -2).addGap(18, 18, 18).addComponent(this.jComboBox1, -2, 194, -2))))).addContainerGap(105, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enablePoolingCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputStartSpinner, -2, -1, -2).addComponent(this.inputEndSpinner, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputStartSpinner, -2, -1, -2).addComponent(this.outputEndSpinner, -2, -1, -2).addComponent(this.jComboBox1, -2, -1, -2)))).addContainerGap(68, Short.MAX_VALUE)));
    }

    private void poolingControlChanged(ChangeEvent evt) {
        this.updatePooler();
    }

    private void strategyDropdownChanged(ActionEvent evt) {
        this.updatePooler();
    }
}

