#include <Servo.h>

const int BAUD_RATE = 9600;
const int SERVO_PIN = 9;
const int DEF_CMD_LEN = 20;

Servo servo;
String command = "";
boolean receivedCommand = false;

void setup() {
  Serial.begin(BAUD_RATE);
  servo.attach(SERVO_PIN);
  command.reserve(DEF_CMD_LEN);
}

void loop() {
  if (receivedCommand) {
    if (command == "on") {
      servo.write(180);
      delay(15);
      Serial.println("Servo has turned right.");
    } else if (command == "off") {
      servo.write(0);
      delay(15);
      Serial.println("Servo has turned left.");
    }
    command = "";
    receivedCommand = false;
  }
}

void serialEvent() {
  while (Serial.available()) {
    char c = (char)Serial.read(); 
    if (c == '\n') {
      receivedCommand = true;
    } else {
      command += c;
    } 
  }
}

