var BAUD_RATE = 9600;
var NEWLINE = "\n";

var connectionId = -1;
var readBuffer = '';

function onOpen(openInfo) {
  connectionId = openInfo.connectionId;
  if (connectionId == -1) {
    setStatus('Could not connect to serial device.');
  } else {
    chrome.serial.read(connectionId, 1, onRead);
    setStatus('Connected to serial device.');
  }
}

function onRead(readInfo) {
  var value = readNextCharacter(readInfo);
  if (value != NEWLINE) {
    readBuffer += value;
  } else {
    processReadBuffer();
  }
  chrome.serial.read(connectionId, 1, onRead);
}

function processReadBuffer() {
  setStatus(readBuffer);
  readBuffer = '';
}

function readNextCharacter(readInfo) {
  var uint8View = new Uint8Array(readInfo.data);
  return String.fromCharCode(uint8View[0]);
}

function setStatus(status) {
  document.getElementById('status').innerText = status;
}

function buildPortPicker(ports) {
  var eligiblePorts = getEligiblePorts(ports);
  var portPicker = populatePortPicker(eligiblePorts);
  portPicker.onchange = portChangedEvent;
}

function portChangedEvent() {
  if (connectionId != -1) {
    chrome.serial.close(connectionId, openSelectedPort);
    setStatus('Connecting...');
  }
  openSelectedPort(); 
}

function populatePortPicker(eligiblePorts) {
  var portPicker = document.getElementById('port-picker');
  eligiblePorts.forEach(function(port) {
    var portOption = document.createElement('option');
    portOption.value = portOption.innerText = port;
    portPicker.appendChild(portOption);
  });
  return portPicker;
}

function getEligiblePorts(ports) {
  var eligiblePorts = ports.filter(function(port) {
    return !port.match(/[Bb]luetooth/);
  });
  return eligiblePorts;
}

function openSelectedPort() {
  var portPicker = document.getElementById('port-picker');
  var selectedPort = portPicker.options[portPicker.selectedIndex].value;
  chrome.serial.open(selectedPort, onOpen);
}

function stringToArrayBuffer(str) {
  var buffer = new ArrayBuffer(str.length);
  var bufferView = new Uint8Array(buffer);
  for (var i = 0; i < str.length; i++) {
    bufferView[i] = str.charCodeAt(i);
  }
  return buffer;
}

function sendCommand(data) {
  chrome.serial.write(connectionId, stringToArrayBuffer(data), function() {});
}

function readLeapMotion() {
  var leapMotion = new Leap.Controller({ enableGestures: true });
  
  leapMotion.on('connect', function() {
    console.log('Connected to internal websocket server.');
  });

  leapMotion.on('deviceConnected', function() {
    console.log('Connected to Leap Motion.');
  });

  leapMotion.on('deviceDisconnected', function() {
    console.log('Disconnected from Leap Motion.');
  });

  leapMotion.on('animationFrame', function(frame) {
    for (var i = 0; i < frame.gestures.length; i++) {
      var gesture = frame.gestures[i];
      if (gesture.type == 'circle' && gesture.state == 'stop') {
        if (gesture.normal[2] <= 0) {
          console.log('clockwise');
          sendCommand("on\n");
        } else {
          console.log('counterclockwise');
          sendCommand("off\n");
        }
        break;
      }
    }
  });

  leapMotion.connect();
}

onload = function() {
  chrome.serial.getPorts(function(ports) {
    buildPortPicker(ports)
    openSelectedPort();
  });

  readLeapMotion();
};
